/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry.range;

import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debugentry.range.CallRange;
import com.oracle.objectfile.debugentry.range.LeafRange;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.debugentry.range.SubRange;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Range {
    private static final String CLASS_DELIMITER = ".";
    protected final MethodEntry methodEntry;
    protected final long lo;
    protected long hi;
    protected final int line;
    protected final int depth;

    public static PrimaryRange createPrimary(MethodEntry methodEntry, long lo, long hi, int line) {
        return new PrimaryRange(methodEntry, lo, hi, line);
    }

    public static SubRange createSubrange(MethodEntry methodEntry, long lo, long hi, int line, PrimaryRange primary, Range caller, boolean isLeaf) {
        assert (primary != null);
        assert (primary.isPrimary());
        if (isLeaf) {
            return new LeafRange(methodEntry, lo, hi, line, primary, caller);
        }
        return new CallRange(methodEntry, lo, hi, line, primary, caller);
    }

    protected Range(MethodEntry methodEntry, long lo, long hi, int line, int depth) {
        assert (methodEntry != null);
        this.methodEntry = methodEntry;
        this.lo = lo;
        this.hi = hi;
        this.line = line;
        this.depth = depth;
    }

    protected abstract void addCallee(SubRange var1);

    public boolean contains(Range other) {
        return this.lo <= other.lo && this.hi >= other.hi;
    }

    public abstract boolean isPrimary();

    public String getClassName() {
        return this.methodEntry.ownerType().getTypeName();
    }

    public String getMethodName() {
        return this.methodEntry.methodName();
    }

    public String getSymbolName() {
        return this.methodEntry.getSymbolName();
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    public int getLine() {
        return this.line;
    }

    public String getFullMethodName() {
        return this.constructClassAndMethodName();
    }

    public String getFullMethodNameWithParams() {
        return this.constructClassAndMethodNameWithParams();
    }

    public boolean isDeoptTarget() {
        return this.methodEntry.isDeopt();
    }

    private String getExtendedMethodName(boolean includeClass, boolean includeParams, boolean includeReturnType) {
        StringBuilder builder = new StringBuilder();
        if (includeReturnType && this.methodEntry.getValueType().getTypeName().length() > 0) {
            builder.append(this.methodEntry.getValueType().getTypeName());
            builder.append(' ');
        }
        if (includeClass && this.getClassName() != null) {
            builder.append(this.getClassName());
            builder.append(CLASS_DELIMITER);
        }
        builder.append(this.getMethodName());
        if (includeParams) {
            builder.append("(");
            TypeEntry[] paramTypes = this.methodEntry.getParamTypes();
            if (paramTypes != null) {
                String prefix = "";
                for (TypeEntry t : paramTypes) {
                    builder.append(prefix);
                    builder.append(t.getTypeName());
                    prefix = ", ";
                }
            }
            builder.append(')');
        }
        if (includeReturnType) {
            builder.append(" ");
            builder.append(this.methodEntry.getValueType().getTypeName());
        }
        return builder.toString();
    }

    private String constructClassAndMethodName() {
        return this.getExtendedMethodName(true, false, false);
    }

    private String constructClassAndMethodNameWithParams() {
        return this.getExtendedMethodName(true, true, false);
    }

    public FileEntry getFileEntry() {
        return this.methodEntry.getFileEntry();
    }

    public int getFileIndex() {
        return this.getFileEntry().getIdx();
    }

    public int getModifiers() {
        return this.methodEntry.getModifiers();
    }

    public String toString() {
        return String.format("Range(lo=0x%05x hi=0x%05x %s %s:%d)", this.lo, this.hi, this.constructClassAndMethodNameWithParams(), this.methodEntry.getFullFileName(), this.line);
    }

    public String getFileName() {
        return this.methodEntry.getFileName();
    }

    public MethodEntry getMethodEntry() {
        return this.methodEntry;
    }

    public abstract SubRange getFirstCallee();

    public abstract boolean isLeaf();

    public boolean includesInlineRanges() {
        SubRange child;
        for (child = this.getFirstCallee(); child != null && child.isLeaf(); child = child.getSiblingCallee()) {
        }
        return child != null;
    }

    public int getDepth() {
        return this.depth;
    }

    public HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> getVarRangeMap() {
        int i;
        MethodEntry calleeMethod;
        if (this.isPrimary()) {
            calleeMethod = this.getMethodEntry();
        } else {
            assert (!this.isLeaf()) : "should only be looking up var ranges for inlined calls";
            calleeMethod = this.getFirstCallee().getMethodEntry();
        }
        HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap = new HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>>();
        if (calleeMethod.getThisParam() != null) {
            varRangeMap.put(calleeMethod.getThisParam(), new ArrayList());
        }
        for (i = 0; i < calleeMethod.getParamCount(); ++i) {
            varRangeMap.put(calleeMethod.getParam(i), new ArrayList());
        }
        for (i = 0; i < calleeMethod.getLocalCount(); ++i) {
            varRangeMap.put(calleeMethod.getLocal(i), new ArrayList());
        }
        return this.updateVarRangeMap(varRangeMap);
    }

    public HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> updateVarRangeMap(HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap) {
        SubRange subRange = this.getFirstCallee();
        while (subRange != null) {
            this.addVarRanges(subRange, varRangeMap);
            subRange = subRange.siblingCallee;
        }
        return varRangeMap;
    }

    public void addVarRanges(SubRange subRange, HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap) {
        int localValueCount = subRange.getLocalValueCount();
        block3: for (int i = 0; i < localValueCount; ++i) {
            DebugInfoProvider.DebugLocalValueInfo localValueInfo = subRange.getLocalValue(i);
            DebugInfoProvider.DebugLocalInfo local = subRange.getLocal(i);
            if (local == null) continue;
            switch (localValueInfo.localKind()) {
                case REGISTER: 
                case STACKSLOT: 
                case CONSTANT: {
                    List<SubRange> varRanges = varRangeMap.get(local);
                    assert (varRanges != null) : "local not present in var to ranges map!";
                    varRanges.add(subRange);
                    continue block3;
                }
            }
        }
    }
}

