/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.dwarf.DwarfSectionImpl;
import java.util.Map;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfARangesSectionImpl
extends DwarfSectionImpl {
    private static final int DW_AR_HEADER_SIZE = 12;
    private static final int DW_AR_HEADER_PAD_SIZE = 4;
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};

    public DwarfARangesSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return this.dwarfSections.arangesSectionName();
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        int methodCount = this.compiledMethodsCount();
        byte[] buffer = new byte[DwarfARangesSectionImpl.entrySize(methodCount)];
        super.setContent(buffer);
    }

    private static int entrySize(int methodCount) {
        int size = 0;
        size += 12;
        size += 4;
        size += methodCount * 16;
        return size += 16;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        Object valueObj;
        ObjectFile.Element textElement = this.getElement().getOwner().elementForName(this.dwarfSections.textSectionName());
        LayoutDecisionMap decisionMap = alreadyDecided.get(textElement);
        if (decisionMap != null && (valueObj = decisionMap.getDecidedValue(LayoutDecision.Kind.VADDR)) != null && valueObj instanceof Number) {
            this.debugTextBase = ((Number)valueObj).longValue();
        }
        return super.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this);
        this.enableLog(context, cursor.get());
        this.log(context, "  [0x%08x] DEBUG_ARANGES", cursor.get());
        int lengthPos = cursor.get();
        cursor.set(this.writeHeader(0, buffer, cursor.get()));
        this.compiledMethodsStream().forEach(compiledMethodEntry -> cursor.set(this.writeARange(context, (CompiledMethodEntry)compiledMethodEntry, buffer, cursor.get())));
        cursor.set(this.writeLong(0L, buffer, cursor.get()));
        cursor.set(this.writeLong(0L, buffer, cursor.get()));
        this.patchLength(lengthPos, buffer, cursor.get());
        assert (cursor.get() == size);
    }

    private int writeHeader(int cuIndex, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeInt(0, buffer, pos);
        pos = this.writeShort((short)2, buffer, pos);
        pos = this.writeInfoSectionOffset(cuIndex, buffer, pos);
        pos = this.writeByte((byte)8, buffer, pos);
        pos = this.writeByte((byte)0, buffer, pos);
        assert (pos - p == 12);
        for (int i = 0; i < 4; ++i) {
            pos = this.writeByte((byte)0, buffer, pos);
        }
        return pos;
    }

    int writeARange(DebugContext context, CompiledMethodEntry compiledMethod, byte[] buffer, int p) {
        int pos = p;
        PrimaryRange primary = compiledMethod.getPrimary();
        this.log(context, "  [0x%08x] %016x %016x %s", pos, this.debugTextBase + primary.getLo(), primary.getHi() - primary.getLo(), primary.getFullMethodNameWithParams());
        pos = this.writeRelocatableCodeOffset(primary.getLo(), buffer, pos);
        pos = this.writeLong(primary.getHi() - primary.getLo(), buffer, pos);
        return pos;
    }

    @Override
    public String targetSectionName() {
        return this.dwarfSections.frameSectionName();
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }
}

