/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.dwarf.DwarfSectionImpl;
import java.util.List;
import org.graalvm.compiler.debug.DebugContext;

public abstract class DwarfFrameSectionImpl
extends DwarfSectionImpl {
    private static final int PADDING_NOPS_ALIGNMENT = 8;
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE};

    public DwarfFrameSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
    }

    @Override
    public String getSectionName() {
        return this.dwarfSections.frameSectionName();
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        int pos = 0;
        pos = this.writeCIE(null, pos);
        pos = this.writeMethodFrames(null, pos);
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        pos = this.writeCIE(buffer, pos);
        pos = this.writeMethodFrames(buffer, pos);
        if (pos != size) {
            System.out.format("pos = 0x%x  size = 0x%x", pos, size);
        }
        assert (pos == size);
    }

    private int writeCIE(byte[] buffer, int p) {
        int pos;
        int lengthPos = pos = p;
        pos = this.writeInt(0, buffer, pos);
        pos = this.writeInt(-1, buffer, pos);
        pos = this.writeByte((byte)1, buffer, pos);
        pos = this.writeByte((byte)0, buffer, pos);
        pos = this.writeULEB(1L, buffer, pos);
        pos = this.writeSLEB(-8L, buffer, pos);
        pos = this.writeByte((byte)this.getReturnPCIdx(), buffer, pos);
        pos = this.writeInitialInstructions(buffer, pos);
        pos = this.writePaddingNops(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeMethodFrame(CompiledMethodEntry compiledEntry, byte[] buffer, int p) {
        int pos;
        int lengthPos = pos = p;
        PrimaryRange range = compiledEntry.getPrimary();
        long lo = range.getLo();
        long hi = range.getHi();
        pos = this.writeFDEHeader((int)lo, (int)hi, buffer, pos);
        pos = this.writeFDEs(compiledEntry.getFrameSize(), compiledEntry.getFrameSizeInfos(), buffer, pos);
        pos = this.writePaddingNops(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeMethodFrames(byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, p);
        this.compiledMethodsStream().forEach(compiledMethod -> cursor.set(this.writeMethodFrame((CompiledMethodEntry)compiledMethod, buffer, cursor.get())));
        return cursor.get();
    }

    protected abstract int writeFDEs(int var1, List<DebugInfoProvider.DebugFrameSizeChange> var2, byte[] var3, int var4);

    private int writeFDEHeader(int lo, int hi, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeInt(0, buffer, pos);
        pos = this.writeInt(0, buffer, pos);
        pos = this.writeRelocatableCodeOffset(lo, buffer, pos);
        return this.writeLong(hi - lo, buffer, pos);
    }

    private int writePaddingNops(byte[] buffer, int p) {
        int pos = p;
        while ((pos & 7) != 0) {
            pos = this.writeByte((byte)0, buffer, pos);
        }
        return pos;
    }

    protected int writeDefCFA(int register, int offset, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeByte((byte)12, buffer, pos);
        pos = this.writeULEB(register, buffer, pos);
        return this.writeULEB(offset, buffer, pos);
    }

    protected int writeDefCFAOffset(int offset, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeByte((byte)14, buffer, pos);
        return this.writeULEB(offset, buffer, pos);
    }

    protected int writeAdvanceLoc(int offset, byte[] buffer, int pos) {
        if (offset <= 63) {
            return this.writeAdvanceLoc0((byte)offset, buffer, pos);
        }
        if (offset <= 255) {
            return this.writeAdvanceLoc1((byte)offset, buffer, pos);
        }
        if (offset <= 65535) {
            return this.writeAdvanceLoc2((short)offset, buffer, pos);
        }
        return this.writeAdvanceLoc4(offset, buffer, pos);
    }

    protected int writeAdvanceLoc0(byte offset, byte[] buffer, int pos) {
        byte op = DwarfFrameSectionImpl.advanceLoc0Op(offset);
        return this.writeByte(op, buffer, pos);
    }

    protected int writeAdvanceLoc1(byte offset, byte[] buffer, int p) {
        int pos = p;
        byte op = 2;
        pos = this.writeByte(op, buffer, pos);
        return this.writeByte(offset, buffer, pos);
    }

    protected int writeAdvanceLoc2(short offset, byte[] buffer, int p) {
        byte op = 3;
        int pos = p;
        pos = this.writeByte(op, buffer, pos);
        return this.writeShort(offset, buffer, pos);
    }

    protected int writeAdvanceLoc4(int offset, byte[] buffer, int p) {
        byte op = 4;
        int pos = p;
        pos = this.writeByte(op, buffer, pos);
        return this.writeInt(offset, buffer, pos);
    }

    protected int writeOffset(int register, int offset, byte[] buffer, int p) {
        byte op = DwarfFrameSectionImpl.offsetOp(register);
        int pos = p;
        pos = this.writeByte(op, buffer, pos);
        return this.writeULEB(offset, buffer, pos);
    }

    protected int writeRestore(int register, byte[] buffer, int p) {
        byte op = DwarfFrameSectionImpl.restoreOp(register);
        int pos = p;
        return this.writeByte(op, buffer, pos);
    }

    protected int writeRegister(int savedReg, int savedToReg, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeByte((byte)9, buffer, pos);
        pos = this.writeULEB(savedReg, buffer, pos);
        return this.writeULEB(savedToReg, buffer, pos);
    }

    protected abstract int getReturnPCIdx();

    protected abstract int getSPIdx();

    protected abstract int writeInitialInstructions(byte[] var1, int var2);

    @Override
    public String targetSectionName() {
        return this.dwarfSections.lineSectionName();
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }

    private static byte offsetOp(int register) {
        assert (register >> 6 == 0);
        return (byte)(0x80 | register);
    }

    private static byte restoreOp(int register) {
        assert (register >> 6 == 0);
        return (byte)(0xC0 | register);
    }

    private static byte advanceLoc0Op(int offset) {
        assert (offset >= 0 && offset <= 63);
        return (byte)(0x40 | offset);
    }
}

