/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf;

import com.oracle.objectfile.dwarf.DwarfARangesSectionImpl;
import com.oracle.objectfile.dwarf.DwarfAbbrevSectionImpl;
import com.oracle.objectfile.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.dwarf.DwarfFrameSectionImpl;
import com.oracle.objectfile.dwarf.DwarfFrameSectionImplAArch64;
import com.oracle.objectfile.dwarf.DwarfFrameSectionImplX86_64;
import com.oracle.objectfile.dwarf.DwarfInfoSectionImpl;
import com.oracle.objectfile.dwarf.DwarfLineSectionImpl;
import com.oracle.objectfile.dwarf.DwarfLocSectionImpl;
import com.oracle.objectfile.dwarf.DwarfStrSectionImpl;
import com.oracle.objectfile.elf.ELFMachine;
import java.nio.ByteOrder;

public class ELFDebugInfo
extends DwarfDebugInfo {
    private final DwarfStrSectionImpl dwarfStrSection;
    private final DwarfAbbrevSectionImpl dwarfAbbrevSection;
    private final DwarfInfoSectionImpl dwarfInfoSection;
    private final DwarfLocSectionImpl dwarfLocSection;
    private final DwarfARangesSectionImpl dwarfARangesSection;
    private final DwarfLineSectionImpl dwarfLineSection;
    private final DwarfFrameSectionImpl dwarfFameSection;
    public final ELFMachine elfMachine;
    private final byte heapbaseRegister;
    private final byte threadRegister;

    public ELFDebugInfo(ELFMachine elfMachine, ByteOrder byteOrder) {
        super(byteOrder);
        this.elfMachine = elfMachine;
        this.dwarfStrSection = new DwarfStrSectionImpl(this);
        this.dwarfAbbrevSection = new DwarfAbbrevSectionImpl(this);
        this.dwarfInfoSection = new DwarfInfoSectionImpl(this);
        this.dwarfLocSection = new DwarfLocSectionImpl(this);
        this.dwarfARangesSection = new DwarfARangesSectionImpl(this);
        this.dwarfLineSection = new DwarfLineSectionImpl(this);
        if (this.isAarch64()) {
            this.dwarfFameSection = new DwarfFrameSectionImplAArch64(this);
            this.heapbaseRegister = (byte)27;
            this.threadRegister = (byte)28;
        } else {
            this.dwarfFameSection = new DwarfFrameSectionImplX86_64(this);
            this.heapbaseRegister = (byte)14;
            this.threadRegister = (byte)15;
        }
    }

    public DwarfStrSectionImpl getStrSectionImpl() {
        return this.dwarfStrSection;
    }

    public DwarfAbbrevSectionImpl getAbbrevSectionImpl() {
        return this.dwarfAbbrevSection;
    }

    public DwarfFrameSectionImpl getFrameSectionImpl() {
        return this.dwarfFameSection;
    }

    public DwarfInfoSectionImpl getInfoSectionImpl() {
        return this.dwarfInfoSection;
    }

    public DwarfLocSectionImpl getLocSectionImpl() {
        return this.dwarfLocSection;
    }

    public DwarfARangesSectionImpl getARangesSectionImpl() {
        return this.dwarfARangesSection;
    }

    public DwarfLineSectionImpl getLineSectionImpl() {
        return this.dwarfLineSection;
    }

    @Override
    public byte getHeapbaseRegister() {
        return this.heapbaseRegister;
    }

    public byte getThreadRegister() {
        return this.threadRegister;
    }

    @Override
    public boolean isAarch64() {
        return this.elfMachine == ELFMachine.AArch64;
    }

    @Override
    public boolean isAMD64() {
        return this.elfMachine == ELFMachine.X86_64;
    }

    @Override
    public String textSectionName() {
        return DwarfSectionName.TEXT_SECTION.value;
    }

    @Override
    public String lineSectionName() {
        return DwarfSectionName.DW_LINE_SECTION.value;
    }

    @Override
    public String strSectionName() {
        return DwarfSectionName.DW_STR_SECTION.value;
    }

    @Override
    public String locSectionName() {
        return DwarfSectionName.DW_LOC_SECTION.value;
    }

    @Override
    public String arangesSectionName() {
        return DwarfSectionName.DW_ARANGES_SECTION.value;
    }

    @Override
    public String frameSectionName() {
        return DwarfSectionName.DW_FRAME_SECTION.value;
    }

    @Override
    public String abbrevSectionName() {
        return DwarfSectionName.DW_ABBREV_SECTION.value;
    }

    @Override
    public String infoSectionName() {
        return DwarfSectionName.DW_INFO_SECTION.value;
    }

    static enum DwarfSectionName {
        TEXT_SECTION(".text"),
        DW_STR_SECTION(".debug_str"),
        DW_LINE_SECTION(".debug_line"),
        DW_FRAME_SECTION(".debug_frame"),
        DW_ABBREV_SECTION(".debug_abbrev"),
        DW_INFO_SECTION(".debug_info"),
        DW_LOC_SECTION(".debug_loc"),
        DW_ARANGES_SECTION(".debug_aranges");

        private final String value;

        private DwarfSectionName(String s) {
            this.value = s;
        }
    }
}

