/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.macho;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.StringTable;
import com.oracle.objectfile.SymbolTable;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.objectfile.io.OutputAssembler;
import com.oracle.objectfile.macho.MachOObjectFile;
import com.oracle.objectfile.macho.MachOStrtab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public final class MachOSymtab
extends MachOObjectFile.LinkEditElement
implements SymbolTable {
    final MachOStrtab strtab;
    private boolean isSorted;
    private final ArrayList<Entry> entries;
    private final HashMap<String, Entry> entriesByName;

    private static int compareEntries(Entry a, Entry b) {
        int cmp = Boolean.compare(a.isLocal(), b.isLocal());
        if (cmp == 0) {
            cmp = Boolean.compare(a.isDefined() && a.isExternal(), b.isDefined() && b.isExternal());
        }
        if (cmp == 0) {
            cmp = Boolean.compare(!a.isDefined() && a.isExternal(), !b.isDefined() && b.isExternal());
        }
        if (cmp == 0) {
            cmp = a.getName().compareTo(b.getName());
        }
        return cmp;
    }

    public MachOSymtab(String name, MachOObjectFile objectFile, MachOObjectFile.Segment64Command containingSegment, MachOStrtab strtab) {
        MachOObjectFile machOObjectFile = objectFile;
        Objects.requireNonNull(machOObjectFile);
        super(machOObjectFile, name, containingSegment, objectFile.getWordSizeInBytes());
        this.isSorted = false;
        this.entries = new ArrayList();
        this.entriesByName = new HashMap();
        this.strtab = strtab;
        strtab.setContentProvider(() -> this.getSortedEntries().stream().map(Entry::getNameInObject).iterator());
    }

    public List<Entry> getSortedEntries() {
        if (!this.isSorted) {
            this.entries.sort(MachOSymtab::compareEntries);
            this.isSorted = true;
        }
        return this.entries;
    }

    private List<Entry> getModifiableEntries() {
        if (this.isSorted) {
            throw new RuntimeException("unexpected access to unsorted symtab entries");
        }
        return this.entries;
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        HashSet<BuildDependency> deps = ObjectFile.minimalDependencies(decisions, this);
        LayoutDecision ourContent = decisions.get(this).getDecision(LayoutDecision.Kind.CONTENT);
        LayoutDecision strtabContent = decisions.get(this.strtab).getDecision(LayoutDecision.Kind.CONTENT);
        deps.add(BuildDependency.createOrGet(ourContent, strtabContent));
        for (Entry e : this.entries) {
            ObjectFile.Section s = e.getDefinedSection();
            if (s == null) continue;
            deps.add(BuildDependency.createOrGet(ourContent, decisions.get(s).getDecision(LayoutDecision.Kind.VADDR)));
        }
        return deps;
    }

    @Override
    public int getOrDecideOffset(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int offsetHint) {
        return ObjectFile.defaultGetOrDecideOffset(alreadyDecided, this, offsetHint);
    }

    private int getWrittenSize() {
        return this.getEntryCount() * EntryStruct.getWrittenSize();
    }

    @Override
    public int getOrDecideSize(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int sizeHint) {
        return this.getWrittenSize();
    }

    private int firstIndexMatching(Predicate<Entry> p) {
        int i = 0;
        for (Entry e : this.getSortedEntries()) {
            if (p.test(e)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int firstIndexMatchingOrZero(Predicate<Entry> p) {
        int firstIndex = this.firstIndexMatching(p);
        return firstIndex != -1 ? firstIndex : 0;
    }

    private int nContiguousMatching(Predicate<Entry> p) {
        int n = 0;
        for (Entry e : this.getSortedEntries()) {
            if (p.test(e)) {
                ++n;
                continue;
            }
            if (n == 0) continue;
            return n;
        }
        return n;
    }

    int firstLocal() {
        return this.firstIndexMatchingOrZero(Entry::isLocal);
    }

    int nLocals() {
        return this.nContiguousMatching(Entry::isLocal);
    }

    int firstExtDef() {
        return this.firstIndexMatchingOrZero(e -> e.isExternal() && e.isDefined());
    }

    int nExtDef() {
        return this.nContiguousMatching(e -> e.isExternal() && e.isDefined());
    }

    int firstUndef() {
        return this.firstIndexMatchingOrZero(e -> !e.isDefined());
    }

    int nUndef() {
        return this.nContiguousMatching(e -> !e.isDefined());
    }

    private boolean isDynamic() {
        return true;
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        AssemblyBuffer oa = AssemblyBuffer.createOutputAssembler(this.getOwner().getByteOrder());
        byte[] strtabContent = (byte[])alreadyDecided.get(this.strtab).getDecidedValue(LayoutDecision.Kind.CONTENT);
        StringTable t = new StringTable(strtabContent);
        EntryStruct s = new EntryStruct();
        for (Entry e : this.getSortedEntries()) {
            int sectionIndex;
            s.strx = t.indexFor(e.getNameInObject());
            assert (s.strx != -1);
            s.type = (byte)(e.type.value() | (e.privateExtern ? 16 : 0) | (e.extern ? 1 : 0));
            int n = sectionIndex = e.section == null ? 0 : this.getOwner().getSections().indexOf(e.section) + 1;
            assert (!e.isDefined() || sectionIndex != -1);
            s.sect = (byte)(e.isDefined() ? sectionIndex : 0);
            s.desc = (short)(ObjectFile.flagSetAsLong(e.descFlags) | (long)e.refType.value());
            int valueToAdd = sectionIndex == 0 ? 0 : (Integer)alreadyDecided.get(e.section).getDecidedValue(LayoutDecision.Kind.VADDR);
            s.value = e.value + (long)valueToAdd;
            s.write(oa);
        }
        assert (oa.pos() == this.getWrittenSize());
        return oa.getBlob();
    }

    @Override
    public int getOrDecideVaddr(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, int vaddrHint) {
        return ObjectFile.defaultGetOrDecideVaddr(alreadyDecided, this, vaddrHint);
    }

    @Override
    public LayoutDecisionMap getDecisions(LayoutDecisionMap copyingIn) {
        return ObjectFile.defaultDecisions(this, copyingIn);
    }

    @Override
    public ObjectFile.Symbol newDefinedEntry(String name, ObjectFile.Section referencedSection, long referencedOffset, long size, boolean isGlobal, boolean isCode) {
        return this.addEntry(new Entry(name, referencedSection, referencedOffset, isGlobal, isCode));
    }

    @Override
    public ObjectFile.Symbol newUndefinedEntry(String name, boolean isCode) {
        return this.addEntry(new Entry(name, isCode));
    }

    private Entry addEntry(Entry entry) {
        this.entriesByName.compute(entry.getName(), (k, v) -> SymbolTable.tryReplace(v, entry));
        this.getModifiableEntries().add(entry);
        return entry;
    }

    @Override
    public ObjectFile.Symbol getSymbol(String name) {
        return this.entriesByName.get(name);
    }

    @Override
    public ElementImpl getImpl() {
        return this;
    }

    @Override
    public boolean isLoadable() {
        return this.segment instanceof MachOObjectFile.LinkEditSegment64Command;
    }

    public int indexOf(ObjectFile.Symbol sym) {
        int offset = Collections.binarySearch(this.getSortedEntries(), (Entry)sym, MachOSymtab::compareEntries);
        return offset < 0 ? -1 : offset;
    }

    @Override
    public Iterator<ObjectFile.Symbol> iterator() {
        return this.getSortedEntries().iterator();
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public static final class Entry
    implements ObjectFile.Symbol {
        private final boolean isCode;
        private final String name;
        private final MachOObjectFile.MachOSection section;
        private final boolean privateExtern;
        private final boolean extern;
        private final SymbolType type;
        private final ReferenceType refType;
        private final EnumSet<DescFlag> descFlags;
        private final long value;

        Entry(String name, boolean isCode) {
            this(name, null, false, true, SymbolType.UNDF, ReferenceType.REFERENCE_FLAG_UNDEFINED_LAZY, EnumSet.noneOf(DescFlag.class), 0L, isCode);
        }

        Entry(String name, ObjectFile.Section referencedSection, long referencedOffset, boolean isGlobal, boolean isCode) {
            this(name, (MachOObjectFile.MachOSection)referencedSection, false, isGlobal, SymbolType.SECT, ReferenceType.REFERENCE_FLAG_DEFINED, EnumSet.noneOf(DescFlag.class), (int)referencedOffset, isCode);
        }

        private Entry(String name, MachOObjectFile.MachOSection section, boolean privateExtern, boolean extern, SymbolType type, ReferenceType refType, EnumSet<DescFlag> descFlags, long value, boolean isCode) {
            this.name = name;
            this.section = section;
            this.privateExtern = privateExtern;
            this.extern = extern;
            this.type = type;
            this.refType = refType;
            this.descFlags = descFlags;
            this.value = value;
            this.isCode = isCode;
        }

        boolean isExternal() {
            return this.privateExtern || this.extern;
        }

        @Override
        public long getDefinedAbsoluteValue() {
            assert (this.type == SymbolType.ABS);
            return this.value;
        }

        @Override
        public long getDefinedOffset() {
            assert (this.type == SymbolType.SECT);
            return this.value;
        }

        @Override
        public ObjectFile.Section getDefinedSection() {
            return this.section;
        }

        public String getNameInObject() {
            return "_" + this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getSize() {
            return 0L;
        }

        @Override
        public boolean isAbsolute() {
            return this.type == SymbolType.ABS;
        }

        @Override
        public boolean isCommon() {
            return this.type == SymbolType.UNDF && this.extern && this.value != 0L;
        }

        @Override
        public boolean isDefined() {
            return this.type == SymbolType.SECT || this.type == SymbolType.ABS;
        }

        public boolean isLocal() {
            return !this.extern && !this.privateExtern;
        }

        @Override
        public boolean isGlobal() {
            return this.extern;
        }

        @Override
        public boolean isFunction() {
            return this.isCode;
        }

        public String toString() {
            return "symbol '" + this.name + "', value " + this.value;
        }
    }

    static class EntryStruct {
        int strx;
        byte type;
        byte sect;
        short desc;
        long value;
        static final short NO_SECT = 0;
        static final short MAX_SECT = 255;
        static final byte N_UNDF = 0;
        static final byte N_ABS = 2;
        static final byte N_SECT = 14;
        static final byte N_PBUD = 12;
        static final byte N_INDR = 10;
        static final byte N_STAB = -32;
        static final byte N_PEXT = 16;
        static final byte N_TYPE = 14;
        static final byte N_EXT = 1;

        EntryStruct() {
        }

        void write(OutputAssembler oa) {
            oa.write4Byte(this.strx);
            oa.writeByte(this.type);
            oa.writeByte(this.sect);
            oa.write2Byte(this.desc);
            oa.write8Byte(this.value);
        }

        static int getWrittenSize() {
            return 16;
        }
    }

    static enum SymbolType {
        UNDF(0),
        ABS(2),
        SECT(14),
        PBUD(12),
        INDR(10);

        private final int value;

        private SymbolType(int value) {
            this.value = value;
        }

        int value() {
            return this.value;
        }
    }

    static enum ReferenceType {
        REFERENCE_FLAG_UNDEFINED_NON_LAZY(0),
        REFERENCE_FLAG_UNDEFINED_LAZY(1),
        REFERENCE_FLAG_DEFINED(2),
        REFERENCE_FLAG_PRIVATE_DEFINED(3),
        REFERENCE_FLAG_PRIVATE_UNDEFINED_NON_LAZY(4),
        REFERENCE_FLAG_PRIVATE_UNDEFINED_LAZY(5);

        private final int value;

        private ReferenceType(int value) {
            this.value = value;
        }

        int value() {
            return this.value;
        }
    }

    static enum DescFlag implements ObjectFile.ValueEnum
    {
        REFERENCED_DYNAMICALLY(16),
        N_DESC_DISCARDED(32),
        N_WEAK_REF(64),
        N_WEAK_DEF(128);

        private final int value;

        private DescFlag(int value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }
    }
}

