/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ConfigurationConditionPrintable;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ProxyConfigurationParser;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public final class ProxyConfiguration
extends ConfigurationBase<ProxyConfiguration, Predicate> {
    private final Set<ConditionalElement<List<String>>> interfaceLists = ConcurrentHashMap.newKeySet();

    public ProxyConfiguration() {
    }

    public ProxyConfiguration(ProxyConfiguration other) {
        for (ConditionalElement<List<String>> interfaceList : other.interfaceLists) {
            this.interfaceLists.add((ConditionalElement<List<String>>)new ConditionalElement(interfaceList.getCondition(), new ArrayList((Collection)interfaceList.getElement())));
        }
    }

    @Override
    public ProxyConfiguration copy() {
        return new ProxyConfiguration(this);
    }

    @Override
    protected void merge(ProxyConfiguration other) {
        for (ConditionalElement<List<String>> interfaceList : other.interfaceLists) {
            this.interfaceLists.add((ConditionalElement<List<String>>)new ConditionalElement(interfaceList.getCondition(), new ArrayList((Collection)interfaceList.getElement())));
        }
    }

    @Override
    protected void intersect(ProxyConfiguration other) {
        this.interfaceLists.retainAll(other.interfaceLists);
    }

    @Override
    protected void removeIf(Predicate predicate) {
        this.interfaceLists.removeIf(predicate::testProxyInterfaceList);
    }

    @Override
    public void subtract(ProxyConfiguration other) {
        this.interfaceLists.removeAll(other.interfaceLists);
    }

    @Override
    public void mergeConditional(ConfigurationCondition condition, ProxyConfiguration other) {
        for (ConditionalElement<List<String>> interfaceList : other.interfaceLists) {
            this.add(condition, new ArrayList<String>((Collection)interfaceList.getElement()));
        }
    }

    public void add(ConfigurationCondition condition, List<String> interfaceList) {
        this.interfaceLists.add((ConditionalElement<List<String>>)new ConditionalElement(condition, interfaceList));
    }

    public boolean contains(ConfigurationCondition condition, List<String> interfaceList) {
        return this.interfaceLists.contains(new ConditionalElement(condition, interfaceList));
    }

    public boolean contains(ConfigurationCondition condition, String ... interfaces) {
        return this.contains(condition, Arrays.asList(interfaces));
    }

    public void printJson(JsonWriter writer) throws IOException {
        ArrayList<ConditionalElement<List<String>>> lists = new ArrayList<ConditionalElement<List<String>>>(this.interfaceLists.size());
        lists.addAll(this.interfaceLists);
        ProxyConfiguration.printProxyInterfaces(writer, lists);
    }

    public static void printProxyInterfaces(JsonWriter writer, List<ConditionalElement<List<String>>> lists) throws IOException {
        lists.sort(ConditionalElement.comparator(ProxyConfiguration::compareList));
        writer.append('[');
        writer.indent();
        String prefix = "";
        for (ConditionalElement<List<String>> list : lists) {
            writer.append(prefix).newline();
            writer.append('{').indent().newline();
            ConfigurationConditionPrintable.printConditionAttribute(list.getCondition(), writer);
            writer.quote("interfaces").append(":").append('[');
            String typePrefix = "";
            for (String type : (List)list.getElement()) {
                writer.append(typePrefix).quote(type);
                typePrefix = ",";
            }
            writer.append(']').unindent().newline();
            writer.append('}');
            prefix = ",";
        }
        writer.unindent().newline();
        writer.append(']');
    }

    @Override
    public ConfigurationParser createParser() {
        return new ProxyConfigurationParser(this.interfaceLists::add, true);
    }

    @Override
    public boolean isEmpty() {
        return this.interfaceLists.isEmpty();
    }

    private static <T extends Comparable<T>> int compareList(List<T> l1, List<T> l2) {
        for (int i = 0; i < l1.size() && i < l2.size(); ++i) {
            int c = ((Comparable)l1.get(i)).compareTo((Comparable)l2.get(i));
            if (c == 0) continue;
            return c;
        }
        return l1.size() - l2.size();
    }

    public static interface Predicate {
        public boolean testProxyInterfaceList(ConditionalElement<List<String>> var1);
    }
}

