/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config.conditional;

import com.oracle.svm.configure.config.ConfigurationPredefinedClass;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.config.SerializationConfigurationLambdaCapturingType;
import com.oracle.svm.configure.config.SerializationConfigurationType;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.filters.ComplexFilter;
import com.oracle.svm.core.configure.ConditionalElement;
import java.util.List;
import java.util.regex.Pattern;

public class ConditionalConfigurationPredicate
implements TypeConfiguration.Predicate,
ProxyConfiguration.Predicate,
ResourceConfiguration.Predicate,
SerializationConfiguration.Predicate,
PredefinedClassesConfiguration.Predicate {
    private final ComplexFilter filter;

    public ConditionalConfigurationPredicate(ComplexFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean testIncludedType(ConditionalElement<String> conditionalElement, ConfigurationType type) {
        return !this.filter.includes(conditionalElement.getCondition().getTypeName()) || !this.filter.includes(type.getQualifiedJavaName());
    }

    @Override
    public boolean testProxyInterfaceList(ConditionalElement<List<String>> conditionalElement) {
        return !this.filter.includes(conditionalElement.getCondition().getTypeName());
    }

    @Override
    public boolean testIncludedResource(ConditionalElement<String> condition, Pattern pattern) {
        return !this.filter.includes(condition.getCondition().getTypeName());
    }

    @Override
    public boolean testIncludedBundle(ConditionalElement<String> condition, ResourceConfiguration.BundleConfiguration bundleConfiguration) {
        return !this.filter.includes(condition.getCondition().getTypeName());
    }

    @Override
    public boolean testSerializationType(SerializationConfigurationType type) {
        return !this.filter.includes(type.getCondition().getTypeName()) || !this.filter.includes(type.getQualifiedJavaName());
    }

    @Override
    public boolean testLambdaSerializationType(SerializationConfigurationLambdaCapturingType type) {
        return !this.filter.includes(type.getCondition().getTypeName()) || !this.filter.includes(type.getQualifiedJavaName());
    }

    @Override
    public boolean testPredefinedClass(ConfigurationPredefinedClass clazz) {
        return clazz.getNameInfo() != null && !this.filter.includes(clazz.getNameInfo());
    }
}

