/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.filters.ConfigurationFilter;
import com.oracle.svm.configure.filters.HierarchyFilterNode;
import java.util.regex.Pattern;
import org.graalvm.compiler.phases.common.LazyValue;

public final class AccessAdvisor {
    public static final Pattern PROXY_CLASS_NAME_PATTERN = Pattern.compile("^(.+[/.])?\\$Proxy[0-9]+$");
    private static final HierarchyFilterNode internalCallerFilter = HierarchyFilterNode.createInclusiveRoot();
    private static final HierarchyFilterNode internalAccessFilter;
    private static final HierarchyFilterNode accessWithoutCallerFilter;
    private ConfigurationFilter callerFilter = internalCallerFilter;
    private ConfigurationFilter accessFilter = internalAccessFilter;
    private boolean heuristicsEnabled = true;
    private boolean isInLivePhase = false;
    private int launchPhase = 0;

    private static void excludeInaccessiblePackages(HierarchyFilterNode rootNode) {
        rootNode.addOrGetChildren("com.oracle.graal.**", ConfigurationFilter.Inclusion.Exclude);
        rootNode.addOrGetChildren("com.oracle.truffle.**", ConfigurationFilter.Inclusion.Exclude);
        rootNode.addOrGetChildren("org.graalvm.compiler.**", ConfigurationFilter.Inclusion.Exclude);
        rootNode.addOrGetChildren("org.graalvm.libgraal.**", ConfigurationFilter.Inclusion.Exclude);
    }

    public static HierarchyFilterNode copyBuiltinCallerFilterTree() {
        return internalCallerFilter.copy();
    }

    public static HierarchyFilterNode copyBuiltinAccessFilterTree() {
        return internalAccessFilter.copy();
    }

    public void setHeuristicsEnabled(boolean enable) {
        this.heuristicsEnabled = enable;
    }

    public void setCallerFilterTree(ConfigurationFilter rootNode) {
        this.callerFilter = rootNode;
    }

    public void setAccessFilterTree(ConfigurationFilter rootNode) {
        this.accessFilter = rootNode;
    }

    public void setInLivePhase(boolean live) {
        this.isInLivePhase = live;
    }

    public boolean shouldIgnore(LazyValue<String> queriedClass, LazyValue<String> callerClass, boolean useLambdaHeuristics) {
        if (this.heuristicsEnabled && !this.isInLivePhase) {
            return true;
        }
        String qualifiedCaller = (String)callerClass.get();
        assert (qualifiedCaller == null || qualifiedCaller.indexOf(47) == -1) : "expecting Java-format qualifiers, not internal format";
        if (qualifiedCaller != null && !this.callerFilter.includes(qualifiedCaller)) {
            return true;
        }
        if (callerClass.get() == null && queriedClass.get() != null && !accessWithoutCallerFilter.includes((String)queriedClass.get())) {
            return true;
        }
        if (this.accessFilter != null && queriedClass.get() != null && !this.accessFilter.includes((String)queriedClass.get())) {
            return true;
        }
        if (this.heuristicsEnabled && queriedClass.get() != null) {
            return useLambdaHeuristics && ((String)queriedClass.get()).contains("$$Lambda$") || PROXY_CLASS_NAME_PATTERN.matcher((CharSequence)queriedClass.get()).matches();
        }
        return false;
    }

    public boolean shouldIgnore(LazyValue<String> queriedClass, LazyValue<String> callerClass) {
        return this.shouldIgnore(queriedClass, callerClass, true);
    }

    public boolean shouldIgnoreJniMethodLookup(LazyValue<String> queriedClass, LazyValue<String> name, LazyValue<String> signature, LazyValue<String> callerClass) {
        assert (!this.shouldIgnore(queriedClass, callerClass)) : "must have been checked before";
        if (!this.heuristicsEnabled) {
            return false;
        }
        if ("sun.launcher.LauncherHelper".equals(queriedClass.get())) {
            if (this.launchPhase == 0 && "getApplicationClass".equals(name.get()) && "()Ljava/lang/Class;".equals(signature.get())) {
                this.launchPhase = 1;
            }
            return true;
        }
        if (this.launchPhase == 1 && "getCanonicalName".equals(name.get()) && "()Ljava/lang/String;".equals(signature.get())) {
            this.launchPhase = 2;
            return true;
        }
        if (this.launchPhase > 0) {
            this.launchPhase = -1;
            if ("main".equals(name.get()) && "([Ljava/lang/String;)V".equals(signature.get())) {
                return true;
            }
        }
        return false;
    }

    public boolean shouldIgnoreLoadClass(LazyValue<String> queriedClass, LazyValue<String> callerClass) {
        assert (!this.shouldIgnore(queriedClass, callerClass)) : "must have been checked before";
        if (!this.heuristicsEnabled) {
            return false;
        }
        return callerClass.get() == null;
    }

    static {
        internalCallerFilter.addOrGetChildren("com.sun.crypto.provider.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("com.sun.java.util.jar.pack.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("com.sun.net.ssl.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("com.sun.nio.file.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("com.sun.nio.sctp.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("com.sun.nio.zipfs.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.io.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.lang.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.lang.ClassLoader$NativeLibrary", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.math.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.net.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.nio.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.text.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.time.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.util.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("java.util.concurrent.atomic.*", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.util.Collections", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("java.util.concurrent.ForkJoinTask", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("javax.crypto.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("javax.lang.model.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("javax.net.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("javax.tools.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("jdk.internal.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("jdk.internal.loader.NativeLibraries$NativeLibraryImpl", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("jdk.jfr.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("jdk.net.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("jdk.nio.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("jdk.vm.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.invoke.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.launcher.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.misc.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.net.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.net.www.protocol.http.*", ConfigurationFilter.Inclusion.Include);
        internalCallerFilter.addOrGetChildren("sun.nio.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.reflect.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.text.**", ConfigurationFilter.Inclusion.Exclude);
        internalCallerFilter.addOrGetChildren("sun.util.**", ConfigurationFilter.Inclusion.Exclude);
        AccessAdvisor.excludeInaccessiblePackages(internalCallerFilter);
        internalCallerFilter.removeRedundantNodes();
        internalAccessFilter = HierarchyFilterNode.createInclusiveRoot();
        AccessAdvisor.excludeInaccessiblePackages(internalAccessFilter);
        internalAccessFilter.removeRedundantNodes();
        accessWithoutCallerFilter = HierarchyFilterNode.createInclusiveRoot();
        accessWithoutCallerFilter.addOrGetChildren("jdk.vm.ci.**", ConfigurationFilter.Inclusion.Exclude);
        accessWithoutCallerFilter.addOrGetChildren("[Ljava.lang.String;", ConfigurationFilter.Inclusion.Exclude);
        accessWithoutCallerFilter.removeRedundantNodes();
    }
}

