/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.model.CodeElementScanner;
import java.util.Objects;

public class CodeImport
implements Comparable<CodeImport> {
    private final String packageName;
    private final String symbolName;
    private final boolean staticImport;

    public CodeImport(String packageName, String symbolName, boolean staticImport) {
        this.packageName = packageName;
        this.symbolName = symbolName;
        this.staticImport = staticImport;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public boolean isStaticImport() {
        return this.staticImport;
    }

    @Override
    public int compareTo(CodeImport o) {
        if (this.staticImport && !o.staticImport) {
            return 1;
        }
        if (!this.staticImport && o.staticImport) {
            return -1;
        }
        int result = this.getPackageName().compareTo(o.getPackageName());
        if (result == 0) {
            return this.getSymbolName().compareTo(o.getSymbolName());
        }
        return result;
    }

    public <P> void accept(CodeElementScanner<?, P> s, P p) {
        s.visitImport(this, p);
    }

    public int hashCode() {
        return Objects.hash(this.packageName, this.symbolName, this.staticImport);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CodeImport) {
            CodeImport otherImport = (CodeImport)obj;
            return this.getPackageName().equals(otherImport.getPackageName()) && this.getSymbolName().equals(otherImport.getSymbolName()) && this.staticImport == otherImport.staticImport;
        }
        return super.equals(obj);
    }
}

