/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public final class LibraryMessage
extends MessageContainer {
    private final LibraryData library;
    private final String name;
    private final ExecutableElement executable;
    private final boolean isDeprecated;
    private boolean isAbstract;
    private final Set<LibraryMessage> abstractIfExported = new LinkedHashSet<LibraryMessage>();
    private final Set<LibraryMessage> abstractIfExportedAsWarning = new LinkedHashSet<LibraryMessage>();
    private List<LibraryMessage> deprecatedOverloads;
    private LibraryMessage deprecatedReplacement;

    public LibraryMessage(LibraryData library, String name, ExecutableElement executable, boolean isDeprecated) {
        this.library = library;
        this.name = name;
        this.executable = executable;
        this.isDeprecated = isDeprecated;
    }

    public LibraryData getLibrary() {
        return this.library;
    }

    public void setDeprecatedOverloads(List<LibraryMessage> deprecated) {
        this.deprecatedOverloads = deprecated;
        for (LibraryMessage message : deprecated) {
            if (!this.canBeDeprecatedFrom(message)) {
                throw new AssertionError((Object)"Undelegatable deprecated message added.");
            }
        }
    }

    public List<LibraryMessage> getDeprecatedOverloads() {
        if (this.deprecatedOverloads == null) {
            return Collections.emptyList();
        }
        return this.deprecatedOverloads;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public String getSimpleName() {
        return this.library.getMessageElement().getSimpleName().toString() + "." + this.name;
    }

    public ExecutableElement getExecutable() {
        return this.executable;
    }

    public boolean canBeDeprecatedFrom(LibraryMessage message) {
        if (this.equals(message)) {
            return true;
        }
        if (!Objects.equals(this.getLibrary(), message.getLibrary())) {
            return false;
        }
        List<? extends VariableElement> otherParameters = message.getExecutable().getParameters();
        List<? extends VariableElement> parameters = this.getExecutable().getParameters();
        if (otherParameters.size() != parameters.size()) {
            return true;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement thisParamter = parameters.get(i);
            VariableElement otherParameter = otherParameters.get(i);
            if (ElementUtils.isAssignable(otherParameter.asType(), thisParamter.asType())) continue;
            return false;
        }
        return true;
    }

    public void setDeprecatedReplacement(LibraryMessage replacement) {
        this.deprecatedReplacement = replacement;
    }

    public LibraryMessage getDeprecatedReplacement() {
        return this.deprecatedReplacement;
    }

    @Override
    public Element getMessageElement() {
        return this.executable;
    }

    public Set<LibraryMessage> getAbstractIfExported() {
        return this.abstractIfExported;
    }

    public Set<LibraryMessage> getAbstractIfExportedAsWarning() {
        return this.abstractIfExportedAsWarning;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return this.isAbstract || this.getExecutable().getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isCompatibleAssignable(List<TypeMirror> parameterTypes) {
        List<? extends VariableElement> libraryParameters = this.executable.getParameters();
        if (libraryParameters.size() != parameterTypes.size()) {
            return false;
        }
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (ElementUtils.isAssignable(parameterTypes.get(i), libraryParameters.get(i).asType())) continue;
            return false;
        }
        return true;
    }

    public boolean isCompatibleExact(List<TypeMirror> parameterTypes) {
        List<? extends VariableElement> libraryParameters = this.executable.getParameters();
        if (libraryParameters.size() != parameterTypes.size()) {
            return false;
        }
        for (int i = 1; i < parameterTypes.size(); ++i) {
            if (ElementUtils.typeEquals(parameterTypes.get(i), libraryParameters.get(i).asType())) continue;
            return false;
        }
        return true;
    }
}

