/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.mxtool.junit;

import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.internal.module.Modules;
import org.junit.runners.Suite;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ModuleSupport {
    private final PrintStream out;
    private static final Pattern OPEN_PACKAGE_SPEC = Pattern.compile("([^/]+)/([^=]+)(?:=(.+))?");

    ModuleSupport(PrintStream out) {
        this.out = out;
    }

    void processAddExportsAnnotations(Set<Class<?>> requestClasses, Set<String> opened, Set<String> exported) {
        HashSet classes = new HashSet();
        for (Class<?> cls : requestClasses) {
            this.gatherClasses(cls, classes);
        }
        HashSet types = new HashSet();
        for (Class clazz : classes) {
            ModuleSupport.gatherSupertypes(clazz, types);
        }
        for (Class clazz : types) {
            Annotation[] annos;
            for (Annotation a : annos = clazz.getAnnotations()) {
                Class<? extends Annotation> annotationType = a.annotationType();
                if (!annotationType.getSimpleName().equals("AddExports")) continue;
                Optional<String[]> value = ModuleSupport.getElement("value", String[].class, a);
                if (value.isPresent()) {
                    for (String spec : value.get()) {
                        this.openPackages(spec, clazz, opened, exported);
                    }
                    continue;
                }
                this.out.printf("%s: Ignoring \"AddExports\" annotation without `String value` element: %s%n", clazz.getName(), a);
            }
        }
    }

    private void gatherClasses(Class<?> base, Set<Class<?>> classes) {
        if (!classes.contains(base)) {
            classes.add(base);
            Suite.SuiteClasses annot = base.getDeclaredAnnotation(Suite.SuiteClasses.class);
            if (annot != null) {
                for (Class cls : annot.value()) {
                    this.gatherClasses(cls, classes);
                }
            }
        }
    }

    void processAddModulesAnnotations(Set<Class<?>> classes) {
        HashSet types = new HashSet();
        for (Class<?> clazz : classes) {
            ModuleSupport.gatherSupertypes(clazz, types);
        }
        for (Class<Object> clazz : types) {
            Annotation[] annos;
            for (Annotation a : annos = clazz.getAnnotations()) {
                Class<? extends Annotation> annotationType = a.annotationType();
                if (!annotationType.getSimpleName().equals("AddModules")) continue;
                Optional<String[]> value = ModuleSupport.getElement("value", String[].class, a);
                if (value.isPresent()) {
                    for (String spec : value.get()) {
                        Modules.loadModule(spec);
                    }
                    continue;
                }
                this.out.printf("%s: Ignoring \"AddModules\" annotation without `String value` element: %s%n", clazz.getName(), a);
            }
        }
    }

    public static List<Module> findModules(String spec) {
        ModuleLayer bootLayer = ModuleLayer.boot();
        Set<Module> modules = bootLayer.modules();
        ArrayList<Module> result = new ArrayList<Module>();
        StringSpec matcher = new StringSpec(spec);
        for (Module module : modules) {
            if (!matcher.matches(module.getName())) continue;
            result.add(module);
        }
        return result;
    }

    void openPackages(String spec, Object context, Set<String> opened, Set<String> exported) {
        Matcher m = OPEN_PACKAGE_SPEC.matcher(spec);
        if (m.matches()) {
            String moduleSpec = m.group(1);
            String packageSpec = m.group(2);
            String targetSpecs = m.group(3);
            List<Module> modules = ModuleSupport.findModules(moduleSpec);
            if (modules.isEmpty()) {
                this.out.printf("%s: Cannot find module(s) matching %s: %s%n", context, moduleSpec, spec);
            } else {
                ArrayList<Module> targets = new ArrayList<Module>();
                if (context instanceof Class) {
                    targets.add(((Class)context).getModule());
                }
                boolean allUnnamedTarget = false;
                if (targetSpecs != null) {
                    for (String targetSpec : targetSpecs.split(",")) {
                        if (targetSpec.equals("ALL-UNNAMED")) {
                            allUnnamedTarget = true;
                            continue;
                        }
                        List<Module> list = ModuleSupport.findModules(targetSpec);
                        if (list.isEmpty()) {
                            this.out.printf("%s: Cannot find target module(s) matching %s: %s%n", context, targetSpec, spec);
                            continue;
                        }
                        targets.addAll(list);
                    }
                } else {
                    allUnnamedTarget = true;
                }
                StringSpec packageMatcher = new StringSpec(packageSpec);
                for (Module module : modules) {
                    for (String pn : module.getPackages()) {
                        if (!packageMatcher.matches(pn)) continue;
                        ArrayList<String> openTargets = new ArrayList<String>();
                        ArrayList<String> exportTargets = new ArrayList<String>();
                        if (allUnnamedTarget) {
                            if (!module.isExported(pn)) {
                                exportTargets.add("ALL-UNNAMED");
                                Modules.addExportsToAllUnnamed(module, pn);
                            }
                            if (!module.isOpen(pn)) {
                                openTargets.add("ALL-UNNAMED");
                                Modules.addOpensToAllUnnamed(module, pn);
                            }
                        }
                        for (Module target : targets) {
                            if (!module.isExported(pn, target)) {
                                if (target.isNamed()) {
                                    exportTargets.add(target.getName());
                                }
                                Modules.addExports(module, pn, target);
                            }
                            if (module.isOpen(pn, target)) continue;
                            if (target.isNamed()) {
                                openTargets.add(target.getName());
                            }
                            Modules.addOpens(module, pn, target);
                        }
                        if (!exportTargets.isEmpty()) {
                            exported.add(String.format("%s/%s=%s", module.getName(), pn, String.join((CharSequence)",", exportTargets)));
                        }
                        if (openTargets.isEmpty()) continue;
                        opened.add(String.format("%s/%s=%s", module.getName(), pn, String.join((CharSequence)",", openTargets)));
                    }
                }
            }
        } else {
            this.out.printf("%s: Ignoring specification not matching <module>/<package>[=<target-module>(,<target-module>)*] pattern: %s%n", context, spec);
        }
    }

    private static void gatherSupertypes(Class<?> cls, Set<Class<?>> supertypes) {
        if (!supertypes.contains(cls)) {
            supertypes.add(cls);
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null) {
                ModuleSupport.gatherSupertypes(superclass, supertypes);
            }
            for (Class<?> iface : cls.getInterfaces()) {
                ModuleSupport.gatherSupertypes(iface, supertypes);
            }
        }
    }

    private static <T> Optional<T> getElement(String name, Class<T> type, Annotation annotation) {
        Method valueAccessor;
        Class<? extends Annotation> annotationType = annotation.annotationType();
        try {
            valueAccessor = annotationType.getMethod(name, new Class[0]);
            if (!valueAccessor.getReturnType().equals(type)) {
                throw new AssertionError((Object)String.format("Element %s of %s is of type %s, not %s ", name, annotationType.getName(), valueAccessor.getReturnType().getName(), type.getName()));
            }
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
        try {
            return Optional.of(type.cast(valueAccessor.invoke((Object)annotation, new Object[0])));
        }
        catch (Exception e) {
            throw new AssertionError(String.format("Could not read %s element from %s", name, annotation), e);
        }
    }

    static class StringSpec {
        final String key;
        final boolean isPrefix;

        StringSpec(String spec) {
            this.isPrefix = spec.endsWith("*");
            this.key = this.isPrefix ? spec.substring(0, spec.length() - 1) : spec;
        }

        boolean matches(String s) {
            if (this.isPrefix) {
                return s.startsWith(this.key);
            }
            return s.equals(this.key);
        }
    }
}

