/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.mxtool.junit;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public final class MxJUnitRequest {
    private final Request request;
    final Set<Class<?>> classes;
    final String methodName;
    final List<Failure> missingClasses;

    private MxJUnitRequest(Request request, Set<Class<?>> classes, String methodName, List<Failure> missingClasses) {
        this.request = request;
        this.classes = classes;
        this.methodName = methodName;
        this.missingClasses = missingClasses;
    }

    public Request getRequest() {
        return this.request;
    }

    public List<Failure> getMissingClasses() {
        return Collections.unmodifiableList(this.missingClasses);
    }

    public static class Builder
    extends AllDefaultPossibilitiesBuilder {
        private final Set<Class<?>> classes = new LinkedHashSet();
        private String methodName = null;
        private final List<Failure> missingClasses = new ArrayList<Failure>();

        public Builder() {
            super(true);
        }

        protected Class<?> resolveClass(String name) throws ClassNotFoundException {
            return Class.forName(name, false, Builder.class.getClassLoader());
        }

        public void addTestSpec(String arg) throws BuilderException {
            String className;
            if (this.methodName != null) {
                throw new BuilderException("Only a single class and method can be specified: " + arg);
            }
            if (arg.contains("#")) {
                String[] pair = arg.split("#");
                if (pair.length != 2) {
                    throw new BuilderException("Malformed class and method request: " + arg);
                }
                if (!this.classes.isEmpty()) {
                    throw new BuilderException("Only a single class and method can be specified: " + arg);
                }
                this.methodName = pair[1];
                className = pair[0];
            } else {
                className = arg;
            }
            try {
                Class<?> cls = this.resolveClass(className);
                if ((cls.getModifiers() & 0x400) == 0) {
                    this.classes.add(cls);
                }
            }
            catch (ClassNotFoundException e) {
                Description description = Description.createSuiteDescription((String)className, (Annotation[])new Annotation[0]);
                Failure failure = new Failure(description, (Throwable)e);
                this.missingClasses.add(failure);
            }
        }

        private static List<Runner> filterRunners(List<Runner> runners) {
            for (Runner runner : runners) {
                if (!(runner instanceof ErrorReportingRunner)) continue;
                ArrayList<Runner> result = new ArrayList<Runner>(runners);
                result.removeIf(x -> !(x instanceof ErrorReportingRunner));
                ArrayList<Runner> tail = new ArrayList<Runner>(runners);
                tail.removeIf(x -> x instanceof ErrorReportingRunner);
                result.addAll(tail);
                return result;
            }
            return runners;
        }

        public List<Runner> runners(Class<?> parent, List<Class<?>> children) throws InitializationError {
            return Builder.filterRunners(super.runners(parent, children));
        }

        public List<Runner> runners(Class<?> parent, Class<?>[] children) throws InitializationError {
            return Builder.filterRunners(super.runners(parent, (Class[])children));
        }

        public MxJUnitRequest build() {
            Request request;
            if (this.methodName == null) {
                try {
                    Suite suite = new Suite((RunnerBuilder)this, this.classes.toArray(new Class[0]));
                    request = Request.runner((Runner)suite);
                }
                catch (InitializationError e) {
                    throw new RuntimeException(e);
                }
            } else {
                request = Request.method(this.classes.iterator().next(), (String)this.methodName);
            }
            return new MxJUnitRequest(request, this.classes, this.methodName, this.missingClasses);
        }

        protected Set<Class<?>> getClasses() {
            return this.classes;
        }
    }

    public static final class BuilderException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private BuilderException(String msg) {
            super(msg);
        }
    }
}

