/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.mxtool.junit;

import com.oracle.mxtool.junit.AnsiTerminalDecorator;
import com.oracle.mxtool.junit.EagerStackTraceDecorator;
import com.oracle.mxtool.junit.FullThreadDumpDecorator;
import com.oracle.mxtool.junit.GCAfterTestDecorator;
import com.oracle.mxtool.junit.JsonResultsDecorator;
import com.oracle.mxtool.junit.ModuleSupport;
import com.oracle.mxtool.junit.MxJUnitRequest;
import com.oracle.mxtool.junit.MxRunListener;
import com.oracle.mxtool.junit.ResultCollectorDecorator;
import com.oracle.mxtool.junit.TestResultLoggerDecorator;
import com.oracle.mxtool.junit.TextRunListener;
import com.oracle.mxtool.junit.TimingAndDiskUsageDecorator;
import com.oracle.mxtool.junit.VerboseTextListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import junit.runner.Version;
import org.junit.internal.JUnitSystem;
import org.junit.internal.RealSystem;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.RunnerScheduler;

public class MxJUnitWrapper {
    public static final String OPENED_PACKAGES_PROPERTY_NAME = "com.oracle.mxtool.junit.opens";
    public static final String EXPORTED_PACKAGES_PROPERTY_NAME = "com.oracle.mxtool.junit.exports";
    private static final int TIMINGS_TO_PRINT = Integer.getInteger("mx.junit.timings_to_print", 10);

    public static void main(String ... args) {
        RealSystem system = new RealSystem();
        JUnitCore junitCore = new JUnitCore();
        system.out().println("MxJUnitCore");
        system.out().println("JUnit version " + Version.id());
        MxJUnitRequest.Builder builder = new MxJUnitRequest.Builder();
        MxJUnitConfig config = new MxJUnitConfig();
        String[] expandedArgs = MxJUnitWrapper.expandArgs(args);
        ArrayList<String> testSpecs = new ArrayList<String>();
        ArrayList<String> openPackagesSpecs = new ArrayList<String>();
        for (int i = 0; i < expandedArgs.length; ++i) {
            String each = expandedArgs[i];
            if (each.charAt(0) == '-') {
                if (each.contentEquals("-JUnitVerbose")) {
                    config.verbose = true;
                    config.enableTiming = true;
                    continue;
                }
                if (each.contentEquals("-JUnitOpenPackages")) {
                    openPackagesSpecs.add(MxJUnitWrapper.parseStringArg((JUnitSystem)system, expandedArgs, each, ++i));
                    continue;
                }
                if (each.contentEquals("-JUnitVeryVerbose")) {
                    config.verbose = true;
                    config.veryVerbose = true;
                    config.enableTiming = true;
                    continue;
                }
                if (each.contentEquals("-JUnitMaxClassFailures")) {
                    config.maxClassFailures = MxJUnitWrapper.parseIntArg((JUnitSystem)system, expandedArgs, each, ++i);
                    continue;
                }
                if (each.contentEquals("-JUnitFailFast")) {
                    config.maxClassFailures = 1;
                    continue;
                }
                if (each.contentEquals("-JUnitEnableTiming")) {
                    config.enableTiming = true;
                    continue;
                }
                if (each.contentEquals("-JUnitColor")) {
                    config.color = true;
                    continue;
                }
                if (each.contentEquals("-JUnitEagerStackTrace")) {
                    config.eagerStackTrace = true;
                    continue;
                }
                if (each.contentEquals("-JUnitGCAfterTest")) {
                    config.gcAfterTest = true;
                    continue;
                }
                if (each.contentEquals("-JUnitRecordResults")) {
                    config.recordResults = true;
                    continue;
                }
                if (each.contentEquals("-JUnitRecordPassed")) {
                    config.recordPassed = MxJUnitWrapper.parseStringArg((JUnitSystem)system, expandedArgs, each, ++i);
                    continue;
                }
                if (each.contentEquals("-JUnitRecordFailed")) {
                    config.recordFailed = MxJUnitWrapper.parseStringArg((JUnitSystem)system, expandedArgs, each, ++i);
                    continue;
                }
                if (each.contentEquals("-JUnitRepeat")) {
                    config.repeatCount = MxJUnitWrapper.parseIntArg((JUnitSystem)system, expandedArgs, each, ++i);
                    continue;
                }
                if (each.contentEquals("-JUnitJsonResults")) {
                    config.jsonResults = MxJUnitWrapper.parseStringArg((JUnitSystem)system, expandedArgs, each, ++i);
                    continue;
                }
                system.out().println("Unknown command line argument: " + each);
                continue;
            }
            testSpecs.add(each);
        }
        ModuleSupport moduleSupport = new ModuleSupport(system.out());
        TreeSet<String> opened = new TreeSet<String>();
        TreeSet<String> exported = new TreeSet<String>();
        for (String string : openPackagesSpecs) {
            moduleSupport.openPackages(string, "-JUnitOpenPackages", opened, exported);
        }
        for (String string : testSpecs) {
            try {
                builder.addTestSpec(string);
            }
            catch (MxJUnitRequest.BuilderException ex) {
                system.out().println(ex.getMessage());
                System.exit(1);
            }
        }
        moduleSupport.processAddModulesAnnotations(builder.getClasses());
        MxJUnitRequest request = builder.build();
        moduleSupport.processAddExportsAnnotations(request.classes, opened, exported);
        if (!opened.isEmpty()) {
            System.setProperty(OPENED_PACKAGES_PROPERTY_NAME, String.join((CharSequence)System.lineSeparator(), opened));
        }
        if (!exported.isEmpty()) {
            System.setProperty(EXPORTED_PACKAGES_PROPERTY_NAME, String.join((CharSequence)System.lineSeparator(), exported));
        }
        for (RunListener p : ServiceLoader.load(RunListener.class)) {
            junitCore.addListener(p);
        }
        Result result = MxJUnitWrapper.runRequest(junitCore, (JUnitSystem)system, config, request);
        System.exit(result.wasSuccessful() ? 0 : -result.getFailureCount());
    }

    public static int parseIntArg(JUnitSystem system, String[] args, String name, int index) {
        if (index >= args.length) {
            system.out().printf("Must include argument for %s%n", name);
            System.exit(1);
        }
        try {
            return Integer.parseInt(args[index]);
        }
        catch (NumberFormatException e) {
            system.out().printf("Expected integer argument for %s. Found: %s%n", name, args[index]);
            System.exit(1);
            throw e;
        }
    }

    public static String parseStringArg(JUnitSystem system, String[] args, String name, int index) {
        if (index >= args.length) {
            system.out().printf("Must include argument for %s%n", name);
            System.exit(1);
        }
        return args[index];
    }

    private static PrintStream openFile(JUnitSystem system, String name) {
        File file = new File(name).getAbsoluteFile();
        try {
            OutputStream os = new FileOutputStream(file);
            if (name.endsWith(".gz")) {
                os = new GZIPOutputStream(os);
            }
            return new PrintStream(os, true);
        }
        catch (IOException e) {
            system.out().println("Could not open " + file + " for writing: " + e);
            System.exit(1);
            return null;
        }
    }

    public static Result runRequest(JUnitCore junitCore, final JUnitSystem system, final MxJUnitConfig config, MxJUnitRequest mxRequest) {
        boolean failingFast;
        int classesCount = mxRequest.classes.size();
        final TextRunListener textListener = config.veryVerbose ? new VerboseTextListener(system, classesCount, Integer.MAX_VALUE) : (config.verbose ? new VerboseTextListener(system, classesCount) : new TextRunListener(system));
        TimingAndDiskUsageDecorator timings = config.enableTiming ? new TimingAndDiskUsageDecorator(textListener) : null;
        MxRunListener mxListener = config.enableTiming ? timings : textListener;
        ResultCollectorDecorator resultLoggerDecorator = null;
        if (config.failFast && config.maxClassFailures == 0) {
            failingFast = true;
            config.maxClassFailures = 1;
        } else {
            failingFast = false;
        }
        if (config.color) {
            mxListener = new AnsiTerminalDecorator(mxListener);
        }
        if (config.eagerStackTrace) {
            mxListener = new EagerStackTraceDecorator(mxListener);
        }
        if (config.gcAfterTest) {
            mxListener = new GCAfterTestDecorator(mxListener);
        }
        if (config.recordResults) {
            PrintStream passed = MxJUnitWrapper.openFile(system, "passed.txt");
            PrintStream failed = MxJUnitWrapper.openFile(system, "failed.txt");
            mxListener = new TestResultLoggerDecorator(passed, failed, mxListener);
        }
        if (config.recordFailed != null || config.recordPassed != null) {
            resultLoggerDecorator = new ResultCollectorDecorator(mxListener);
            mxListener = resultLoggerDecorator;
        }
        if (config.jsonResults != null) {
            mxListener = new JsonResultsDecorator(mxListener, MxJUnitWrapper.openFile(system, config.jsonResults));
        }
        mxListener = new FullThreadDumpDecorator(mxListener);
        junitCore.addListener(TextRunListener.createRunListener(mxListener, mxRequest.missingClasses));
        Request request = mxRequest.getRequest();
        if (mxRequest.methodName == null) {
            if (config.maxClassFailures > 0) {
                Runner runner = request.getRunner();
                if (runner instanceof ParentRunner) {
                    ParentRunner parentRunner = (ParentRunner)runner;
                    parentRunner.setScheduler(new RunnerScheduler(){
                        int failureCount = 0;
                        Failure lastFailure;

                        public void schedule(Runnable childStatement) {
                            Failure failure = textListener.getLastFailure();
                            if (failure != null && failure != this.lastFailure) {
                                this.lastFailure = failure;
                                ++this.failureCount;
                                if (this.failureCount == config.maxClassFailures && !failingFast) {
                                    system.out().printf("Stopping after failures in %s test classes (use --max-class-failures option to adjust failure limit)%n", config.maxClassFailures);
                                }
                            }
                            if (this.failureCount < config.maxClassFailures) {
                                childStatement.run();
                            }
                        }

                        public void finished() {
                        }
                    });
                } else {
                    system.out().println("Unexpected Runner subclass " + runner.getClass().getName() + " - fail fast not supported");
                }
            }
        } else if (config.maxClassFailures != 0) {
            system.out().println("Single method selected - fail fast or max failure limit not supported");
        }
        if (config.repeatCount != 1) {
            request = new RepeatingRequest(request, config.repeatCount);
        }
        ResultCollectorDecorator finalResultLoggerDecorator = resultLoggerDecorator;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (config.enableTiming) {
                MxJUnitWrapper.printTimings(timings, classesCount);
            }
            if (config.recordFailed != null || config.recordPassed != null) {
                PrintStream passed = MxJUnitWrapper.getResultStream(system, config.recordPassed);
                PrintStream failed = MxJUnitWrapper.getResultStream(system, config.recordFailed);
                MxJUnitWrapper.printResult(finalResultLoggerDecorator, passed, failed);
            }
        }));
        return junitCore.run(request);
    }

    private static PrintStream getResultStream(JUnitSystem system, String file) {
        if (file == null) {
            return null;
        }
        if (file.equals("-")) {
            return System.out;
        }
        return MxJUnitWrapper.openFile(system, file);
    }

    private static void printTimings(TimingAndDiskUsageDecorator timings, int classesCount) {
        if (TIMINGS_TO_PRINT != 0) {
            int i;
            ArrayList<Timing<Class<Object>>> classTimes = new ArrayList<Timing<Class<Object>>>(timings.classTimes.size());
            ArrayList<Timing<Object>> testTimes = new ArrayList<Timing<Object>>(timings.testTimes.size());
            for (Map.Entry<Class<?>, Long> entry : timings.classTimes.entrySet()) {
                classTimes.add(new Timing(entry.getKey(), entry.getValue()));
            }
            for (Map.Entry<Class<?>, Long> entry : timings.testTimes.entrySet()) {
                testTimes.add(new Timing<Description>((Description)entry.getKey(), entry.getValue()));
            }
            classTimes.sort(Collections.reverseOrder());
            testTimes.sort(Collections.reverseOrder());
            System.out.println();
            System.out.printf("%d longest running test classes after running %d of %d classes:%n", TIMINGS_TO_PRINT, classTimes.size(), classesCount);
            for (i = 0; i < TIMINGS_TO_PRINT && i < classTimes.size(); ++i) {
                Timing timing = (Timing)classTimes.get(i);
                System.out.printf(" %,10d ms    %s%n", timing.value, ((Class)timing.subject).getName());
            }
            System.out.printf("%d longest running tests:%n", TIMINGS_TO_PRINT);
            for (i = 0; i < TIMINGS_TO_PRINT && i < testTimes.size(); ++i) {
                Timing timing = (Timing)testTimes.get(i);
                System.out.printf(" %,10d ms    %s%n", timing.value, timing.subject);
            }
            Object[] current = timings.getCurrentTestDuration();
            if (current != null) {
                System.out.printf("Test %s not finished after %d ms%n", current[0], current[1]);
                FullThreadDumpDecorator.printFullThreadDump(System.out);
            }
        }
    }

    private static void printResult(ResultCollectorDecorator results, PrintStream passed, PrintStream failed) {
        String prefix;
        if (passed != null && !results.getPassed().isEmpty()) {
            boolean isStdOut = passed.equals(System.out);
            if (isStdOut) {
                System.out.println("Passed tests:");
            }
            prefix = isStdOut ? "  " : "";
            results.getPassed().stream().map(d -> prefix + MxJUnitWrapper.getFormattedDescription(d)).forEach(passed::println);
        }
        if (failed != null && !results.getFailed().isEmpty()) {
            boolean isStdout = failed.equals(System.out);
            if (isStdout) {
                System.out.println("Failing tests:");
            }
            prefix = isStdout ? "  " : "";
            results.getFailed().stream().map(d -> prefix + MxJUnitWrapper.getFormattedDescription(d.getDescription())).forEach(failed::println);
        }
    }

    private static String getFormattedDescription(Description description) {
        return description.getClassName() + "#" + description.getMethodName();
    }

    private static String[] expandArgs(String[] args) {
        ArrayList<String> result = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.length() > 0 && arg.charAt(0) == '@') {
                if (result != null) continue;
                result = new ArrayList<String>();
                for (int j = 0; j < i; ++j) {
                    result.add(args[j]);
                }
                MxJUnitWrapper.expandArg(arg.substring(1), result);
                continue;
            }
            if (result == null) continue;
            result.add(arg);
        }
        return result != null ? result.toArray(new String[0]) : args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expandArg(String filename, List<String> args) {
        BufferedReader br = null;
        try {
            String buf;
            br = new BufferedReader(new FileReader(filename));
            while ((buf = br.readLine()) != null) {
                args.add(buf);
            }
            br.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(2);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(3);
            }
        }
    }

    public static class MxJUnitConfig {
        public boolean verbose = false;
        public boolean veryVerbose = false;
        public boolean enableTiming = false;
        public boolean failFast = false;
        public boolean color = false;
        public boolean eagerStackTrace = false;
        public boolean gcAfterTest = false;
        public boolean recordResults = false;
        public int repeatCount = 1;
        public int maxClassFailures;
        public String recordFailed;
        public String recordPassed;
        public String jsonResults;
        public String jsonResultTags;
    }

    private static class RepeatingRequest
    extends Request {
        private final Request request;
        private final int repeat;

        RepeatingRequest(Request request, int repeat) {
            this.request = request;
            this.repeat = repeat;
        }

        public Runner getRunner() {
            return new RepeatingRunner(this.request.getRunner(), this.repeat);
        }
    }

    private static class Timing<T>
    implements Comparable<Timing<T>> {
        final T subject;
        final long value;

        Timing(T subject, long value) {
            this.subject = subject;
            this.value = value;
        }

        @Override
        public int compareTo(Timing<T> o) {
            if (this.value < o.value) {
                return -1;
            }
            if (this.value > o.value) {
                return 1;
            }
            return 0;
        }
    }

    private static class RepeatingRunner
    extends Runner {
        private final Runner parent;
        private int repeat;

        RepeatingRunner(Runner parent, int repeat) {
            this.parent = parent;
            this.repeat = repeat;
        }

        public Description getDescription() {
            return this.parent.getDescription();
        }

        public void run(RunNotifier notifier) {
            for (int i = 0; i < this.repeat; ++i) {
                this.parent.run(notifier);
            }
        }

        public int testCount() {
            return super.testCount() * this.repeat;
        }
    }
}

