/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.mxtool.junit;

import com.oracle.mxtool.junit.MxRunListener;
import com.oracle.mxtool.junit.MxRunListenerDecorator;
import java.io.PrintStream;
import org.junit.runner.Result;

class TestResultLoggerDecorator
extends MxRunListenerDecorator {
    private final PrintStream passed;
    private final PrintStream failed;

    TestResultLoggerDecorator(PrintStream passed, PrintStream failed, MxRunListener l) {
        super(l);
        this.passed = passed;
        this.failed = failed;
    }

    @Override
    public void testClassFinished(Class<?> clazz, int numPassed, int numFailed, int numIgnored, int numAssumptionFailed) {
        super.testClassFinished(clazz, numPassed, numFailed, numIgnored, numAssumptionFailed);
        if (numFailed != 0) {
            this.failed.println(clazz.getName());
        } else {
            this.passed.println(clazz.getName());
        }
    }

    @Override
    public void testRunFinished(Result result) {
        super.testRunFinished(result);
        this.passed.close();
        this.failed.close();
    }
}

