/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.mxtool.junit;

import com.oracle.mxtool.junit.MxRunListener;
import java.io.PrintStream;
import java.util.List;
import org.junit.internal.JUnitSystem;
import org.junit.internal.TextListener;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

class TextRunListener
implements MxRunListener {
    private final PrintStream fWriter;
    protected Failure lastFailure;

    TextRunListener(JUnitSystem system) {
        this(system.out());
    }

    TextRunListener(PrintStream writer) {
        this.fWriter = writer;
    }

    @Override
    public boolean beVerbose() {
        return false;
    }

    @Override
    public PrintStream getWriter() {
        return this.fWriter;
    }

    public Failure getLastFailure() {
        return this.lastFailure;
    }

    @Override
    public void testStarted(Description description) {
        this.getWriter().print('.');
    }

    @Override
    public void testFailed(Failure failure) {
        this.getWriter().print('E');
        this.lastFailure = failure;
    }

    @Override
    public void testIgnored(Description description) {
        this.getWriter().print('I');
    }

    public static RunListener createRunListener(final MxRunListener l, final List<Failure> missingClasses) {
        final PrintStream theWriter = l.getWriter();
        return new TextListener(theWriter){
            private Class<?> lastClass;
            private int passedInLastClass;
            private int failedInLastClass;
            private int ignoredInLastClass;
            private int assumptionFailedInLastClass;
            private boolean failed;

            public void testStarted(Description description) {
                Class currentClass = description.getTestClass();
                if (currentClass != this.lastClass) {
                    this.testClassStarted(currentClass);
                }
                this.failed = false;
                l.testStarted(description);
                l.testStartedDelimiter();
            }

            private void testClassStarted(Class<?> clazz) {
                if (this.lastClass != null) {
                    l.testClassFinished(this.lastClass, this.passedInLastClass, this.failedInLastClass, this.ignoredInLastClass, this.assumptionFailedInLastClass);
                    l.testClassFinishedDelimiter();
                }
                this.lastClass = clazz;
                this.passedInLastClass = 0;
                this.failedInLastClass = 0;
                l.testClassStarted(clazz);
                l.testClassStartedDelimiter();
            }

            public void testFailure(Failure failure) {
                this.failed = true;
                ++this.failedInLastClass;
                l.testFailed(failure);
            }

            public void testFinished(Description description) {
                if (!this.failed) {
                    l.testSucceeded(description);
                    ++this.passedInLastClass;
                }
                l.testFinished(description);
                l.testFinishedDelimiter();
            }

            public void testIgnored(Description description) {
                this.testStarted(description);
                l.testIgnored(description);
                ++this.ignoredInLastClass;
                l.testFinished(description);
                l.testFinishedDelimiter();
            }

            public void testRunStarted(Description description) {
                l.testRunStarted(description);
            }

            public void testRunFinished(Result result) {
                result.getFailures().addAll(missingClasses);
                if (this.lastClass != null) {
                    l.testClassFinished(this.lastClass, this.passedInLastClass, this.failedInLastClass, this.ignoredInLastClass, this.assumptionFailedInLastClass);
                }
                l.testRunFinished(result);
                super.testRunFinished(result);
            }

            public void testAssumptionFailure(Failure failure) {
                Class currentClass = failure.getDescription().getTestClass();
                if (currentClass != this.lastClass) {
                    this.testClassAssumptionFailure(failure);
                } else {
                    l.testAssumptionFailure(failure);
                }
                ++this.assumptionFailedInLastClass;
            }

            private void testClassAssumptionFailure(Failure failure) {
                this.testClassStarted(failure.getDescription().getTestClass());
                if (l.beVerbose()) {
                    l.getWriter().print("  ");
                }
                l.testAssumptionFailure(failure);
                if (l.beVerbose()) {
                    l.getWriter().println();
                }
            }

            protected void printFailure(Failure each, String prefix) {
                String header = each.getDescription().getClassName() + "#" + each.getDescription().getMethodName();
                theWriter.println(prefix + ") " + header);
                theWriter.print(each.getTrace());
            }
        };
    }
}

