/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.mxtool.junit;

import com.oracle.mxtool.junit.TextRunListener;
import java.io.PrintStream;
import org.junit.Ignore;
import org.junit.internal.JUnitSystem;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

class VerboseTextListener
extends TextRunListener {
    private static final int DEFAULT_MAX_TEST_PER_CLASS = 50;
    public static final int SHOW_ALL_TESTS = Integer.MAX_VALUE;
    private final int classesCount;
    private final int maxTestsPerClass;
    private int currentClassNum;
    private int currentTestNum;

    VerboseTextListener(JUnitSystem system, int classesCount) {
        this(system.out(), classesCount, 50);
    }

    VerboseTextListener(JUnitSystem system, int classesCount, int maxTests) {
        this(system.out(), classesCount, maxTests);
    }

    VerboseTextListener(PrintStream writer, int classesCount, int maxTests) {
        super(writer);
        this.maxTestsPerClass = maxTests;
        this.classesCount = classesCount;
    }

    @Override
    public boolean beVerbose() {
        return this.currentTestNum < this.maxTestsPerClass;
    }

    @Override
    public void testClassStarted(Class<?> clazz) {
        ++this.currentClassNum;
        this.getWriter().printf("%s started (%d of %d)", clazz.getName(), this.currentClassNum, this.classesCount);
        this.currentTestNum = 0;
    }

    @Override
    public void testClassFinished(Class<?> clazz, int numPassed, int numFailed, int numIgnored, int numAssumptionFailed) {
        this.getWriter().print(clazz.getName() + " finished");
        this.currentTestNum = 0;
    }

    @Override
    public void testStarted(Description description) {
        ++this.currentTestNum;
        if (this.beVerbose()) {
            this.getWriter().print("  " + description.getMethodName() + ": ");
        } else {
            super.testStarted(description);
        }
    }

    @Override
    public void testIgnored(Description description) {
        if (this.beVerbose()) {
            this.getWriter().print("Ignored");
            Ignore a = (Ignore)description.getAnnotation(Ignore.class);
            if (a != null && !a.value().isEmpty()) {
                this.getWriter().printf(" (%s)", a.value());
            }
        } else {
            super.testIgnored(description);
        }
    }

    @Override
    public void testSucceeded(Description description) {
        if (this.beVerbose()) {
            this.getWriter().print("Passed");
        } else {
            super.testSucceeded(description);
        }
    }

    @Override
    public void testAssumptionFailure(Failure failure) {
        if (this.beVerbose()) {
            this.getWriter().printf("(%s) ", failure.getMessage());
        } else {
            super.testAssumptionFailure(failure);
        }
    }

    @Override
    public void testFailed(Failure failure) {
        this.getWriter().print("FAILED");
        this.lastFailure = failure;
    }

    @Override
    public void testClassFinishedDelimiter() {
        this.getWriter().println();
    }

    @Override
    public void testClassStartedDelimiter() {
        this.getWriter().println();
    }

    @Override
    public void testFinishedDelimiter() {
        if (this.beVerbose()) {
            this.getWriter().println();
        } else {
            super.testFinishedDelimiter();
        }
    }
}

