/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.util.UnsafePartitionKind;
import java.lang.reflect.Executable;

public interface ReachabilityAnalysis {
    public AnalysisType addRootClass(Class<?> var1, boolean var2, boolean var3);

    public AnalysisType addRootClass(AnalysisType var1, boolean var2, boolean var3);

    public AnalysisType addRootField(Class<?> var1, String var2);

    public AnalysisMethod addRootMethod(AnalysisMethod var1, boolean var2);

    public AnalysisMethod addRootMethod(Executable var1, boolean var2);

    default public void registerAsFrozenUnsafeAccessed(AnalysisField field) {
        field.setUnsafeFrozenTypeState(true);
    }

    default public boolean registerAsUnsafeAccessed(AnalysisField field, UnsafePartitionKind partitionKind, Object reason) {
        if (field.registerAsUnsafeAccessed(partitionKind, reason)) {
            this.forceUnsafeUpdate(field);
            return true;
        }
        return false;
    }

    default public boolean registerTypeAsReachable(AnalysisType type, Object reason) {
        return type.registerAsReachable(reason);
    }

    default public boolean registerTypeAsAllocated(AnalysisType type, Object reason) {
        return type.registerAsAllocated(reason);
    }

    default public boolean registerTypeAsInHeap(AnalysisType type, Object reason) {
        return type.registerAsInHeap(reason);
    }

    default public void markFieldAccessed(AnalysisField field, Object reason) {
        field.registerAsAccessed(reason);
    }

    default public void markFieldRead(AnalysisField field, Object reason) {
        field.registerAsRead(reason);
    }

    default public void markFieldWritten(AnalysisField field, Object reason) {
        field.registerAsWritten(reason);
    }

    public boolean finish() throws InterruptedException;

    public void cleanupAfterAnalysis();

    public void forceUnsafeUpdate(AnalysisField var1);

    public void registerAsJNIAccessed(AnalysisField var1, boolean var2);

    public Iterable<AnalysisType> getAllSynchronizedTypes();

    public Iterable<AnalysisType> getAllInstantiatedTypes();

    public AnalysisMetaAccess getMetaAccess();

    public AnalysisUniverse getUniverse();

    public AnalysisPolicy analysisPolicy();
}

