/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;

public class MethodTypeFlow
extends TypeFlow<AnalysisMethod> {
    protected final PointsToAnalysisMethod method;
    protected volatile MethodFlowsGraph flowsGraph;
    private InvokeTypeFlow parsingReason;
    private int returnedParameterIndex;
    private MethodFlowsGraph.GraphKind graphKind;
    private Object sealedFlowsGraph;
    private boolean forceReparseOnCreation = false;

    public MethodTypeFlow(PointsToAnalysisMethod method) {
        super(method, null);
        this.method = method;
        this.graphKind = MethodFlowsGraph.GraphKind.FULL;
    }

    public PointsToAnalysisMethod getMethod() {
        return this.method;
    }

    public synchronized void setAsStubFlow() {
        this.graphKind = MethodFlowsGraph.GraphKind.STUB;
        assert (!this.method.isOriginalMethod()) : "setting original method as stub";
        assert (!this.flowsGraphCreated()) : "cannot set as flow creation kind flows graph is created";
    }

    private void throwSealedError() {
        assert (this.sealedFlowsGraph != null);
        StringBuilder sb = new StringBuilder();
        sb.append("Sealed problem:\n");
        if (this.sealedFlowsGraph instanceof StackTraceElement[]) {
            StackTraceElement[] trace = (StackTraceElement[])this.sealedFlowsGraph;
            sb = new StringBuilder();
            sb.append("stack trace:\n");
            for (StackTraceElement elem : trace) {
                sb.append(elem.toString()).append("\n");
            }
            sb.append("end trace:\n");
        } else {
            sb.append("stack trace is unknown\n");
        }
        throw AnalysisError.shouldNotReachHere(sb.toString());
    }

    public MethodFlowsGraphInfo getOrCreateMethodFlowsGraphInfo(PointsToAnalysis bb, InvokeTypeFlow reason) {
        this.ensureFlowsGraphCreated(bb, reason);
        return this.flowsGraph;
    }

    public MethodFlowsGraphInfo getMethodFlowsGraphInfo() {
        assert (this.flowsGraph != null);
        return this.flowsGraph;
    }

    public MethodFlowsGraph getMethodFlowsGraph() {
        this.ensureFlowsGraphSealed();
        assert (this.flowsGraph != null);
        return this.flowsGraph;
    }

    protected void ensureFlowsGraphSealed() {
        if (this.sealedFlowsGraph == null) {
            this.sealFlowsGraph();
        }
    }

    private synchronized void sealFlowsGraph() {
        if (this.sealedFlowsGraph == null) {
            this.sealedFlowsGraph = Assertions.assertionsEnabled() ? Thread.currentThread().getStackTrace() : Boolean.TRUE;
        }
    }

    public boolean flowsGraphCreated() {
        return this.flowsGraph != null;
    }

    public void ensureFlowsGraphCreated(PointsToAnalysis bb, InvokeTypeFlow reason) {
        if (this.flowsGraph == null) {
            this.createFlowsGraph(bb, reason);
        }
    }

    private synchronized void createFlowsGraph(PointsToAnalysis bb, InvokeTypeFlow reason) {
        if (this.flowsGraph == null) {
            AnalysisError.guarantee(reason == null || reason.getSource() == null || !((BytecodePosition)reason.getSource()).getMethod().equals(this.method), "Parsing reason cannot be in the target method itself: %s", this.method);
            this.parsingReason = reason;
            try {
                MethodTypeFlowBuilder builder = bb.createMethodTypeFlowBuilder(bb, this.method, null, this.graphKind);
                builder.apply(this.forceReparseOnCreation, PointsToAnalysisMethod.unwrapInvokeReason(this.parsingReason));
                bb.numParsedGraphs.incrementAndGet();
                boolean computeIndex = bb.getHostVM().getMultiMethodAnalysisPolicy().canComputeReturnedParameterIndex(this.method.getMultiMethodKey());
                this.returnedParameterIndex = computeIndex ? MethodTypeFlow.computeReturnedParameterIndex(builder.graph) : -1;
                this.flowsGraph = builder.flowsGraph;
                assert (this.flowsGraph != null);
                this.initFlowsGraph(bb, builder.postInitFlows);
            }
            catch (Throwable t) {
                throw AnalysisError.parsingError(this.method, t);
            }
        }
    }

    private static int computeReturnedParameterIndex(StructuredGraph graph) {
        if (graph == null) {
            return -1;
        }
        ValueNode singleReturnedValue = null;
        for (ReturnNode returnNode : graph.getNodes(ReturnNode.TYPE)) {
            if (singleReturnedValue == null) {
                singleReturnedValue = returnNode.result();
                continue;
            }
            if (returnNode.result() == singleReturnedValue) continue;
            return -1;
        }
        if (singleReturnedValue instanceof ParameterNode) {
            return ((ParameterNode)singleReturnedValue).index();
        }
        return -1;
    }

    protected void initFlowsGraph(PointsToAnalysis bb, List<TypeFlow<?>> postInitFlows) {
        for (TypeFlow<?> flow : postInitFlows) {
            flow.initFlow(bb);
        }
    }

    public Collection<MethodFlowsGraph> getFlows() {
        this.ensureFlowsGraphSealed();
        return this.flowsGraph == null ? Collections.emptyList() : List.of(this.flowsGraph);
    }

    public EconomicMap<Object, InvokeTypeFlow> getInvokes() {
        this.ensureFlowsGraphSealed();
        return this.flowsGraph == null ? EconomicMap.emptyMap() : this.flowsGraph.getInvokes();
    }

    public TypeFlow<?> getParameter(int idx) {
        return this.flowsGraph == null ? null : this.flowsGraph.getParameter(idx);
    }

    public Iterable<TypeFlow<?>> getParameters() {
        return this.flowsGraph == null ? Collections.emptyList() : Arrays.asList(this.flowsGraph.getParameters());
    }

    public boolean isSaturated(PointsToAnalysis bb, TypeFlow<?> originalTypeFlow) {
        return originalTypeFlow.isSaturated();
    }

    public TypeState foldTypeFlow(PointsToAnalysis bb, TypeFlow<?> originalTypeFlow) {
        return originalTypeFlow == null ? null : originalTypeFlow.getState();
    }

    public int getReturnedParameterIndex() {
        assert (this.flowsGraphCreated());
        return this.returnedParameterIndex;
    }

    public Object getParsingReason() {
        return PointsToAnalysisMethod.unwrapInvokeReason(this.parsingReason);
    }

    @Override
    public void update(PointsToAnalysis bb) {
        JVMCIError.shouldNotReachHere();
    }

    public synchronized boolean updateFlowsGraph(PointsToAnalysis bb, MethodFlowsGraph.GraphKind newGraphKind, InvokeTypeFlow newParsingReason, boolean forceReparse) {
        assert (!this.method.isOriginalMethod());
        if (this.sealedFlowsGraph != null) {
            this.throwSealedError();
        }
        boolean bl = this.forceReparseOnCreation = forceReparse || this.forceReparseOnCreation;
        assert (newGraphKind != MethodFlowsGraph.GraphKind.STUB || this.graphKind != MethodFlowsGraph.GraphKind.FULL) : "creating less strict graph";
        MethodFlowsGraph.GraphKind originalGraphKind = this.graphKind;
        this.graphKind = newGraphKind;
        if (!forceReparse && originalGraphKind == newGraphKind) {
            return false;
        }
        if (newGraphKind == MethodFlowsGraph.GraphKind.STUB) {
            assert (originalGraphKind == MethodFlowsGraph.GraphKind.STUB);
            return false;
        }
        if (this.flowsGraph == null) {
            return false;
        }
        if (newParsingReason != null) {
            this.parsingReason = newParsingReason;
        }
        try {
            assert (this.returnedParameterIndex == -1);
            boolean registerAsImplementationInvoked = originalGraphKind == MethodFlowsGraph.GraphKind.STUB;
            this.flowsGraph.removeInternalFlows(bb);
            MethodTypeFlowBuilder builder = bb.createMethodTypeFlowBuilder(bb, this.method, this.flowsGraph, newGraphKind);
            builder.apply(forceReparse, PointsToAnalysisMethod.unwrapInvokeReason(this.parsingReason));
            this.flowsGraph.updateInternalState(newGraphKind);
            this.initFlowsGraph(bb, builder.postInitFlows);
            if (registerAsImplementationInvoked) {
                if (this.parsingReason == null) {
                    this.method.registerAsImplementationInvoked(PointsToAnalysisMethod.unwrapInvokeReason(null));
                } else {
                    bb.analysisPolicy().registerAsImplementationInvoked(this.parsingReason, this.method);
                }
            }
        }
        catch (Throwable t) {
            throw AnalysisError.parsingError(this.method, t);
        }
        return true;
    }

    @Override
    public String toString() {
        return "MethodTypeFlow<" + String.valueOf(this.method) + ">";
    }
}

