/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.phases;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisInlineInvokePlugin;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.replacements.PEGraphDecoder;

public class InlineBeforeAnalysisGraphDecoder<S extends InlineBeforeAnalysisPolicy.Scope>
extends PEGraphDecoder {
    protected final BigBang bb;
    protected final InlineBeforeAnalysisPolicy<S> policy;

    protected InlineBeforeAnalysisGraphDecoder(BigBang bb, InlineBeforeAnalysisPolicy<S> policy, StructuredGraph graph, HostedProviders providers) {
        super(AnalysisParsedGraph.HOST_ARCHITECTURE, graph, (CoreProviders)providers, null, providers.getGraphBuilderPlugins().getInvocationPlugins(), new InlineInvokePlugin[]{new InlineBeforeAnalysisInlineInvokePlugin(policy)}, null, policy.nodePlugins, null, null, new ConcurrentHashMap(), new ConcurrentHashMap(), true, false);
        this.bb = bb;
        this.policy = policy;
        if (graph.getDebug().isLogEnabled()) {
            graph.getDebug().logv("InlineBeforeAnalysis: decoding " + graph.method().format("%H.%n(%p)"), new Object[0]);
        }
    }

    protected InvocationPlugin getInvocationPlugin(ResolvedJavaMethod targetMethod) {
        if (this.policy.tryInvocationPlugins()) {
            return super.getInvocationPlugin(targetMethod);
        }
        return null;
    }

    protected PEGraphDecoder.PEMethodScope createMethodScope(StructuredGraph targetGraph, PEGraphDecoder.PEMethodScope caller, GraphDecoder.LoopScope callerLoopScope, EncodedGraph encodedGraph, ResolvedJavaMethod method, GraphDecoder.InvokeData invokeData, int inliningDepth, ValueNode[] arguments) {
        return new InlineBeforeAnalysisMethodScope(targetGraph, caller, callerLoopScope, encodedGraph, method, invokeData, inliningDepth, arguments);
    }

    protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider) {
        AnalysisMethod aMethod = (AnalysisMethod)method;
        return aMethod.ensureGraphParsed(this.bb).getEncodedGraph();
    }

    protected Node addFloatingNode(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        assert (node.isUnregistered()) : "If node is already in the graph, we would count it twice";
        this.maybeAbortInlining(methodScope, loopScope, node);
        return super.addFloatingNode(methodScope, loopScope, node);
    }

    protected Node canonicalizeFixedNode(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        Node canonical = super.canonicalizeFixedNode(methodScope, loopScope, node);
        if (canonical == node || canonical != null && canonical.isUnregistered()) {
            this.maybeAbortInlining(methodScope, loopScope, canonical);
        }
        return canonical;
    }

    protected void handleNonInlinedInvoke(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData) {
        this.maybeAbortInlining(methodScope, loopScope, (Node)invokeData.invoke.asNode());
        super.handleNonInlinedInvoke(methodScope, loopScope, invokeData);
    }

    protected void maybeAbortInlining(GraphDecoder.MethodScope ms, GraphDecoder.LoopScope loopScope, Node node) {
        InlineBeforeAnalysisMethodScope methodScope = this.cast(ms);
        if (!methodScope.inliningAborted && methodScope.isInlinedMethod()) {
            if (this.graph.getDebug().isLogEnabled()) {
                this.graph.getDebug().logv("  ".repeat(methodScope.inliningDepth) + "  node " + String.valueOf(node) + ": " + String.valueOf(methodScope.policyScope), new Object[0]);
            }
            if (!this.policy.processNode(this.bb.getMetaAccess(), methodScope.method, methodScope.policyScope, node)) {
                this.abortInlining(methodScope);
            }
        }
    }

    protected void abortInlining(InlineBeforeAnalysisMethodScope methodScope) {
        if (!methodScope.inliningAborted) {
            if (this.graph.getDebug().isLogEnabled()) {
                this.graph.getDebug().logv("  ".repeat(methodScope.inliningDepth) + "    abort!", new Object[0]);
            }
            methodScope.inliningAborted = true;
        }
    }

    protected GraphDecoder.LoopScope processNextNode(GraphDecoder.MethodScope ms, GraphDecoder.LoopScope loopScope) {
        InlineBeforeAnalysisMethodScope methodScope = this.cast(ms);
        if (methodScope.inliningAborted) {
            loopScope.nodesToProcess.clear();
            return loopScope;
        }
        return super.processNextNode((GraphDecoder.MethodScope)methodScope, loopScope);
    }

    protected void finishInlining(GraphDecoder.MethodScope is) {
        InlineBeforeAnalysisMethodScope inlineScope = this.cast(is);
        InlineBeforeAnalysisMethodScope callerScope = this.cast((GraphDecoder.MethodScope)inlineScope.caller);
        GraphDecoder.LoopScope callerLoopScope = inlineScope.callerLoopScope;
        GraphDecoder.InvokeData invokeData = inlineScope.invokeData;
        if (inlineScope.inliningAborted) {
            if (this.graph.getDebug().isLogEnabled()) {
                this.graph.getDebug().logv("  ".repeat(callerScope.inliningDepth) + "  aborted " + invokeData.callTarget.targetMethod().format("%H.%n(%p)") + ": " + String.valueOf(inlineScope.policyScope), new Object[0]);
            }
            if (callerScope.policyScope != null) {
                this.policy.abortCalleeScope(callerScope.policyScope, inlineScope.policyScope);
            }
            if (invokeData.invokePredecessor.next() != null) {
                this.killControlFlowNodes(inlineScope, invokeData.invokePredecessor.next());
                assert (invokeData.invokePredecessor.next() == null) : "Successor must have been a fixed node created in the aborted scope, which is deleted now";
            }
            invokeData.invokePredecessor.setNext(invokeData.invoke.asFixedNode());
            if (inlineScope.exceptionPlaceholderNode != null) {
                assert (invokeData.invoke instanceof InvokeWithExceptionNode);
                assert (this.lookupNode(callerLoopScope, invokeData.exceptionOrderId) == inlineScope.exceptionPlaceholderNode);
                this.registerNode(callerLoopScope, invokeData.exceptionOrderId, null, true, true);
                FixedNode exceptionReplacement = this.makeStubNode((GraphDecoder.MethodScope)callerScope, callerLoopScope, invokeData.exceptionOrderId);
                inlineScope.exceptionPlaceholderNode.replaceAtUsagesAndDelete((Node)exceptionReplacement);
            }
            this.handleNonInlinedInvoke((GraphDecoder.MethodScope)callerScope, callerLoopScope, invokeData);
            return;
        }
        if (this.graph.getDebug().isLogEnabled()) {
            this.graph.getDebug().logv("  ".repeat(callerScope.inliningDepth) + "  committed " + invokeData.callTarget.targetMethod().format("%H.%n(%p)") + ": " + String.valueOf(inlineScope.policyScope), new Object[0]);
        }
        if (callerScope.policyScope != null) {
            this.policy.commitCalleeScope(callerScope.policyScope, inlineScope.policyScope);
        }
        NodeSourcePosition reason = this.graph.currentNodeSourcePosition() != null ? this.graph.currentNodeSourcePosition() : this.graph.method();
        ((AnalysisMethod)invokeData.callTarget.targetMethod()).registerAsInlined(reason);
        super.finishInlining((GraphDecoder.MethodScope)inlineScope);
    }

    private void killControlFlowNodes(PEGraphDecoder.PEMethodScope inlineScope, FixedNode start) {
        ArrayDeque<Node> workList = null;
        FixedNode cur = start;
        while (true) {
            assert (!cur.isDeleted());
            assert (this.graph.isNew(inlineScope.methodStartMark, (Node)cur));
            FixedNode next = null;
            if (cur instanceof FixedWithNextNode) {
                next = ((FixedWithNextNode)cur).next();
            } else if (cur instanceof ControlSplitNode) {
                for (Node successor : cur.successors()) {
                    if (next == null) {
                        next = successor;
                        continue;
                    }
                    if (workList == null) {
                        workList = new ArrayDeque<Node>();
                    }
                    workList.push(successor);
                }
            } else if (cur instanceof AbstractEndNode) {
                next = ((AbstractEndNode)cur).merge();
            } else if (!(cur instanceof ControlSinkNode)) {
                throw GraalError.shouldNotReachHere();
            }
            if (cur instanceof AbstractMergeNode) {
                for (ValueNode phi : ((AbstractMergeNode)cur).phis().snapshot()) {
                    phi.replaceAtUsages(null);
                    phi.safeDelete();
                }
            }
            cur.replaceAtPredecessor(null);
            cur.replaceAtUsages(null);
            cur.safeDelete();
            if (next != null) {
                cur = next;
                continue;
            }
            if (workList == null || workList.isEmpty()) break;
            cur = (Node)workList.pop();
        }
    }

    protected InlineBeforeAnalysisMethodScope cast(GraphDecoder.MethodScope methodScope) {
        return (InlineBeforeAnalysisMethodScope)methodScope;
    }

    public class InlineBeforeAnalysisMethodScope
    extends PEGraphDecoder.PEMethodScope {
        private final S policyScope;
        private boolean inliningAborted;

        InlineBeforeAnalysisMethodScope(StructuredGraph targetGraph, PEGraphDecoder.PEMethodScope caller, GraphDecoder.LoopScope callerLoopScope, EncodedGraph encodedGraph, ResolvedJavaMethod method, GraphDecoder.InvokeData invokeData, int inliningDepth, ValueNode[] arguments) {
            super((PEGraphDecoder)InlineBeforeAnalysisGraphDecoder.this, targetGraph, caller, callerLoopScope, encodedGraph, method, invokeData, inliningDepth, arguments);
            if (caller == null) {
                this.policyScope = InlineBeforeAnalysisGraphDecoder.this.policy.createRootScope();
                if (InlineBeforeAnalysisGraphDecoder.this.graph.getDebug().isLogEnabled()) {
                    InlineBeforeAnalysisGraphDecoder.this.graph.getDebug().logv("  ".repeat(inliningDepth) + "createRootScope for " + method.format("%H.%n(%p)") + ": " + String.valueOf(this.policyScope), new Object[0]);
                }
            } else {
                this.policyScope = InlineBeforeAnalysisGraphDecoder.this.policy.openCalleeScope(InlineBeforeAnalysisGraphDecoder.this.cast((GraphDecoder.MethodScope)caller).policyScope);
                if (InlineBeforeAnalysisGraphDecoder.this.graph.getDebug().isLogEnabled()) {
                    InlineBeforeAnalysisGraphDecoder.this.graph.getDebug().logv("  ".repeat(inliningDepth) + "openCalleeScope for " + method.format("%H.%n(%p)") + ": " + String.valueOf(this.policyScope), new Object[0]);
                }
            }
        }
    }
}

