/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class VM {
    public final String info;
    public final String version;
    public final String vendor;
    public final String vendorUrl;
    public final String vendorVersion;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VM(String vmInfo) {
        this.info = vmInfo;
        this.version = VM.getVersion();
        this.vendor = VM.getVendor();
        this.vendorUrl = VM.getVendorUrl();
        this.vendorVersion = VM.getVendorVersion();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String getSupportUrl() {
        return System.getProperty("org.graalvm.supporturl", System.getProperty("java.vendor.url.bug", "https://graalvm.org/support"));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String getVendor() {
        return System.getProperty("org.graalvm.vendor", System.getProperty("java.vendor", "GraalVM Community"));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String getVendorUrl() {
        return System.getProperty("org.graalvm.vendorurl", System.getProperty("java.vendor.url", "https://www.graalvm.org/"));
    }

    public static String getVendorVersion() {
        return System.getProperty("org.graalvm.vendorversion", System.getProperty("java.vendor.version", ""));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String getVersion() {
        return VM.stripJVMCISuffix(System.getProperty("java.runtime.version"));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static String stripJVMCISuffix(String javaRuntimeVersion) {
        int jvmciIndex = javaRuntimeVersion.indexOf("-jvmci");
        if (jvmciIndex >= 0) {
            return javaRuntimeVersion.substring(0, jvmciIndex);
        }
        return javaRuntimeVersion;
    }
}

