/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.genscavenge.AbstractMemoryPoolMXBean;
import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.util.VMError;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class GenScavengeMemoryPoolMXBeans {
    private static final String YOUNG_GEN_SCAVENGER = "young generation scavenger";
    private static final String COMPLETE_SCAVENGER = "complete scavenger";
    private static final String EPSILON_SCAVENGER = "epsilon scavenger";
    private static AbstractMemoryPoolMXBean[] mxBeans;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static MemoryPoolMXBean[] createMemoryPoolMXBeans() {
        if (SubstrateOptions.useSerialOrParallelGC()) {
            mxBeans = new AbstractMemoryPoolMXBean[]{new EdenMemoryPoolMXBean(new String[]{YOUNG_GEN_SCAVENGER, COMPLETE_SCAVENGER}), new SurvivorMemoryPoolMXBean(new String[]{YOUNG_GEN_SCAVENGER, COMPLETE_SCAVENGER}), new OldGenerationMemoryPoolMXBean(COMPLETE_SCAVENGER)};
        } else {
            assert (SubstrateOptions.UseEpsilonGC.getValue().booleanValue());
            mxBeans = new AbstractMemoryPoolMXBean[]{new EpsilonMemoryPoolMXBean(EPSILON_SCAVENGER)};
        }
        return mxBeans;
    }

    public static void notifyAfterCollection(GCAccounting accounting) {
        for (AbstractMemoryPoolMXBean mxBean : mxBeans) {
            mxBean.afterCollection(accounting);
        }
    }

    static final class EdenMemoryPoolMXBean
    extends AbstractMemoryPoolMXBean {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        EdenMemoryPoolMXBean(String ... managerNames) {
            super("eden space", managerNames);
        }

        @Override
        UnsignedWord computeInitialValue() {
            return GCImpl.getPolicy().getInitialEdenSize();
        }

        @Override
        UnsignedWord getMaximumValue() {
            return UNDEFINED;
        }

        @Override
        void afterCollection(GCAccounting accounting) {
            this.updatePeakUsage(accounting.getEdenChunkBytesBefore());
        }

        @Override
        public MemoryUsage getUsage() {
            return this.memoryUsage(EdenMemoryPoolMXBean.getCurrentUsage());
        }

        @Override
        public MemoryUsage getPeakUsage() {
            this.updatePeakUsage(EdenMemoryPoolMXBean.getCurrentUsage());
            return this.memoryUsage((UnsignedWord)this.peakUsage.get());
        }

        @Override
        public MemoryUsage getCollectionUsage() {
            return this.memoryUsage((UnsignedWord)WordFactory.zero());
        }

        private static UnsignedWord getCurrentUsage() {
            return HeapImpl.getHeapImpl().getAccounting().getEdenUsedBytes();
        }
    }

    static final class SurvivorMemoryPoolMXBean
    extends AbstractMemoryPoolMXBean {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        SurvivorMemoryPoolMXBean(String ... managerNames) {
            super("survivor space", managerNames);
        }

        @Override
        UnsignedWord computeInitialValue() {
            return GCImpl.getPolicy().getInitialSurvivorSize();
        }

        @Override
        UnsignedWord getMaximumValue() {
            return UNDEFINED;
        }

        @Override
        void afterCollection(GCAccounting accounting) {
            this.updatePeakUsage(accounting.getYoungChunkBytesAfter());
        }

        @Override
        public MemoryUsage getUsage() {
            return this.getCollectionUsage();
        }

        @Override
        public MemoryUsage getPeakUsage() {
            return this.memoryUsage((UnsignedWord)this.peakUsage.get());
        }

        @Override
        public MemoryUsage getCollectionUsage() {
            return this.memoryUsage(GCImpl.getGCImpl().getAccounting().getYoungChunkBytesAfter());
        }
    }

    static final class OldGenerationMemoryPoolMXBean
    extends AbstractMemoryPoolMXBean {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        OldGenerationMemoryPoolMXBean(String ... managerNames) {
            super("old generation space", managerNames);
        }

        @Override
        UnsignedWord computeInitialValue() {
            return GCImpl.getPolicy().getInitialOldSize();
        }

        @Override
        UnsignedWord getMaximumValue() {
            return UNDEFINED;
        }

        @Override
        void afterCollection(GCAccounting accounting) {
            this.updatePeakUsage(accounting.getOldGenerationAfterChunkBytes());
        }

        @Override
        public MemoryUsage getUsage() {
            return this.getCollectionUsage();
        }

        @Override
        public MemoryUsage getPeakUsage() {
            return this.memoryUsage((UnsignedWord)this.peakUsage.get());
        }

        @Override
        public MemoryUsage getCollectionUsage() {
            return this.memoryUsage(GCImpl.getGCImpl().getAccounting().getOldGenerationAfterChunkBytes());
        }
    }

    static final class EpsilonMemoryPoolMXBean
    extends AbstractMemoryPoolMXBean {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        EpsilonMemoryPoolMXBean(String ... managerNames) {
            super("epsilon heap", managerNames);
        }

        @Override
        UnsignedWord computeInitialValue() {
            return GCImpl.getPolicy().getMinimumHeapSize();
        }

        @Override
        UnsignedWord getMaximumValue() {
            return UNDEFINED;
        }

        @Override
        void afterCollection(GCAccounting accounting) {
            throw VMError.shouldNotReachHere();
        }

        @Override
        public MemoryUsage getUsage() {
            HeapImpl heapImpl = HeapImpl.getHeapImpl();
            return this.memoryUsage(heapImpl.getUsedBytes(), heapImpl.getCommittedBytes());
        }

        @Override
        public MemoryUsage getPeakUsage() {
            return this.getUsage();
        }

        @Override
        public MemoryUsage getCollectionUsage() {
            return this.memoryUsage((UnsignedWord)WordFactory.zero());
        }
    }
}

