/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.parallel.ParallelGC;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

final class GreyToBlackObjRefVisitor
implements ObjectReferenceVisitor {
    private final Counters counters = SerialGCOptions.GreyToBlackObjRefDemographics.getValue() != false ? new RealCounters() : new NoopCounters();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GreyToBlackObjRefVisitor() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
        return this.visitObjectReferenceInline(objRef, 0, compressed, holderObject);
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean visitObjectReferenceInline(Pointer objRef, int innerOffset, boolean compressed, Object holderObject) {
        assert (innerOffset >= 0);
        assert (!objRef.isNull());
        this.counters.noteObjRef();
        Word offsetP = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
        assert (offsetP.isNonNull() || innerOffset == 0);
        Pointer p = offsetP.subtract(innerOffset);
        if (p.isNull()) {
            this.counters.noteNullReferent();
            return true;
        }
        if (HeapImpl.getHeapImpl().isInImageHeap(p)) {
            this.counters.noteNonHeapReferent();
            return true;
        }
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        Word header = ohi.readHeaderFromPointer(p);
        if (GCImpl.getGCImpl().isCompleteCollection() || !RememberedSet.get().hasRememberedSet((UnsignedWord)header)) {
            if (ObjectHeaderImpl.isForwardedHeader((UnsignedWord)header)) {
                this.counters.noteForwardedReferent();
                Object obj = ohi.getForwardedObject(p, (UnsignedWord)header);
                assert (ParallelGC.isEnabled() && ParallelGC.singleton().isInParallelPhase() || (long)innerOffset < LayoutEncoding.getSizeFromObjectInGC(obj).rawValue());
                Object offsetObj = innerOffset == 0 ? obj : Word.objectToUntrackedPointer((Object)obj).add(innerOffset).toObject();
                ReferenceAccess.singleton().writeObjectAt(objRef, offsetObj, compressed);
                RememberedSet.get().dirtyCardIfNecessary(holderObject, obj);
                return true;
            }
            Object obj = p.toObject();
            Object copy = GCImpl.getGCImpl().promoteObject(obj, (UnsignedWord)header);
            if (copy != obj) {
                this.counters.noteCopiedReferent();
                assert (ParallelGC.isEnabled() && ParallelGC.singleton().isInParallelPhase() || (long)innerOffset < LayoutEncoding.getSizeFromObjectInGC(copy).rawValue());
                Object offsetCopy = innerOffset == 0 ? copy : Word.objectToUntrackedPointer((Object)copy).add(innerOffset).toObject();
                ReferenceAccess.singleton().writeObjectAt(objRef, offsetCopy, compressed);
            } else {
                this.counters.noteUnmodifiedReference();
            }
            RememberedSet.get().dirtyCardIfNecessary(holderObject, copy);
        }
        return true;
    }

    public Counters openCounters() {
        return this.counters.open();
    }

    public static class RealCounters
    implements Counters {
        private final UninterruptibleUtils.AtomicLong objRef = new UninterruptibleUtils.AtomicLong(0L);
        private final UninterruptibleUtils.AtomicLong nullObjRef = new UninterruptibleUtils.AtomicLong(0L);
        private final UninterruptibleUtils.AtomicLong nullReferent = new UninterruptibleUtils.AtomicLong(0L);
        private final UninterruptibleUtils.AtomicLong forwardedReferent = new UninterruptibleUtils.AtomicLong(0L);
        private final UninterruptibleUtils.AtomicLong nonHeapReferent = new UninterruptibleUtils.AtomicLong(0L);
        private final UninterruptibleUtils.AtomicLong copiedReferent = new UninterruptibleUtils.AtomicLong(0L);
        private final UninterruptibleUtils.AtomicLong unmodifiedReference = new UninterruptibleUtils.AtomicLong(0L);

        RealCounters() {
            this.reset();
        }

        @Override
        public void reset() {
            this.objRef.set(0L);
            this.nullObjRef.set(0L);
            this.nullReferent.set(0L);
            this.forwardedReferent.set(0L);
            this.nonHeapReferent.set(0L);
            this.copiedReferent.set(0L);
            this.unmodifiedReference.set(0L);
        }

        @Override
        public RealCounters open() {
            this.reset();
            return this;
        }

        @Override
        public void close() {
            this.toLog();
            this.reset();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteObjRef() {
            this.objRef.incrementAndGet();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNullReferent() {
            this.nullReferent.incrementAndGet();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteForwardedReferent() {
            this.forwardedReferent.incrementAndGet();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNonHeapReferent() {
            this.nonHeapReferent.incrementAndGet();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteCopiedReferent() {
            this.copiedReferent.incrementAndGet();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteUnmodifiedReference() {
            this.unmodifiedReference.incrementAndGet();
        }

        private void toLog() {
            Log log = Log.log();
            log.string("[GreyToBlackObjRefVisitor.counters:");
            log.string("  objRef: ").signed(this.objRef.get());
            log.string("  nullObjRef: ").signed(this.nullObjRef.get());
            log.string("  nullReferent: ").signed(this.nullReferent.get());
            log.string("  forwardedReferent: ").signed(this.forwardedReferent.get());
            log.string("  nonHeapReferent: ").signed(this.nonHeapReferent.get());
            log.string("  copiedReferent: ").signed(this.copiedReferent.get());
            log.string("  unmodifiedReference: ").signed(this.unmodifiedReference.get());
            log.string("]").newline();
        }
    }

    public static interface Counters
    extends AutoCloseable {
        public Counters open();

        @Override
        public void close();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteObjRef();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNullReferent();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteForwardedReferent();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNonHeapReferent();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteCopiedReferent();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteUnmodifiedReference();

        public void reset();
    }

    public static class NoopCounters
    implements Counters {
        NoopCounters() {
        }

        @Override
        public NoopCounters open() {
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteObjRef() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNullReferent() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteForwardedReferent() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNonHeapReferent() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteCopiedReferent() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteUnmodifiedReference() {
        }

        @Override
        public void reset() {
        }
    }
}

