/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.NotifyGCRuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.OptionKey;

public final class SerialAndEpsilonGCOptions {
    public static final RuntimeOptionKey<Integer> MaximumHeapSizePercent = new NotifyGCRuntimeOptionKey<Integer>(Integer.valueOf(80), SerialAndEpsilonGCOptions::serialOrParallelOrEpsilonGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Integer> MaximumYoungGenerationSizePercent = new NotifyGCRuntimeOptionKey<Integer>(Integer.valueOf(10), SerialAndEpsilonGCOptions::serialOrParallelOrEpsilonGCOnly, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Long> AlignedHeapChunkSize = new HostedOptionKey<Long>(Long.valueOf(0x100000L), SerialAndEpsilonGCOptions::serialOrParallelOrEpsilonGCOnly){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            int multiple = 4096;
            UserError.guarantee(newValue > 0L && newValue % (long)multiple == 0L, "%s value must be a multiple of %d.", this.getName(), multiple);
        }
    };
    public static final HostedOptionKey<Long> LargeArrayThreshold = new HostedOptionKey<Long>(0L, SerialAndEpsilonGCOptions::serialOrParallelOrEpsilonGCOnly);
    public static final HostedOptionKey<Boolean> ZapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::serialOrParallelOrEpsilonGCOnly);
    public static final HostedOptionKey<Boolean> ZapProducedHeapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::serialOrParallelOrEpsilonGCOnly);
    public static final HostedOptionKey<Boolean> ZapConsumedHeapChunks = new HostedOptionKey<Boolean>(false, SerialAndEpsilonGCOptions::serialOrParallelOrEpsilonGCOnly);
    public static final HostedOptionKey<Integer> HeapChunkHeaderPadding = new HostedOptionKey<Integer>(0, SerialAndEpsilonGCOptions::serialOrParallelOrEpsilonGCOnly);

    private SerialAndEpsilonGCOptions() {
    }

    public static void serialOrParallelOrEpsilonGCOnly(OptionKey<?> optionKey) {
        if (!SubstrateOptions.useSerialOrParallelOrEpsilonGC()) {
            throw new InterruptImageBuilding("The option '" + optionKey.getName() + "' can only be used together with the serial ('--gc=serial'), parallel ('--gc=parallel'), or the epsilon garbage collector ('--gc=epsilon').");
        }
    }
}

