/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.ChunksAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkLogging;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.parallel.ParallelGC;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class Space {
    private final String name;
    private final boolean isFromSpace;
    private final int age;
    private final ChunksAccounting accounting;
    private AlignedHeapChunk.AlignedHeader firstAlignedHeapChunk;
    private AlignedHeapChunk.AlignedHeader lastAlignedHeapChunk;
    private UnalignedHeapChunk.UnalignedHeader firstUnalignedHeapChunk;
    private UnalignedHeapChunk.UnalignedHeader lastUnalignedHeapChunk;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    Space(String name, boolean isFromSpace, int age) {
        this(name, isFromSpace, age, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    Space(String name, boolean isFromSpace, int age, ChunksAccounting accounting) {
        assert (name != null) : "Space name should not be null.";
        this.name = name;
        this.isFromSpace = isFromSpace;
        this.age = age;
        this.accounting = new ChunksAccounting(accounting);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isEmpty() {
        return this.firstAlignedHeapChunk.isNull() && this.firstUnalignedHeapChunk.isNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void tearDown() {
        HeapChunkProvider.freeAlignedChunkList(this.firstAlignedHeapChunk);
        this.firstAlignedHeapChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        HeapChunkProvider.freeUnalignedChunkList(this.firstUnalignedHeapChunk);
        this.firstUnalignedHeapChunk = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isEdenSpace() {
        return this.age == 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isYoungSpace() {
        return this.age <= HeapParameters.getMaxSurvivorSpaces();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isSurvivorSpace() {
        return this.age > 0 && this.age <= HeapParameters.getMaxSurvivorSpaces();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isOldSpace() {
        return this.age == HeapParameters.getMaxSurvivorSpaces() + 1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    int getAge() {
        return this.age;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    int getNextAgeForPromotion() {
        return this.age + 1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isFromSpace() {
        return this.isFromSpace;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void walkAllocChunk(AlignedHeapChunk.AlignedHeader allocChunk, Pointer start, GreyToBlackObjectVisitor visitor) {
        assert (allocChunk.isNonNull());
        assert (HeapChunk.getTopPointer(allocChunk).aboveThan((UnsignedWord)start));
        HeapChunk.walkObjectsFromInline(allocChunk, start, visitor);
        if (start.equal((UnsignedWord)ParallelGC.singleton().getAllocChunkScanPointer(this.age, false))) {
            ParallelGC.singleton().setAllocChunk(this.age, allocChunk);
        }
    }

    public boolean walkObjects(ObjectVisitor visitor) {
        AlignedHeapChunk.AlignedHeader aChunk = this.firstAlignedHeapChunk;
        while (aChunk.isNonNull()) {
            if (!AlignedHeapChunk.walkObjects(aChunk, visitor)) {
                return false;
            }
            aChunk = HeapChunk.getNext(aChunk);
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = this.firstUnalignedHeapChunk;
        while (uChunk.isNonNull()) {
            if (!UnalignedHeapChunk.walkObjects(uChunk, visitor)) {
                return false;
            }
            uChunk = HeapChunk.getNext(uChunk);
        }
        return true;
    }

    public Log report(Log log, boolean traceHeapChunks) {
        log.string(this.getName()).string(":").indent(true);
        this.accounting.report(log);
        if (traceHeapChunks) {
            HeapChunkLogging.logChunks(log, this.firstAlignedHeapChunk);
            HeapChunkLogging.logChunks(log, this.firstUnalignedHeapChunk);
        }
        log.redent(false);
        return log;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Pointer allocateMemory(UnsignedWord objectSize) {
        if (ParallelGC.isEnabled()) {
            return this.allocateMemoryParallel(objectSize);
        }
        return this.allocateMemorySerial(objectSize);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Pointer allocateMemorySerial(UnsignedWord objectSize) {
        Pointer result;
        assert (!ParallelGC.isEnabled());
        AlignedHeapChunk.AlignedHeader oldChunk = this.lastAlignedHeapChunk;
        if (oldChunk.isNonNull() && (result = AlignedHeapChunk.allocateMemory(oldChunk, objectSize)).isNonNull()) {
            return result;
        }
        return this.allocateInNewChunk(objectSize);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Pointer allocateMemoryParallel(UnsignedWord objectSize) {
        Pointer oldChunkPtr = ParallelGC.singleton().getAllocChunkScanPointer(this.age, false);
        if (oldChunkPtr.isNonNull()) {
            AlignedHeapChunk.AlignedHeader oldChunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer(oldChunkPtr);
            assert (oldChunk.isNonNull());
            Pointer result = AlignedHeapChunk.allocateMemory(oldChunk, objectSize);
            if (result.isNonNull()) {
                return result;
            }
        }
        return this.allocateInNewChunkParallel(oldChunkPtr, objectSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Pointer allocateInNewChunkParallel(Pointer oldChunkPtr, UnsignedWord objectSize) {
        AlignedHeapChunk.AlignedHeader newChunk;
        ParallelGC.singleton().getMutex().lockNoTransitionUnspecifiedOwner();
        try {
            if (oldChunkPtr.isNonNull()) {
                ParallelGC.singleton().pushAllocChunk(oldChunkPtr);
            }
            newChunk = this.requestAlignedHeapChunk();
        }
        finally {
            ParallelGC.singleton().getMutex().unlockNoTransitionUnspecifiedOwner();
        }
        ParallelGC.singleton().setAllocChunk(this.age, newChunk);
        if (newChunk.isNonNull()) {
            return AlignedHeapChunk.allocateMemory(newChunk, objectSize);
        }
        return (Pointer)WordFactory.nullPointer();
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void retractAllocationParallel(UnsignedWord objectSize) {
        assert (ParallelGC.isEnabled() && ParallelGC.singleton().isInParallelPhase());
        Pointer allocChunkPtr = ParallelGC.singleton().getAllocChunkScanPointer(this.age, false);
        AlignedHeapChunk.AlignedHeader chunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer(allocChunkPtr);
        assert (chunk.isNonNull());
        AlignedHeapChunk.retractAllocation(chunk, objectSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Pointer allocateInNewChunk(UnsignedWord objectSize) {
        AlignedHeapChunk.AlignedHeader newChunk = this.requestAlignedHeapChunk();
        if (newChunk.isNonNull()) {
            return AlignedHeapChunk.allocateMemory(newChunk, objectSize);
        }
        return (Pointer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void releaseChunks(GCImpl.ChunkReleaser chunkReleaser) {
        chunkReleaser.add(this.firstAlignedHeapChunk);
        chunkReleaser.add(this.firstUnalignedHeapChunk);
        this.firstAlignedHeapChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        this.lastAlignedHeapChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        this.firstUnalignedHeapChunk = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
        this.lastUnalignedHeapChunk = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
        this.accounting.reset();
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    void appendAlignedHeapChunk(AlignedHeapChunk.AlignedHeader aChunk, Space originalSpace) {
        assert (Space.verifyMutualExclusionForAppendChunk()) : "Trying to append an aligned heap chunk but no mutual exclusion.";
        assert (HeapChunk.getSpace(aChunk) == originalSpace);
        assert (this != originalSpace);
        if (originalSpace != null) {
            originalSpace.extractAlignedHeapChunk(aChunk);
        }
        HeapChunk.setSpace(aChunk, this);
        AlignedHeapChunk.AlignedHeader oldLast = this.lastAlignedHeapChunk;
        HeapChunk.setPrevious(aChunk, oldLast);
        HeapChunk.setNext(aChunk, (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        if (oldLast.isNonNull()) {
            HeapChunk.setNext(oldLast, aChunk);
        }
        this.lastAlignedHeapChunk = aChunk;
        if (this.firstAlignedHeapChunk.isNull()) {
            this.firstAlignedHeapChunk = aChunk;
        }
        this.accounting.noteAlignedHeapChunk();
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    void appendUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader uChunk, Space originalSpace) {
        assert (Space.verifyMutualExclusionForAppendChunk()) : "Trying to append an aligned heap chunk but no mutual exclusion.";
        assert (uChunk.getSpace() == originalSpace);
        assert (this != originalSpace);
        if (originalSpace != null) {
            originalSpace.extractUnalignedHeapChunk(uChunk);
        }
        if (uChunk.getSpace() == this) {
            return;
        }
        uChunk.setSpace(this);
        UnalignedHeapChunk.UnalignedHeader oldLast = this.lastUnalignedHeapChunk;
        HeapChunk.setPrevious(uChunk, oldLast);
        HeapChunk.setNext(uChunk, (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
        if (oldLast.isNonNull()) {
            HeapChunk.setNext(oldLast, uChunk);
        }
        this.lastUnalignedHeapChunk = uChunk;
        if (this.firstUnalignedHeapChunk.isNull()) {
            this.firstUnalignedHeapChunk = uChunk;
        }
        this.accounting.noteUnalignedHeapChunk(uChunk);
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void extractAlignedHeapChunk(AlignedHeapChunk.AlignedHeader aChunk) {
        assert (VMOperation.isGCInProgress());
        AlignedHeapChunk.AlignedHeader chunkNext = HeapChunk.getNext(aChunk);
        AlignedHeapChunk.AlignedHeader chunkPrev = HeapChunk.getPrevious(aChunk);
        if (chunkPrev.isNonNull()) {
            HeapChunk.setNext(chunkPrev, chunkNext);
        } else {
            this.firstAlignedHeapChunk = chunkNext;
        }
        if (chunkNext.isNonNull()) {
            HeapChunk.setPrevious(chunkNext, chunkPrev);
        } else {
            this.lastAlignedHeapChunk = chunkPrev;
        }
        HeapChunk.setNext(aChunk, (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        HeapChunk.setPrevious(aChunk, (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        HeapChunk.setSpace(aChunk, null);
        this.accounting.unnoteAlignedHeapChunk();
    }

    @Uninterruptible(reason="Must not interact with garbage collections.")
    private void extractUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader uChunk) {
        assert (VMOperation.isGCInProgress());
        UnalignedHeapChunk.UnalignedHeader chunkNext = HeapChunk.getNext(uChunk);
        UnalignedHeapChunk.UnalignedHeader chunkPrev = HeapChunk.getPrevious(uChunk);
        if (chunkPrev.isNonNull()) {
            HeapChunk.setNext(chunkPrev, chunkNext);
        } else {
            this.firstUnalignedHeapChunk = chunkNext;
        }
        if (chunkNext.isNonNull()) {
            HeapChunk.setPrevious(chunkNext, chunkPrev);
        } else {
            this.lastUnalignedHeapChunk = chunkPrev;
        }
        HeapChunk.setNext(uChunk, (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
        HeapChunk.setPrevious(uChunk, (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
        HeapChunk.setSpace(uChunk, null);
        this.accounting.unnoteUnalignedHeapChunk(uChunk);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean verifyMutualExclusionForAppendChunk() {
        return SubstrateOptions.MultiThreaded.getValue() == false || VMThreads.ownsThreadMutex(true) || ParallelGC.isEnabled() && VMOperation.isGCInProgress() && ParallelGC.singleton().isInParallelPhase() && ParallelGC.singleton().getMutex().isOwner(true);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public AlignedHeapChunk.AlignedHeader getFirstAlignedHeapChunk() {
        return this.firstAlignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    AlignedHeapChunk.AlignedHeader getLastAlignedHeapChunk() {
        return this.lastAlignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnalignedHeapChunk.UnalignedHeader getFirstUnalignedHeapChunk() {
        return this.firstUnalignedHeapChunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnalignedHeapChunk.UnalignedHeader getLastUnalignedHeapChunk() {
        return this.lastUnalignedHeapChunk;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Object promoteAlignedObject(Object original, Space originalSpace) {
        assert (ObjectHeaderImpl.isAlignedObject(original));
        assert (this != originalSpace && originalSpace.isFromSpace());
        if (ParallelGC.isEnabled() && ParallelGC.singleton().isInParallelPhase()) {
            return this.copyAlignedObjectParallel(original);
        }
        return this.copyAlignedObjectSerial(original);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Object copyAlignedObjectSerial(Object originalObj) {
        Pointer copyMemory;
        Word header;
        UnsignedWord originalSize;
        assert (VMOperation.isGCInProgress());
        assert (ObjectHeaderImpl.isAlignedObject(originalObj));
        UnsignedWord copySize = originalSize = LayoutEncoding.getSizeFromObjectInlineInGC(originalObj, false);
        boolean addIdentityHashField = false;
        if (!ConfigurationValues.getObjectLayout().hasFixedIdentityHashField() && BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)ObjectHeaderImpl.hasIdentityHashFromAddressInline(header = ObjectHeaderImpl.readHeaderFromObject(originalObj)))) {
            addIdentityHashField = true;
            copySize = LayoutEncoding.getSizeFromObjectInlineInGC(originalObj, true);
        }
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)(copyMemory = this.allocateMemory(copySize)).isNull())) {
            return null;
        }
        Word originalMemory = Word.objectToUntrackedPointer((Object)originalObj);
        UnmanagedMemoryUtil.copyLongsForward((Pointer)originalMemory, copyMemory, originalSize);
        Object copy = copyMemory.toObject();
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)addIdentityHashField)) {
            AlignedHeapChunk.AlignedHeader originalChunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer((Pointer)originalMemory);
            int value = IdentityHashCodeSupport.computeHashCodeFromAddress(originalMemory, HeapChunk.getIdentityHashSalt(originalChunk));
            int offset = LayoutEncoding.getOptionalIdentityHashOffset(copy);
            ObjectAccess.writeInt((Object)copy, (int)offset, (int)value, (LocationIdentity)IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
            ObjectHeaderImpl.getObjectHeaderImpl().setIdentityHashInField(copy);
        }
        if (this.isOldSpace()) {
            AlignedHeapChunk.AlignedHeader copyChunk = AlignedHeapChunk.getEnclosingChunk(copy);
            RememberedSet.get().enableRememberedSetForObject(copyChunk, copy);
        }
        ObjectHeaderImpl.getObjectHeaderImpl().installForwardingPointer(originalObj, copy);
        return copy;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Object copyAlignedObjectParallel(Object original) {
        UnsignedWord originalSize;
        Word originalHeader;
        assert (VMOperation.isGCInProgress());
        Word originalMemory = Word.objectToUntrackedPointer((Object)original);
        int hubOffset = ObjectHeaderImpl.getHubOffset();
        long eightHeaderBytes = originalMemory.readLong(hubOffset);
        Word word = originalHeader = ObjectHeaderImpl.hasShift() ? (Word)WordFactory.unsigned((long)(eightHeaderBytes & 0xFFFFFFFFL)) : (Word)WordFactory.unsigned((long)eightHeaderBytes);
        assert (ObjectHeaderImpl.isAlignedHeader((UnsignedWord)originalHeader));
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        if (ObjectHeaderImpl.isForwardedHeader((UnsignedWord)originalHeader)) {
            return ohi.getForwardedObject((Pointer)originalMemory, (UnsignedWord)originalHeader);
        }
        UnsignedWord copySize = originalSize = LayoutEncoding.getSizeFromHeader(original, originalHeader, eightHeaderBytes, false);
        boolean addIdentityHashField = false;
        if (!ConfigurationValues.getObjectLayout().hasFixedIdentityHashField() && BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)ObjectHeaderImpl.hasIdentityHashFromAddressInline(originalHeader))) {
            addIdentityHashField = true;
            copySize = LayoutEncoding.getSizeFromHeader(original, originalHeader, eightHeaderBytes, true);
        }
        assert (copySize.aboveThan(0));
        Pointer copyMemory = this.allocateMemoryParallel(copySize);
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)copyMemory.isNull())) {
            return null;
        }
        long copyHeaderBytes = this.isOldSpace() ? ObjectHeaderImpl.setRememberedSetBit(eightHeaderBytes) : eightHeaderBytes;
        copyMemory.writeLong(hubOffset, copyHeaderBytes);
        Object copy = copyMemory.toObject();
        Object forward = ohi.installForwardingPointerParallel(original, eightHeaderBytes, copy);
        if (forward != copy) {
            this.retractAllocationParallel(copySize);
            return forward;
        }
        if (hubOffset > 0) {
            UnmanagedMemoryUtil.copyLongsForward((Pointer)originalMemory, copyMemory, WordFactory.unsigned((int)hubOffset));
        }
        int offset = hubOffset + 8;
        UnmanagedMemoryUtil.copyLongsForward((Pointer)originalMemory.add(offset), copyMemory.add(offset), originalSize.subtract(offset));
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)addIdentityHashField)) {
            AlignedHeapChunk.AlignedHeader originalChunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer((Pointer)originalMemory);
            int value = IdentityHashCodeSupport.computeHashCodeFromAddress(originalMemory, HeapChunk.getIdentityHashSalt(originalChunk));
            offset = LayoutEncoding.getOptionalIdentityHashOffset(copy);
            ObjectAccess.writeInt((Object)copy, (int)offset, (int)value, (LocationIdentity)IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
            ObjectHeaderImpl.getObjectHeaderImpl().setIdentityHashInField(copy);
        }
        if (this.isOldSpace()) {
            AlignedHeapChunk.AlignedHeader copyChunk = AlignedHeapChunk.getEnclosingChunk(copy);
            RememberedSet.get().enableRememberedSetForObject(copyChunk, copy);
        }
        return copy;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void promoteAlignedHeapChunk(AlignedHeapChunk.AlignedHeader chunk) {
        assert (!ParallelGC.isEnabled() || !ParallelGC.singleton().isInParallelPhase());
        Space originalSpace = HeapChunk.getSpace(chunk);
        assert (originalSpace.isFromSpace());
        assert (!this.isFromSpace());
        this.appendAlignedHeapChunk(chunk, originalSpace);
        if (this.isOldSpace()) {
            if (originalSpace.isYoungSpace()) {
                RememberedSet.get().enableRememberedSetForChunk(chunk);
            } else {
                assert (originalSpace.isOldSpace());
                RememberedSet.get().clearRememberedSet(chunk);
            }
        }
        if (ParallelGC.isEnabled()) {
            ParallelGC.singleton().push(chunk, 2);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void promoteUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        if (ParallelGC.isEnabled() && ParallelGC.singleton().isInParallelPhase()) {
            this.promoteUnalignedHeapChunkParallel(chunk);
        } else {
            this.promoteUnalignedHeapChunkSerial(chunk);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void promoteUnalignedHeapChunkSerial(UnalignedHeapChunk.UnalignedHeader chunk) {
        Space originalSpace = HeapChunk.getSpace(chunk);
        this.promoteUnalignedHeapChunk0(chunk, originalSpace);
        if (ParallelGC.isEnabled()) {
            ParallelGC.singleton().push(chunk, 2);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void promoteUnalignedHeapChunkParallel(UnalignedHeapChunk.UnalignedHeader chunk) {
        ParallelGC.singleton().getMutex().lockNoTransitionUnspecifiedOwner();
        try {
            Space originalSpace = HeapChunk.getSpace(chunk);
            if (!originalSpace.isFromSpace()) {
                return;
            }
            this.promoteUnalignedHeapChunk0(chunk, originalSpace);
            ParallelGC.singleton().push(chunk, 2);
        }
        finally {
            ParallelGC.singleton().getMutex().unlockNoTransitionUnspecifiedOwner();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void promoteUnalignedHeapChunk0(UnalignedHeapChunk.UnalignedHeader chunk, Space originalSpace) {
        assert (originalSpace.isFromSpace());
        if (this.isOldSpace()) {
            if (originalSpace.isYoungSpace()) {
                RememberedSet.get().enableRememberedSetForChunk(chunk);
            } else {
                assert (originalSpace.isOldSpace());
                RememberedSet.get().clearRememberedSet(chunk);
            }
        }
        this.appendUnalignedHeapChunk(chunk, originalSpace);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private AlignedHeapChunk.AlignedHeader requestAlignedHeapChunk() {
        AlignedHeapChunk.AlignedHeader chunk;
        if (this.isYoungSpace()) {
            assert (this.isSurvivorSpace());
            chunk = HeapImpl.getHeapImpl().getYoungGeneration().requestAlignedSurvivorChunk();
        } else {
            chunk = HeapImpl.getHeapImpl().getOldGeneration().requestAlignedChunk();
        }
        if (chunk.isNonNull()) {
            this.appendAlignedHeapChunk(chunk, null);
        }
        return chunk;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void absorb(Space src) {
        AlignedHeapChunk.AlignedHeader aChunk = src.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader next = HeapChunk.getNext(aChunk);
            this.appendAlignedHeapChunk(aChunk, src);
            aChunk = next;
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = src.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader next = HeapChunk.getNext(uChunk);
            this.appendUnalignedHeapChunk(uChunk, src);
            uChunk = next;
        }
    }

    boolean walkHeapChunks(MemoryWalker.Visitor visitor) {
        boolean continueVisiting = true;
        AlignedHeapChunk.AlignedHeader aChunk = this.firstAlignedHeapChunk;
        while (continueVisiting && aChunk.isNonNull()) {
            continueVisiting = visitor.visitHeapChunk(aChunk, AlignedHeapChunk.getMemoryWalkerAccess());
            aChunk = HeapChunk.getNext(aChunk);
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = this.firstUnalignedHeapChunk;
        while (continueVisiting && uChunk.isNonNull()) {
            continueVisiting = visitor.visitHeapChunk(uChunk, UnalignedHeapChunk.getMemoryWalkerAccess());
            uChunk = HeapChunk.getNext(uChunk);
        }
        return continueVisiting;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getChunkBytes() {
        assert (!this.isEdenSpace() || VMOperation.isGCInProgress()) : "eden data is only accurate during a GC";
        return this.getAlignedChunkBytes().add(this.accounting.getUnalignedChunkBytes());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getAlignedChunkBytes() {
        return this.accounting.getAlignedChunkBytes();
    }

    UnsignedWord computeObjectBytes() {
        assert (!this.isEdenSpace() || VMOperation.isGCInProgress()) : "eden data is only accurate during a GC";
        return this.computeAlignedObjectBytes().add(this.computeUnalignedObjectBytes());
    }

    private UnsignedWord computeAlignedObjectBytes() {
        UnsignedWord result = (UnsignedWord)WordFactory.zero();
        AlignedHeapChunk.AlignedHeader aChunk = this.firstAlignedHeapChunk;
        while (aChunk.isNonNull()) {
            UnsignedWord allocatedBytes = HeapChunk.getTopOffset(aChunk).subtract(AlignedHeapChunk.getObjectsStartOffset());
            result = result.add(allocatedBytes);
            aChunk = HeapChunk.getNext(aChunk);
        }
        return result;
    }

    private UnsignedWord computeUnalignedObjectBytes() {
        UnsignedWord result = (UnsignedWord)WordFactory.zero();
        UnalignedHeapChunk.UnalignedHeader uChunk = this.firstUnalignedHeapChunk;
        while (uChunk.isNonNull()) {
            UnsignedWord allocatedBytes = HeapChunk.getTopOffset(uChunk).subtract(UnalignedHeapChunk.getObjectStartOffset());
            result = result.add(allocatedBytes);
            uChunk = HeapChunk.getNext(uChunk);
        }
        return result;
    }
}

