/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets.riscv64;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.riscv64.PosixRISCV64VaListSnippets;
import com.oracle.svm.core.graal.snippets.riscv64.RISCV64ArithmeticSnippets;
import com.oracle.svm.core.graal.snippets.riscv64.RISCV64NonSnippetLowerings;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.RISCV64.class})
class RISCV64SnippetsFeature
implements InternalFeature {
    RISCV64SnippetsFeature() {
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        Predicate<ResolvedJavaMethod> mustNotAllocatePredicate = null;
        if (hosted) {
            mustNotAllocatePredicate = method -> ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate((ResolvedJavaMethod)method);
        }
        RISCV64ArithmeticSnippets.registerLowerings(options, providers, lowerings);
        RISCV64NonSnippetLowerings.registerLowerings(runtimeConfig, mustNotAllocatePredicate, options, providers, lowerings, hosted);
        PosixRISCV64VaListSnippets.registerLowerings(options, providers, lowerings);
    }
}

