/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.Containers;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class PhysicalMemory {
    private static final UninterruptibleUtils.AtomicInteger INITIALIZING = new UninterruptibleUtils.AtomicInteger(0);
    private static final UnsignedWord UNSET_SENTINEL;
    private static UnsignedWord cachedSize;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isInitialized() {
        return cachedSize != UNSET_SENTINEL;
    }

    @Uninterruptible(reason="May only be called during early startup.")
    public static void setSize(UnsignedWord value) {
        VMError.guarantee(!PhysicalMemory.isInitialized(), "PhysicalMemorySize must not be initialized yet.");
        cachedSize = value;
    }

    public static UnsignedWord size() {
        if (PhysicalMemory.isInitializationDisallowed()) {
            throw VMError.shouldNotReachHere("Accessing the physical memory size may require allocation and synchronization");
        }
        if (!PhysicalMemory.isInitialized()) {
            INITIALIZING.incrementAndGet();
            try {
                long memoryLimit = SubstrateOptions.MaxRAM.getValue();
                cachedSize = memoryLimit > 0L ? WordFactory.unsigned((long)memoryLimit) : ((memoryLimit = Containers.memoryLimitInBytes()) == -1L ? ((PhysicalMemorySupport)ImageSingletons.lookup(PhysicalMemorySupport.class)).size() : WordFactory.unsigned((long)memoryLimit));
            }
            finally {
                INITIALIZING.decrementAndGet();
            }
        }
        return cachedSize;
    }

    public static UnsignedWord getCachedSize() {
        VMError.guarantee(PhysicalMemory.isInitialized(), "Cached physical memory size is not available");
        return cachedSize;
    }

    private static boolean isInitializationDisallowed() {
        return Heap.getHeap().isAllocationDisallowed() || VMOperation.isInProgress() || !PlatformThreads.isCurrentAssigned() || StackOverflowCheck.singleton().isYellowZoneAvailable();
    }

    static {
        cachedSize = UNSET_SENTINEL = UnsignedUtils.MAX_VALUE;
    }

    public static interface PhysicalMemorySupport {
        default public boolean hasSize() {
            throw VMError.shouldNotReachHere("Unused, will be removed");
        }

        public UnsignedWord size();
    }
}

