/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK17OrLater;
import java.awt.Composite;
import java.awt.geom.AffineTransform;
import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.java2d.SurfaceData;
import sun.java2d.pipe.Region;

public final class JavaAWTSubstitutions {

    @Platforms(value={Platform.DARWIN.class})
    @TargetClass(className="sun.java2d.metal.MTLSurfaceData", onlyWith={JDK17OrLater.class})
    static final class Target_sun_java2d_metal_MTLSurfaceData {
        Target_sun_java2d_metal_MTLSurfaceData() {
        }

        @Substitute
        protected boolean initFlipBackbuffer(long pData) {
            throw new UnsupportedOperationException();
        }
    }

    @Platforms(value={Platform.DARWIN.class})
    @TargetClass(className="sun.font.CStrikeDisposer")
    static final class Target_sun_font_CStrikeDisposer {
        Target_sun_font_CStrikeDisposer() {
        }

        @Substitute
        private void freeNativeScalerContext(long pContext) {
            throw new UnsupportedOperationException();
        }
    }

    @Platforms(value={Platform.LINUX.class})
    @TargetClass(className="sun.font.FcFontConfiguration")
    static final class Target_sun_font_FcFontConfiguration {
        @Alias
        private Target_sun_font_FontConfigManager_FcCompFont[] fcCompFonts;
        @Alias
        protected Target_sun_font_SunFontManager fontManager;

        Target_sun_font_FcFontConfiguration() {
        }

        @Alias
        private native void readFcInfo();

        @Alias
        private native void writeFcInfo();

        @Alias
        private static native void warning(String var0);

        @Substitute
        public synchronized boolean init() {
            if (this.fcCompFonts != null) {
                return true;
            }
            SubstrateUtil.cast(this, Target_sun_awt_FontConfiguration.class).setFontConfiguration();
            this.readFcInfo();
            Target_sun_awt_FcFontManager fm = SubstrateUtil.cast(this.fontManager, Target_sun_awt_FcFontManager.class);
            Target_sun_font_FontConfigManager fcm = fm.getFontConfigManager();
            if (this.fcCompFonts == null) {
                this.fcCompFonts = fcm.loadFontConfig();
                if (this.fcCompFonts != null) {
                    try {
                        this.writeFcInfo();
                    }
                    catch (Exception e) {
                        if (Target_sun_font_FontUtilities.debugFonts()) {
                            Target_sun_font_FcFontConfiguration.warning("Exception writing fcInfo " + String.valueOf(e));
                        }
                    }
                } else if (Target_sun_font_FontUtilities.debugFonts()) {
                    Target_sun_font_FcFontConfiguration.warning("Failed to get info from libfontconfig");
                }
            } else {
                fcm.populateFontConfig(this.fcCompFonts);
            }
            return this.fcCompFonts != null;
        }
    }

    @Platforms(value={Platform.LINUX.class})
    @TargetClass(className="sun.font.FontUtilities")
    static final class Target_sun_font_FontUtilities {
        Target_sun_font_FontUtilities() {
        }

        @Alias
        public static native boolean debugFonts();
    }

    @Platforms(value={Platform.LINUX.class})
    @TargetClass(className="sun.font.FontConfigManager")
    static final class Target_sun_font_FontConfigManager {
        Target_sun_font_FontConfigManager() {
        }

        @Alias
        native Target_sun_font_FontConfigManager_FcCompFont[] loadFontConfig();

        @Alias
        native void populateFontConfig(Target_sun_font_FontConfigManager_FcCompFont[] var1);
    }

    @Platforms(value={Platform.LINUX.class})
    @TargetClass(className="sun.awt.FcFontManager")
    static final class Target_sun_awt_FcFontManager {
        Target_sun_awt_FcFontManager() {
        }

        @Alias
        public synchronized native Target_sun_font_FontConfigManager getFontConfigManager();
    }

    @Platforms(value={Platform.LINUX.class})
    @TargetClass(className="sun.font.SunFontManager", onlyWith={SunFontManagerEnabled.class})
    static final class Target_sun_font_SunFontManager {
        Target_sun_font_SunFontManager() {
        }
    }

    @Platforms(value={Platform.LINUX.class})
    private static final class SunFontManagerEnabled
    implements BooleanSupplier {
        private SunFontManagerEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return SubstrateOptions.StaticExecutable.getValue() == false;
        }
    }

    @Platforms(value={Platform.LINUX.class})
    @TargetClass(className="sun.font.FontConfigManager", innerClass={"FcCompFont"})
    static final class Target_sun_font_FontConfigManager_FcCompFont {
        Target_sun_font_FontConfigManager_FcCompFont() {
        }
    }

    @Platforms(value={Platform.LINUX.class})
    @TargetClass(className="sun.awt.FontConfiguration")
    static final class Target_sun_awt_FontConfiguration {
        Target_sun_awt_FontConfiguration() {
        }

        @Substitute
        public boolean foundOsSpecificFile() {
            return false;
        }

        @Substitute
        private void findFontConfigFile() {
        }

        @Alias
        protected native void setFontConfiguration();
    }

    @Platforms(value={Platform.DARWIN.class})
    @TargetClass(className="sun.font.FileFontStrike")
    static final class Target_sun_font_FileFontStrike {
        Target_sun_font_FileFontStrike() {
        }

        @Substitute
        static boolean initNative() {
            throw new UnsupportedOperationException();
        }

        @Substitute
        long _getGlyphImageFromWindows(String family, int style, int size, int glyphCode, boolean fracMetrics, int fontDataSize) {
            throw new UnsupportedOperationException();
        }
    }

    @Platforms(value={Platform.DARWIN.class})
    @TargetClass(className="sun.java2d.loops.TransformBlit")
    static final class Target_sun_java2d_loops_TransformBlit {
        Target_sun_java2d_loops_TransformBlit() {
        }

        @Substitute
        void Transform(SurfaceData src, SurfaceData dst, Composite comp, Region clip, AffineTransform at, int hint, int srcx, int srcy, int dstx, int dsty, int width, int height) {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="sun.awt.DebugSettings")
    static final class Target_sun_awt_DebugSettings {
        Target_sun_awt_DebugSettings() {
        }

        @Substitute
        void setCTracingOn(boolean enabled) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        void setCTracingOn(boolean enabled, String file) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        void setCTracingOn(boolean enabled, String file, int line) {
            throw new UnsupportedOperationException();
        }
    }
}

