/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.bundles;

import com.oracle.svm.core.jdk.localization.bundles.StoredBundle;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class DelayedBundle
implements StoredBundle {
    private final Method getContents;

    public DelayedBundle(Class<?> clazz) {
        this.getContents = DelayedBundle.findGetContentsMethod(clazz);
    }

    private static Method findGetContentsMethod(Class<?> clazz) {
        Class<?> c = clazz;
        while (ResourceBundle.class.isAssignableFrom(c)) {
            Method method = ReflectionUtil.lookupMethod((boolean)true, c, (String)"getContents", (Class[])new Class[0]);
            if (method != null) {
                return method;
            }
            c = c.getSuperclass();
        }
        throw VMError.shouldNotReachHere("Failed to find method `getContents` in " + String.valueOf(clazz));
    }

    @Override
    public Map<String, Object> getContent(Object bundle) {
        try {
            Object[][] content = (Object[][])this.getContents.invoke(bundle, new Object[0]);
            return DelayedBundle.asMap(content);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> asMap(Object[][] content) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Object[] entry : content) {
            String key = (String)entry[0];
            Object value = entry[1];
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            res.put(key, value);
        }
        return res;
    }
}

