/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Containers;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JDK17OrEarlier;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.jdk.JDK19OrLater;
import com.oracle.svm.core.jdk.JDK20OrLater;
import com.oracle.svm.core.jfr.HasChunkRotationMonitorField;
import com.oracle.svm.core.jfr.HasFileDeltaChangeField;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_EventWriter;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventConfiguration;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_handlers_EventHandler;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import com.oracle.svm.core.util.VMError;
import java.util.List;
import jdk.internal.event.Event;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogTag;
import org.graalvm.nativeimage.ProcessProperties;

@TargetClass(value=JVM.class, onlyWith={HasJfrSupport.class})
public final class Target_jdk_jfr_internal_JVM {
    @Alias
    @TargetElement(onlyWith={HasChunkRotationMonitorField.class})
    static Object CHUNK_ROTATION_MONITOR;
    @Alias
    @TargetElement(onlyWith={HasFileDeltaChangeField.class})
    static Object FILE_DELTA_CHANGE;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private volatile boolean nativeOK;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private volatile boolean recording;

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public void markChunkFinal() {
        SubstrateJVM.get().markChunkFinal();
    }

    @Substitute
    public void beginRecording() {
        SubstrateJVM.get().beginRecording();
    }

    @Substitute
    @Uninterruptible(reason="Needed for calling SubstrateJVM.isRecording().")
    @TargetElement(onlyWith={JDK17OrLater.class})
    public boolean isRecording() {
        return SubstrateJVM.get().isRecording();
    }

    @Substitute
    public void endRecording() {
        SubstrateJVM.get().endRecording();
    }

    @Substitute
    public static long counterTime() {
        return JfrTicks.elapsedTicks();
    }

    @Substitute
    public boolean emitEvent(long eventTypeId, long timestamp, long when) {
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public List<Class<? extends Event>> getAllEventClasses() {
        return JfrJavaEvents.getAllEventClasses();
    }

    @Substitute
    @TargetElement(name="getAllEventClasses", onlyWith={JDK11OrEarlier.class})
    public List<Class<? extends jdk.jfr.Event>> getAllEventClassesJDK11() {
        return JfrJavaEvents.getJfrEventClasses();
    }

    @Substitute
    public long getUnloadedEventClassCount() {
        return 0L;
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getClassId().")
    public static long getClassId(Class<?> clazz) {
        return SubstrateJVM.get().getClassId(clazz);
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    public static long getClassIdNonIntrinsic(Class<?> clazz) {
        return Target_jdk_jfr_internal_JVM.getClassId(clazz);
    }

    @Substitute
    public String getPid() {
        long id = ProcessProperties.getProcessID();
        return String.valueOf(id);
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getStackTraceId().")
    public long getStackTraceId(int skipCount) {
        return SubstrateJVM.get().getStackTraceId(skipCount);
    }

    @Substitute
    public long getThreadId(Thread t) {
        return SubstrateJVM.getThreadId(t);
    }

    @Substitute
    public long getTicksFrequency() {
        return JfrTicks.getTicksFrequency();
    }

    @Substitute
    public static void log(int tagSetId, int level, String message) {
        SubstrateJVM.get().log(tagSetId, level, message);
    }

    @Substitute
    public static void logEvent(int level, String[] lines, boolean system) {
        SubstrateJVM.get().logEvent(level, lines, system);
    }

    @Substitute
    public static void subscribeLogLevel(LogTag lt, int tagSetId) {
        SubstrateJVM.get().subscribeLogLevel(lt, tagSetId);
    }

    @Substitute
    public synchronized void retransformClasses(Class<?>[] classes) {
    }

    @Substitute
    public void setEnabled(long eventTypeId, boolean enabled) {
        SubstrateJVM.get().setEnabled(eventTypeId, enabled);
    }

    @Substitute
    public void setFileNotification(long delta) {
        SubstrateJVM.get().setFileNotification(delta);
    }

    @Substitute
    public void setGlobalBufferCount(long count) throws IllegalArgumentException, IllegalStateException {
        SubstrateJVM.get().setGlobalBufferCount(count);
    }

    @Substitute
    public void setGlobalBufferSize(long size) throws IllegalArgumentException {
        SubstrateJVM.get().setGlobalBufferSize(size);
    }

    @Substitute
    public void setMemorySize(long size) throws IllegalArgumentException {
        SubstrateJVM.get().setMemorySize(size);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public void setMethodSamplingPeriod(long type, long intervalMillis) {
        SubstrateJVM.get().setMethodSamplingInterval(type, intervalMillis);
    }

    @Substitute
    public void setOutput(String file) {
        SubstrateJVM.get().setOutput(file);
    }

    @Substitute
    public void setForceInstrumentation(boolean force) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    public void setSampleThreads(boolean sampleThreads) throws IllegalStateException {
        SubstrateJVM.get().setSampleThreads(sampleThreads);
    }

    @Substitute
    public void setCompressedIntegers(boolean compressed) throws IllegalStateException {
        SubstrateJVM.get().setCompressedIntegers(compressed);
    }

    @Substitute
    public void setStackDepth(int depth) throws IllegalArgumentException, IllegalStateException {
        SubstrateJVM.get().setStackDepth(depth);
    }

    @Substitute
    public void setStackTraceEnabled(long eventTypeId, boolean enabled) {
        SubstrateJVM.get().setStackTraceEnabled(eventTypeId, enabled);
    }

    @Substitute
    public void setThreadBufferSize(long size) throws IllegalArgumentException, IllegalStateException {
        SubstrateJVM.get().setThreadBufferSize(size);
    }

    @Substitute
    public boolean setThreshold(long eventTypeId, long ticks) {
        return SubstrateJVM.get().setThreshold(eventTypeId, ticks);
    }

    @Substitute
    public void storeMetadataDescriptor(byte[] bytes) {
        SubstrateJVM.get().storeMetadataDescriptor(bytes);
    }

    @Substitute
    public boolean getAllowedToDoEventRetransforms() {
        return false;
    }

    @Substitute
    private boolean createJFR(boolean simulateFailure) throws IllegalStateException {
        return SubstrateJVM.get().createJFR(simulateFailure);
    }

    @Substitute
    private boolean destroyJFR() {
        return SubstrateJVM.get().destroyJFR();
    }

    @Substitute
    public boolean isAvailable() {
        return true;
    }

    @Substitute
    public double getTimeConversionFactor() {
        return 1.0;
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class, JDK17OrEarlier.class})
    public boolean setHandler(Class<? extends Event> eventClass, Target_jdk_jfr_internal_handlers_EventHandler handler) {
        throw VMError.shouldNotReachHere("eventHandler does not exist for: " + String.valueOf(eventClass));
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class, JDK17OrEarlier.class})
    public Object getHandler(Class<? extends Event> eventClass) {
        return SubstrateJVM.getHandler(eventClass);
    }

    @Substitute
    public long getTypeId(Class<?> clazz) {
        return JfrTraceId.getTraceId(clazz);
    }

    @Substitute
    public static Object getEventWriter() {
        return SubstrateJVM.get().getEventWriter();
    }

    @Substitute
    public static Target_jdk_jfr_internal_EventWriter newEventWriter() {
        return SubstrateJVM.get().newEventWriter();
    }

    @Substitute
    public static boolean flush(Target_jdk_jfr_internal_EventWriter writer, int uncommittedSize, int requestedSize) {
        return SubstrateJVM.get().flush(writer, uncommittedSize, requestedSize);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public void flush() {
        SubstrateJVM.get().flush();
    }

    @Substitute
    public void setRepositoryLocation(String dirText) {
        SubstrateJVM.get().setRepositoryLocation(dirText);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public void setDumpPath(String dumpPathText) {
        SubstrateJVM.get().setDumpPath(dumpPathText);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public String getDumpPath() {
        return SubstrateJVM.get().getDumpPath();
    }

    @Substitute
    public void abort(String errorMsg) {
        SubstrateJVM.get().abort(errorMsg);
    }

    @Substitute
    public static boolean addStringConstant(long id, String s) {
        return false;
    }

    @Substitute
    public void uncaughtException(Thread thread, Throwable t) {
    }

    @Substitute
    public boolean setCutoff(long eventTypeId, long cutoffTicks) {
        return SubstrateJVM.get().setCutoff(eventTypeId, cutoffTicks);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public boolean setThrottle(long eventTypeId, long eventSampleSize, long periodMs) {
        return true;
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    public void emitOldObjectSamples(long cutoff, boolean emitAll) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public void emitOldObjectSamples(long cutoff, boolean emitAll, boolean skipBFS) {
    }

    @Substitute
    public boolean shouldRotateDisk() {
        return SubstrateJVM.get().shouldRotateDisk();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public void include(Thread thread) {
        JfrThreadLocal.setExcluded(thread, false);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public void exclude(Thread thread) {
        JfrThreadLocal.setExcluded(thread, true);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public boolean isExcluded(Thread thread) {
        return JfrThreadLocal.isThreadExcluded(thread);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public boolean isExcluded(Class<? extends Event> eventClass) {
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public boolean isInstrumented(Class<? extends Event> eventClass) {
        return true;
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    public long getChunkStartNanos() {
        return SubstrateJVM.get().getChunkStartNanos();
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public boolean setConfiguration(Class<? extends Event> eventClass, Target_jdk_jfr_internal_event_EventConfiguration configuration) {
        return SubstrateJVM.get().setConfiguration(eventClass, configuration);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public Object getConfiguration(Class<? extends Event> eventClass) {
        return SubstrateJVM.get().getConfiguration(eventClass);
    }

    @Substitute
    public long getTypeId(String name) {
        return -1L;
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public boolean isContainerized() {
        return Containers.isContainerized();
    }

    @Substitute
    @TargetElement(onlyWith={JDK20OrLater.class})
    public long hostTotalMemory() {
        return 0L;
    }
}

