/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.ThreadCpuTimeSupport;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;

public class ThreadCPULoadEvent {
    private static final FastThreadLocalLong cpuTimeTL = FastThreadLocalFactory.createLong("ThreadCPULoadEvent.cpuTimeTL");
    private static final FastThreadLocalLong userTimeTL = FastThreadLocalFactory.createLong("ThreadCPULoadEvent.userTimeTL");
    private static final FastThreadLocalLong timeTL = FastThreadLocalFactory.createLong("ThreadCPULoadEvent.timeTL");
    private static volatile int lastActiveProcessorCount;

    public static void emitEvents() {
        if (ThreadCPULoadEvent.shouldEmitUnsafe()) {
            EmitThreadCPULoadEventsOperation vmOp = new EmitThreadCPULoadEventsOperation();
            vmOp.enqueue();
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static void emit(IsolateThread isolateThread) {
        long currSystemTime;
        if (!JfrEvent.ThreadCPULoad.shouldEmit()) {
            return;
        }
        long currCpuTime = ThreadCPULoadEvent.getThreadCpuTime(isolateThread, true);
        long prevCpuTime = cpuTimeTL.get(isolateThread);
        long currTime = ThreadCPULoadEvent.getCurrentTime();
        long prevTime = timeTL.get(isolateThread);
        timeTL.set(isolateThread, currTime);
        if (currCpuTime - prevCpuTime < 1000000L) {
            return;
        }
        long currUserTime = ThreadCPULoadEvent.getThreadCpuTime(isolateThread, false);
        long prevUserTime = userTimeTL.get(isolateThread);
        long prevSystemTime = prevCpuTime - prevUserTime;
        if (prevSystemTime > (currSystemTime = currCpuTime - currUserTime)) {
            currCpuTime += prevSystemTime - currSystemTime;
            currSystemTime = prevSystemTime;
        }
        int processorsCount = ThreadCPULoadEvent.getProcessorCount();
        long userTime = currUserTime - prevUserTime;
        long systemTime = currSystemTime - prevSystemTime;
        long wallClockTime = currTime - prevTime;
        float totalAvailableTime = wallClockTime * (long)processorsCount;
        if (userTime + systemTime > wallClockTime) {
            long excess = userTime + systemTime - wallClockTime;
            currCpuTime -= excess;
            if (userTime > excess) {
                userTime -= excess;
                currUserTime -= excess;
            } else {
                excess -= userTime;
                currUserTime -= userTime;
                userTime = 0L;
                systemTime -= excess;
            }
        }
        cpuTimeTL.set(isolateThread, currCpuTime);
        userTimeTL.set(isolateThread, currUserTime);
        JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
        JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
        JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.ThreadCPULoad);
        JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
        JfrNativeEventWriter.putEventThread(data);
        JfrNativeEventWriter.putFloat(data, (float)userTime / totalAvailableTime);
        JfrNativeEventWriter.putFloat(data, (float)systemTime / totalAvailableTime);
        JfrNativeEventWriter.endSmallEvent(data);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getProcessorCount() {
        int curProcessorCount = Jvm.JVM_ActiveProcessorCount();
        int prevProcessorCount = lastActiveProcessorCount;
        lastActiveProcessorCount = curProcessorCount;
        return UninterruptibleUtils.Math.max(curProcessorCount, prevProcessorCount);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long getThreadCpuTime(IsolateThread isolateThread, boolean includeSystemTime) {
        long threadCpuTime = ThreadCpuTimeSupport.getInstance().getThreadCpuTime(isolateThread, includeSystemTime);
        return threadCpuTime < 0L ? 0L : threadCpuTime;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long getCurrentTime() {
        return System.nanoTime();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initCurrentTime(IsolateThread isolateThread) {
        if (timeTL.get(isolateThread) <= 0L) {
            timeTL.set(isolateThread, ThreadCPULoadEvent.getCurrentTime());
        }
    }

    @Uninterruptible(reason="Used to avoid the VM operation if it is not absolutely needed.")
    private static boolean shouldEmitUnsafe() {
        return JfrEvent.ThreadCPULoad.shouldEmit();
    }

    private static final class EmitThreadCPULoadEventsOperation
    extends JavaVMOperation {
        EmitThreadCPULoadEventsOperation() {
            super(VMOperationInfos.get(EmitThreadCPULoadEventsOperation.class, "Emit ThreadCPULoad events", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            IsolateThread isolateThread = VMThreads.firstThread();
            while (isolateThread.isNonNull()) {
                ThreadCPULoadEvent.emit(isolateThread);
                isolateThread = VMThreads.nextThread(isolateThread);
            }
        }
    }
}

