/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.log.Log;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordBase;

public abstract class VMLockSupport {
    public abstract VMMutex[] getMutexes();

    public abstract VMCondition[] getConditions();

    public abstract VMSemaphore[] getSemaphores();

    public static class DumpVMMutexes
    extends SubstrateDiagnostics.DiagnosticThunk {
        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("VM mutexes:").indent(true);
            VMLockSupport support = null;
            if (ImageSingletons.contains(VMLockSupport.class)) {
                support = (VMLockSupport)ImageSingletons.lookup(VMLockSupport.class);
            }
            if (support == null || support.getMutexes() == null) {
                log.string("No mutex information is available.").newline();
            } else {
                VMMutex[] mutexes = support.getMutexes();
                for (int i = 0; i < mutexes.length; ++i) {
                    VMMutex mutex = mutexes[i];
                    IsolateThread owner = mutex.owner;
                    log.string("mutex \"").string(mutex.getName()).string("\" ");
                    if (owner.isNull()) {
                        log.string("is unlocked.");
                    } else {
                        log.string("is locked by ");
                        if (owner.equal((ComparableWord)VMMutex.UNSPECIFIED_OWNER)) {
                            log.string("an unspecified thread.");
                        } else {
                            log.string("thread ").zhex((WordBase)owner);
                        }
                    }
                    log.newline();
                }
            }
            log.indent(false);
        }
    }
}

