/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.linux.LinuxPthread;
import com.oracle.svm.core.posix.headers.linux.LinuxTime;
import com.oracle.svm.core.posix.linux.LinuxLibCHelper;
import com.oracle.svm.core.thread.ThreadCpuTimeSupport;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;

@AutomaticallyRegisteredImageSingleton(value={ThreadCpuTimeSupport.class})
final class LinuxThreadCpuTimeSupport
implements ThreadCpuTimeSupport {
    LinuxThreadCpuTimeSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCurrentThreadCpuTime(boolean includeSystemTime) {
        if (!includeSystemTime) {
            int tid = (int)VMThreads.findOSThreadIdForIsolateThread(CurrentIsolate.getCurrentThread()).rawValue();
            return LinuxLibCHelper.getThreadUserTimeSlow(tid);
        }
        return LinuxThreadCpuTimeSupport.fastThreadCpuTime(LinuxTime.CLOCK_THREAD_CPUTIME_ID());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadCpuTime(IsolateThread isolateThread, boolean includeSystemTime) {
        if (!includeSystemTime) {
            int tid = (int)VMThreads.findOSThreadIdForIsolateThread(isolateThread).rawValue();
            return LinuxLibCHelper.getThreadUserTimeSlow(tid);
        }
        return this.getThreadCpuTime(VMThreads.findOSThreadHandleForIsolateThread(isolateThread));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long getThreadCpuTime(VMThreads.OSThreadHandle osThreadHandle) {
        CIntPointer threadsClockId = (CIntPointer)StackValue.get((int)4);
        if (LinuxPthread.pthread_getcpuclockid((Pthread.pthread_t)osThreadHandle, threadsClockId) != 0) {
            return -1L;
        }
        return LinuxThreadCpuTimeSupport.fastThreadCpuTime(threadsClockId.read());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long fastThreadCpuTime(int clockId) {
        Time.timespec time = UnsafeStackValue.get(Time.timespec.class);
        if (LinuxTime.NoTransitions.clock_gettime(clockId, time) != 0) {
            return -1L;
        }
        return time.tv_sec() * 1000000000L + time.tv_nsec();
    }
}

