/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.Uninterruptible;
import org.graalvm.word.Pointer;

public class TypedMemoryReader {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getS1(Pointer ptr) {
        return ptr.readByte(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getS2(Pointer ptr) {
        return ptr.readShort(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getS4(Pointer ptr) {
        return ptr.readInt(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getS8(Pointer ptr) {
        return ptr.readLong(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getU1(Pointer ptr) {
        return TypedMemoryReader.getS1(ptr) & 0xFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getU2(Pointer ptr) {
        return TypedMemoryReader.getS2(ptr) & 0xFFFF;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getU4(Pointer ptr) {
        return (long)TypedMemoryReader.getS4(ptr) & 0xFFFFFFFFL;
    }
}

