/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.NeverInlineTrivial;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.graal.thread.VMThreadLocalAccess;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.Target_java_lang_ref_Reference;
import com.oracle.svm.core.heap.UnknownClass;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.ReferenceType;
import com.oracle.svm.core.jdk.ClassLoaderSupport;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.jdk.LambdaFormHiddenMethod;
import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.jdk.SealedClassSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.BootLoaderSupport;
import com.oracle.svm.hosted.ClassLoaderFeature;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.ModuleAccess;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.ReachabilityRegistrationNode;
import com.oracle.svm.hosted.analysis.SVMParsingSupport;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.InliningUtilities;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.code.UninterruptibleAnnotationChecker;
import com.oracle.svm.hosted.heap.PodSupport;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.AnalysisGraphBuilderPhase;
import com.oracle.svm.hosted.phases.ImplicitAssertionsPhase;
import com.oracle.svm.hosted.phases.InlineBeforeAnalysisPolicyImpl;
import com.oracle.svm.hosted.substitute.UnsafeAutomaticSubstitutionProcessor;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiPredicate;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.MethodFilter;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.StaticDeoptimizingNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.UnsafeAccessNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.BoxNodeIdentityPhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.RelocatedPointer;

public class SVMHost
extends HostVM {
    private final ConcurrentHashMap<AnalysisType, DynamicHub> typeToHub = new ConcurrentHashMap();
    private final ConcurrentHashMap<DynamicHub, AnalysisType> hubToType = new ConcurrentHashMap();
    private final Map<String, EnumSet<AnalysisType.UsageKind>> forbiddenTypes;
    private final Platform platform;
    private final ClassInitializationSupport classInitializationSupport;
    private final LinkAtBuildTimeSupport linkAtBuildTimeSupport;
    private final HostedStringDeduplication stringTable;
    private final UnsafeAutomaticSubstitutionProcessor automaticSubstitutions;
    private ConcurrentMap<AnalysisMethod, StructuredGraph> analysisGraphs;
    private final ConcurrentMap<AnalysisMethod, Boolean> containsStackValueNode = new ConcurrentHashMap<AnalysisMethod, Boolean>();
    private final ConcurrentMap<AnalysisMethod, Boolean> classInitializerSideEffect = new ConcurrentHashMap<AnalysisMethod, Boolean>();
    private final ConcurrentMap<AnalysisMethod, Set<AnalysisType>> initializedClasses = new ConcurrentHashMap<AnalysisMethod, Set<AnalysisType>>();
    private final ConcurrentMap<AnalysisMethod, Boolean> analysisTrivialMethods = new ConcurrentHashMap<AnalysisMethod, Boolean>();
    private final Set<AnalysisField> finalFieldsInitializedOutsideOfConstructor = ConcurrentHashMap.newKeySet();
    private final HostVM.MultiMethodAnalysisPolicy multiMethodAnalysisPolicy;
    private final SVMParsingSupport parsingSupport;
    private final boolean parseOnce = SubstrateOptions.parseOnce();
    private final Method getDeclaringClass0 = ReflectionUtil.lookupMethod(Class.class, (String)"getDeclaringClass0", (Class[])new Class[0]);
    private final Method getSimpleBinaryName0 = ReflectionUtil.lookupMethod(Class.class, (String)"getSimpleBinaryName0", (Class[])new Class[0]);
    private final InlineBeforeAnalysisPolicy<?> inlineBeforeAnalysisPolicy = new InlineBeforeAnalysisPolicyImpl(this);
    private final List<BiPredicate<AnalysisMethod, AnalysisMethod>> neverInlineTrivialHandlers = new CopyOnWriteArrayList<BiPredicate<AnalysisMethod, AnalysisMethod>>();

    public SVMHost(OptionValues options, ClassLoader classLoader, ClassInitializationSupport classInitializationSupport, UnsafeAutomaticSubstitutionProcessor automaticSubstitutions, Platform platform) {
        super(options, classLoader);
        this.classInitializationSupport = classInitializationSupport;
        this.stringTable = HostedStringDeduplication.singleton();
        this.forbiddenTypes = SVMHost.setupForbiddenTypes(options);
        this.automaticSubstitutions = automaticSubstitutions;
        this.platform = platform;
        this.linkAtBuildTimeSupport = LinkAtBuildTimeSupport.singleton();
        if (ImageSingletons.contains(HostVM.MultiMethodAnalysisPolicy.class)) {
            this.multiMethodAnalysisPolicy = (HostVM.MultiMethodAnalysisPolicy)ImageSingletons.lookup(HostVM.MultiMethodAnalysisPolicy.class);
        } else {
            ImageSingletons.add(HostVM.MultiMethodAnalysisPolicy.class, (Object)DEFAULT_MULTIMETHOD_ANALYSIS_POLICY);
            this.multiMethodAnalysisPolicy = DEFAULT_MULTIMETHOD_ANALYSIS_POLICY;
        }
        this.parsingSupport = ImageSingletons.contains(SVMParsingSupport.class) ? (SVMParsingSupport)ImageSingletons.lookup(SVMParsingSupport.class) : null;
    }

    private static Map<String, EnumSet<AnalysisType.UsageKind>> setupForbiddenTypes(OptionValues options) {
        List forbiddenTypesOptionValues = ((LocatableMultiOptionValue.Strings)SubstrateOptions.ReportAnalysisForbiddenType.getValue(options)).values();
        HashMap<String, EnumSet<AnalysisType.UsageKind>> forbiddenTypes = new HashMap<String, EnumSet<AnalysisType.UsageKind>>();
        for (String forbiddenTypesOptionValue : forbiddenTypesOptionValues) {
            EnumSet<AnalysisType.UsageKind> usageKinds;
            String[] typeNameUsageKind = forbiddenTypesOptionValue.split(":", 2);
            if (typeNameUsageKind.length == 1) {
                usageKinds = EnumSet.allOf(AnalysisType.UsageKind.class);
            } else {
                String[] usageKindValues;
                usageKinds = EnumSet.noneOf(AnalysisType.UsageKind.class);
                for (String usageKindValue : usageKindValues = typeNameUsageKind[1].split(",")) {
                    usageKinds.add(AnalysisType.UsageKind.valueOf((String)usageKindValue));
                }
            }
            forbiddenTypes.put(typeNameUsageKind[0], usageKinds);
        }
        return forbiddenTypes.isEmpty() ? null : forbiddenTypes;
    }

    public void checkForbidden(AnalysisType type, AnalysisType.UsageKind kind) {
        if (SubstrateOptions.VerifyNamingConventions.getValue().booleanValue()) {
            NativeImageGenerator.checkName(type.getWrapped().toJavaName(), null, null);
        }
        if (this.forbiddenTypes == null) {
            return;
        }
        for (AnalysisType cur = type; cur != null; cur = cur.getSuperclass()) {
            EnumSet<AnalysisType.UsageKind> forbiddenType = this.forbiddenTypes.get(cur.getWrapped().toJavaName());
            if (forbiddenType == null || !forbiddenType.contains(kind)) continue;
            throw new UnsupportedFeatureException("Forbidden type " + cur.getWrapped().toJavaName() + (String)(cur.equals((Object)type) ? "" : " (superclass of " + type.getWrapped().toJavaName() + ")") + " UsageKind: " + String.valueOf(kind));
        }
    }

    public GraphBuilderPhase.Instance createGraphBuilderPhase(HostedProviders builderProviders, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        return new AnalysisGraphBuilderPhase((CoreProviders)builderProviders, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, builderProviders.getWordTypes(), this);
    }

    public String getImageName() {
        return (String)SubstrateOptions.Name.getValue(this.options);
    }

    public boolean isRelocatedPointer(UniverseMetaAccess metaAccess, JavaConstant constant) {
        return metaAccess.isInstanceOf(constant, RelocatedPointer.class);
    }

    public void installInThread(Object vmConfig) {
        super.installInThread(vmConfig);
        assert (vmConfig == ImageSingletonsSupportImpl.HostedManagement.get());
    }

    public Object getConfiguration() {
        return ImageSingletonsSupportImpl.HostedManagement.getAndAssertExists();
    }

    public void registerType(AnalysisType analysisType) {
        DynamicHub hub = this.createHub(analysisType);
        DynamicHub existing = this.typeToHub.put(analysisType, hub);
        assert (existing == null);
        existing = this.hubToType.put(hub, analysisType);
        assert (existing == null);
    }

    public void onTypeReachable(AnalysisType analysisType) {
        Package packageValue;
        ClassLoader runtimeClassLoader;
        if (!analysisType.isReachable()) {
            throw VMError.shouldNotReachHere("Registering and initializing a type that was not yet marked as reachable: " + String.valueOf(analysisType));
        }
        if (BuildPhaseProvider.isAnalysisFinished()) {
            throw VMError.shouldNotReachHere("Initializing type after analysis: " + String.valueOf(analysisType));
        }
        this.classInitializationSupport.maybeInitializeHosted((ResolvedJavaType)analysisType);
        Class javaClass = analysisType.getJavaClass();
        ClassLoader classloader = javaClass.getClassLoader();
        if (classloader == null) {
            classloader = BootLoaderSupport.getBootLoader();
        }
        if ((runtimeClassLoader = ClassLoaderFeature.getRuntimeClassLoader(classloader)) != null && (packageValue = javaClass.getPackage()) != null) {
            DynamicHub typeHub = this.typeToHub.get(analysisType);
            String packageName = typeHub.getPackageName();
            ClassLoaderSupport.registerPackage(runtimeClassLoader, packageName, packageValue);
        }
        this.automaticSubstitutions.computeSubstitutions(this, GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType(analysisType.getJavaClass()));
    }

    public boolean isInitialized(AnalysisType type) {
        boolean shouldInitializeAtRuntime = this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)type);
        assert (shouldInitializeAtRuntime || type.getWrapped().isInitialized()) : "Types that are not marked for runtime initializations must have been initialized: " + String.valueOf(type);
        return !shouldInitializeAtRuntime;
    }

    public GraphBuilderConfiguration updateGraphBuilderConfiguration(GraphBuilderConfiguration config, AnalysisMethod method) {
        return config.withRetainLocalVariables(this.retainLocalVariables()).withUnresolvedIsError(this.linkAtBuildTimeSupport.linkAtBuildTime((ResolvedJavaType)method.getDeclaringClass())).withFullInfopoints(SubstrateOptions.getSourceLevelDebug() && SubstrateOptions.getSourceLevelDebugFilter().test(method.getDeclaringClass().toJavaName()));
    }

    private boolean retainLocalVariables() {
        if (this.parseOnce) {
            return SubstrateOptions.optimizationLevel() == SubstrateOptions.OptimizationLevel.O0;
        }
        return true;
    }

    public Optional<AnalysisMethod> handleForeignCall(ForeignCallDescriptor foreignCallDescriptor, ForeignCallsProvider foreignCallsProvider) {
        SubstrateForeignCallsProvider foreignCalls = (SubstrateForeignCallsProvider)foreignCallsProvider;
        Optional<AnalysisMethod> targetMethod = Optional.empty();
        if (foreignCalls.getForeignCalls().size() > 0) {
            SubstrateForeignCallLinkage linkage = foreignCalls.lookupForeignCall(foreignCallDescriptor);
            targetMethod = Optional.of((AnalysisMethod)linkage.getMethod());
        }
        return targetMethod;
    }

    public DynamicHub dynamicHub(ResolvedJavaType type) {
        AnalysisType aType;
        if (type instanceof AnalysisType) {
            aType = (AnalysisType)type;
        } else if (type instanceof HostedType) {
            aType = ((HostedType)type).getWrapped();
        } else {
            throw VMError.shouldNotReachHere("Found unsupported type: " + String.valueOf(type));
        }
        return this.typeToHub.get(aType);
    }

    public AnalysisType lookupType(DynamicHub hub) {
        assert (hub != null) : "Hub must not be null";
        return this.hubToType.get(hub);
    }

    private DynamicHub createHub(AnalysisType type) {
        DynamicHub superHub = null;
        if (type.isInstanceClass() && type.getSuperclass() != null || type.isArray()) {
            superHub = this.dynamicHub((ResolvedJavaType)type.getSuperclass());
        }
        DynamicHub componentHub = null;
        if (type.isArray()) {
            componentHub = this.dynamicHub((ResolvedJavaType)type.getComponentType());
        }
        Class javaClass = type.getJavaClass();
        int modifiers = javaClass.getModifiers();
        ClassLoader hubClassLoader = javaClass.getClassLoader();
        String className = type.toClassName().intern();
        String sourceFileName = this.stringTable.deduplicate(type.getSourceFileName(), true);
        String simpleBinaryName = this.stringTable.deduplicate(this.getSimpleBinaryName(javaClass), true);
        Class<?> nestHost = javaClass.getNestHost();
        boolean isHidden = SubstrateUtil.isHiddenClass(javaClass);
        boolean isRecord = RecordSupport.singleton().isRecord(javaClass);
        boolean assertionStatus = RuntimeAssertionsSupport.singleton().desiredAssertionStatus(javaClass);
        boolean isSealed = SealedClassSupport.singleton().isSealed(javaClass);
        boolean isVMInternal = type.isAnnotationPresent(InternalVMMethod.class);
        boolean isLambdaFormHidden = type.isAnnotationPresent(LambdaFormHiddenMethod.class);
        DynamicHub dynamicHub = new DynamicHub(javaClass, className, SVMHost.computeHubType(type), SVMHost.computeReferenceType(type), superHub, componentHub, sourceFileName, modifiers, hubClassLoader, isHidden, isRecord, nestHost, assertionStatus, type.hasDefaultMethods(), type.declaresDefaultMethods(), isSealed, isVMInternal, isLambdaFormHidden, simpleBinaryName, this.getDeclaringClass(javaClass));
        ModuleAccess.extractAndSetModule(dynamicHub, javaClass);
        return dynamicHub;
    }

    private Object getDeclaringClass(Class<?> javaClass) {
        try {
            return this.getDeclaringClass0.invoke(javaClass, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof LinkageError) {
                if (cause instanceof IncompatibleClassChangeError) {
                    return cause;
                }
                return this.handleLinkageError(javaClass, this.getDeclaringClass0.getName(), (LinkageError)cause);
            }
            throw VMError.shouldNotReachHere(e);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private LinkageError handleLinkageError(Class<?> javaClass, String methodName, LinkageError linkageError) {
        if (!this.linkAtBuildTimeSupport.linkAtBuildTime(javaClass)) {
            return linkageError;
        }
        String message = "Discovered a type for which " + methodName + " cannot be called: " + javaClass.getTypeName() + ". " + this.linkAtBuildTimeSupport.errorMessageFor(javaClass);
        throw new UnsupportedFeatureException(message, (Throwable)linkageError);
    }

    private String getSimpleBinaryName(Class<?> javaClass) {
        try {
            return (String)this.getSimpleBinaryName0.invoke(javaClass, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public static boolean isUnknownClass(ResolvedJavaType resolvedJavaType) {
        return resolvedJavaType.getAnnotation(UnknownClass.class) != null;
    }

    public static boolean isUnknownObjectField(ResolvedJavaField resolvedJavaField) {
        return resolvedJavaField.getAnnotation(UnknownObjectField.class) != null;
    }

    public static boolean isUnknownPrimitiveField(AnalysisField field) {
        return field.getAnnotation(UnknownPrimitiveField.class) != null;
    }

    public ClassInitializationSupport getClassInitializationSupport() {
        return this.classInitializationSupport;
    }

    public UnsafeAutomaticSubstitutionProcessor getAutomaticSubstitutionProcessor() {
        return this.automaticSubstitutions;
    }

    private static int computeHubType(AnalysisType type) {
        if (type.isArray()) {
            if (type.getComponentType().isPrimitive() || type.getComponentType().isWordType()) {
                return 5;
            }
            return 6;
        }
        if (type.isInstanceClass()) {
            if (Reference.class.isAssignableFrom(type.getJavaClass())) {
                return 1;
            }
            if (PodSupport.isPresent() && PodSupport.singleton().isPodClass(type.getJavaClass())) {
                return 2;
            }
            if (Continuation.isSupported() && type.getJavaClass() == StoredContinuation.class) {
                return 3;
            }
            assert (!Target_java_lang_ref_Reference.class.isAssignableFrom(type.getJavaClass())) : "should not see substitution type here";
            return 0;
        }
        return 4;
    }

    private static ReferenceType computeReferenceType(AnalysisType type) {
        Class clazz = type.getJavaClass();
        if (PhantomReference.class.isAssignableFrom(clazz)) {
            return ReferenceType.Phantom;
        }
        if (WeakReference.class.isAssignableFrom(clazz)) {
            return ReferenceType.Weak;
        }
        if (SoftReference.class.isAssignableFrom(clazz)) {
            return ReferenceType.Soft;
        }
        if (Reference.class.isAssignableFrom(clazz)) {
            return ReferenceType.Other;
        }
        return ReferenceType.None;
    }

    public void checkType(ResolvedJavaType type, AnalysisUniverse universe) {
        Class originalClass = OriginalClassProvider.getJavaClass((ResolvedJavaType)type);
        ClassLoader originalClassLoader = originalClass.getClassLoader();
        if (NativeImageSystemClassLoader.singleton().isDisallowedClassLoader(originalClassLoader)) {
            String message = "Class " + originalClass.getName() + " was loaded by " + String.valueOf(originalClassLoader) + " and not by the current image class loader " + String.valueOf(this.classLoader) + ". ";
            message = message + "This usually means that some objects from a previous build leaked in the current build. ";
            message = message + "This can happen when using the image build server. ";
            message = message + "To fix the issue you must reset all static state from the bootclasspath and application classpath that points to the application objects. ";
            message = message + "If the offending code is in JDK code please file a bug with GraalVM. ";
            throw new UnsupportedFeatureException(message);
        }
    }

    protected boolean deoptsForbidden(AnalysisMethod method) {
        return method.getMultiMethodKey() != SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD;
    }

    public void methodAfterParsingHook(BigBang bb, AnalysisMethod method, StructuredGraph graph) {
        if (graph != null) {
            if (this.deoptsForbidden(method)) {
                graph.getGraphState().configureExplicitExceptionsNoDeoptIfNecessary();
            }
            if (this.parseOnce) {
                new ImplicitAssertionsPhase().apply(graph, this.getProviders(method.getMultiMethodKey()));
                UninterruptibleAnnotationChecker.checkAfterParsing((ResolvedJavaMethod)method, graph);
                this.optimizeAfterParsing(bb, method, graph);
                CanonicalizerPhase.create().apply(graph, (Object)this.getProviders(method.getMultiMethodKey()));
            }
            super.methodAfterParsingHook(bb, method, graph);
        }
    }

    protected void optimizeAfterParsing(BigBang bb, AnalysisMethod method, StructuredGraph graph) {
        if (((Boolean)PointstoOptions.EscapeAnalysisBeforeAnalysis.getValue(bb.getOptions())).booleanValue() && method.isOriginalMethod()) {
            new BoxNodeIdentityPhase().apply(graph, (Object)this.getProviders(method.getMultiMethodKey()));
            new PartialEscapePhase(false, false, CanonicalizerPhase.create(), null, this.options).apply(graph, (Object)this.getProviders(method.getMultiMethodKey()));
        }
    }

    public void methodBeforeTypeFlowCreationHook(BigBang bb, AnalysisMethod method, StructuredGraph graph) {
        Object node;
        ValueNode receiver;
        if (method.isEntryPoint() && !Modifier.isStatic(graph.method().getModifiers()) && (receiver = graph.start().stateAfter().localAt(0)) != null && receiver.hasUsages()) {
            bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, "Entry point is non-static and uses its receiver: " + method.format("%r %H.%n(%p)"));
        }
        if (!NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            for (Node n : graph.getNodes()) {
                if (!(n instanceof StaticDeoptimizingNode) || (node = (StaticDeoptimizingNode)n).getReason() != DeoptimizationReason.JavaSubroutineMismatch) continue;
                bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, "The bytecodes of the method " + method.format("%H.%n(%p)") + " contain a JSR/RET structure that could not be simplified by the compiler. The JSR bytecode is unused and deprecated since Java 6. Please recompile your application with a newer Java compiler." + System.lineSeparator() + "To diagnose the issue, you can add the option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportUnsupportedElementsAtRuntime, "+") + ". The error is then reported at run time when the JSR/RET is executed.");
            }
        }
        if (this.analysisGraphs != null) {
            this.analysisGraphs.put(method, graph);
        }
        if (InliningUtilities.isTrivialMethod(graph)) {
            this.analysisTrivialMethods.put(method, true);
        }
        for (Node n : graph.getNodes()) {
            if (n instanceof StackValueNode) {
                this.containsStackValueNode.put(method, true);
            } else if (n instanceof ReachabilityRegistrationNode) {
                node = (ReachabilityRegistrationNode)n;
                bb.postTask(arg_0 -> SVMHost.lambda$methodBeforeTypeFlowCreationHook$0((ReachabilityRegistrationNode)((Object)node), arg_0));
            }
            this.checkClassInitializerSideEffect(method, n);
        }
    }

    private void checkClassInitializerSideEffect(AnalysisMethod method, Node n) {
        if (n instanceof AccessFieldNode) {
            ResolvedJavaField field = ((AccessFieldNode)n).field();
            if (!(!field.isStatic() || method.isClassInitializer() && field.getDeclaringClass().equals(method.getDeclaringClass()))) {
                this.classInitializerSideEffect.put(method, true);
            }
        } else if (n instanceof UnsafeAccessNode || n instanceof VMThreadLocalAccess) {
            this.classInitializerSideEffect.put(method, true);
        } else if (n instanceof EnsureClassInitializedNode) {
            ResolvedJavaType type = ((EnsureClassInitializedNode)n).constantTypeOrNull((CoreProviders)this.getProviders(method.getMultiMethodKey()));
            if (type != null) {
                this.initializedClasses.computeIfAbsent(method, k -> new HashSet()).add((AnalysisType)type);
            } else {
                this.classInitializerSideEffect.put(method, true);
            }
        }
    }

    public void keepAnalysisGraphs() {
        if (this.analysisGraphs == null) {
            this.analysisGraphs = new ConcurrentHashMap<AnalysisMethod, StructuredGraph>();
        }
    }

    public StructuredGraph getAnalysisGraph(AnalysisMethod method) {
        VMError.guarantee(this.analysisGraphs != null, "Keeping of analysis graphs must be enabled manually");
        return (StructuredGraph)this.analysisGraphs.get(method);
    }

    public boolean containsStackValueNode(AnalysisMethod method) {
        return this.containsStackValueNode.containsKey(method);
    }

    public boolean hasClassInitializerSideEffect(AnalysisMethod method) {
        return this.classInitializerSideEffect.containsKey(method);
    }

    public Set<AnalysisType> getInitializedClasses(AnalysisMethod method) {
        Set result = (Set)this.initializedClasses.get(method);
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    public boolean isAnalysisTrivialMethod(AnalysisMethod method) {
        return this.analysisTrivialMethods.containsKey(method);
    }

    public boolean hasNeverInlineDirective(ResolvedJavaMethod method) {
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, NeverInline.class)) {
            return true;
        }
        if (!SubstrateOptions.NeverInline.hasBeenSet()) {
            return false;
        }
        return SubstrateOptions.NeverInline.getValue().values().stream().anyMatch(re -> MethodFilter.parse((String)re).matches((JavaMethod)method));
    }

    public InlineBeforeAnalysisPolicy<?> inlineBeforeAnalysisPolicy(MultiMethod.MultiMethodKey multiMethodKey) {
        if (multiMethodKey == MultiMethod.ORIGINAL_METHOD) {
            return this.inlineBeforeAnalysisPolicy;
        }
        return InlineBeforeAnalysisPolicy.NO_INLINING;
    }

    public boolean skipInterface(AnalysisUniverse universe, ResolvedJavaType interfaceType, ResolvedJavaType implementingType) {
        if (!this.platformSupported((AnnotatedElement)interfaceType)) {
            String message = "The interface " + interfaceType.toJavaName(true) + " is not available in the current platform, but used by " + implementingType.toJavaName(true) + ". GraalVM before version 21.2 ignored such interfaces, but this was an oversight.";
            String commandArgument = SubstrateOptionsParser.commandArgument(Options.PlatformInterfaceCompatibilityMode, "+");
            if (Options.PlatformInterfaceCompatibilityMode.getValue().booleanValue()) {
                System.out.println("Warning: " + message + " The interface is filtered because the compatibility option " + commandArgument + " is used. This option will be removed in a future GraalVM version.");
                return true;
            }
            throw new UnsupportedFeatureException(message + " The old behavior can be temporarily restored using the option " + commandArgument + ". This option will be removed in a future GraalVM version.");
        }
        return false;
    }

    public boolean platformSupported(AnnotatedElement element) {
        Package p;
        if (element instanceof ResolvedJavaType) {
            ResolvedJavaType enclosingType;
            ResolvedJavaType javaType = (ResolvedJavaType)element;
            p = OriginalClassProvider.getJavaClass((ResolvedJavaType)javaType).getPackage();
            if (p != null && !this.platformSupported(p)) {
                return false;
            }
            try {
                enclosingType = javaType.getEnclosingType();
            }
            catch (LinkageError e) {
                enclosingType = null;
            }
            if (enclosingType != null && !this.platformSupported((AnnotatedElement)enclosingType)) {
                return false;
            }
        }
        if (element instanceof Class) {
            Class<?> enclosingClass;
            Class clazz = (Class)element;
            p = clazz.getPackage();
            if (p != null && !this.platformSupported(p)) {
                return false;
            }
            try {
                enclosingClass = clazz.getEnclosingClass();
            }
            catch (LinkageError e) {
                enclosingClass = null;
            }
            if (enclosingClass != null && !this.platformSupported(enclosingClass)) {
                return false;
            }
        }
        Platforms platformsAnnotation = (Platforms)AnnotationAccess.getAnnotation((AnnotatedElement)element, Platforms.class);
        if (this.platform == null || platformsAnnotation == null) {
            return true;
        }
        for (Class platformGroup : platformsAnnotation.value()) {
            if (!platformGroup.isInstance(this.platform)) continue;
            return true;
        }
        return false;
    }

    public void registerNeverInlineTrivialHandler(BiPredicate<AnalysisMethod, AnalysisMethod> handler) {
        this.neverInlineTrivialHandlers.add(handler);
    }

    public boolean neverInlineTrivial(AnalysisMethod caller, AnalysisMethod callee) {
        if (!callee.canBeInlined() || AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, NeverInlineTrivial.class)) {
            return true;
        }
        for (BiPredicate<AnalysisMethod, AnalysisMethod> handler : this.neverInlineTrivialHandlers) {
            if (!handler.test(caller, callee)) continue;
            return true;
        }
        return false;
    }

    public Comparator<? super ResolvedJavaType> getTypeComparator() {
        return (o1, o2) -> HostedUniverse.TYPE_COMPARATOR.compare((HostedType)o1, (HostedType)o2);
    }

    public void recordFieldStore(ResolvedJavaField field, ResolvedJavaMethod method) {
        if (!(field.isStatic() || !field.isFinal() || method.isConstructor() && field.getDeclaringClass().equals(method.getDeclaringClass()))) {
            AnalysisField aField = field instanceof HostedField ? ((HostedField)field).getWrapped() : (AnalysisField)field;
            this.finalFieldsInitializedOutsideOfConstructor.add(aField);
        }
    }

    public boolean allowConstantFolding(ResolvedJavaField field) {
        AnalysisField aField = field instanceof HostedField ? ((HostedField)field).getWrapped() : (AnalysisField)field;
        return !this.finalFieldsInitializedOutsideOfConstructor.contains(aField);
    }

    public Object parseGraph(BigBang bb, DebugContext debug, AnalysisMethod method) {
        if (this.parsingSupport != null) {
            return this.parsingSupport.parseGraph(bb, debug, method);
        }
        return super.parseGraph(bb, debug, method);
    }

    public boolean validateGraph(PointsToAnalysis bb, StructuredGraph graph) {
        if (this.parsingSupport != null) {
            return this.parsingSupport.validateGraph(bb, graph);
        }
        return super.validateGraph(bb, graph);
    }

    public StructuredGraph.AllowAssumptions allowAssumptions(AnalysisMethod method) {
        if (this.parsingSupport != null && this.parsingSupport.allowAssumptions(method)) {
            return StructuredGraph.AllowAssumptions.YES;
        }
        return super.allowAssumptions(method);
    }

    public HostedProviders getProviders(MultiMethod.MultiMethodKey key) {
        HostedProviders providers;
        if (this.parsingSupport != null && (providers = this.parsingSupport.getHostedProviders(key)) != null) {
            return providers;
        }
        return super.getProviders(key);
    }

    public HostVM.MultiMethodAnalysisPolicy getMultiMethodAnalysisPolicy() {
        return this.multiMethodAnalysisPolicy;
    }

    public boolean ignoreInstanceOfTypeDisallowed() {
        if (ClassInitializationOptions.AllowDeprecatedInitializeAllClassesAtBuildTime.getValue().booleanValue()) {
            return true;
        }
        return super.ignoreInstanceOfTypeDisallowed();
    }

    private static /* synthetic */ void lambda$methodBeforeTypeFlowCreationHook$0(ReachabilityRegistrationNode node, DebugContext debug) {
        node.getRegistrationTask().ensureDone();
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PlatformInterfaceCompatibilityMode = new HostedOptionKey<Boolean>(false);
    }
}

