/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationSubstitutionField;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionMethod;
import com.oracle.svm.hosted.annotation.AnnotationSupport;
import com.oracle.svm.hosted.annotation.CustomSubstitutionType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public class AnnotationSubstitutionType
extends CustomSubstitutionType<AnnotationSubstitutionField, AnnotationSubstitutionMethod> {
    private final String name;
    private final MetaAccessProvider metaAccess;
    private final ResolvedJavaType annotationInterfaceType;

    public AnnotationSubstitutionType(MetaAccessProvider metaAccess, ResolvedJavaType original) {
        super(original);
        this.metaAccess = metaAccess;
        assert (original.getSuperclass().equals(metaAccess.lookupJavaType(Proxy.class)));
        assert (metaAccess.lookupJavaType(Annotation.class).isAssignableFrom(original));
        this.annotationInterfaceType = AnnotationSupport.findAnnotationInterfaceTypeForMarkedAnnotationType(original, metaAccess);
        assert (this.annotationInterfaceType.isAssignableFrom(original));
        assert (metaAccess.lookupJavaType(Annotation.class).isAssignableFrom(this.annotationInterfaceType));
        String n = this.annotationInterfaceType.getName();
        assert (n.endsWith(";"));
        this.name = n.substring(0, n.length() - 1) + "$$ProxyImpl;";
    }

    @Override
    public ResolvedJavaType[] getInterfaces() {
        ResolvedJavaType[] interfaces = super.getInterfaces();
        return (ResolvedJavaType[])Arrays.stream(interfaces).filter(t -> !AnnotationSupport.isAnnotationMarkerInterface(t, this.metaAccess)).toArray(ResolvedJavaType[]::new);
    }

    public String getName() {
        return this.name;
    }

    public ResolvedJavaType getAnnotationInterfaceType() {
        return this.annotationInterfaceType;
    }

    public String toString() {
        return "AnnotationType<" + this.toJavaName(true) + " -> " + String.valueOf(this.original) + ">";
    }
}

