/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMemoryAccessProvider;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.function.ObjIntConsumer;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class HostedConstantReflectionProvider
extends SharedConstantReflectionProvider {
    private final SVMHost hostVM;
    private final HostedUniverse universe;
    private final UniverseMetaAccess metaAccess;
    private final HostedMemoryAccessProvider memoryAccess;

    public HostedConstantReflectionProvider(SVMHost hostVM, HostedUniverse universe, UniverseMetaAccess metaAccess, HostedMemoryAccessProvider memoryAccess) {
        this.hostVM = hostVM;
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.memoryAccess = memoryAccess;
    }

    public MemoryAccessProvider getMemoryAccessProvider() {
        return this.memoryAccess;
    }

    public ResolvedJavaType asJavaType(Constant constant) {
        if (constant instanceof SubstrateObjectConstant) {
            Object obj = SubstrateObjectConstant.asObject(constant);
            if (obj instanceof DynamicHub) {
                return this.universe.lookup((JavaType)this.hostVM.lookupType((DynamicHub)obj));
            }
            if (obj instanceof Class) {
                throw VMError.shouldNotReachHere("Must not have java.lang.Class object: " + String.valueOf(obj));
            }
        }
        if (constant instanceof ImageHeapConstant && this.metaAccess.isInstanceOf((JavaConstant)constant, Class.class)) {
            throw VMError.shouldNotReachHere("ConstantReflectionProvider.asJavaType(Constant) not yet implemented for ImageHeapObject");
        }
        return null;
    }

    public JavaConstant asJavaClass(ResolvedJavaType type) {
        return SubstrateObjectConstant.forObject(this.hostVM.dynamicHub((ResolvedJavaType)((HostedType)type).wrapped));
    }

    @Override
    public Integer readArrayLength(JavaConstant array) {
        return this.universe.getConstantReflectionProvider().readArrayLength(array);
    }

    @Override
    public JavaConstant readArrayElement(JavaConstant array, int index) {
        return this.universe.getConstantReflectionProvider().readArrayElement(array, index);
    }

    @Override
    public void forEachArrayElement(JavaConstant array, ObjIntConsumer<JavaConstant> consumer) {
        this.universe.getConstantReflectionProvider().forEachArrayElement(array, consumer);
    }

    public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        return ((HostedField)field).readValue(receiver);
    }
}

