/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.phases.NoClassInitializationPlugin;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializerGraphBuilderPhase;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.ComputedValue;
import com.oracle.svm.hosted.substitute.ComputedValueField;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.ConstantFoldUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;

public class UnsafeAutomaticSubstitutionProcessor
extends SubstitutionProcessor {
    private static final int BASIC_LEVEL = 1;
    private static final int INFO_LEVEL = 2;
    private static final int DEBUG_LEVEL = 3;
    private final AnnotationSubstitutionProcessor annotationSubstitutions;
    private final Map<ResolvedJavaField, ComputedValueField> fieldSubstitutions;
    private final List<ResolvedJavaType> suppressWarnings;
    private static ResolvedJavaType resolvedUnsafeClass;
    private static ResolvedJavaType resolvedSunMiscUnsafeClass;
    private ResolvedJavaMethod unsafeStaticFieldOffsetMethod;
    private ResolvedJavaMethod unsafeStaticFieldBaseMethod;
    private ResolvedJavaMethod unsafeObjectFieldOffsetFieldMethod;
    private ResolvedJavaMethod sunMiscUnsafeObjectFieldOffsetMethod;
    private ResolvedJavaMethod unsafeObjectFieldOffsetClassStringMethod;
    private ResolvedJavaMethod unsafeArrayBaseOffsetMethod;
    private ResolvedJavaMethod unsafeArrayIndexScaleMethod;
    private ResolvedJavaMethod integerNumberOfLeadingZerosMethod;
    private HashSet<ResolvedJavaMethod> neverInlineSet = new HashSet();
    private HashSet<ResolvedJavaMethod> noCheckedExceptionsSet = new HashSet();
    private GraphBuilderConfiguration.Plugins plugins;
    private final OptionValues options;
    private final SnippetReflectionProvider snippetReflection;

    public UnsafeAutomaticSubstitutionProcessor(OptionValues options, AnnotationSubstitutionProcessor annotationSubstitutions, SnippetReflectionProvider snippetReflection) {
        this.options = options;
        this.snippetReflection = snippetReflection;
        this.annotationSubstitutions = annotationSubstitutions;
        this.fieldSubstitutions = new ConcurrentHashMap<ResolvedJavaField, ComputedValueField>();
        this.suppressWarnings = new ArrayList<ResolvedJavaType>();
    }

    public void init(ImageClassLoader loader, MetaAccessProvider originalMetaAccess) {
        try {
            Class<?> unsafeClass;
            Class<?> sunMiscUnsafeClass;
            Method fieldSetAccessible = Field.class.getMethod("setAccessible", Boolean.TYPE);
            ResolvedJavaMethod fieldSetAccessibleMethod = originalMetaAccess.lookupJavaMethod((Executable)fieldSetAccessible);
            this.neverInlineSet.add(fieldSetAccessibleMethod);
            Method fieldGet = Field.class.getMethod("get", Object.class);
            ResolvedJavaMethod fieldGetMethod = originalMetaAccess.lookupJavaMethod((Executable)fieldGet);
            this.neverInlineSet.add(fieldGetMethod);
            for (Method method : loader.findClassOrFail("java.lang.invoke.VarHandles").getDeclaredMethods()) {
                this.neverInlineSet.add(originalMetaAccess.lookupJavaMethod((Executable)method));
            }
            try {
                sunMiscUnsafeClass = Class.forName("sun.misc.Unsafe");
                unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
            }
            catch (ClassNotFoundException cnfe) {
                throw VMError.shouldNotReachHere(cnfe);
            }
            resolvedUnsafeClass = originalMetaAccess.lookupJavaType(unsafeClass);
            resolvedSunMiscUnsafeClass = originalMetaAccess.lookupJavaType(sunMiscUnsafeClass);
            Method unsafeStaticFieldOffset = unsafeClass.getMethod("staticFieldOffset", Field.class);
            this.unsafeStaticFieldOffsetMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeStaticFieldOffset);
            this.noCheckedExceptionsSet.add(this.unsafeStaticFieldOffsetMethod);
            this.neverInlineSet.add(this.unsafeStaticFieldOffsetMethod);
            Method unsafeStaticFieldBase = unsafeClass.getMethod("staticFieldBase", Field.class);
            this.unsafeStaticFieldBaseMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeStaticFieldBase);
            this.noCheckedExceptionsSet.add(this.unsafeStaticFieldBaseMethod);
            this.neverInlineSet.add(this.unsafeStaticFieldBaseMethod);
            Method unsafeObjectFieldOffset = unsafeClass.getMethod("objectFieldOffset", Field.class);
            this.unsafeObjectFieldOffsetFieldMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeObjectFieldOffset);
            this.noCheckedExceptionsSet.add(this.unsafeObjectFieldOffsetFieldMethod);
            this.neverInlineSet.add(this.unsafeObjectFieldOffsetFieldMethod);
            Method unsafeObjectClassStringOffset = unsafeClass.getMethod("objectFieldOffset", Class.class, String.class);
            this.unsafeObjectFieldOffsetClassStringMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeObjectClassStringOffset);
            this.noCheckedExceptionsSet.add(this.unsafeObjectFieldOffsetClassStringMethod);
            this.neverInlineSet.add(this.unsafeObjectFieldOffsetClassStringMethod);
            if (JavaVersionUtil.JAVA_SPEC >= 17) {
                Method sunMiscUnsafeObjectFieldOffset = sunMiscUnsafeClass.getMethod("objectFieldOffset", Field.class);
                this.sunMiscUnsafeObjectFieldOffsetMethod = originalMetaAccess.lookupJavaMethod((Executable)sunMiscUnsafeObjectFieldOffset);
                this.noCheckedExceptionsSet.add(this.sunMiscUnsafeObjectFieldOffsetMethod);
                this.neverInlineSet.add(this.sunMiscUnsafeObjectFieldOffsetMethod);
            }
            Method unsafeArrayBaseOffset = unsafeClass.getMethod("arrayBaseOffset", Class.class);
            this.unsafeArrayBaseOffsetMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeArrayBaseOffset);
            this.noCheckedExceptionsSet.add(this.unsafeArrayBaseOffsetMethod);
            this.neverInlineSet.add(this.unsafeArrayBaseOffsetMethod);
            Method unsafeArrayIndexScale = unsafeClass.getMethod("arrayIndexScale", Class.class);
            this.unsafeArrayIndexScaleMethod = originalMetaAccess.lookupJavaMethod((Executable)unsafeArrayIndexScale);
            this.noCheckedExceptionsSet.add(this.unsafeArrayIndexScaleMethod);
            this.neverInlineSet.add(this.unsafeArrayIndexScaleMethod);
            Method integerNumberOfLeadingZeros = Integer.class.getMethod("numberOfLeadingZeros", Integer.TYPE);
            this.integerNumberOfLeadingZerosMethod = originalMetaAccess.lookupJavaMethod((Executable)integerNumberOfLeadingZeros);
            this.neverInlineSet.add(this.integerNumberOfLeadingZerosMethod);
            Method atomicIntegerFieldUpdaterNewUpdater = AtomicIntegerFieldUpdater.class.getMethod("newUpdater", Class.class, String.class);
            ResolvedJavaMethod atomicIntegerFieldUpdaterNewUpdaterMethod = originalMetaAccess.lookupJavaMethod((Executable)atomicIntegerFieldUpdaterNewUpdater);
            this.neverInlineSet.add(atomicIntegerFieldUpdaterNewUpdaterMethod);
            Method atomicLongFieldUpdaterNewUpdater = AtomicLongFieldUpdater.class.getMethod("newUpdater", Class.class, String.class);
            ResolvedJavaMethod atomicLongFieldUpdaterNewUpdaterMethod = originalMetaAccess.lookupJavaMethod((Executable)atomicLongFieldUpdaterNewUpdater);
            this.neverInlineSet.add(atomicLongFieldUpdaterNewUpdaterMethod);
            Method atomicReferenceFieldUpdaterNewUpdater = AtomicReferenceFieldUpdater.class.getMethod("newUpdater", Class.class, Class.class, String.class);
            ResolvedJavaMethod atomicReferenceFieldUpdaterNewUpdaterMethod = originalMetaAccess.lookupJavaMethod((Executable)atomicReferenceFieldUpdaterNewUpdater);
            this.neverInlineSet.add(atomicReferenceFieldUpdaterNewUpdaterMethod);
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
        StaticInitializerInlineInvokePlugin inlineInvokePlugin = new StaticInitializerInlineInvokePlugin(this.neverInlineSet);
        this.plugins = new GraphBuilderConfiguration.Plugins(new InvocationPlugins());
        this.plugins.appendInlineInvokePlugin((InlineInvokePlugin)inlineInvokePlugin);
        NoClassInitializationPlugin classInitializationPlugin = new NoClassInitializationPlugin();
        this.plugins.setClassInitializationPlugin((ClassInitializationPlugin)classInitializationPlugin);
        FallbackFeature fallbackFeature = ImageSingletons.contains(FallbackFeature.class) ? (FallbackFeature)ImageSingletons.lookup(FallbackFeature.class) : null;
        ReflectionPlugins.registerInvocationPlugins(loader, this.snippetReflection, this.annotationSubstitutions, (ClassInitializationPlugin)classInitializationPlugin, this.plugins.getInvocationPlugins(), null, ParsingReason.UnsafeSubstitutionAnalysis, fallbackFeature);
        try {
            this.suppressWarnings.add(originalMetaAccess.lookupJavaType(Class.forName("sun.security.provider.ByteArrayAccess")));
        }
        catch (ClassNotFoundException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    void processComputedValueFields(FeatureImpl.DuringAnalysisAccessImpl access) {
        for (ResolvedJavaField resolvedJavaField : this.fieldSubstitutions.values()) {
            if (!(resolvedJavaField instanceof ComputedValue)) continue;
            ComputedValue cvField = (ComputedValue)resolvedJavaField;
            switch (cvField.getRecomputeValueKind()) {
                case FieldOffset: {
                    Field targetField = cvField.getTargetField();
                    if (!access.registerAsUnsafeAccessed(access.getMetaAccess().lookupJavaField(targetField), cvField)) break;
                    access.requireAnalysisIteration();
                }
            }
        }
    }

    private void addSubstitutionField(ResolvedJavaField original, ComputedValueField substitution) {
        assert (substitution != null);
        assert (!this.fieldSubstitutions.containsKey(original));
        this.fieldSubstitutions.put(original, substitution);
    }

    public ResolvedJavaField lookup(ResolvedJavaField field) {
        if (this.fieldSubstitutions.containsKey(field)) {
            return this.fieldSubstitutions.get(field);
        }
        return field;
    }

    public void computeSubstitutions(SVMHost hostVM, ResolvedJavaType hostType) {
        if (hostType.isArray()) {
            return;
        }
        if (hostVM.getClassInitializationSupport().shouldInitializeAtRuntime(hostType)) {
            return;
        }
        if (this.annotationSubstitutions.findSubstitution(hostType).isPresent()) {
            UnsafeAutomaticSubstitutionProcessor.reportSkippedSubstitution(hostType);
            return;
        }
        ResolvedJavaMethod clinit = hostType.getClassInitializer();
        if (clinit != null && clinit.hasBytecodes()) {
            DebugContext debug = new DebugContext.Builder(this.options).build();
            try (DebugContext.Scope s = debug.scope((Object)"Field offset computation", (Object)clinit);){
                StructuredGraph clinitGraph = this.getStaticInitializerGraph(clinit, debug);
                for (Invoke invoke : clinitGraph.getInvokes()) {
                    if (!(invoke.callTarget() instanceof MethodCallTargetNode)) continue;
                    if (UnsafeAutomaticSubstitutionProcessor.isInvokeTo(invoke, this.unsafeStaticFieldBaseMethod)) {
                        this.processUnsafeFieldComputation(hostType, invoke, RecomputeFieldValue.Kind.StaticFieldBase);
                        continue;
                    }
                    if (UnsafeAutomaticSubstitutionProcessor.isInvokeTo(invoke, this.unsafeObjectFieldOffsetFieldMethod) || UnsafeAutomaticSubstitutionProcessor.isInvokeTo(invoke, this.sunMiscUnsafeObjectFieldOffsetMethod) || UnsafeAutomaticSubstitutionProcessor.isInvokeTo(invoke, this.unsafeStaticFieldOffsetMethod)) {
                        this.processUnsafeFieldComputation(hostType, invoke, RecomputeFieldValue.Kind.FieldOffset);
                        continue;
                    }
                    if (UnsafeAutomaticSubstitutionProcessor.isInvokeTo(invoke, this.unsafeObjectFieldOffsetClassStringMethod)) {
                        this.processUnsafeObjectFieldOffsetClassStringInvoke(hostType, invoke);
                        continue;
                    }
                    if (UnsafeAutomaticSubstitutionProcessor.isInvokeTo(invoke, this.unsafeArrayBaseOffsetMethod)) {
                        this.processUnsafeArrayBaseOffsetInvoke(hostType, invoke);
                        continue;
                    }
                    if (!UnsafeAutomaticSubstitutionProcessor.isInvokeTo(invoke, this.unsafeArrayIndexScaleMethod)) continue;
                    this.processUnsafeArrayIndexScaleInvoke(hostType, invoke, clinitGraph);
                }
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
    }

    private void processUnsafeFieldComputation(ResolvedJavaType type, Invoke invoke, RecomputeFieldValue.Kind kind) {
        ArrayList<Supplier<String>> unsuccessfulReasons = new ArrayList<Supplier<String>>();
        Class<?> targetFieldHolder = null;
        String targetFieldName = null;
        String methodFormat = invoke.callTarget().targetMethod().format("%H.%n(%P)");
        ValueNode fieldArgumentNode = (ValueNode)invoke.callTarget().arguments().get(1);
        JavaConstant fieldArgument = this.nodeAsConstant(fieldArgumentNode);
        if (fieldArgument != null) {
            Field targetField = (Field)this.snippetReflection.asObject(Field.class, fieldArgument);
            if (this.isValidField(invoke, targetField, unsuccessfulReasons, methodFormat)) {
                targetFieldHolder = targetField.getDeclaringClass();
                targetFieldName = targetField.getName();
            }
        } else {
            unsuccessfulReasons.add(() -> "The argument of " + methodFormat + " is not a constant value or a field load that can be constant-folded.");
        }
        this.processUnsafeFieldComputation(type, invoke, kind, unsuccessfulReasons, targetFieldHolder, targetFieldName);
    }

    private JavaConstant nodeAsConstant(ValueNode node) {
        if (node.isConstant()) {
            return node.asJavaConstant();
        }
        if (node instanceof LoadFieldNode) {
            Providers p;
            ConstantNode result;
            ValueNode receiverNode;
            LoadFieldNode loadFieldNode = (LoadFieldNode)node;
            ResolvedJavaField field = loadFieldNode.field();
            JavaConstant receiver = null;
            if (!field.isStatic() && (receiverNode = loadFieldNode.object()).isConstant()) {
                receiver = receiverNode.asJavaConstant();
            }
            if ((result = ConstantFoldUtil.tryConstantFold((ConstantFieldProvider)(p = GraalAccess.getOriginalProviders()).getConstantFieldProvider(), (ConstantReflectionProvider)p.getConstantReflection(), (MetaAccessProvider)p.getMetaAccess(), (ResolvedJavaField)field, (JavaConstant)receiver, (OptionValues)this.options, (Object)loadFieldNode.getNodeSourcePosition())) != null) {
                return result.asJavaConstant();
            }
        }
        return null;
    }

    private boolean isValidField(Invoke invoke, Field field, List<Supplier<String>> unsuccessfulReasons, String methodFormat) {
        if (field == null) {
            unsuccessfulReasons.add(() -> "The argument of " + methodFormat + " is a null constant.");
            return false;
        }
        boolean valid = true;
        if (JavaVersionUtil.JAVA_SPEC >= 17 && UnsafeAutomaticSubstitutionProcessor.isInvokeTo(invoke, this.sunMiscUnsafeObjectFieldOffsetMethod)) {
            Class<?> declaringClass = field.getDeclaringClass();
            if (RecordSupport.singleton().isRecord(declaringClass)) {
                unsuccessfulReasons.add(() -> "The argument to " + methodFormat + " is a field of a record.");
                valid = false;
            }
            if (SubstrateUtil.isHiddenClass(declaringClass)) {
                unsuccessfulReasons.add(() -> "The argument to " + methodFormat + " is a field of a hidden class.");
                valid = false;
            }
        }
        return valid;
    }

    private void processUnsafeObjectFieldOffsetClassStringInvoke(ResolvedJavaType type, Invoke unsafeObjectFieldOffsetInvoke) {
        ArrayList<Supplier<String>> unsuccessfulReasons = new ArrayList<Supplier<String>>();
        Class targetFieldHolder = null;
        String targetFieldName = null;
        ValueNode classArgument = (ValueNode)unsafeObjectFieldOffsetInvoke.callTarget().arguments().get(1);
        if (classArgument.isConstant()) {
            Class clazz = (Class)this.snippetReflection.asObject(Class.class, classArgument.asJavaConstant());
            if (clazz == null) {
                unsuccessfulReasons.add(() -> "The Class argument of Unsafe.objectFieldOffset(Class, String) is a null constant.");
            } else {
                targetFieldHolder = clazz;
            }
        } else {
            unsuccessfulReasons.add(() -> "The Class argument of Unsafe.objectFieldOffset(Class, String) is not a constant class.");
        }
        ValueNode nameArgument = (ValueNode)unsafeObjectFieldOffsetInvoke.callTarget().arguments().get(2);
        if (nameArgument.isConstant()) {
            String fieldName = (String)this.snippetReflection.asObject(String.class, nameArgument.asJavaConstant());
            if (fieldName == null) {
                unsuccessfulReasons.add(() -> "The String argument of Unsafe.objectFieldOffset(Class, String) is a null String.");
            } else {
                targetFieldName = fieldName;
            }
        } else {
            unsuccessfulReasons.add(() -> "The name argument of Unsafe.objectFieldOffset(Class, String) is not a constant String.");
        }
        this.processUnsafeFieldComputation(type, unsafeObjectFieldOffsetInvoke, RecomputeFieldValue.Kind.FieldOffset, unsuccessfulReasons, targetFieldHolder, targetFieldName);
    }

    private void processUnsafeFieldComputation(ResolvedJavaType type, Invoke invoke, RecomputeFieldValue.Kind kind, List<Supplier<String>> unsuccessfulReasons, Class<?> targetFieldHolder, String targetFieldName) {
        assert (kind == RecomputeFieldValue.Kind.FieldOffset || kind == RecomputeFieldValue.Kind.StaticFieldBase);
        SearchResult result = UnsafeAutomaticSubstitutionProcessor.extractValueStoreField(invoke.asNode(), kind, unsuccessfulReasons);
        if (result.valueStoreField == null && !result.illegalUseFound) {
            return;
        }
        ResolvedJavaField valueStoreField = result.valueStoreField;
        if (targetFieldHolder != null && targetFieldName != null && valueStoreField != null) {
            Supplier<ComputedValueField> supplier = () -> new ComputedValueField(valueStoreField, null, kind, targetFieldHolder, targetFieldName, false);
            if (this.tryAutomaticRecomputation(valueStoreField, kind, supplier)) {
                UnsafeAutomaticSubstitutionProcessor.reportSuccessfulAutomaticRecomputation(kind, valueStoreField, targetFieldHolder.getName() + "." + targetFieldName);
            }
        } else {
            this.reportUnsuccessfulAutomaticRecomputation(type, valueStoreField, invoke, kind, unsuccessfulReasons);
        }
    }

    private void processUnsafeArrayBaseOffsetInvoke(ResolvedJavaType type, Invoke unsafeArrayBaseOffsetInvoke) {
        SnippetReflectionProvider snippetReflectionProvider = GraalAccess.getOriginalSnippetReflection();
        ArrayList<Supplier<String>> unsuccessfulReasons = new ArrayList<Supplier<String>>();
        Class arrayClass = null;
        ValueNode arrayClassArgument = (ValueNode)unsafeArrayBaseOffsetInvoke.callTarget().arguments().get(1);
        if (arrayClassArgument.isJavaConstant()) {
            arrayClass = (Class)snippetReflectionProvider.asObject(Class.class, arrayClassArgument.asJavaConstant());
        } else {
            unsuccessfulReasons.add(() -> "The argument of the call to Unsafe.arrayBaseOffset() is not a constant.");
        }
        SearchResult result = UnsafeAutomaticSubstitutionProcessor.extractValueStoreField(unsafeArrayBaseOffsetInvoke.asNode(), RecomputeFieldValue.Kind.ArrayBaseOffset, unsuccessfulReasons);
        ResolvedJavaField offsetField = result.valueStoreField;
        if (arrayClass != null && offsetField != null) {
            Class finalArrayClass = arrayClass;
            Supplier<ComputedValueField> supplier = () -> new ComputedValueField(offsetField, null, RecomputeFieldValue.Kind.ArrayBaseOffset, finalArrayClass, null, true);
            if (this.tryAutomaticRecomputation(offsetField, RecomputeFieldValue.Kind.ArrayBaseOffset, supplier)) {
                UnsafeAutomaticSubstitutionProcessor.reportSuccessfulAutomaticRecomputation(RecomputeFieldValue.Kind.ArrayBaseOffset, offsetField, arrayClass.getCanonicalName());
            }
        } else if (result.illegalUseFound) {
            this.reportUnsuccessfulAutomaticRecomputation(type, offsetField, unsafeArrayBaseOffsetInvoke, RecomputeFieldValue.Kind.ArrayBaseOffset, unsuccessfulReasons);
        }
    }

    private void processUnsafeArrayIndexScaleInvoke(ResolvedJavaType type, Invoke unsafeArrayIndexScale, StructuredGraph clinitGraph) {
        SnippetReflectionProvider snippetReflectionProvider = GraalAccess.getOriginalSnippetReflection();
        ArrayList<Supplier<String>> unsuccessfulReasons = new ArrayList<Supplier<String>>();
        Class arrayClass = null;
        ValueNode arrayClassArgument = (ValueNode)unsafeArrayIndexScale.callTarget().arguments().get(1);
        if (arrayClassArgument.isJavaConstant()) {
            arrayClass = (Class)snippetReflectionProvider.asObject(Class.class, arrayClassArgument.asJavaConstant());
        } else {
            unsuccessfulReasons.add(() -> "The argument of the call to Unsafe.arrayIndexScale() is not a constant.");
        }
        SearchResult result = UnsafeAutomaticSubstitutionProcessor.extractValueStoreField(unsafeArrayIndexScale.asNode(), RecomputeFieldValue.Kind.ArrayIndexScale, unsuccessfulReasons);
        ResolvedJavaField indexScaleField = result.valueStoreField;
        boolean indexScaleComputed = false;
        boolean indexShiftComputed = false;
        if (arrayClass != null) {
            if (indexScaleField != null) {
                Class finalArrayClass = arrayClass;
                Supplier<ComputedValueField> supplier = () -> new ComputedValueField(indexScaleField, null, RecomputeFieldValue.Kind.ArrayIndexScale, finalArrayClass, null, true);
                if (this.tryAutomaticRecomputation(indexScaleField, RecomputeFieldValue.Kind.ArrayIndexScale, supplier)) {
                    UnsafeAutomaticSubstitutionProcessor.reportSuccessfulAutomaticRecomputation(RecomputeFieldValue.Kind.ArrayIndexScale, indexScaleField, arrayClass.getCanonicalName());
                    indexScaleComputed = true;
                    indexShiftComputed = this.processArrayIndexShiftFromField(type, indexScaleField, arrayClass, clinitGraph);
                }
            } else {
                indexShiftComputed = this.processArrayIndexShiftFromLocal(type, unsafeArrayIndexScale, arrayClass);
            }
        }
        if (!indexScaleComputed && !indexShiftComputed && result.illegalUseFound) {
            this.reportUnsuccessfulAutomaticRecomputation(type, indexScaleField, unsafeArrayIndexScale, RecomputeFieldValue.Kind.ArrayIndexScale, unsuccessfulReasons);
        }
    }

    private boolean processArrayIndexShiftFromField(ResolvedJavaType type, ResolvedJavaField indexScaleField, Class<?> arrayClass, StructuredGraph clinitGraph) {
        for (LoadFieldNode load : clinitGraph.getNodes().filter(LoadFieldNode.class)) {
            if (!load.field().equals(indexScaleField) || !this.processArrayIndexShift(type, arrayClass, (ValueNode)load, true)) continue;
            return true;
        }
        return false;
    }

    private boolean processArrayIndexShiftFromLocal(ResolvedJavaType type, Invoke unsafeArrayIndexScale, Class<?> arrayClass) {
        return this.processArrayIndexShift(type, arrayClass, unsafeArrayIndexScale.asNode(), false);
    }

    private boolean processArrayIndexShift(ResolvedJavaType type, Class<?> arrayClass, ValueNode indexScaleValue, boolean silentFailure) {
        NodeIterable loadMethodCallTargetUsages = indexScaleValue.usages().filter(MethodCallTargetNode.class);
        for (MethodCallTargetNode methodCallTarget : loadMethodCallTargetUsages) {
            if (!UnsafeAutomaticSubstitutionProcessor.isInvokeTo(methodCallTarget.invoke(), this.integerNumberOfLeadingZerosMethod)) continue;
            SearchResult result = null;
            ResolvedJavaField indexShiftField = null;
            ArrayList<Supplier<String>> unsuccessfulReasons = new ArrayList<Supplier<String>>();
            Invoke numberOfLeadingZerosInvoke = methodCallTarget.invoke();
            NodeIterable numberOfLeadingZerosInvokeSubUsages = numberOfLeadingZerosInvoke.asNode().usages().filter(SubNode.class);
            if (numberOfLeadingZerosInvokeSubUsages.count() == 1) {
                SubNode subNode = (SubNode)numberOfLeadingZerosInvokeSubUsages.first();
                if (UnsafeAutomaticSubstitutionProcessor.subNodeComputesLog2(subNode, numberOfLeadingZerosInvoke)) {
                    result = UnsafeAutomaticSubstitutionProcessor.extractValueStoreField((ValueNode)subNode, RecomputeFieldValue.Kind.ArrayIndexShift, unsuccessfulReasons);
                    indexShiftField = result.valueStoreField;
                } else {
                    unsuccessfulReasons.add(() -> "The index array scale value provided by " + String.valueOf(indexScaleValue) + " is not used to calculate the array index shift.");
                }
            } else {
                unsuccessfulReasons.add(() -> "The call to " + methodCallTarget.targetMethod().format("%H.%n(%p)") + " has multiple uses.");
            }
            if (indexShiftField != null) {
                ResolvedJavaField finalIndexShiftField = indexShiftField;
                Supplier<ComputedValueField> supplier = () -> new ComputedValueField(finalIndexShiftField, null, RecomputeFieldValue.Kind.ArrayIndexShift, arrayClass, null, true);
                if (!this.tryAutomaticRecomputation(indexShiftField, RecomputeFieldValue.Kind.ArrayIndexShift, supplier)) continue;
                UnsafeAutomaticSubstitutionProcessor.reportSuccessfulAutomaticRecomputation(RecomputeFieldValue.Kind.ArrayIndexShift, indexShiftField, arrayClass.getCanonicalName());
                return true;
            }
            if (silentFailure || (result == null || !result.illegalUseFound) && unsuccessfulReasons.isEmpty()) continue;
            this.reportUnsuccessfulAutomaticRecomputation(type, null, numberOfLeadingZerosInvoke, RecomputeFieldValue.Kind.ArrayIndexShift, unsuccessfulReasons);
        }
        return false;
    }

    private static boolean subNodeComputesLog2(SubNode subNode, Invoke numberOfLeadingZerosInvokeNode) {
        PrimitiveConstant yValueConstant;
        PrimitiveConstant xValueConstant;
        ValueNode xValueNode = subNode.getX();
        ValueNode yValueNode = subNode.getY();
        if (xValueNode.isJavaConstant() && xValueNode.asJavaConstant().getJavaKind() == JavaKind.Int && (xValueConstant = (PrimitiveConstant)xValueNode.asJavaConstant()).asInt() == 31) {
            assert (yValueNode.equals(numberOfLeadingZerosInvokeNode.asNode()));
            return true;
        }
        if (yValueNode.isJavaConstant() && yValueNode.asJavaConstant().getJavaKind() == JavaKind.Int && (yValueConstant = (PrimitiveConstant)yValueNode.asJavaConstant()).asInt() == 31) {
            assert (xValueNode.equals(numberOfLeadingZerosInvokeNode.asNode()));
            return true;
        }
        return false;
    }

    private static SearchResult extractValueStoreField(ValueNode valueNode, RecomputeFieldValue.Kind substitutionKind, List<Supplier<String>> unsuccessfulReasons) {
        ResolvedJavaField valueStoreField = null;
        boolean illegalUseFound = false;
        block0: for (Node valueNodeUsage : valueNode.usages()) {
            if (valueNodeUsage instanceof StoreFieldNode && valueStoreField == null) {
                valueStoreField = ((StoreFieldNode)valueNodeUsage).field();
                continue;
            }
            if (valueNodeUsage instanceof SignExtendNode && valueStoreField == null) {
                SignExtendNode signExtendNode = (SignExtendNode)valueNodeUsage;
                for (Node signExtendNodeUsage : signExtendNode.usages()) {
                    if (signExtendNodeUsage instanceof StoreFieldNode && valueStoreField == null) {
                        valueStoreField = ((StoreFieldNode)signExtendNodeUsage).field();
                        continue;
                    }
                    if (UnsafeAutomaticSubstitutionProcessor.isAllowedUnsafeValueSink(signExtendNodeUsage)) continue;
                    illegalUseFound = true;
                    break block0;
                }
                continue;
            }
            if (UnsafeAutomaticSubstitutionProcessor.isAllowedUnsafeValueSink(valueNodeUsage)) continue;
            illegalUseFound = true;
            break;
        }
        if (valueStoreField != null && !illegalUseFound) {
            if (valueStoreField.isStatic() && valueStoreField.isFinal()) {
                return SearchResult.foundField(valueStoreField);
            }
            ResolvedJavaField valueStoreFieldFinal = valueStoreField;
            Supplier<String> message = () -> "The field " + valueStoreFieldFinal.format("%H.%n") + ", where the value produced by the " + UnsafeAutomaticSubstitutionProcessor.kindAsString(substitutionKind) + " computation is stored, is not" + (!valueStoreFieldFinal.isStatic() ? " static" : "") + (!valueStoreFieldFinal.isFinal() ? " final" : "") + ".";
            unsuccessfulReasons.add(message);
            return SearchResult.foundIllegalUse();
        }
        if (illegalUseFound) {
            String operation;
            String producer;
            if (valueNode instanceof Invoke) {
                Invoke invokeNode = (Invoke)valueNode;
                producer = "call to " + invokeNode.callTarget().targetMethod().format("%H.%n(%p)");
                operation = "call";
            } else if (valueNode instanceof SubNode) {
                producer = "subtraction operation " + String.valueOf(valueNode);
                operation = "subtraction";
            } else {
                throw VMError.shouldNotReachHere();
            }
            Supplier<String> message = () -> "Could not determine the field where the value produced by the " + producer + " for the " + UnsafeAutomaticSubstitutionProcessor.kindAsString(substitutionKind) + " computation is stored. The " + operation + " is not directly followed by a field store or by a sign extend node followed directly by a field store. ";
            unsuccessfulReasons.add(message);
            return SearchResult.foundIllegalUse();
        }
        return SearchResult.didNotFindIllegalUse();
    }

    private static boolean isAllowedUnsafeValueSink(Node valueNodeUsage) {
        MethodCallTargetNode methodCallTarget;
        ResolvedJavaType declaringClass;
        if (valueNodeUsage instanceof FrameState) {
            return true;
        }
        return valueNodeUsage instanceof MethodCallTargetNode && ((declaringClass = (methodCallTarget = (MethodCallTargetNode)valueNodeUsage).targetMethod().getDeclaringClass()).equals(resolvedUnsafeClass) || declaringClass.equals(resolvedSunMiscUnsafeClass));
    }

    private boolean tryAutomaticRecomputation(ResolvedJavaField field, RecomputeFieldValue.Kind kind, Supplier<ComputedValueField> substitutionSupplier) {
        if (this.annotationSubstitutions.isDeleted(field)) {
            String conflictingSubstitution = "The field " + field.format("%H.%n") + " is marked as deleted. ";
            UnsafeAutomaticSubstitutionProcessor.reportConflictingSubstitution(field, kind, conflictingSubstitution);
            return false;
        }
        ComputedValueField computedValueField = substitutionSupplier.get();
        Field targetField = computedValueField.getTargetField();
        if (targetField != null && this.annotationSubstitutions.isDeleted(targetField)) {
            String conflictingSubstitution = "The target field of " + field.format("%H.%n") + " is marked as deleted. ";
            UnsafeAutomaticSubstitutionProcessor.reportSkippedSubstitution(field, kind, conflictingSubstitution);
            return false;
        }
        Optional<ResolvedJavaField> annotationSubstitution = this.annotationSubstitutions.findSubstitution(field);
        if (annotationSubstitution.isPresent()) {
            ResolvedJavaField substitutionField = annotationSubstitution.get();
            if (substitutionField instanceof ComputedValueField) {
                ComputedValueField computedSubstitutionField = (ComputedValueField)substitutionField;
                if (computedSubstitutionField.getRecomputeValueKind().equals((Object)kind)) {
                    if (computedSubstitutionField.getTargetField().equals(computedValueField.getTargetField())) {
                        UnsafeAutomaticSubstitutionProcessor.reportUnnecessarySubstitution(computedValueField, computedSubstitutionField);
                    }
                    return false;
                }
                if (computedSubstitutionField.getRecomputeValueKind().equals((Object)RecomputeFieldValue.Kind.None)) {
                    this.addSubstitutionField(computedSubstitutionField, computedValueField);
                    UnsafeAutomaticSubstitutionProcessor.reportOvewrittenSubstitution(substitutionField, kind, computedSubstitutionField.getAnnotated(), computedSubstitutionField.getRecomputeValueKind());
                    return true;
                }
                String conflictingSubstitution = "Detected RecomputeFieldValue." + String.valueOf(computedSubstitutionField.getRecomputeValueKind()) + " " + computedSubstitutionField.getAnnotated().format("%H.%n") + " substitution field. ";
                UnsafeAutomaticSubstitutionProcessor.reportConflictingSubstitution(substitutionField, kind, conflictingSubstitution);
                return false;
            }
            String conflictingSubstitution = "Detected " + substitutionField.format("%H.%n") + " substitution field. ";
            UnsafeAutomaticSubstitutionProcessor.reportConflictingSubstitution(substitutionField, kind, conflictingSubstitution);
            return false;
        }
        this.addSubstitutionField(field, computedValueField);
        return true;
    }

    private static void reportSkippedSubstitution(ResolvedJavaType type) {
        if (Options.UnsafeAutomaticSubstitutionsLogLevel.getValue() >= 3) {
            String msg = "Warning: Skipped automatic unsafe substitutions analysis for type " + type.getName() + ". The entire type is substituted, therefore its class initializer is eliminated.";
            System.out.println(msg);
        }
    }

    private static void reportUnnecessarySubstitution(ResolvedJavaField offsetField, ComputedValueField computedSubstitutionField) {
        if (Options.UnsafeAutomaticSubstitutionsLogLevel.getValue() >= 1) {
            RecomputeFieldValue.Kind kind = computedSubstitutionField.getRecomputeValueKind();
            String kindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(kind);
            String annotatedFieldStr = computedSubstitutionField.getAnnotated().format("%H.%n");
            String offsetFieldStr = offsetField.format("%H.%n");
            String msg = "Warning: Detected unnecessary " + kindStr + " " + annotatedFieldStr + " substitution field for " + offsetFieldStr + ". ";
            msg = msg + "The annotated field can be removed. This " + String.valueOf(kind) + " computation can be detected automatically. ";
            msg = msg + "Use option -H:+" + Options.UnsafeAutomaticSubstitutionsLogLevel.getName() + "=2 to print all automatically detected substitutions. ";
            System.out.println(msg);
        }
    }

    private static void reportSuccessfulAutomaticRecomputation(RecomputeFieldValue.Kind substitutionKind, ResolvedJavaField substitutedField, String target) {
        if (Options.UnsafeAutomaticSubstitutionsLogLevel.getValue() >= 2) {
            String substitutionKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(substitutionKind);
            String substitutedFieldStr = substitutedField.format("%H.%n");
            String msg = "Info:" + substitutionKindStr + " substitution automatically registered for " + substitutedFieldStr + ", target element " + target + ".";
            System.out.println(msg);
        }
    }

    private static void reportOvewrittenSubstitution(ResolvedJavaField offsetField, RecomputeFieldValue.Kind newKind, ResolvedJavaField overwrittenField, RecomputeFieldValue.Kind overwrittenKind) {
        if (Options.UnsafeAutomaticSubstitutionsLogLevel.getValue() >= 2) {
            String newKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(newKind);
            String overwrittenKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(overwrittenKind);
            String offsetFieldStr = offsetField.format("%H.%n");
            String overwrittenFieldStr = overwrittenField.format("%H.%n");
            String msg = "Info: The " + overwrittenKindStr + " " + overwrittenFieldStr + " substitution was overwritten. ";
            msg = msg + "A " + newKindStr + " substitution for " + offsetFieldStr + " was automatically registered.";
            System.out.println(msg);
        }
    }

    private static void reportConflictingSubstitution(ResolvedJavaField field, RecomputeFieldValue.Kind substitutionKind, String conflictingSubstitution) {
        if (Options.UnsafeAutomaticSubstitutionsLogLevel.getValue() >= 1) {
            String fieldStr = field.format("%H.%n");
            String substitutionKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(substitutionKind);
            String msg = "Warning: The " + substitutionKindStr + " substitution for " + fieldStr + " could not be recomputed automatically because a conflicting substitution was detected. ";
            msg = msg + "Conflicting substitution: " + conflictingSubstitution;
            msg = msg + "Add a " + substitutionKindStr + " manual substitution for " + fieldStr + ". ";
            System.out.println(msg);
        }
    }

    private static void reportSkippedSubstitution(ResolvedJavaField field, RecomputeFieldValue.Kind substitutionKind, String conflictingSubstitution) {
        if (Options.UnsafeAutomaticSubstitutionsLogLevel.getValue() >= 1) {
            String fieldStr = field.format("%H.%n");
            String substitutionKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(substitutionKind);
            String msg = "Warning: The " + substitutionKindStr + " substitution for " + fieldStr + " could not be recomputed automatically because a conflicting substitution was detected. ";
            msg = msg + "Conflicting substitution: " + conflictingSubstitution;
            System.out.println(msg);
        }
    }

    private void reportUnsuccessfulAutomaticRecomputation(ResolvedJavaType type, ResolvedJavaField computedField, Invoke invoke, RecomputeFieldValue.Kind substitutionKind, List<Supplier<String>> reasons) {
        Object msg = "";
        if (!(Options.UnsafeAutomaticSubstitutionsLogLevel.getValue() < 1 || this.suppressWarningsFor(type) && Options.UnsafeAutomaticSubstitutionsLogLevel.getValue() < 3)) {
            String substitutionKindStr = RecomputeFieldValue.class.getSimpleName() + "." + String.valueOf(substitutionKind);
            String invokeStr = invoke.callTarget().targetMethod().format("%H.%n(%p)");
            msg = (String)msg + substitutionKindStr + " automatic substitution failed. ";
            msg = (String)msg + "The automatic substitution registration was attempted because ";
            msg = substitutionKind == RecomputeFieldValue.Kind.ArrayIndexShift ? (String)msg + "an " + String.valueOf(RecomputeFieldValue.Kind.ArrayIndexScale) + " computation followed by a call to " + invokeStr + " " : (String)msg + "a call to " + invokeStr + " ";
            msg = (String)msg + "was detected in the static initializer of " + type.toJavaName() + ". ";
            if (computedField != null) {
                msg = (String)msg + "Add a " + substitutionKindStr + " manual substitution for " + computedField.format("%H.%n") + ". ";
            }
            msg = (String)msg + "Detailed failure reason(s): " + reasons.stream().map(s -> (String)s.get()).collect(Collectors.joining(", "));
        }
        if (Options.UnsafeAutomaticSubstitutionsLogLevel.getValue() >= 3 && this.suppressWarningsFor(type)) {
            msg = (String)msg + "(This warning is suppressed by default because this type ";
            if (this.warningsAreWhiteListed(type)) {
                msg = (String)msg + "is manually added to a white list";
            } else if (this.isAliased(type)) {
                msg = (String)msg + "is aliased";
            } else {
                ResolvedJavaType substitutionType = this.findSubstitutionType(type);
                msg = (String)msg + "is substituted by " + substitutionType.toJavaName();
            }
            msg = (String)msg + ".)";
        }
        if (!((String)msg).isEmpty()) {
            System.out.println("Warning: " + (String)msg);
        }
    }

    private static String kindAsString(RecomputeFieldValue.Kind substitutionKind) {
        switch (substitutionKind) {
            case FieldOffset: {
                return "field offset";
            }
            case StaticFieldBase: {
                return "static field base";
            }
            case ArrayBaseOffset: {
                return "array base offset";
            }
            case ArrayIndexScale: {
                return "array index scale";
            }
            case ArrayIndexShift: {
                return "array index shift";
            }
        }
        throw VMError.shouldNotReachHere("Unexpected substitution kind: " + String.valueOf(substitutionKind));
    }

    private boolean suppressWarningsFor(ResolvedJavaType type) {
        return this.warningsAreWhiteListed(type) || this.isAliased(type) || this.findSubstitutionType(type) != null;
    }

    private boolean warningsAreWhiteListed(ResolvedJavaType type) {
        return this.suppressWarnings.contains(type);
    }

    private ResolvedJavaType findSubstitutionType(ResolvedJavaType type) {
        Optional<ResolvedJavaType> substTypeOptional = this.annotationSubstitutions.findSubstitution(type);
        return substTypeOptional.orElse(null);
    }

    private boolean isAliased(ResolvedJavaType type) {
        return this.annotationSubstitutions.isAliased(type);
    }

    private StructuredGraph getStaticInitializerGraph(ResolvedJavaMethod clinit, DebugContext debug) {
        assert (clinit.hasBytecodes());
        HighTierContext context = new HighTierContext(GraalAccess.getOriginalProviders(), null, OptimisticOptimizations.NONE);
        StructuredGraph graph = new StructuredGraph.Builder(this.options, debug).method(clinit).recordInlinedMethods(false).build();
        graph.getGraphState().configureExplicitExceptionsNoDeopt();
        ClassInitializerGraphBuilderPhase builderPhase = new ClassInitializerGraphBuilderPhase((CoreProviders)context, GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)this.plugins).withEagerResolving(true), context.getOptimisticOptimizations());
        builderPhase.apply(graph, context);
        for (InvokeWithExceptionNode invoke : graph.getNodes(InvokeWithExceptionNode.TYPE)) {
            if (!this.noCheckedExceptionsSet.contains(invoke.callTarget().targetMethod())) continue;
            invoke.replaceWithInvoke();
        }
        CanonicalizerPhase.createWithoutReadCanonicalization().apply(graph, (Object)context);
        return graph;
    }

    private static boolean isInvokeTo(Invoke invoke, ResolvedJavaMethod method) {
        if (method == null) {
            return false;
        }
        ResolvedJavaMethod targetMethod = invoke.callTarget().targetMethod();
        return method.equals(targetMethod);
    }

    static class StaticInitializerInlineInvokePlugin
    implements InlineInvokePlugin {
        static final int maxDepth = 1;
        static final int maxCodeSize = 500;
        private final HashSet<ResolvedJavaMethod> neverInline;

        StaticInitializerInlineInvokePlugin(HashSet<ResolvedJavaMethod> neverInline) {
            this.neverInline = neverInline;
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
            if (this.neverInline.contains(original)) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (original.getCode() != null && original.getCodeSize() < 500 && builder.getDepth() <= 1) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)original);
            }
            return null;
        }
    }

    static final class SearchResult {
        final ResolvedJavaField valueStoreField;
        final boolean illegalUseFound;

        private SearchResult(ResolvedJavaField valueStoreField, boolean illegalUseFound) {
            this.valueStoreField = valueStoreField;
            this.illegalUseFound = illegalUseFound;
        }

        static SearchResult foundField(ResolvedJavaField offsetField) {
            return new SearchResult(offsetField, false);
        }

        static SearchResult foundIllegalUse() {
            return new SearchResult(null, true);
        }

        static SearchResult didNotFindIllegalUse() {
            return new SearchResult(null, false);
        }
    }

    static class Options {
        static final HostedOptionKey<Integer> UnsafeAutomaticSubstitutionsLogLevel = new HostedOptionKey<Integer>(1);

        Options() {
        }
    }
}

