/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.driver.NativeImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class DefaultOptionHandler
extends NativeImage.OptionHandler<NativeImage> {
    private static final String requireValidJarFileMessage = "-jar requires a valid jarfile";
    private static final String newStyleClasspathOptionName = "--class-path";
    static final String addModulesOption = "--add-modules";
    static final String limitModulesOption = "--limit-modules";
    private static final String moduleSetModifierOptionErrorMessage = " requires modules to be specified";
    static final String ADD_ENV_VAR_OPTION = "-E";
    private static final String noServerOption = "--no-server";
    boolean disableAtFiles = false;

    DefaultOptionHandler(NativeImage nativeImage) {
        super(nativeImage);
    }

    @Override
    public boolean consume(NativeImage.ArgumentQueue args) {
        String headArg;
        switch (headArg = args.peek()) {
            case "-cp": 
            case "-classpath": 
            case "--class-path": {
                args.poll();
                String cpArgs = args.poll();
                if (cpArgs == null) {
                    NativeImage.showError(headArg + " requires class path specification");
                }
                this.processClasspathArgs(cpArgs);
                return true;
            }
            case "-p": 
            case "--module-path": {
                args.poll();
                String mpArgs = args.poll();
                if (mpArgs == null) {
                    NativeImage.showError(headArg + " requires module path specification");
                }
                this.processModulePathArgs(mpArgs);
                return true;
            }
            case "-m": 
            case "--module": {
                String[] mainClassModuleArgParts;
                args.poll();
                String mainClassModuleArg = args.poll();
                if (mainClassModuleArg == null) {
                    NativeImage.showError(headArg + " requires module name");
                }
                if ((mainClassModuleArgParts = mainClassModuleArg.split("/", 2)).length > 1) {
                    this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHClass + mainClassModuleArgParts[1]);
                }
                this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHModule + mainClassModuleArgParts[0]);
                this.nativeImage.setModuleOptionMode(true);
                return true;
            }
            case "--add-modules": {
                args.poll();
                String addModulesArgs = args.poll();
                if (addModulesArgs == null) {
                    NativeImage.showError(headArg + moduleSetModifierOptionErrorMessage);
                }
                this.nativeImage.addImageBuilderJavaArgs(addModulesOption, addModulesArgs);
                this.nativeImage.addAddedModules(addModulesArgs);
                return true;
            }
            case "--limit-modules": {
                args.poll();
                String limitModulesArgs = args.poll();
                if (limitModulesArgs == null) {
                    NativeImage.showError(headArg + moduleSetModifierOptionErrorMessage);
                }
                this.nativeImage.addLimitedModules(limitModulesArgs);
                return true;
            }
            case "-jar": {
                args.poll();
                String jarFilePathStr = args.poll();
                if (jarFilePathStr == null) {
                    NativeImage.showError(requireValidJarFileMessage);
                }
                this.handleJarFileArg(this.nativeImage.canonicalize(Paths.get(jarFilePathStr, new String[0])));
                this.nativeImage.setJarOptionMode(true);
                return true;
            }
            case "--diagnostics-mode": {
                args.poll();
                this.nativeImage.enableDiagnostics();
                this.nativeImage.addPlainImageBuilderArg("-H:+DiagnosticsMode");
                this.nativeImage.addPlainImageBuilderArg("-H:DiagnosticsDir=" + String.valueOf(this.nativeImage.diagnosticsDir));
                System.out.println("# Diagnostics mode enabled: image-build reports are saved to " + String.valueOf(this.nativeImage.diagnosticsDir));
                return true;
            }
            case "--disable-@files": {
                args.poll();
                this.disableAtFiles = true;
                return true;
            }
            case "--no-server": {
                args.poll();
                NativeImage.showWarning("Ignoring server-mode native-image argument " + headArg + ".");
                return true;
            }
            case "--enable-preview": {
                args.poll();
                this.nativeImage.addCustomJavaArgs("--enable-preview");
                return true;
            }
        }
        String singleArgClasspathPrefix = "--class-path=";
        if (headArg.startsWith(singleArgClasspathPrefix)) {
            String cpArgs = args.poll().substring(singleArgClasspathPrefix.length());
            if (cpArgs.isEmpty()) {
                NativeImage.showError(headArg + " requires class path specification");
            }
            this.processClasspathArgs(cpArgs);
            return true;
        }
        if (headArg.startsWith("-H:")) {
            args.poll();
            this.nativeImage.addPlainImageBuilderArg(NativeImage.injectHostedOptionOrigin(headArg, args.argumentOrigin));
            return true;
        }
        if (headArg.startsWith("-R:")) {
            args.poll();
            this.nativeImage.addPlainImageBuilderArg(headArg);
            return true;
        }
        String javaArgsPrefix = "-D";
        if (headArg.startsWith(javaArgsPrefix)) {
            args.poll();
            this.nativeImage.addCustomJavaArgs(headArg);
            return true;
        }
        String optionKeyPrefix = "-V";
        if (headArg.startsWith(optionKeyPrefix)) {
            args.poll();
            String keyValueStr = headArg.substring(optionKeyPrefix.length());
            String[] keyValue = keyValueStr.split("=");
            if (keyValue.length != 2) {
                throw NativeImage.showError("Use " + optionKeyPrefix + "<key>=<value>");
            }
            this.nativeImage.addOptionKeyValue(keyValue[0], keyValue[1]);
            return true;
        }
        if (headArg.startsWith(ADD_ENV_VAR_OPTION)) {
            args.poll();
            String envVarSetting = headArg.substring(ADD_ENV_VAR_OPTION.length());
            String[] keyValue = envVarSetting.split("=", 2);
            String valueDefinedOrInherited = keyValue.length > 1 ? keyValue[1] : null;
            this.nativeImage.imageBuilderEnvironment.put(keyValue[0], valueDefinedOrInherited);
            return true;
        }
        if (headArg.startsWith("-J")) {
            args.poll();
            if (headArg.equals("-J")) {
                NativeImage.showError("The -J option should not be followed by a space");
            } else {
                this.nativeImage.addCustomJavaArgs(headArg.substring(2));
            }
            return true;
        }
        if (headArg.startsWith("--add-modules=")) {
            args.poll();
            String addModulesArgs = headArg.substring(addModulesOption.length() + 1);
            if (addModulesArgs.isEmpty()) {
                NativeImage.showError(headArg + moduleSetModifierOptionErrorMessage);
            }
            this.nativeImage.addImageBuilderJavaArgs(addModulesOption, addModulesArgs);
            this.nativeImage.addAddedModules(addModulesArgs);
            return true;
        }
        if (headArg.startsWith("--limit-modules=")) {
            args.poll();
            String limitModulesArgs = headArg.substring(limitModulesOption.length() + 1);
            if (limitModulesArgs.isEmpty()) {
                NativeImage.showError(headArg + moduleSetModifierOptionErrorMessage);
            }
            this.nativeImage.addLimitedModules(limitModulesArgs);
            return true;
        }
        if (headArg.startsWith("@") && !this.disableAtFiles) {
            args.poll();
            headArg = headArg.substring(1);
            Path origArgFile = Paths.get(headArg, new String[0]);
            Path argFile = this.nativeImage.useBundle() ? this.nativeImage.bundleSupport.substituteAuxiliaryPath(origArgFile, BundleMember.Role.Input) : origArgFile;
            NativeImage nativeImage = this.nativeImage;
            Objects.requireNonNull(nativeImage);
            NativeImage.NativeImageArgsProcessor processor = new NativeImage.NativeImageArgsProcessor(nativeImage, "argfile:" + String.valueOf(argFile));
            DefaultOptionHandler.readArgFile(argFile).forEach(processor);
            List<String> leftoverArgs = processor.apply(false);
            if (leftoverArgs.size() > 0) {
                NativeImage.showError(String.format("Found unrecognized options while parsing argument file '%s':%n%s", argFile, String.join((CharSequence)System.lineSeparator(), leftoverArgs)));
            }
            return true;
        }
        return false;
    }

    private static List<String> readArgFile(Path file) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--disable-@files");
        String options = null;
        try {
            options = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NativeImage.showError("Error reading argument file", e);
        }
        CTX_ARGS ctx = new CTX_ARGS();
        ctx.state = PARSER_STATE.FIND_NEXT;
        ctx.parts = new ArrayList<String>(4);
        ctx.quoteChar = (char)34;
        ctx.cptr = 0;
        ctx.eob = options.length();
        ctx.options = options;
        String token = DefaultOptionHandler.nextToken(ctx);
        while (token != null) {
            arguments.add(token);
            token = DefaultOptionHandler.nextToken(ctx);
        }
        if ((ctx.state == PARSER_STATE.IN_TOKEN || ctx.state == PARSER_STATE.IN_QUOTE) && ctx.parts.size() != 0) {
            token = String.join((CharSequence)"", ctx.parts);
            arguments.add(token);
        }
        return arguments;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String nextToken(CTX_ARGS ctx) {
        int nextc = ctx.cptr;
        int eob = ctx.eob;
        int anchor = nextc;
        while (true) {
            block33: {
                char ch;
                block35: {
                    block34: {
                        block31: {
                            block30: {
                                block32: {
                                    if (nextc >= eob) break block30;
                                    ch = ctx.options.charAt(nextc);
                                    if (ctx.state == PARSER_STATE.FIND_NEXT || ctx.state == PARSER_STATE.SKIP_LEAD_WS) break block31;
                                    if (ctx.state != PARSER_STATE.IN_ESCAPE) break block32;
                                    if (ch == '\n' || ch == '\r') {
                                        ctx.state = PARSER_STATE.SKIP_LEAD_WS;
                                    } else {
                                        ctx.parts.add(switch (ch) {
                                            case 'n' -> "\n";
                                            case 'r' -> "\r";
                                            case 't' -> "\t";
                                            case 'f' -> "\f";
                                            default -> String.valueOf(ch);
                                        });
                                        ctx.state = PARSER_STATE.IN_QUOTE;
                                    }
                                    anchor = nextc + 1;
                                    break block33;
                                }
                                if (ctx.state != PARSER_STATE.IN_COMMENT) break block34;
                                break block35;
                            }
                            assert (nextc == eob);
                            if ((ctx.state == PARSER_STATE.IN_TOKEN || ctx.state == PARSER_STATE.IN_QUOTE) && anchor < nextc) {
                                ctx.parts.add(ctx.options.substring(anchor, nextc));
                            }
                            return null;
                        }
                        while (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f') {
                            if (++nextc >= eob) {
                                return null;
                            }
                            ch = ctx.options.charAt(nextc);
                        }
                        ctx.state = ctx.state == PARSER_STATE.FIND_NEXT ? PARSER_STATE.IN_TOKEN : PARSER_STATE.IN_QUOTE;
                        anchor = nextc;
                    }
                    assert (ctx.state != PARSER_STATE.IN_ESCAPE);
                    assert (ctx.state != PARSER_STATE.FIND_NEXT);
                    assert (ctx.state != PARSER_STATE.SKIP_LEAD_WS);
                    assert (ctx.state != PARSER_STATE.IN_COMMENT);
                    switch (ch) {
                        case '\t': 
                        case '\f': 
                        case ' ': {
                            if (ctx.state == PARSER_STATE.IN_QUOTE) break;
                        }
                        case '\n': 
                        case '\r': {
                            String token;
                            if (ctx.parts.size() == 0) {
                                token = ctx.options.substring(anchor, nextc);
                            } else {
                                ctx.parts.add(ctx.options.substring(anchor, nextc));
                                token = String.join((CharSequence)"", ctx.parts);
                                ctx.parts = new ArrayList<String>();
                            }
                            ctx.cptr = nextc + 1;
                            ctx.state = PARSER_STATE.FIND_NEXT;
                            return token;
                        }
                        case '#': {
                            if (ctx.state == PARSER_STATE.IN_QUOTE) break;
                            ctx.state = PARSER_STATE.IN_COMMENT;
                            anchor = nextc + 1;
                            break;
                        }
                        case '\\': {
                            if (ctx.state != PARSER_STATE.IN_QUOTE) break;
                            ctx.parts.add(ctx.options.substring(anchor, nextc));
                            ctx.state = PARSER_STATE.IN_ESCAPE;
                            anchor = nextc + 1;
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            if (ctx.state == PARSER_STATE.IN_QUOTE && ctx.quoteChar != ch) break;
                            if (anchor != nextc) {
                                ctx.parts.add(ctx.options.substring(anchor, nextc));
                            }
                            anchor = nextc + 1;
                            if (ctx.state == PARSER_STATE.IN_TOKEN) {
                                ctx.quoteChar = ch;
                                ctx.state = PARSER_STATE.IN_QUOTE;
                                break;
                            }
                            ctx.state = PARSER_STATE.IN_TOKEN;
                            break;
                        }
                    }
                    break block33;
                }
                while (ch != '\n' && ch != '\r') {
                    if (++nextc >= eob) {
                        return null;
                    }
                    ch = ctx.options.charAt(nextc);
                }
                anchor = nextc + 1;
                ctx.state = PARSER_STATE.FIND_NEXT;
            }
            ++nextc;
        }
    }

    private void processClasspathArgs(String cpArgs) {
        for (String cp : cpArgs.split(File.pathSeparator, Integer.MAX_VALUE)) {
            String cpEntry = cp.isEmpty() ? "." : cp;
            this.nativeImage.addCustomImageClasspath(cpEntry);
        }
    }

    private void processModulePathArgs(String mpArgs) {
        for (String mpEntry : mpArgs.split(File.pathSeparator, Integer.MAX_VALUE)) {
            this.nativeImage.addImageModulePath(Paths.get(mpEntry, new String[0]), false);
        }
    }

    private void handleJarFileArg(Path jarFilePath) {
        String jarSuffix;
        String jarFileName;
        String jarFileNameBase;
        if (Files.isDirectory(jarFilePath, new LinkOption[0])) {
            NativeImage.showError(String.valueOf(jarFilePath) + " is a directory. (-jar requires a valid jarfile)");
        }
        if (!(jarFileNameBase = (jarFileName = jarFilePath.getFileName().toString()).endsWith(jarSuffix = ".jar") ? jarFileName.substring(0, jarFileName.length() - jarSuffix.length()) : jarFileName).isEmpty()) {
            String origin = "manifest from " + String.valueOf(jarFilePath.toUri());
            this.nativeImage.addPlainImageBuilderArg(NativeImage.injectHostedOptionOrigin(this.nativeImage.oHName + jarFileNameBase, origin));
        }
        Path finalFilePath = this.nativeImage.useBundle() ? this.nativeImage.bundleSupport.substituteClassPath(jarFilePath) : jarFilePath;
        if (!NativeImage.processJarManifestMainAttributes(finalFilePath, this.nativeImage::handleMainClassAttribute)) {
            NativeImage.showError("No manifest in " + String.valueOf(finalFilePath));
        }
        this.nativeImage.addCustomImageClasspath(finalFilePath);
    }

    static class CTX_ARGS {
        PARSER_STATE state;
        int cptr;
        int eob;
        char quoteChar;
        List<String> parts;
        String options;

        CTX_ARGS() {
        }
    }

    static enum PARSER_STATE {
        FIND_NEXT,
        IN_COMMENT,
        IN_QUOTE,
        IN_ESCAPE,
        SKIP_LEAD_WS,
        IN_TOKEN;

    }
}

