/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AtomicUtils {
    public static <T, V> boolean atomicSet(T holder, V value, AtomicReferenceFieldUpdater<T, V> updater) {
        Objects.requireNonNull(value, "The value parameter of AtomicUtils.atomicSet() should not be null.");
        if (updater.get(holder) == null) {
            return updater.compareAndSet(holder, null, value);
        }
        return false;
    }

    public static <T, V> boolean atomicSetAndRun(T holder, V value, AtomicReferenceFieldUpdater<T, V> updater, Runnable task) {
        Objects.requireNonNull(value, "The value parameter of AtomicUtils.atomicSetAndRun() should not be null.");
        if (updater.get(holder) == null) {
            boolean firstAttempt = updater.compareAndSet(holder, null, value);
            if (firstAttempt) {
                task.run();
            }
            return firstAttempt;
        }
        return false;
    }

    public static <T, V> boolean isSet(T holder, AtomicReferenceFieldUpdater<T, V> updater) {
        return updater.get(holder) != null;
    }

    public static <T> boolean atomicMark(T holder, AtomicIntegerFieldUpdater<T> updater) {
        if (updater.get(holder) == 0) {
            return updater.compareAndSet(holder, 0, 1);
        }
        return false;
    }

    public static <T> boolean isSet(T holder, AtomicIntegerFieldUpdater<T> updater) {
        return updater.get(holder) == 1;
    }

    public static <T> T produceAndSetValue(AtomicReference<T> reference, Supplier<T> supplier, Consumer<T> initializer) {
        T value;
        if (reference.get() == null && reference.compareAndSet(null, value = supplier.get())) {
            initializer.accept(value);
        }
        return reference.get();
    }
}

