/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.CodeWriter;
import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.LanguageRegistrationProcessor;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.transform.FixWarningsVisitor;
import com.oracle.truffle.dsl.processor.java.transform.GenerateOverrideVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.Option", "com.oracle.truffle.api.Option.Group"})
public class OptionProcessor
extends AbstractProcessor {
    private final Set<Element> processed = new HashSet<Element>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        try (ProcessorContext context = ProcessorContext.enter(this.processingEnv);){
            TruffleTypes types = context.getTypes();
            HashMap<Element, Object> map = new HashMap<Element, Object>();
            for (Element element : roundEnv.getElementsAnnotatedWith(ElementUtils.castTypeElement(types.Option))) {
                if (this.processed.contains(element)) continue;
                this.processed.add(element);
                Element topElement = element.getEnclosingElement();
                Object options = (OptionsInfo)map.get(topElement);
                if (options == null) {
                    options = new OptionsInfo(topElement);
                    map.put(topElement, options);
                }
                AnnotationMirror mirror = ElementUtils.findAnnotationMirror(element.getAnnotationMirrors(), (TypeMirror)types.Option);
                try {
                    this.processElement(element, mirror, (OptionsInfo)options);
                }
                catch (Throwable t) {
                    this.handleThrowable(t, topElement);
                }
            }
            HashMap<String, OptionInfo> seenKeys = new HashMap<String, OptionInfo>();
            for (OptionsInfo infos : map.values()) {
                for (OptionInfo info : infos.options) {
                    if (seenKeys.containsKey(info.name)) {
                        OptionInfo otherInfo = (OptionInfo)seenKeys.get(info.name);
                        String message = "Two options with duplicated resolved descriptor name '%s' found.";
                        info.valid = false;
                        otherInfo.valid = false;
                        OptionProcessor.error(info.field, info.annotation, message, info.name);
                        OptionProcessor.error(otherInfo.field, otherInfo.annotation, message, otherInfo.name);
                        continue;
                    }
                    seenKeys.put(info.name, info);
                }
            }
            for (OptionsInfo infos : map.values()) {
                ListIterator<OptionInfo> listIterator = infos.options.listIterator();
                while (listIterator.hasNext()) {
                    OptionInfo info;
                    info = listIterator.next();
                    if (info.valid) {
                        ExpectError.assertNoErrorExpected(info.field);
                        continue;
                    }
                    listIterator.remove();
                }
                Collections.sort(infos.options, new Comparator<OptionInfo>(){

                    @Override
                    public int compare(OptionInfo o1, OptionInfo o2) {
                        return o1.name.compareTo(o2.name);
                    }
                });
            }
            for (OptionsInfo info : map.values()) {
                try {
                    OptionProcessor.generateOptionDescriptor(info);
                }
                catch (Throwable t) {
                    this.handleThrowable(t, info.type);
                }
            }
        }
        return true;
    }

    private boolean processElement(Element element, AnnotationMirror elementAnnotation, OptionsInfo info) {
        VariableElement sandboxElement;
        String sandbox;
        VariableElement stabilityElement;
        String category;
        char firstChar;
        String help;
        ProcessorContext context = ProcessorContext.getInstance();
        TruffleTypes types = context.getTypes();
        if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
            OptionProcessor.error(element, elementAnnotation, "Option field must be static", new Object[0]);
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            OptionProcessor.error(element, elementAnnotation, "Option field cannot be private", new Object[0]);
            return false;
        }
        List<String> groupPrefixStrings = null;
        AnnotationMirror prefix = ElementUtils.findAnnotationMirror(info.type, (TypeMirror)types.Option_Group);
        if (prefix != null) {
            groupPrefixStrings = ElementUtils.getAnnotationValueList(String.class, prefix, "value");
        } else {
            AnnotationMirror registration;
            TypeMirror erasedTruffleType = context.getEnvironment().getTypeUtils().erasure(types.TruffleLanguage);
            if (context.getEnvironment().getTypeUtils().isAssignable(info.type.asType(), erasedTruffleType)) {
                String languageId;
                registration = ElementUtils.findAnnotationMirror(info.type, (TypeMirror)types.TruffleLanguage_Registration);
                if (registration != null && (groupPrefixStrings = Arrays.asList(languageId = LanguageRegistrationProcessor.resolveLanguageId(info.type, registration))).get(0).isEmpty()) {
                    OptionProcessor.error(element, elementAnnotation, "%s must specify an id such that Truffle options can infer their prefix.", types.TruffleLanguage_Registration.asElement().getSimpleName().toString());
                    return false;
                }
            } else if (context.getEnvironment().getTypeUtils().isAssignable(info.type.asType(), types.TruffleInstrument) && (registration = ElementUtils.findAnnotationMirror(info.type, (TypeMirror)types.TruffleInstrument_Registration)) != null && (groupPrefixStrings = Arrays.asList(ElementUtils.getAnnotationValue(String.class, registration, "id"))).get(0).isEmpty()) {
                OptionProcessor.error(element, elementAnnotation, "%s must specify an id such that Truffle options can infer their prefix.", types.TruffleInstrument_Registration.asElement().getSimpleName().toString());
                return false;
            }
        }
        if (groupPrefixStrings == null || groupPrefixStrings.isEmpty()) {
            groupPrefixStrings = Arrays.asList("");
        }
        AnnotationMirror annotation = ElementUtils.findAnnotationMirror(element, (TypeMirror)types.Option);
        assert (annotation != null);
        assert (element instanceof VariableElement);
        assert (element.getKind() == ElementKind.FIELD);
        VariableElement field = (VariableElement)element;
        String fieldName = field.getSimpleName().toString();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeMirror fieldType = field.asType();
        if (fieldType.getKind() != TypeKind.DECLARED) {
            OptionProcessor.error(element, elementAnnotation, "Option field must be of type " + ElementUtils.getQualifiedName(types.OptionKey), new Object[0]);
            return false;
        }
        if (!typeUtils.isSubtype(fieldType, typeUtils.erasure(types.OptionKey))) {
            OptionProcessor.error(element, elementAnnotation, "Option field type %s is not a subclass of %s", fieldType, types.OptionKey);
            return false;
        }
        if (!field.getModifiers().contains((Object)Modifier.STATIC)) {
            OptionProcessor.error(element, elementAnnotation, "Option field must be static", new Object[0]);
            return false;
        }
        if (field.getModifiers().contains((Object)Modifier.PRIVATE)) {
            OptionProcessor.error(element, elementAnnotation, "Option field cannot be private", new Object[0]);
            return false;
        }
        boolean optionMap = false;
        DeclaredType optionMapType = types.OptionMap;
        List<? extends TypeMirror> typeArguments = ((DeclaredType)fieldType).getTypeArguments();
        if (typeArguments.size() == 1) {
            optionMap = typeUtils.isSubtype(typeArguments.get(0), typeUtils.erasure(optionMapType));
        }
        if ((help = ElementUtils.getAnnotationValue(String.class, annotation, "help")).length() != 0 && !Character.isUpperCase(firstChar = help.charAt(0))) {
            OptionProcessor.error(element, elementAnnotation, "Option help text must start with upper case letter", new Object[0]);
            return false;
        }
        String usageSyntax = ElementUtils.getAnnotationValue(String.class, annotation, "usageSyntax");
        AnnotationValue value = ElementUtils.getAnnotationValue(elementAnnotation, "name", false);
        String optionName = value == null ? fieldName : ElementUtils.getAnnotationValue(String.class, annotation, "name");
        if (optionMap && optionName.contains(".")) {
            OptionProcessor.error(element, elementAnnotation, "Option (maps) cannot contain a '.' in the name", new Object[0]);
            return false;
        }
        boolean deprecated = ElementUtils.getAnnotationValue(Boolean.class, annotation, "deprecated");
        VariableElement categoryElement = ElementUtils.getAnnotationValue(VariableElement.class, annotation, "category");
        String string = category = categoryElement != null ? categoryElement.getSimpleName().toString() : null;
        if (category == null) {
            category = "INTERNAL";
        }
        String stability = (stabilityElement = ElementUtils.getAnnotationValue(VariableElement.class, annotation, "stability")) != null ? stabilityElement.getSimpleName().toString() : null;
        String deprecationMessage = ElementUtils.getAnnotationValue(String.class, annotation, "deprecationMessage");
        if (deprecationMessage.length() != 0) {
            if (!deprecated) {
                OptionProcessor.error(element, elementAnnotation, "Deprecation message can be specified only for deprecated options.", new Object[0]);
                return false;
            }
            char firstChar2 = deprecationMessage.charAt(0);
            if (!Character.isUpperCase(firstChar2)) {
                OptionProcessor.error(element, elementAnnotation, "Option deprecation message must start with upper case letter.", new Object[0]);
                return false;
            }
        }
        String string2 = sandbox = (sandboxElement = ElementUtils.getAnnotationValue(VariableElement.class, annotation, "sandbox")) != null ? sandboxElement.getSimpleName().toString() : null;
        if (sandbox == null) {
            sandbox = "TRUSTED";
        }
        for (String group : groupPrefixStrings) {
            if (group.isEmpty() && optionName.isEmpty()) {
                OptionProcessor.error(element, elementAnnotation, "Both group and option name cannot be empty", new Object[0]);
                continue;
            }
            Object name = optionName.isEmpty() ? group : (group.isEmpty() ? optionName : group + "." + optionName);
            info.options.add(new OptionInfo((String)name, help, field, elementAnnotation, deprecated, category, stability, optionMap, deprecationMessage, usageSyntax, sandbox));
        }
        return true;
    }

    private static void error(Element element, AnnotationMirror annotation, String message, Object ... args) {
        ProcessingEnvironment processingEnv = ProcessorContext.getInstance().getEnvironment();
        String formattedMessage = String.format(message, args);
        if (ExpectError.isExpectedError(element, formattedMessage)) {
            return;
        }
        processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, formattedMessage, element, annotation);
    }

    private static void generateOptionDescriptor(OptionsInfo info) {
        block2: {
            Element element = info.type;
            ProcessorContext context = ProcessorContext.getInstance();
            CodeTypeElement unit = OptionProcessor.generateDescriptors(context, element, info);
            DeclaredType overrideType = (DeclaredType)context.getType(Override.class);
            unit.accept(new GenerateOverrideVisitor(overrideType), null);
            unit.accept(new FixWarningsVisitor(overrideType), null);
            try {
                unit.accept(new CodeWriter(context.getEnvironment(), element), null);
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof FilerException) || !e.getCause().getMessage().startsWith("Source file already created")) break block2;
                return;
            }
        }
    }

    private void handleThrowable(Throwable t, Element e) {
        String message = "Uncaught error in " + this.getClass().getSimpleName() + " while processing " + String.valueOf(e) + " ";
        ProcessorContext.getInstance().getEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, message + ": " + ElementUtils.printException(t), e);
    }

    private static CodeTypeElement generateDescriptors(ProcessorContext context, Element element, OptionsInfo model) {
        TruffleTypes types = context.getTypes();
        String optionsClassName = ElementUtils.getSimpleName(element.asType()) + types.OptionDescriptors.asElement().getSimpleName().toString();
        TypeElement sourceType = (TypeElement)model.type;
        PackageElement pack = context.getEnvironment().getElementUtils().getPackageOf(sourceType);
        Set<Modifier> typeModifiers = ElementUtils.modifiers(Modifier.FINAL);
        CodeTypeElement descriptors = new CodeTypeElement(typeModifiers, ElementKind.CLASS, pack, optionsClassName);
        descriptors.getImplements().add(types.TruffleOptionDescriptors);
        GeneratorUtils.addGeneratedBy(context, descriptors, (TypeElement)element);
        ExecutableElement get = ElementUtils.findExecutableElement(types.OptionDescriptors, "get");
        CodeExecutableElement getMethod = CodeExecutableElement.clone(get);
        getMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
        CodeTreeBuilder builder = getMethod.createBuilder();
        String nameVariableName = getMethod.getParameters().get(0).getSimpleName().toString();
        boolean elseIf = false;
        for (OptionInfo optionInfo : model.options) {
            if (!optionInfo.optionMap) continue;
            elseIf = builder.startIf(elseIf);
            builder.startCall(nameVariableName, "startsWith").doubleQuote(optionInfo.name + ".").end();
            builder.string(" || ");
            builder.startCall(nameVariableName, "equals").doubleQuote(optionInfo.name).end();
            builder.end().startBlock();
            builder.startReturn().tree(OptionProcessor.createBuildOptionDescriptor(context, optionInfo)).end();
            builder.end();
        }
        boolean startSwitch = false;
        for (OptionInfo info : model.options) {
            if (info.optionMap) continue;
            if (!startSwitch) {
                builder.startSwitch().string(nameVariableName).end().startBlock();
                startSwitch = true;
            }
            builder.startCase().doubleQuote(info.name).end().startCaseBlock();
            builder.startReturn().tree(OptionProcessor.createBuildOptionDescriptor(context, info)).end();
            builder.end();
        }
        if (startSwitch) {
            builder.end();
        }
        builder.returnNull();
        descriptors.add(getMethod);
        CodeExecutableElement codeExecutableElement = CodeExecutableElement.clone(ElementUtils.findExecutableElement(types.TruffleOptionDescriptors, "getSandboxPolicy", 1));
        codeExecutableElement.getModifiers().remove((Object)Modifier.ABSTRACT);
        codeExecutableElement.renameArguments("optionName");
        LinkedHashMap<String, List> groupedOptions = new LinkedHashMap<String, List>();
        for (OptionInfo info : model.options) {
            groupedOptions.computeIfAbsent(info.sandboxPolicy, s -> new LinkedList()).add(info);
        }
        builder = codeExecutableElement.createBuilder();
        builder.startAssert().string("get(optionName) != null : ").doubleQuote("Unknown option ").string(" + optionName").end();
        String defaultSandboxPolicy = null;
        String maxEntry = null;
        if (groupedOptions.size() == 0) {
            defaultSandboxPolicy = "TRUSTED";
        } else if (groupedOptions.size() == 1) {
            defaultSandboxPolicy = (String)groupedOptions.keySet().iterator().next();
        } else {
            int maxSize = -1;
            for (Map.Entry entry : groupedOptions.entrySet()) {
                if (((List)entry.getValue()).size() <= maxSize) continue;
                maxSize = ((List)entry.getValue()).size();
                maxEntry = (String)entry.getKey();
            }
        }
        assert (defaultSandboxPolicy != null != (maxEntry != null));
        groupedOptions.remove(defaultSandboxPolicy);
        groupedOptions.remove(maxEntry);
        elseIf = false;
        Iterator groupIt = groupedOptions.entrySet().iterator();
        while (groupIt.hasNext()) {
            Map.Entry entry = groupIt.next();
            List options = (List)entry.getValue();
            Iterator optionsIt = options.iterator();
            while (optionsIt.hasNext()) {
                OptionInfo optionInfo = (OptionInfo)optionsIt.next();
                if (!optionInfo.optionMap) continue;
                elseIf = builder.startIf(elseIf);
                builder.startCall(nameVariableName, "startsWith").doubleQuote(optionInfo.name + ".").end();
                builder.string(" || ");
                builder.startCall(nameVariableName, "equals").doubleQuote(optionInfo.name).end();
                builder.end().startBlock();
                builder.startReturn().type(types.SandboxPolicy).string(".", (String)entry.getKey()).end();
                builder.end();
                optionsIt.remove();
            }
            if (!options.isEmpty()) continue;
            groupIt.remove();
        }
        if (defaultSandboxPolicy != null) {
            builder.startReturn().type(types.SandboxPolicy).string(".", defaultSandboxPolicy).end();
        } else if (groupedOptions.isEmpty()) {
            builder.startReturn().type(types.SandboxPolicy).string(".", maxEntry).end();
        } else {
            builder.startSwitch().string("optionName").end().startBlock();
            for (Map.Entry entry : groupedOptions.entrySet()) {
                for (OptionInfo optionInfo : (List)entry.getValue()) {
                    assert (!optionInfo.optionMap);
                    builder.startCase().doubleQuote(optionInfo.name).end().startCaseBlock();
                    builder.startReturn().type(types.SandboxPolicy).string(".", (String)entry.getKey()).end();
                    builder.end();
                }
            }
            builder.caseDefault().startCaseBlock();
            builder.startReturn().type(types.SandboxPolicy).string(".", maxEntry).end();
            builder.end();
            builder.end();
        }
        descriptors.add(codeExecutableElement);
        CodeExecutableElement iteratorMethod = CodeExecutableElement.clone(ElementUtils.findExecutableElement(types.OptionDescriptors, "iterator"));
        iteratorMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
        builder = iteratorMethod.createBuilder();
        builder.startReturn();
        if (model.options.isEmpty()) {
            builder.startStaticCall(context.getType(Collections.class), "<OptionDescriptor> emptyList().iterator").end();
        } else {
            builder.startStaticCall(context.getType(Arrays.class), "asList");
            for (OptionInfo info : model.options) {
                builder.startGroup();
                builder.startIndention();
                builder.newLine();
                builder.tree(OptionProcessor.createBuildOptionDescriptor(context, info));
                builder.end();
                builder.end();
            }
            builder.end();
            builder.newLine();
            builder.startCall("", "iterator").end();
        }
        builder.end();
        descriptors.add(iteratorMethod);
        return descriptors;
    }

    private static CodeTree createBuildOptionDescriptor(ProcessorContext context, OptionInfo info) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        TruffleTypes types = context.getTypes();
        builder.startStaticCall(types.OptionDescriptor, "newBuilder");
        VariableElement var = info.field;
        builder.staticReference(var.getEnclosingElement().asType(), var.getSimpleName().toString());
        builder.doubleQuote(info.name);
        builder.end();
        if (info.deprecated) {
            builder.startCall("", "deprecated").string("true").end();
            OptionProcessor.addCallWithStringWithPossibleNewlines(builder, context, "deprecationMessage", info.deprecationMessage);
        } else {
            builder.startCall("", "deprecated").string("false").end();
        }
        OptionProcessor.addCallWithStringWithPossibleNewlines(builder, context, "help", info.help);
        OptionProcessor.addCallWithStringWithPossibleNewlines(builder, context, "usageSyntax", info.usageSyntax);
        builder.startCall("", "category").staticReference(types.OptionCategory, info.category).end();
        builder.startCall("", "stability").staticReference(types.OptionStability, info.stability).end();
        builder.startCall("", "build").end();
        return builder.build();
    }

    private static void addCallWithStringWithPossibleNewlines(CodeTreeBuilder builder, ProcessorContext context, String callName, String value) {
        if (value.contains("%n")) {
            builder.startCall("", callName).startStaticCall(context.getType(String.class), "format").doubleQuote(value).end().end();
        } else {
            builder.startCall("", callName).doubleQuote(value).end();
        }
    }

    static class OptionsInfo {
        final Element type;
        final List<OptionInfo> options = new ArrayList<OptionInfo>();

        OptionsInfo(Element topDeclaringType) {
            this.type = topDeclaringType;
        }
    }

    static class OptionInfo
    implements Comparable<OptionInfo> {
        boolean valid = true;
        final String name;
        final String help;
        final boolean deprecated;
        final boolean optionMap;
        final VariableElement field;
        final AnnotationMirror annotation;
        final String category;
        final String stability;
        final String deprecationMessage;
        final String sandboxPolicy;
        private String usageSyntax;

        OptionInfo(String name, String help, VariableElement field, AnnotationMirror annotation, boolean deprecated, String category, String stability, boolean optionMap, String deprecationMessage, String usageSyntax, String sandboxPolicy) {
            this.name = name;
            this.help = help;
            this.field = field;
            this.annotation = annotation;
            this.deprecated = deprecated;
            this.category = category;
            this.stability = stability;
            this.optionMap = optionMap;
            this.deprecationMessage = deprecationMessage;
            this.usageSyntax = usageSyntax;
            this.sandboxPolicy = sandboxPolicy;
        }

        @Override
        public int compareTo(OptionInfo other) {
            return this.name.compareTo(other.name);
        }
    }
}

