/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import java.util.List;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class CodeAnnotationValue
implements AnnotationValue {
    private final Object value;

    public CodeAnnotationValue(Object value) {
        Objects.requireNonNull(value);
        if (!(value instanceof AnnotationMirror || value instanceof List || value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Double || value instanceof VariableElement || value instanceof Float || value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof String || value instanceof TypeMirror)) {
            throw new IllegalArgumentException("Invalid annotation value type " + value.getClass().getName());
        }
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
        if (this.value instanceof AnnotationMirror) {
            return v.visitAnnotation((AnnotationMirror)this.value, p);
        }
        if (this.value instanceof List) {
            return v.visitArray((List)this.value, p);
        }
        if (this.value instanceof Boolean) {
            return v.visitBoolean((Boolean)this.value, p);
        }
        if (this.value instanceof Byte) {
            return v.visitByte((Byte)this.value, p);
        }
        if (this.value instanceof Character) {
            return v.visitChar(((Character)this.value).charValue(), p);
        }
        if (this.value instanceof Double) {
            return v.visitDouble((Double)this.value, p);
        }
        if (this.value instanceof VariableElement) {
            return v.visitEnumConstant((VariableElement)this.value, p);
        }
        if (this.value instanceof Float) {
            return v.visitFloat(((Float)this.value).floatValue(), p);
        }
        if (this.value instanceof Integer) {
            return v.visitInt((Integer)this.value, p);
        }
        if (this.value instanceof Long) {
            return v.visitLong((Long)this.value, p);
        }
        if (this.value instanceof Short) {
            return v.visitShort((Short)this.value, p);
        }
        if (this.value instanceof String) {
            return v.visitString((String)this.value, p);
        }
        if (this.value instanceof TypeMirror) {
            return v.visitType((TypeMirror)this.value, p);
        }
        return v.visitUnknown(this, p);
    }
}

