/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.diagnosticsagent;

import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.diagnosticsagent.NativeImageDiagnosticsAgent;
import com.oracle.svm.diagnosticsagent.NativeImageDiagnosticsAgentJNIHandleSet;
import com.oracle.svm.jvmtiagentbase.JvmtiAgentBase;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiFrameInfo;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiLineNumberEntry;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

public class JavaStackTraceCreator {
    private static final int LINE_NUMBER_UNAVAILABLE = -1;
    private final JvmtiEnv jvmti;
    private final JNIEnvironment jni;

    public JavaStackTraceCreator(JvmtiEnv jvmti, JNIEnvironment jni) {
        this.jvmti = jvmti;
        this.jni = jni;
    }

    protected void inspectStackTraceElementMethod(JNIMethodId jMethodID) {
    }

    private int getCurrentThreadStackFrameCount() {
        CIntPointer countPointer = (CIntPointer)StackValue.get(CIntPointer.class);
        Support.check((JvmtiError)this.jvmti.getFunctions().GetFrameCount().invoke(this.jvmti, (JNIObjectHandle)JNIObjectHandles.nullHandle(), countPointer));
        return countPointer.read();
    }

    private String getSourceFileName(JNIObjectHandle clazz) {
        CCharPointerPointer sourceFileNamePointer = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        JvmtiError errorCode = this.jvmti.getFunctions().GetSourceFileName().invoke(this.jvmti, clazz, sourceFileNamePointer);
        if (errorCode == JvmtiError.JVMTI_ERROR_NONE) {
            String sourceFileName = Support.fromCString((CCharPointer)sourceFileNamePointer.read());
            this.jvmti.getFunctions().Deallocate().invoke(this.jvmti, (PointerBase)sourceFileNamePointer.read());
            return sourceFileName;
        }
        return null;
    }

    private static int getFrameSourceLineNumber(JvmtiEnv jvmti, JvmtiFrameInfo frameInfo) {
        JvmtiLineNumberEntry entry;
        CIntPointer entryCountPointer = (CIntPointer)StackValue.get(CIntPointer.class);
        WordPointer lineEntryTablePointer = (WordPointer)StackValue.get(WordPointer.class);
        JvmtiError errorCode = jvmti.getFunctions().GetLineNumberTable().invoke(jvmti, frameInfo.getMethod(), entryCountPointer, lineEntryTablePointer);
        if (errorCode == JvmtiError.JVMTI_ERROR_MUST_POSSESS_CAPABILITY || errorCode == JvmtiError.JVMTI_ERROR_ABSENT_INFORMATION) {
            return -1;
        }
        Support.check((JvmtiError)errorCode);
        int entryCount = entryCountPointer.read();
        Pointer lineEntryTable = (Pointer)lineEntryTablePointer.read();
        VMError.guarantee((boolean)lineEntryTable.isNonNull());
        int previousLineNumber = -1;
        for (int i = 0; i < entryCount && (entry = (JvmtiLineNumberEntry)lineEntryTable.add(i * SizeOf.get(JvmtiLineNumberEntry.class))).getStartLocation() <= frameInfo.getLocation(); ++i) {
            previousLineNumber = entry.getLineNumber();
        }
        jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)lineEntryTable);
        return previousLineNumber;
    }

    private StackTraceElement constructStackTraceElement(JvmtiFrameInfo frameInfo) {
        JNIObjectHandle declaringClass = Support.getMethodDeclaringClass((JNIMethodId)frameInfo.getMethod());
        String methodName = Support.getMethodNameOr((JNIMethodId)frameInfo.getMethod(), (String)"");
        String declaringClassName = Support.getClassNameOr((JNIEnvironment)this.jni, (JNIObjectHandle)declaringClass, (String)"", (String)"");
        CCharPointer isNativePtr = (CCharPointer)StackValue.get(CCharPointer.class);
        String fileName = null;
        int lineNumber = -1;
        JvmtiError errorCode = this.jvmti.getFunctions().IsMethodNative().invoke(this.jvmti, frameInfo.getMethod(), isNativePtr);
        if (errorCode == JvmtiError.JVMTI_ERROR_NONE && isNativePtr.read() == 0) {
            fileName = this.getSourceFileName(declaringClass);
            lineNumber = JavaStackTraceCreator.getFrameSourceLineNumber(this.jvmti, frameInfo);
        }
        return new StackTraceElement(declaringClassName, methodName, fileName, lineNumber);
    }

    public JNIObjectHandle getStackTraceArray() {
        int threadStackFrameCount = this.getCurrentThreadStackFrameCount();
        int frameInfoSize = SizeOf.get(JvmtiFrameInfo.class);
        Pointer stackFramesPtr = (Pointer)UnmanagedMemory.malloc((int)(frameInfoSize * threadStackFrameCount));
        CIntPointer readStackFramesPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        Support.check((JvmtiError)this.jvmti.getFunctions().GetStackTrace().invoke(this.jvmti, (JNIObjectHandle)JNIObjectHandles.nullHandle(), 0, threadStackFrameCount, (WordPointer)stackFramesPtr, readStackFramesPtr));
        VMError.guarantee((readStackFramesPtr.read() == threadStackFrameCount ? 1 : 0) != 0);
        NativeImageDiagnosticsAgent agent = (NativeImageDiagnosticsAgent)JvmtiAgentBase.singleton();
        JNIObjectHandle stackTraceArray = this.jni.getFunctions().getNewObjectArray().invoke(this.jni, threadStackFrameCount, ((NativeImageDiagnosticsAgentJNIHandleSet)agent.handles()).javaLangStackTraceElement, (JNIObjectHandle)JNIObjectHandles.nullHandle());
        for (int i = 0; i < threadStackFrameCount; ++i) {
            JvmtiFrameInfo frameInfo = (JvmtiFrameInfo)stackFramesPtr.add(i * frameInfoSize);
            StackTraceElement stackTraceElement = this.constructStackTraceElement(frameInfo);
            JNIObjectHandle classNameHandle = Support.toJniString((JNIEnvironment)this.jni, (String)stackTraceElement.getClassName());
            JNIObjectHandle methodNameHandle = Support.toJniString((JNIEnvironment)this.jni, (String)stackTraceElement.getMethodName());
            JNIObjectHandle sourceFileNameHandle = Support.toJniString((JNIEnvironment)this.jni, (String)stackTraceElement.getFileName());
            int lineNumber = stackTraceElement.getLineNumber();
            JNIObjectHandle stackTraceElementHandle = Support.newObjectLLLJ((JNIEnvironment)this.jni, (JNIObjectHandle)((NativeImageDiagnosticsAgentJNIHandleSet)agent.handles()).javaLangStackTraceElement, (JNIMethodId)((NativeImageDiagnosticsAgentJNIHandleSet)agent.handles()).javaLangStackTraceElementCtor4, (JNIObjectHandle)classNameHandle, (JNIObjectHandle)methodNameHandle, (JNIObjectHandle)sourceFileNameHandle, (long)lineNumber);
            this.jni.getFunctions().getSetObjectArrayElement().invoke(this.jni, stackTraceArray, i, stackTraceElementHandle);
            this.inspectStackTraceElementMethod(frameInfo.getMethod());
        }
        UnmanagedMemory.free((PointerBase)stackFramesPtr);
        return stackTraceArray;
    }
}

