/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.common.option.CommonOptions;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.ExitStatus;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.driver.APIOptionHandler;
import com.oracle.svm.driver.BundleSupport;
import com.oracle.svm.driver.CmdLineOptionHandler;
import com.oracle.svm.driver.DefaultOptionHandler;
import com.oracle.svm.driver.MacroOption;
import com.oracle.svm.driver.MacroOptionHandler;
import com.oracle.svm.driver.MemoryUtil;
import com.oracle.svm.driver.WindowsBuildEnvironmentUtil;
import com.oracle.svm.driver.metainf.MetaInfFileType;
import com.oracle.svm.driver.metainf.NativeImageMetaInfResourceProcessor;
import com.oracle.svm.driver.metainf.NativeImageMetaInfWalker;
import com.oracle.svm.hosted.NativeImageGeneratorRunner;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ProcessProperties;

public class NativeImage {
    private static final String DEFAULT_GENERATOR_CLASS_NAME = NativeImageGeneratorRunner.class.getName();
    private static final String DEFAULT_GENERATOR_MODULE_NAME = NativeImageGeneratorRunner.class.getModule().getName();
    private static final String DEFAULT_GENERATOR_9PLUS_SUFFIX = "$JDK9Plus";
    private static final String CUSTOM_SYSTEM_CLASS_LOADER = NativeImageSystemClassLoader.class.getCanonicalName();
    static final boolean IS_AOT = Boolean.getBoolean("com.oracle.graalvm.isaot");
    static final String platform = NativeImage.getPlatform();
    static final String graalvmVendor = VM.getVendor();
    static final String graalvmVendorUrl = VM.getVendorUrl();
    static final String graalvmVendorVersion = VM.getVendorVersion();
    static final String graalvmVersion = System.getProperty("org.graalvm.version", "dev");
    static final Map<String, String[]> graalCompilerFlags = NativeImage.getCompilerFlags();
    static Boolean useJVMCINativeLibrary = null;
    private static final String usageText = NativeImage.getResource("/Usage.txt");
    final CmdLineOptionHandler cmdLineOptionHandler;
    final DefaultOptionHandler defaultOptionHandler;
    final APIOptionHandler apiOptionHandler;
    public static final String oH = "-H:";
    static final String oHEnabled = "-H:+";
    static final String oHDisabled = "-H:-";
    static final String oR = "-R:";
    final String enablePrintFlags = CommonOptions.PrintFlags.getName();
    final String enablePrintFlagsWithExtraHelp = CommonOptions.PrintFlagsWithExtraHelp.getName();
    final String oHModule = NativeImage.oH(SubstrateOptions.Module);
    final String oHClass = NativeImage.oH(SubstrateOptions.Class);
    final String oHName = NativeImage.oH(SubstrateOptions.Name);
    final String oHPath = NativeImage.oH(SubstrateOptions.Path);
    final String oHEnableSharedLibraryFlag = NativeImage.oHEnabled((OptionKey<Boolean>)SubstrateOptions.SharedLibrary);
    final String oHEnableBuildOutputColorful = NativeImage.oHEnabled((OptionKey<Boolean>)SubstrateOptions.BuildOutputColorful);
    final String oHEnableBuildOutputProgress = NativeImage.oHEnabled((OptionKey<Boolean>)SubstrateOptions.BuildOutputProgress);
    final String oHEnableBuildOutputLinks = NativeImage.oHEnabled((OptionKey<Boolean>)SubstrateOptions.BuildOutputLinks);
    final String oHCLibraryPath = NativeImage.oH(SubstrateOptions.CLibraryPath);
    final String oHFallbackThreshold = NativeImage.oH(SubstrateOptions.FallbackThreshold);
    final String oHFallbackExecutorJavaArg = NativeImage.oH(FallbackExecutor.Options.FallbackExecutorJavaArg);
    final String oRRuntimeJavaArg = NativeImage.oR(FallbackExecutor.Options.FallbackExecutorRuntimeJavaArg);
    final String oHTraceClassInitialization = NativeImage.oH(SubstrateOptions.TraceClassInitialization);
    final String oHTraceObjectInstantiation = NativeImage.oH(SubstrateOptions.TraceObjectInstantiation);
    final String oHTargetPlatform = NativeImage.oH(SubstrateOptions.TargetPlatform);
    final String oHInspectServerContentPath = NativeImage.oH(PointstoOptions.InspectServerContentPath);
    final String oHDeadlockWatchdogInterval = NativeImage.oH(SubstrateOptions.DeadlockWatchdogInterval);
    final Map<String, String> imageBuilderEnvironment = new HashMap<String, String>();
    private final ArrayList<String> imageBuilderArgs = new ArrayList();
    private final LinkedHashSet<Path> imageBuilderModulePath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageBuilderClasspath = new LinkedHashSet();
    private final ArrayList<String> imageBuilderJavaArgs = new ArrayList();
    private final LinkedHashSet<Path> imageClasspath = new LinkedHashSet();
    private final LinkedHashSet<Path> imageModulePath = new LinkedHashSet();
    private final ArrayList<String> customJavaArgs = new ArrayList();
    private final LinkedHashSet<Path> customImageClasspath = new LinkedHashSet();
    private final ArrayList<OptionHandler<? extends NativeImage>> optionHandlers = new ArrayList();
    protected final BuildConfiguration config;
    final Map<String, String> userConfigProperties = new HashMap<String, String>();
    private final Map<String, String> propertyFileSubstitutionValues = new HashMap<String, String>();
    private int verbose = Boolean.valueOf(System.getenv("VERBOSE_GRAALVM_LAUNCHERS")) != false ? 1 : 0;
    private boolean diagnostics = false;
    Path diagnosticsDir;
    private boolean jarOptionMode = false;
    private boolean moduleOptionMode = false;
    private boolean dryRun = false;
    private String printFlagsOptionQuery = null;
    private String printFlagsWithExtraHelpOptionQuery = null;
    final MacroOption.Registry optionRegistry;
    private final List<ExcludeConfig> excludedConfigs = new ArrayList<ExcludeConfig>();
    private final LinkedHashSet<String> addModules = new LinkedHashSet();
    private final LinkedHashSet<String> limitModules = new LinkedHashSet();
    private long imageBuilderPid = -1L;
    BundleSupport bundleSupport;
    private final DriverMetaInfProcessor metaInfProcessor;
    static final String CONFIG_FILE_ENV_VAR_KEY = "NATIVE_IMAGE_CONFIG_FILE";
    private String targetPlatform = null;
    private String targetOS = null;
    private String targetArch = null;
    String mainClass;
    String imageName;
    Path imagePath;
    private static final Function<BuildConfiguration, NativeImage> defaultNativeImageProvider = NativeImage::new;
    LinkedHashSet<String> builderModuleNames = null;
    private static String deletedFileSuffix = ".deleted";

    private static String getPlatform() {
        return (OS.getCurrent().className + "-" + SubstrateUtil.getArchitectureName()).toLowerCase();
    }

    private static Map<String, String[]> getCompilerFlags() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String versionTag : NativeImage.getResource(NativeImage.flagsFileName("versions")).split("\n")) {
            result.put(versionTag, NativeImage.getResource(NativeImage.flagsFileName(versionTag)).split("\n"));
        }
        return result;
    }

    private static String flagsFileName(String versionTag) {
        return "/graal-compiler-flags-" + versionTag + ".config";
    }

    static String getResource(String resourceName) {
        String string;
        block8: {
            InputStream input = NativeImage.class.getResourceAsStream(resourceName);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
                String resourceString = reader.lines().collect(Collectors.joining("\n"));
                string = resourceString.replace("%pathsep%", File.pathSeparator);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    VMError.shouldNotReachHere((Throwable)e);
                    return null;
                }
            }
            input.close();
        }
        return string;
    }

    private static <T> String oH(OptionKey<T> option) {
        return oH + option.getName() + "=";
    }

    private static <T> String oH(OptionKey<T> option, String origin) {
        VMError.guarantee((origin != null && !origin.contains("=") ? 1 : 0) != 0);
        return oH + option.getName() + "@" + origin + "=";
    }

    private static String oHEnabled(OptionKey<Boolean> option) {
        return oHEnabled + option.getName();
    }

    private static String oHDisabled(OptionKey<Boolean> option) {
        return oHDisabled + option.getName();
    }

    private static <T> String oR(OptionKey<T> option) {
        return oR + option.getName() + "=";
    }

    private ArrayList<String> createFallbackBuildArgs() {
        Path imagePathPath;
        ArrayList<String> buildArgs = new ArrayList<String>();
        Collection fallbackSystemProperties = this.customJavaArgs.stream().filter(s -> s.startsWith("-D")).collect(Collectors.toCollection(LinkedHashSet::new));
        for (Object property : fallbackSystemProperties) {
            buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorSystemProperty) + (String)property);
        }
        List runtimeJavaArgs = this.imageBuilderArgs.stream().filter(s -> s.startsWith(this.oRRuntimeJavaArg)).collect(Collectors.toList());
        for (Object runtimeJavaArg : runtimeJavaArgs) {
            buildArgs.add((String)runtimeJavaArg);
        }
        List fallbackExecutorJavaArgs = this.imageBuilderArgs.stream().filter(s -> s.startsWith(this.oHFallbackExecutorJavaArg)).collect(Collectors.toList());
        for (String fallbackExecutorJavaArg : fallbackExecutorJavaArgs) {
            buildArgs.add(fallbackExecutorJavaArg);
        }
        buildArgs.add(NativeImage.oHEnabled((OptionKey<Boolean>)SubstrateOptions.BuildOutputSilent));
        buildArgs.add(NativeImage.oHEnabled((OptionKey<Boolean>)SubstrateOptions.ParseRuntimeOptions));
        try {
            imagePathPath = this.canonicalize(this.imagePath);
        }
        catch (NativeImageError | InvalidPathException e) {
            throw NativeImage.showError("The given " + this.oHPath + String.valueOf(this.imagePath) + " argument does not specify a valid path", e);
        }
        boolean[] isPortable = new boolean[]{true};
        String classpathString = this.imageClasspath.stream().map(path -> {
            try {
                return imagePathPath.relativize((Path)path);
            }
            catch (IllegalArgumentException e) {
                isPortable[0] = false;
                return path;
            }
        }).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        if (!isPortable[0]) {
            NativeImage.showWarning("The produced fallback image will not be portable, because not all classpath entries could be relativized (e.g., they are on another drive).");
        }
        buildArgs.add(this.oHPath + imagePathPath.toString());
        buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorClasspath) + classpathString);
        buildArgs.add(NativeImage.oH(FallbackExecutor.Options.FallbackExecutorMainClass) + this.mainClass);
        buildArgs.add(NativeImage.oHDisabled((OptionKey<Boolean>)SubstrateOptions.DetectUserDirectoriesInImageHeap));
        buildArgs.add(FallbackExecutor.class.getName());
        buildArgs.add(this.imageName);
        this.defaultOptionHandler.addFallbackBuildArgs(buildArgs);
        for (OptionHandler<? extends NativeImage> handler : this.optionHandlers) {
            handler.addFallbackBuildArgs(buildArgs);
        }
        return buildArgs;
    }

    protected NativeImage(BuildConfiguration config) {
        this.config = config;
        this.metaInfProcessor = new DriverMetaInfProcessor();
        String configFile = System.getenv(CONFIG_FILE_ENV_VAR_KEY);
        if (configFile != null && !configFile.isEmpty()) {
            try {
                this.userConfigProperties.putAll(NativeImage.loadProperties(this.canonicalize(Paths.get(configFile, new String[0]))));
            }
            catch (NativeImageError | Exception e) {
                NativeImage.showError("Invalid environment variable NATIVE_IMAGE_CONFIG_FILE", e);
            }
        }
        this.addPlainImageBuilderArg(this.oHPath + String.valueOf(config.getWorkingDirectory()));
        this.optionRegistry = new MacroOption.Registry();
        this.optionRegistry.addMacroOptionRoot(config.rootDir);
        this.optionRegistry.addMacroOptionRoot(config.rootDir.resolve(Paths.get("lib", "svm")));
        this.cmdLineOptionHandler = new CmdLineOptionHandler(this);
        this.defaultOptionHandler = new DefaultOptionHandler(this);
        this.registerOptionHandler(this.defaultOptionHandler);
        this.apiOptionHandler = new APIOptionHandler(this);
        this.registerOptionHandler(this.apiOptionHandler);
        this.registerOptionHandler(new MacroOptionHandler(this));
    }

    void addMacroOptionRoot(Path configDir) {
        Path origRootDir = this.canonicalize(configDir);
        Path rootDir = this.useBundle() ? this.bundleSupport.substituteClassPath(origRootDir) : origRootDir;
        this.optionRegistry.addMacroOptionRoot(rootDir);
    }

    protected void registerOptionHandler(OptionHandler<? extends NativeImage> handler) {
        this.optionHandlers.add(handler);
    }

    private List<String> getDefaultNativeImageArgs() {
        String defaultNativeImageArgs = this.userConfigProperties.get("NativeImageArgs");
        if (defaultNativeImageArgs != null && !defaultNativeImageArgs.isEmpty()) {
            String optionName = BundleSupport.BundleOptionVariants.apply.optionName();
            if (this.config.getBuildArgs().stream().noneMatch(arg -> arg.startsWith(optionName + "="))) {
                return List.of(defaultNativeImageArgs.split(" "));
            }
            NativeImage.showWarning(String.format("Option %s in use. Ignoring args from file specified with environment variable %s.", optionName, CONFIG_FILE_ENV_VAR_KEY));
        }
        return List.of();
    }

    static void ensureDirectoryExists(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw NativeImage.showError("File " + String.valueOf(dir) + " is not a directory");
            }
        } else {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw NativeImage.showError("Could not create directory " + String.valueOf(dir));
            }
        }
    }

    private void prepareImageBuildArgs() {
        this.addImageBuilderJavaArgs("-Xss10m");
        this.addImageBuilderJavaArgs(MemoryUtil.determineMemoryFlags());
        this.addImageBuilderJavaArgs("-Djava.awt.headless=true");
        this.addImageBuilderJavaArgs("-Dorg.graalvm.vendor=" + graalvmVendor);
        this.addImageBuilderJavaArgs("-Dorg.graalvm.vendorurl=" + graalvmVendorUrl);
        this.addImageBuilderJavaArgs("-Dorg.graalvm.vendorversion=" + graalvmVendorVersion);
        this.addImageBuilderJavaArgs("-Dorg.graalvm.version=" + graalvmVersion);
        this.addImageBuilderJavaArgs("-Dcom.oracle.graalvm.isaot=true");
        this.addImageBuilderJavaArgs("-Djava.system.class.loader=" + CUSTOM_SYSTEM_CLASS_LOADER);
        this.addImageBuilderJavaArgs("-Xshare:off");
        this.config.getImageClasspath().forEach(this::addCustomImageClasspath);
    }

    private void completeOptionArgs() {
        LinkedHashSet<MacroOption.EnabledOption> enabledOptions = this.optionRegistry.getEnabledOptions();
        if (!enabledOptions.isEmpty()) {
            this.addPlainImageBuilderArg(this.oHFallbackThreshold + "0");
        }
        NativeImage.consolidateListArgs(this.imageBuilderJavaArgs, "-Dpolyglot.engine.PreinitializeContexts=", ",", Function.identity());
        NativeImage.consolidateListArgs(this.imageBuilderJavaArgs, "-Dpolyglot.image-build-time.PreinitializeContexts=", ",", Function.identity());
    }

    protected static boolean replaceArg(Collection<String> args, String argPrefix, String argSuffix) {
        boolean elementsRemoved = args.removeIf(arg -> arg.startsWith(argPrefix));
        args.add(argPrefix + argSuffix);
        return elementsRemoved;
    }

    private static LinkedHashSet<String> collectListArgs(Collection<String> args, String argPrefix, String delimiter) {
        LinkedHashSet<String> allEntries = new LinkedHashSet<String>();
        for (String arg : args) {
            String argEntriesRaw;
            if (!arg.startsWith(argPrefix) || (argEntriesRaw = arg.substring(argPrefix.length())).isEmpty()) continue;
            allEntries.addAll(Arrays.asList(argEntriesRaw.split(delimiter)));
        }
        return allEntries;
    }

    private static void consolidateListArgs(Collection<String> args, String argPrefix, String delimiter, Function<String, String> mapFunc) {
        LinkedHashSet<String> allEntries = NativeImage.collectListArgs(args, argPrefix, delimiter);
        if (!allEntries.isEmpty()) {
            NativeImage.replaceArg(args, argPrefix, allEntries.stream().map(mapFunc).collect(Collectors.joining(delimiter)));
        }
    }

    private void processClasspathNativeImageMetaInf(Path classpathEntry) {
        try {
            NativeImageMetaInfWalker.walkMetaInfForCPEntry(classpathEntry, this.metaInfProcessor);
        }
        catch (NativeImageMetaInfWalker.MetaInfWalkException e) {
            throw NativeImage.showError(e.getMessage(), e.cause);
        }
    }

    public void addExcludeConfig(Pattern jarPattern, Pattern resourcePattern) {
        this.excludedConfigs.add(new ExcludeConfig(jarPattern, resourcePattern));
    }

    static String injectHostedOptionOrigin(String option, String origin) {
        if (origin != null && option.startsWith(oH)) {
            char boolPrefix;
            String optionOriginSeparator = "@";
            int eqIndex = option.indexOf(61);
            char c = boolPrefix = option.length() > oH.length() ? option.charAt(oH.length()) : (char)'\u0000';
            if (boolPrefix == '-' || boolPrefix == '+') {
                if (eqIndex != -1) {
                    NativeImage.showError("Invalid boolean native-image hosted-option " + option + " at " + origin);
                }
                return option + optionOriginSeparator + origin;
            }
            if (eqIndex == -1) {
                NativeImage.showError("Invalid native-image hosted-option " + option + " at " + origin);
            }
            String front = option.substring(0, eqIndex);
            String back = option.substring(eqIndex);
            return front + optionOriginSeparator + origin + back;
        }
        return option;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean processJarManifestMainAttributes(Path jarFilePath, BiConsumer<Path, Attributes> manifestConsumer) {
        try (JarFile jarFile = new JarFile(jarFilePath.toFile());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            manifestConsumer.accept(jarFilePath, manifest.getMainAttributes());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw NativeImage.showError("Invalid or corrupt jarfile " + String.valueOf(jarFilePath), e);
        }
    }

    void handleMainClassAttribute(Path jarFilePath, Attributes mainAttributes) {
        String mainClassValue = mainAttributes.getValue("Main-Class");
        if (mainClassValue == null) {
            NativeImage.showError("No main manifest attribute, in " + String.valueOf(jarFilePath));
        }
        String origin = "manifest from " + String.valueOf(jarFilePath.toUri());
        this.addPlainImageBuilderArg(NativeImage.injectHostedOptionOrigin(this.oHClass + mainClassValue, origin));
    }

    void handleClassPathAttribute(LinkedHashSet<Path> destination, Path jarFilePath, Attributes mainAttributes) {
        String classPathValue = mainAttributes.getValue("Class-Path");
        if (classPathValue != null) {
            Path origJarFilePath = null;
            for (String cp : classPathValue.split(" +")) {
                Path manifestClassPath = Path.of(cp, new String[0]);
                if (!manifestClassPath.isAbsolute()) {
                    Path relativeManifestClassPath = manifestClassPath;
                    manifestClassPath = jarFilePath.getParent().resolve(relativeManifestClassPath);
                    if (this.useBundle() && !Files.exists(manifestClassPath, new LinkOption[0])) {
                        if (origJarFilePath == null) {
                            origJarFilePath = this.bundleSupport.originalPath(jarFilePath);
                        }
                        if (origJarFilePath == null) {
                            assert (false) : "Manifest Class-Path handling failed. No original path for " + String.valueOf(jarFilePath) + " available.";
                            break;
                        }
                        manifestClassPath = origJarFilePath.getParent().resolve(relativeManifestClassPath);
                    }
                }
                this.addImageClasspathEntry(destination, manifestClassPath.normalize(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int completeImageBuild() {
        List<Path> imageProvidedJars;
        List<String> leftoverArgs = this.processNativeImageArgs();
        this.config.getBuilderClasspath().forEach(this::addImageBuilderClasspath);
        if (this.config.getBuilderInspectServerPath() != null) {
            this.addPlainImageBuilderArg(this.oHInspectServerContentPath + String.valueOf(this.config.getBuilderInspectServerPath()));
        }
        this.config.getBuilderModulePath().forEach(this::addImageBuilderModulePath);
        String upgradeModulePath = this.config.getBuilderUpgradeModulePath().stream().map(p -> this.canonicalize((Path)p).toString()).collect(Collectors.joining(File.pathSeparator));
        if (!upgradeModulePath.isEmpty()) {
            this.addImageBuilderJavaArgs(Arrays.asList("--upgrade-module-path", upgradeModulePath));
        }
        this.completeOptionArgs();
        this.addTargetArguments();
        String clibrariesPath = this.targetPlatform != null ? this.targetPlatform : platform;
        String clibrariesBuilderArg = this.config.getBuilderCLibrariesPaths().stream().map(path -> this.canonicalize(path.resolve(clibrariesPath)).toString()).collect(Collectors.joining(",", this.oHCLibraryPath, ""));
        this.imageBuilderArgs.add(0, clibrariesBuilderArg);
        boolean printFlags = false;
        if (this.printFlagsOptionQuery != null) {
            printFlags = true;
            this.addPlainImageBuilderArg(oH + this.enablePrintFlags + "=" + this.printFlagsOptionQuery);
            this.addPlainImageBuilderArg(oR + this.enablePrintFlags + "=" + this.printFlagsOptionQuery);
        } else if (this.printFlagsWithExtraHelpOptionQuery != null) {
            printFlags = true;
            this.addPlainImageBuilderArg(oH + this.enablePrintFlagsWithExtraHelp + "=" + this.printFlagsWithExtraHelpOptionQuery);
            this.addPlainImageBuilderArg(oR + this.enablePrintFlagsWithExtraHelp + "=" + this.printFlagsWithExtraHelpOptionQuery);
        }
        if (this.shouldAddCWDToCP()) {
            if (this.useBundle()) {
                throw NativeImage.showError("Bundle support requires -cp or -p to be set (implicit current directory classpath unsupported).");
            }
            this.addImageClasspath(Paths.get(".", new String[0]));
        }
        this.imageClasspath.addAll(this.customImageClasspath);
        this.imageBuilderJavaArgs.add("-Djdk.internal.lambda.disableEagerInitialization=true");
        this.imageBuilderJavaArgs.add("-Djdk.internal.lambda.eagerlyInitialize=false");
        this.imageBuilderJavaArgs.add("-Djava.lang.invoke.InnerClassLambdaMetafactory.initializeLambdas=false");
        boolean afterOption = false;
        for (String arg2 : this.customJavaArgs) {
            if (arg2.startsWith("-")) {
                afterOption = true;
                continue;
            }
            if (!afterOption) {
                NativeImage.showError("Found invalid image builder Java VM argument: " + arg2);
                continue;
            }
            afterOption = false;
        }
        this.addImageBuilderJavaArgs(this.customJavaArgs.toArray(new String[0]));
        this.imageBuilderJavaArgs.addAll(this.getAgentArguments());
        this.mainClass = NativeImage.getHostedOptionFinalArgumentValue(this.imageBuilderArgs, this.oHClass);
        boolean buildExecutable = this.imageBuilderArgs.stream().noneMatch(arg -> arg.contains(this.oHEnableSharedLibraryFlag));
        boolean listModules = this.imageBuilderArgs.stream().anyMatch(arg -> arg.contains("-H:+ListModules"));
        if (printFlags |= this.imageBuilderArgs.stream().anyMatch(arg -> arg.contains("-H:MicroArchitecture=list"))) {
            this.addPlainImageBuilderArg(this.oHName + "dummy-image");
        } else {
            ArrayList<String> extraImageArgs = new ArrayList<String>();
            ListIterator<String> leftoverArgsItr = leftoverArgs.listIterator();
            while (leftoverArgsItr.hasNext()) {
                String leftoverArg = leftoverArgsItr.next();
                if (leftoverArg.startsWith("-")) continue;
                leftoverArgsItr.remove();
                extraImageArgs.add(leftoverArg);
            }
            if (!this.jarOptionMode) {
                boolean hasMainClass;
                boolean explicitMainClass = NativeImage.getHostedOptionFinalArgumentValue(this.imageBuilderArgs, this.oHClass) != null;
                String mainClassModule = NativeImage.getHostedOptionFinalArgumentValue(this.imageBuilderArgs, this.oHModule);
                boolean hasMainClassModule = mainClassModule != null && !mainClassModule.isEmpty();
                boolean bl = hasMainClass = this.mainClass != null && !this.mainClass.isEmpty();
                if (extraImageArgs.isEmpty()) {
                    if (buildExecutable && !hasMainClassModule && !hasMainClass && !listModules) {
                        String moduleMsg = this.config.modulePathBuild ? " (or <module>/<mainclass>)" : "";
                        NativeImage.showError("Please specify class" + moduleMsg + " containing the main entry point method. (see --help)");
                    }
                } else if (!this.moduleOptionMode) {
                    explicitMainClass = true;
                    this.mainClass = (String)extraImageArgs.remove(0);
                    this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Class, "explicit main-class") + this.mainClass);
                }
                if (extraImageArgs.isEmpty()) {
                    if (NativeImage.getHostedOptionFinalArgumentValue(this.imageBuilderArgs, this.oHName) == null) {
                        if (explicitMainClass) {
                            this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "main-class lower case as image name") + this.mainClass.toLowerCase());
                        } else if (NativeImage.getHostedOptionFinalArgumentValue(this.imageBuilderArgs, this.oHName) == null) {
                            if (hasMainClassModule) {
                                this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "image-name from module-name") + mainClassModule.toLowerCase());
                            } else if (!listModules) {
                                throw NativeImage.showError("Missing image-name. Use -o <imagename> to provide one.");
                            }
                        }
                    }
                } else {
                    this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "explicit image name") + (String)extraImageArgs.remove(0));
                }
            } else if (!extraImageArgs.isEmpty()) {
                this.imageBuilderArgs.add(NativeImage.oH(SubstrateOptions.Name, "explicit image name") + (String)extraImageArgs.remove(0));
            }
            if (!extraImageArgs.isEmpty()) {
                String prefix = "Unknown argument" + (extraImageArgs.size() == 1 ? ": " : "s: ");
                NativeImage.showError(extraImageArgs.stream().collect(Collectors.joining(", ", prefix, "")));
            }
        }
        ArgumentEntry imageNameEntry = NativeImage.getHostedOptionFinalArgument(this.imageBuilderArgs, this.oHName).orElseThrow();
        this.imageName = imageNameEntry.value;
        ArgumentEntry imagePathEntry = NativeImage.getHostedOptionFinalArgument(this.imageBuilderArgs, this.oHPath).orElseThrow();
        this.imagePath = Path.of(imagePathEntry.value, new String[0]);
        Path imageNamePath = Path.of(this.imageName, new String[0]);
        Path imageNamePathParent = imageNamePath.getParent();
        if (imageNamePathParent != null) {
            this.imageName = imageNamePath.getFileName().toString();
            if (!imageNamePathParent.isAbsolute()) {
                imageNamePathParent = this.imagePath.resolve(imageNamePathParent);
            }
            if (!this.useBundle()) {
                if (!Files.isDirectory(imageNamePathParent, new LinkOption[0])) {
                    throw NativeImage.showError("Writing image to non-existent directory " + String.valueOf(imageNamePathParent) + " is not allowed. Create the missing directory if you want the image to be written to that location.");
                }
                if (!Files.isWritable(imageNamePathParent)) {
                    throw NativeImage.showError("Writing image to directory without write access " + String.valueOf(imageNamePathParent) + " is not possible. Ensure the directory has write access or specify image path with write access.");
                }
            }
            this.imagePath = imageNamePathParent;
            NativeImage.updateArgumentEntryValue(this.imageBuilderArgs, imageNameEntry, this.imageName);
            NativeImage.updateArgumentEntryValue(this.imageBuilderArgs, imagePathEntry, this.imagePath.toString());
        }
        if (this.useBundle()) {
            Object bundleName = this.imageName.endsWith(".nib") ? this.imageName : this.imageName + ".nib";
            this.bundleSupport.updateBundleLocation(this.imagePath.resolve((String)bundleName), false);
            this.imagePath = this.bundleSupport.substituteImagePath(this.imagePath);
            NativeImage.updateArgumentEntryValue(this.imageBuilderArgs, imagePathEntry, this.imagePath.toString());
        }
        if (!leftoverArgs.isEmpty()) {
            String prefix = "Unrecognized option" + (leftoverArgs.size() == 1 ? ": " : "s: ");
            NativeImage.showError(leftoverArgs.stream().collect(Collectors.joining(", ", prefix, "")));
        }
        LinkedHashSet<Path> finalImageModulePath = new LinkedHashSet<Path>(this.imageModulePath);
        LinkedHashSet<Path> finalImageClasspath = new LinkedHashSet<Path>(this.imageClasspath);
        if (this.config.modulePathBuild) {
            imageProvidedJars = this.config.getImageProvidedModulePath();
            finalImageModulePath.addAll(imageProvidedJars);
        } else {
            imageProvidedJars = this.config.getImageProvidedClasspath();
            finalImageClasspath.addAll(imageProvidedJars);
        }
        imageProvidedJars.forEach(this::processClasspathNativeImageMetaInf);
        if (!this.config.buildFallbackImage() && this.imageBuilderArgs.contains(this.oHFallbackThreshold + "10")) {
            return ExitStatus.FALLBACK_IMAGE.getValue();
        }
        if (!this.addModules.isEmpty()) {
            this.imageBuilderJavaArgs.add("-Dorg.graalvm.nativeimage.module.addmods=" + String.join((CharSequence)",", this.addModules));
        }
        if (!this.limitModules.isEmpty()) {
            this.imageBuilderJavaArgs.add("-Dorg.graalvm.nativeimage.module.limitmods=" + String.join((CharSequence)",", this.limitModules));
        }
        if (this.config.modulePathBuild && !finalImageClasspath.isEmpty()) {
            this.imageBuilderJavaArgs.add("--add-modules=ALL-DEFAULT");
        }
        boolean useColorfulOutput = this.configureBuildOutput();
        List<String> finalImageBuilderJavaArgs = Stream.concat(this.config.getBuilderJavaArgs().stream(), this.imageBuilderJavaArgs.stream()).collect(Collectors.toList());
        try {
            int n = this.buildImage(finalImageBuilderJavaArgs, this.imageBuilderClasspath, this.imageBuilderModulePath, this.imageBuilderArgs, finalImageClasspath, finalImageModulePath);
            return n;
        }
        finally {
            if (useColorfulOutput) {
                this.performANSIReset();
            }
        }
    }

    private static void updateArgumentEntryValue(List<String> argList, ArgumentEntry listEntry, String newValue) {
        APIOptionHandler.BuilderArgumentParts argParts = APIOptionHandler.BuilderArgumentParts.from(argList.get(listEntry.index));
        argParts.optionValue = newValue;
        argList.set(listEntry.index, argParts.toString());
    }

    private static String getLocationAgnosticArgPrefix(String argPrefix) {
        VMError.guarantee((argPrefix.startsWith(oH) && argPrefix.endsWith("=") ? 1 : 0) != 0, (String)"argPrefix has to be a hosted option that ends with \"=\"");
        return "^" + argPrefix.substring(0, argPrefix.length() - 1) + "(@[^=]*)?=";
    }

    private static String getHostedOptionFinalArgumentValue(List<String> args, String argPrefix) {
        return NativeImage.getHostedOptionFinalArgument(args, argPrefix).map(entry -> entry.value).orElse(null);
    }

    private static Optional<ArgumentEntry> getHostedOptionFinalArgument(List<String> args, String argPrefix) {
        List<ArgumentEntry> values = NativeImage.getHostedOptionArgumentValues(args, argPrefix);
        return values.isEmpty() ? Optional.empty() : Optional.of(values.get(values.size() - 1));
    }

    private static List<ArgumentEntry> getHostedOptionArgumentValues(List<String> args, String argPrefix) {
        ArrayList<ArgumentEntry> values = new ArrayList<ArgumentEntry>();
        String locationAgnosticArgPrefix = NativeImage.getLocationAgnosticArgPrefix(argPrefix);
        Pattern pattern = Pattern.compile(locationAgnosticArgPrefix);
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            Matcher matcher = pattern.matcher(arg);
            if (!matcher.find()) continue;
            values.add(new ArgumentEntry(i, arg.substring(matcher.group().length())));
        }
        return values;
    }

    private static Boolean getHostedOptionFinalBooleanArgumentValue(List<String> args, OptionKey<Boolean> option) {
        String locationAgnosticBooleanPattern = "^-H:[+-]" + option.getName() + "(@[^=]*)?$";
        Pattern pattern = Pattern.compile(locationAgnosticBooleanPattern);
        Boolean result = null;
        for (String arg : args) {
            Matcher matcher = pattern.matcher(arg);
            if (!matcher.find()) continue;
            result = arg.startsWith(oHEnabled);
        }
        return result;
    }

    private boolean shouldAddCWDToCP() {
        if (this.config.buildFallbackImage() || this.printFlagsOptionQuery != null || this.printFlagsWithExtraHelpOptionQuery != null) {
            return false;
        }
        Optional<MacroOption.EnabledOption> explicitMacroOption = this.optionRegistry.getEnabledOptions(OptionUtils.MacroOptionKind.Macro).stream().filter(MacroOption.EnabledOption::isEnabledFromCommandline).findAny();
        if (explicitMacroOption.isPresent()) {
            return false;
        }
        if (this.useBundle() && this.bundleSupport.loadBundle) {
            return false;
        }
        return this.customImageClasspath.isEmpty() && this.imageModulePath.isEmpty();
    }

    private List<String> getAgentArguments() {
        ArrayList<String> args = new ArrayList<String>();
        Object agentOptions = "";
        List<ArgumentEntry> traceClassInitializationOpts = NativeImage.getHostedOptionArgumentValues(this.imageBuilderArgs, this.oHTraceClassInitialization);
        List<ArgumentEntry> traceObjectInstantiationOpts = NativeImage.getHostedOptionArgumentValues(this.imageBuilderArgs, this.oHTraceObjectInstantiation);
        if (!traceClassInitializationOpts.isEmpty()) {
            agentOptions = NativeImage.getAgentOptions(traceClassInitializationOpts, "c");
        }
        if (!traceObjectInstantiationOpts.isEmpty()) {
            if (!((String)agentOptions).isEmpty()) {
                agentOptions = (String)agentOptions + ",";
            }
            agentOptions = (String)agentOptions + NativeImage.getAgentOptions(traceObjectInstantiationOpts, "o");
        }
        if (!((String)agentOptions).isEmpty()) {
            if (this.useDebugAttach()) {
                throw NativeImage.showError("--debug-attach cannot be used with class initialization/object instantiation tracing (" + this.oHTraceClassInitialization + "/ + " + this.oHTraceObjectInstantiation + ").");
            }
            args.add("-agentlib:native-image-diagnostics-agent=" + (String)agentOptions);
        }
        return args;
    }

    private static String getAgentOptions(List<ArgumentEntry> options, String optionName) {
        return options.stream().flatMap(optValue -> Arrays.stream(optValue.value.split(","))).map(clazz -> optionName + "=" + clazz).collect(Collectors.joining(","));
    }

    private void addTargetArguments() {
        this.targetPlatform = NativeImage.getHostedOptionFinalArgumentValue(this.imageBuilderArgs, this.oHTargetPlatform);
        if (this.targetPlatform == null) {
            return;
        }
        this.targetPlatform = this.targetPlatform.toLowerCase();
        String[] parts = this.targetPlatform.split("-");
        if (parts.length != 2) {
            throw NativeImage.showError("--target argument must be in format <OS>-<architecture>");
        }
        this.targetOS = parts[0];
        this.targetArch = parts[1];
        if (this.customJavaArgs.stream().anyMatch(arg -> arg.startsWith("-Dsvm.platform="))) {
            NativeImage.showWarning("Usage of -Dsvm.platform might conflict with --target parameter.");
        }
        if (this.targetOS != null) {
            this.customJavaArgs.add("-Dsvm.targetPlatformOS=" + this.targetOS);
        }
        if (this.targetArch != null) {
            this.customJavaArgs.add("-Dsvm.targetPlatformArch=" + this.targetArch);
        }
    }

    protected static List<String> createImageBuilderArgs(List<String> imageArgs, List<Path> imagecp, List<Path> imagemp) {
        ArrayList<String> result = new ArrayList<String>();
        if (!imagecp.isEmpty()) {
            result.add("-imagecp");
            result.add(imagecp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
        }
        if (!imagemp.isEmpty()) {
            result.add("-imagemp");
            result.add(imagemp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
        }
        result.addAll(imageArgs);
        return result;
    }

    protected static String createVMInvocationArgumentFile(List<String> arguments) {
        try {
            Path argsFile = Files.createTempFile("vminvocation", ".args", new FileAttribute[0]);
            StringJoiner joiner = new StringJoiner("\n");
            for (String arg : arguments) {
                String quoted = SubstrateUtil.quoteShellArg((String)arg);
                if (quoted.startsWith("'")) {
                    quoted = quoted.replace("\\", "\\\\");
                }
                joiner.add(quoted);
            }
            String joinedOptions = joiner.toString();
            Files.write(argsFile, joinedOptions.getBytes(), new OpenOption[0]);
            argsFile.toFile().deleteOnExit();
            return "@" + String.valueOf(argsFile);
        }
        catch (IOException e) {
            throw NativeImage.showError(e.getMessage());
        }
    }

    protected static String createImageBuilderArgumentFile(List<String> imageBuilderArguments) {
        try {
            Path argsFile = Files.createTempFile("native-image", ".args", new FileAttribute[0]);
            String joinedOptions = String.join((CharSequence)"\u0000", imageBuilderArguments);
            Files.write(argsFile, joinedOptions.getBytes(), new OpenOption[0]);
            argsFile.toFile().deleteOnExit();
            return "--image-args-file=" + argsFile.toString();
        }
        catch (IOException e) {
            throw NativeImage.showError(e.getMessage());
        }
    }

    protected int buildImage(List<String> javaArgs, LinkedHashSet<Path> cp, LinkedHashSet<Path> mp, ArrayList<String> imageArgs, LinkedHashSet<Path> imagecp, LinkedHashSet<Path> imagemp) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(javaArgs);
        if (!cp.isEmpty()) {
            arguments.addAll(Arrays.asList("-cp", cp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator))));
        }
        if (!mp.isEmpty()) {
            List<String> strings = Arrays.asList("--module-path", mp.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            arguments.addAll(strings);
        }
        arguments.addAll(this.config.getGeneratorMainClass());
        if (IS_AOT && OS.getCurrent().hasProcFS) {
            arguments.addAll(Arrays.asList("-watchpid", "" + ProcessProperties.getProcessID()));
        }
        if (this.useBundle()) {
            NativeImage.showWarning("Native Image Bundles are an experimental feature.");
        }
        BiFunction<Path, BundleMember.Role, Path> substituteAuxiliaryPath = this.useBundle() ? this.bundleSupport::substituteAuxiliaryPath : (a, b) -> a;
        Function<String, String> imageArgsTransformer = rawArg -> this.apiOptionHandler.transformBuilderArgument((String)rawArg, substituteAuxiliaryPath);
        List<String> finalImageArgs = imageArgs.stream().map(imageArgsTransformer).collect(Collectors.toList());
        Function substituteClassPath = this.useBundle() ? this.bundleSupport::substituteClassPath : Function.identity();
        List<Path> finalImageClassPath = imagecp.stream().map(substituteClassPath).collect(Collectors.toList());
        Function substituteModulePath = this.useBundle() ? this.bundleSupport::substituteModulePath : Function.identity();
        List<Path> finalImageModulePath = imagemp.stream().map(substituteModulePath).collect(Collectors.toList());
        List<String> finalImageBuilderArgs = NativeImage.createImageBuilderArgs(finalImageArgs, finalImageClassPath, finalImageModulePath);
        ArrayList<String> command = new ArrayList<String>();
        String javaExecutable = this.canonicalize(this.config.getJavaExecutable()).toString();
        command.add(javaExecutable);
        command.add(NativeImage.createVMInvocationArgumentFile(arguments));
        command.add(NativeImage.createImageBuilderArgumentFile(finalImageBuilderArgs));
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(command);
        Map<String, String> environment = pb.environment();
        String deprecatedSanitationKey = "NATIVE_IMAGE_DEPRECATED_BUILDER_SANITATION";
        String deprecatedSanitationValue = System.getenv().getOrDefault(deprecatedSanitationKey, "false");
        if (Boolean.parseBoolean(deprecatedSanitationValue)) {
            if (this.useBundle()) {
                this.bundleSupport = null;
                throw NativeImage.showError("Bundle support is not compatible with environment variable %s=%s.".formatted(deprecatedSanitationKey, deprecatedSanitationValue));
            }
            if (!this.imageBuilderEnvironment.isEmpty()) {
                throw NativeImage.showError("Option -E<env-var-key>[=<env-var-value>] is not compatible with environment variable %s=%s.".formatted(deprecatedSanitationKey, deprecatedSanitationValue));
            }
            LogUtils.warningDeprecatedEnvironmentVariable((String)deprecatedSanitationKey);
            NativeImage.deprecatedSanitizeJVMEnvironment(environment);
        } else {
            NativeImage.sanitizeJVMEnvironment(environment, this.imageBuilderEnvironment);
        }
        if (OS.WINDOWS.isCurrent()) {
            WindowsBuildEnvironmentUtil.propagateEnv(environment);
        }
        environment.put("USE_NATIVE_IMAGE_JAVA_PLATFORM_MODULE_SYSTEM", Boolean.toString(this.config.modulePathBuild));
        if (!this.config.modulePathBuild) {
            LogUtils.warningDeprecatedEnvironmentVariable((String)"USE_NATIVE_IMAGE_JAVA_PLATFORM_MODULE_SYSTEM");
        }
        ArrayList<String> completeCommandList = new ArrayList<String>();
        completeCommandList.addAll(environment.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).sorted().toList());
        completeCommandList.add(javaExecutable);
        completeCommandList.addAll(arguments);
        completeCommandList.addAll(finalImageBuilderArgs);
        String commandLine = SubstrateUtil.getShellCommandString(completeCommandList, (boolean)true);
        if (this.isDiagnostics()) {
            Path finalDiagnosticsDir = this.useBundle() ? this.bundleSupport.substituteAuxiliaryPath(this.diagnosticsDir, BundleMember.Role.Output) : this.diagnosticsDir.toAbsolutePath();
            ReportUtils.report((String)"command line arguments", (String)finalDiagnosticsDir.toString(), (String)"command-line", (String)"txt", printWriter -> printWriter.write(commandLine));
        } else {
            this.showVerboseMessage(this.isVerbose(), "Executing [");
            this.showVerboseMessage(this.isVerbose(), commandLine);
            this.showVerboseMessage(this.isVerbose(), "]");
        }
        if (this.dryRun) {
            return ExitStatus.OK.getValue();
        }
        Process p = null;
        try {
            p = pb.inheritIO().start();
            this.imageBuilderPid = p.pid();
            int n = p.waitFor();
            return n;
        }
        catch (IOException | InterruptedException e2) {
            throw NativeImage.showError(e2.getMessage());
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    boolean useBundle() {
        return this.bundleSupport != null;
    }

    @Deprecated
    private static void deprecatedSanitizeJVMEnvironment(Map<String, String> environment) {
        String[] jvmAffectingEnvironmentVariables;
        for (String affectingEnvironmentVariable : jvmAffectingEnvironmentVariables = new String[]{"JAVA_COMPILER", "_JAVA_OPTIONS", "JAVA_TOOL_OPTIONS", "JDK_JAVA_OPTIONS", "CLASSPATH"}) {
            environment.remove(affectingEnvironmentVariable);
        }
    }

    private static void sanitizeJVMEnvironment(Map<String, String> environment, Map<String, String> imageBuilderEnvironment) {
        Function<Object, Object> keyMapper;
        HashSet<String> requiredKeys = new HashSet<String>(List.of("PATH", "PWD", "HOME", "LANG", "LC_ALL"));
        requiredKeys.add("SRCHOME");
        if (OS.WINDOWS.isCurrent()) {
            requiredKeys.addAll(List.of("TEMP", "INCLUDE", "LIB"));
            keyMapper = String::toUpperCase;
        } else {
            keyMapper = Function.identity();
        }
        HashMap<String, String> restrictedEnvironment = new HashMap<String, String>();
        environment.forEach((key, val) -> {
            if (requiredKeys.contains(keyMapper.apply(key))) {
                restrictedEnvironment.put((String)key, (String)val);
            }
        });
        Iterator<Map.Entry<String, String>> iterator = imageBuilderEnvironment.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (entry.getValue() != null) {
                restrictedEnvironment.put(entry.getKey(), entry.getValue());
                continue;
            }
            environment.forEach((key, val) -> {
                if (((String)keyMapper.apply(key)).equals(keyMapper.apply((String)entry.getKey()))) {
                    restrictedEnvironment.put((String)entry.getKey(), (String)val);
                    entry.setValue((String)val);
                }
            });
            if (entry.getValue() != null) continue;
            NativeImage.showWarning("Environment variable '" + entry.getKey() + "' is undefined and therefore not available during image build-time.");
            iterator.remove();
        }
        environment.clear();
        environment.putAll(restrictedEnvironment);
    }

    public static void main(String[] args) {
        NativeImage.performBuild(new BuildConfiguration(Arrays.asList(args)), defaultNativeImageProvider);
    }

    public static void build(BuildConfiguration config) {
        NativeImage.build(config, defaultNativeImageProvider);
    }

    public static void agentBuild(Path javaHome, Path workDir, List<String> buildArgs) {
        NativeImage.performBuild(new BuildConfiguration(javaHome, workDir, buildArgs), NativeImage::new);
    }

    public static List<String> translateAPIOptions(List<String> arguments) {
        APIOptionHandler handler = new APIOptionHandler(new NativeImage(new BuildConfiguration(arguments)));
        ArgumentQueue argumentQueue = new ArgumentQueue(null);
        handler.nativeImage.config.args.forEach(argumentQueue::add);
        ArrayList<String> translatedOptions = new ArrayList<String>();
        while (!argumentQueue.isEmpty()) {
            String translatedOption = handler.translateOption(argumentQueue);
            String originalOption = argumentQueue.poll();
            translatedOptions.add(translatedOption != null ? translatedOption : originalOption);
        }
        return translatedOptions;
    }

    private static void performBuild(BuildConfiguration config, Function<BuildConfiguration, NativeImage> nativeImageProvider) {
        try {
            NativeImage.build(config, nativeImageProvider);
        }
        catch (NativeImageError e) {
            String message = e.getMessage();
            if (message != null) {
                NativeImage.show(System.err::println, "Error: " + message);
            }
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                NativeImage.show(System.err::println, "Caused by: " + String.valueOf(cause));
            }
            if (config.getBuildArgs().contains("--verbose")) {
                e.printStackTrace();
            }
            System.exit(e.exitCode);
        }
        System.exit(ExitStatus.OK.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void build(BuildConfiguration config, Function<BuildConfiguration, NativeImage> nativeImageProvider) {
        NativeImage nativeImage = nativeImageProvider.apply(config);
        if (config.getBuildArgs().isEmpty()) {
            nativeImage.showMessage(usageText);
            return;
        }
        try {
            nativeImage.prepareImageBuildArgs();
        }
        catch (NativeImageError e) {
            if (!nativeImage.isVerbose()) throw NativeImage.showError("Requirements for building native images are not fulfilled [cause: " + e.getMessage() + "]", null);
            throw NativeImage.showError("Requirements for building native images are not fulfilled", e);
        }
        try {
            int exitStatusCode = nativeImage.completeImageBuild();
            switch (ExitStatus.of((int)exitStatusCode)) {
                case OK: {
                    return;
                }
                case BUILDER_ERROR: {
                    throw NativeImage.showError(null, null, exitStatusCode);
                }
                case FALLBACK_IMAGE: {
                    nativeImage.showMessage("Generating fallback image...");
                    NativeImage.build(new FallbackBuildConfiguration(nativeImage), nativeImageProvider);
                    NativeImage.showWarning("Image '" + nativeImage.imageName + "' is a fallback image that requires a JDK for execution (use --no-fallback to suppress fallback image generation and to print more detailed information why a fallback image was necessary).");
                    return;
                }
                case OUT_OF_MEMORY: {
                    nativeImage.showOutOfMemoryWarning();
                    throw NativeImage.showError(null, null, exitStatusCode);
                }
                default: {
                    String message = String.format("Image build request for '%s' (pid: %d, path: %s) failed with exit status %d", nativeImage.imageName, nativeImage.imageBuilderPid, nativeImage.imagePath, exitStatusCode);
                    throw NativeImage.showError(message, null, exitStatusCode);
                }
            }
        }
        finally {
            if (nativeImage.useBundle()) {
                nativeImage.bundleSupport.complete();
            }
        }
    }

    Path canonicalize(Path path) {
        return this.canonicalize(path, true);
    }

    Path canonicalize(Path path, boolean strict) {
        Path absolutePath;
        Path prev;
        if (this.useBundle() && (prev = this.bundleSupport.restoreCanonicalization(path)) != null) {
            return prev;
        }
        Path path2 = absolutePath = path.isAbsolute() ? path : this.config.getWorkingDirectory().resolve(path);
        if (!strict) {
            return this.useBundle() ? this.bundleSupport.recordCanonicalization(path, absolutePath) : absolutePath;
        }
        try {
            Path realPath = absolutePath.toRealPath(new LinkOption[0]);
            if (!Files.isReadable(realPath)) {
                NativeImage.showError("Path entry " + String.valueOf(path) + " is not readable");
            }
            return this.useBundle() ? this.bundleSupport.recordCanonicalization(path, realPath) : realPath;
        }
        catch (IOException e) {
            throw NativeImage.showError("Invalid Path entry " + String.valueOf(path), e);
        }
    }

    public void addImageBuilderModulePath(Path modulePathEntry) {
        this.imageBuilderModulePath.add(this.canonicalize(modulePathEntry));
    }

    public void addAddedModules(String addModulesArg) {
        this.addModules.addAll(Arrays.asList(SubstrateUtil.split((String)addModulesArg, (String)",")));
    }

    public void addLimitedModules(String limitModulesArg) {
        this.limitModules.addAll(Arrays.asList(SubstrateUtil.split((String)limitModulesArg, (String)",")));
    }

    void addImageBuilderClasspath(Path classpath) {
        this.imageBuilderClasspath.add(this.canonicalize(classpath));
    }

    void addImageBuilderJavaArgs(String ... javaArgs) {
        this.addImageBuilderJavaArgs(Arrays.asList(javaArgs));
    }

    void addImageBuilderJavaArgs(Collection<String> javaArgs) {
        this.imageBuilderJavaArgs.addAll(javaArgs);
    }

    void addPlainImageBuilderArg(String plainArg) {
        assert (plainArg.startsWith(oH) || plainArg.startsWith(oR));
        this.imageBuilderArgs.add(plainArg);
    }

    void addImageClasspath(Path classpath) {
        this.addImageClasspathEntry(this.imageClasspath, classpath, true);
    }

    void addImageModulePath(Path modulePathEntry) {
        this.addImageModulePath(modulePathEntry, true);
    }

    void addImageModulePath(Path modulePathEntry, boolean strict) {
        Path mpEntry;
        this.enableModulePathBuild();
        try {
            mpEntry = this.canonicalize(modulePathEntry);
        }
        catch (NativeImageError e) {
            if (strict) {
                throw e;
            }
            if (this.isVerbose()) {
                NativeImage.showWarning("Invalid module-path entry: " + String.valueOf(modulePathEntry));
            }
            this.imageModulePath.add(this.canonicalize(modulePathEntry, false));
            return;
        }
        if (this.imageModulePath.contains(mpEntry)) {
            return;
        }
        Path mpEntryFinal = this.useBundle() ? this.bundleSupport.substituteModulePath(mpEntry) : mpEntry;
        this.imageModulePath.add(mpEntryFinal);
        this.processClasspathNativeImageMetaInf(mpEntryFinal);
    }

    void addCustomImageClasspath(String classpath) {
        for (Path path : NativeImage.expandAsteriskClassPathElement(classpath)) {
            this.addImageClasspathEntry(this.customImageClasspath, path, false);
        }
    }

    public static List<Path> expandAsteriskClassPathElement(String cp) {
        ArrayList<String> components;
        int lastElementIndex;
        Object separators = Pattern.quote(File.separator);
        if (OS.getCurrent().equals((Object)OS.WINDOWS)) {
            separators = (String)separators + "/";
        }
        if ((lastElementIndex = (components = new ArrayList<String>(List.of(cp.split("[" + (String)separators + "]")))).size() - 1) >= 0 && "*".equals(components.get(lastElementIndex))) {
            List<Path> list;
            block10: {
                components.remove(lastElementIndex);
                Path searchDir = Path.of(String.join((CharSequence)File.separator, components), new String[0]);
                Stream<Path> filesInSearchDir = Files.list(searchDir);
                try {
                    list = filesInSearchDir.filter(NativeImage::hasJarFileSuffix).collect(Collectors.toList());
                    if (filesInSearchDir == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (filesInSearchDir != null) {
                            try {
                                filesInSearchDir.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw NativeImage.showError("Class path element asterisk (*) expansion failed for directory " + String.valueOf(searchDir));
                    }
                }
                filesInSearchDir.close();
            }
            return list;
        }
        return List.of(Path.of(cp, new String[0]));
    }

    private static boolean hasJarFileSuffix(Path p) {
        return p.getFileName().toString().toLowerCase().endsWith(".jar");
    }

    void addCustomImageClasspath(Path classpath) {
        this.addImageClasspathEntry(this.customImageClasspath, classpath, true);
    }

    private void addImageClasspathEntry(LinkedHashSet<Path> destination, Path classpath, boolean strict) {
        Path classpathEntryFinal;
        Path classpathEntry;
        try {
            classpathEntry = this.canonicalize(classpath);
        }
        catch (NativeImageError e) {
            if (strict) {
                throw e;
            }
            if (this.isVerbose()) {
                NativeImage.showWarning("Invalid classpath entry: " + String.valueOf(classpath));
            }
            destination.add(this.canonicalize(classpath, false));
            return;
        }
        Path path = classpathEntryFinal = this.useBundle() ? this.bundleSupport.substituteClassPath(classpathEntry) : classpathEntry;
        if (!this.imageClasspath.contains(classpathEntryFinal) && !this.customImageClasspath.contains(classpathEntryFinal)) {
            destination.add(classpathEntryFinal);
            if (ClasspathUtils.isJar((Path)classpathEntryFinal)) {
                NativeImage.processJarManifestMainAttributes(classpathEntryFinal, (jarFilePath, attributes) -> this.handleClassPathAttribute(destination, (Path)jarFilePath, (Attributes)attributes));
            }
            this.processClasspathNativeImageMetaInf(classpathEntryFinal);
        }
    }

    void addCustomJavaArgs(String javaArg) {
        this.customJavaArgs.add(javaArg);
    }

    void addVerbose() {
        ++this.verbose;
    }

    void enableDiagnostics() {
        if (this.diagnostics) {
            return;
        }
        this.diagnostics = true;
        this.diagnosticsDir = Paths.get("reports", ReportUtils.timeStampedFileName((String)"diagnostics", (String)""));
        this.addVerbose();
        this.addVerbose();
    }

    void setJarOptionMode(boolean val) {
        this.jarOptionMode = val;
    }

    void setModuleOptionMode(boolean val) {
        this.enableModulePathBuild();
        this.moduleOptionMode = val;
    }

    private void enableModulePathBuild() {
        if (!this.config.modulePathBuild) {
            NativeImage.showError("Module options not allowed in this image build. Reason: " + this.config.imageBuilderModeEnforcer);
        }
        this.config.modulePathBuild = true;
    }

    boolean isVerbose() {
        return this.verbose > 0;
    }

    boolean isVVerbose() {
        return this.verbose > 1;
    }

    boolean isVVVerbose() {
        return this.verbose > 2;
    }

    boolean isDiagnostics() {
        return this.diagnostics;
    }

    boolean useDebugAttach() {
        return this.cmdLineOptionHandler.useDebugAttach;
    }

    protected void setDryRun(boolean val) {
        this.dryRun = val;
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    public void setPrintFlagsOptionQuery(String val) {
        this.printFlagsOptionQuery = val;
    }

    public void setPrintFlagsWithExtraHelpOptionQuery(String val) {
        this.printFlagsWithExtraHelpOptionQuery = val;
    }

    void showVerboseMessage(boolean show, String message) {
        if (show) {
            NativeImage.show(System.out::println, message);
        }
    }

    void showMessage(String message) {
        NativeImage.show(System.out::println, message);
    }

    void showMessage(String format, Object ... args) {
        this.showMessage(String.format(format, args));
    }

    void showNewline() {
        System.out.println();
    }

    void showMessagePart(String message) {
        NativeImage.show(s -> {
            System.out.print((String)s);
            System.out.flush();
        }, message);
    }

    void showOutOfMemoryWarning() {
        String xmxFlag = "-Xmx";
        String lastMaxHeapValue = null;
        for (String arg : this.imageBuilderJavaArgs) {
            if (!arg.startsWith(xmxFlag)) continue;
            lastMaxHeapValue = arg;
        }
        Object maxHeapText = lastMaxHeapValue == null ? "" : " (The maximum heap size of the process was set with '" + lastMaxHeapValue + "'.)";
        Object additionalAction = lastMaxHeapValue == null ? "" : " or increase the maximum heap size using the '" + xmxFlag + "' option";
        this.showMessage("The Native Image build process ran out of memory.%s%nPlease make sure your build system has more memory available%s.", maxHeapText, additionalAction);
    }

    public static void showWarning(String message) {
        NativeImage.show(System.err::println, "Warning: " + message);
    }

    void performANSIReset() {
        this.showMessagePart("\u001b[0m");
    }

    public static Error showError(String message) {
        throw new NativeImageError(message);
    }

    public static Error showError(String message, Throwable cause) {
        throw new NativeImageError(message, cause);
    }

    public static Error showError(String message, Throwable cause, int exitCode) {
        throw new NativeImageError(message, cause, exitCode);
    }

    private static void show(Consumer<String> printFunc, String message) {
        printFunc.accept(message);
    }

    protected static List<Path> getJars(Path dir, String ... jarBaseNames) {
        try {
            List<String> baseNameList = Arrays.asList(jarBaseNames);
            return Files.list(dir).filter(p -> {
                String jarFileName = p.getFileName().toString();
                String jarSuffix = ".jar";
                if (!jarFileName.toLowerCase().endsWith(jarSuffix)) {
                    return false;
                }
                if (baseNameList.isEmpty()) {
                    return true;
                }
                String jarBaseName = jarFileName.substring(0, jarFileName.length() - jarSuffix.length());
                return baseNameList.contains(jarBaseName);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw NativeImage.showError("Unable to use jar-files from directory " + String.valueOf(dir), e);
        }
    }

    private List<String> processNativeImageArgs() {
        NativeImageArgsProcessor argsProcessor = new NativeImageArgsProcessor(null);
        for (String arg : this.getNativeImageArgs()) {
            argsProcessor.accept(arg);
        }
        return argsProcessor.apply(false);
    }

    List<String> getNativeImageArgs() {
        return Stream.concat(this.getDefaultNativeImageArgs().stream(), this.config.getBuildArgs().stream()).toList();
    }

    private static boolean isDumbTerm() {
        String term = System.getenv().getOrDefault("TERM", "");
        return term.isEmpty() || term.equals("dumb") || term.equals("unknown");
    }

    private static boolean hasColorSupport() {
        return !NativeImage.isDumbTerm() && !SubstrateUtil.isRunningInCI() && OS.getCurrent() != OS.WINDOWS && System.getenv("NO_COLOR") == null;
    }

    private static boolean hasProgressSupport(List<String> imageBuilderArgs) {
        return !NativeImage.isDumbTerm() && !SubstrateUtil.isRunningInCI() && NativeImage.getHostedOptionArgumentValues(imageBuilderArgs, "-H:Log=").isEmpty();
    }

    private boolean configureBuildOutput() {
        boolean useColorfulOutput = false;
        Boolean buildOutputColorfulValue = NativeImage.getHostedOptionFinalBooleanArgumentValue(this.imageBuilderArgs, (OptionKey<Boolean>)SubstrateOptions.BuildOutputColorful);
        if (buildOutputColorfulValue != null) {
            useColorfulOutput = buildOutputColorfulValue;
        } else if (NativeImage.hasColorSupport()) {
            useColorfulOutput = true;
            this.addPlainImageBuilderArg(this.oHEnableBuildOutputColorful);
        }
        if (NativeImage.getHostedOptionFinalBooleanArgumentValue(this.imageBuilderArgs, (OptionKey<Boolean>)SubstrateOptions.BuildOutputProgress) == null && NativeImage.hasProgressSupport(this.imageBuilderArgs)) {
            this.addPlainImageBuilderArg(this.oHEnableBuildOutputProgress);
        }
        if (NativeImage.getHostedOptionFinalBooleanArgumentValue(this.imageBuilderArgs, (OptionKey<Boolean>)SubstrateOptions.BuildOutputLinks) == null && buildOutputColorfulValue == null && useColorfulOutput) {
            this.addPlainImageBuilderArg(this.oHEnableBuildOutputLinks);
        }
        return useColorfulOutput;
    }

    static Map<String, String> loadProperties(Path propertiesPath) {
        if (Files.isReadable(propertiesPath)) {
            try {
                return NativeImage.loadProperties(Files.newInputStream(propertiesPath, new OpenOption[0]));
            }
            catch (IOException e) {
                throw NativeImage.showError("Could not read properties-file: " + String.valueOf(propertiesPath), e);
            }
        }
        return Collections.emptyMap();
    }

    static Map<String, String> loadProperties(InputStream propertiesInputStream) {
        Properties properties = new Properties();
        try (InputStream input = propertiesInputStream;){
            properties.load(input);
        }
        catch (IOException e) {
            NativeImage.showError("Could not read properties", e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return Collections.unmodifiableMap(map);
    }

    static boolean forEachPropertyValue(String propertyValue, Consumer<String> target, Function<String, String> resolver) {
        return NativeImage.forEachPropertyValue(propertyValue, target, resolver, "\\s+");
    }

    static boolean forEachPropertyValue(String propertyValue, Consumer<String> target, Function<String, String> resolver, String separatorRegex) {
        if (propertyValue != null) {
            for (String propertyValuePart : propertyValue.split(separatorRegex)) {
                target.accept(resolver.apply(propertyValuePart));
            }
            return true;
        }
        return false;
    }

    public void addOptionKeyValue(String key, String value) {
        this.propertyFileSubstitutionValues.put(key, value);
    }

    static String resolvePropertyValue(String val, String optionArg, Path componentDirectory, BuildConfiguration config) {
        String resultVal = val;
        if (optionArg != null) {
            resultVal = NativeImage.safeSubstitution(resultVal, "${*}", optionArg);
            for (String argNameValue : optionArg.split(",")) {
                String[] splitted = argNameValue.split(":", 2);
                if (splitted.length != 2) continue;
                String argName = splitted[0];
                String argValue = splitted[1];
                if (argName.isEmpty()) continue;
                resultVal = NativeImage.safeSubstitution(resultVal, "${" + argName + "}", argValue);
            }
        }
        resultVal = NativeImage.safeSubstitution(resultVal, "${.}", componentDirectory.toString());
        resultVal = NativeImage.safeSubstitution(resultVal, "${java.home}", config.getJavaHome().toString());
        return resultVal;
    }

    private static String safeSubstitution(String source, CharSequence target, CharSequence replacement) {
        if (replacement == null && source.contains(target)) {
            throw NativeImage.showError("Unable to provide meaningful substitution for \"" + String.valueOf(target) + "\" in " + source);
        }
        return source.replace(target, replacement);
    }

    protected static boolean isDeletedPath(Path toDelete) {
        return toDelete.getFileName().toString().endsWith(deletedFileSuffix);
    }

    protected void deleteAllFiles(Path toDelete) {
        block3: {
            try {
                Path deletedPath = toDelete;
                if (!NativeImage.isDeletedPath(deletedPath)) {
                    deletedPath = toDelete.resolveSibling(String.valueOf(toDelete.getFileName()) + deletedFileSuffix);
                    Files.move(toDelete, deletedPath, new CopyOption[0]);
                }
                Files.walk(deletedPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                if (!this.isVerbose()) break block3;
                this.showMessage("Could not recursively delete path: " + String.valueOf(toDelete));
                e.printStackTrace();
            }
        }
    }

    public static final class NativeImageError
    extends Error {
        final int exitCode;

        private NativeImageError(String message) {
            this(message, null);
        }

        private NativeImageError(String message, Throwable cause) {
            this(message, cause, ExitStatus.DRIVER_ERROR.getValue());
        }

        public NativeImageError(String message, Throwable cause, int exitCode) {
            super(message, cause);
            this.exitCode = exitCode;
        }
    }

    static abstract class OptionHandler<T extends NativeImage> {
        protected final T nativeImage;

        OptionHandler(T nativeImage) {
            this.nativeImage = nativeImage;
        }

        abstract boolean consume(ArgumentQueue var1);

        void addFallbackBuildArgs(List<String> buildArgs) {
        }
    }

    protected static class BuildConfiguration {
        private static final Method isModulePathBuild = ReflectionUtil.lookupMethod(ModuleSupport.class, (String)"isModulePathBuild", (Class[])new Class[0]);
        protected boolean modulePathBuild;
        String imageBuilderModeEnforcer;
        protected final Path workDir;
        protected final Path rootDir;
        protected final Path libJvmciDir;
        protected final List<String> args;

        BuildConfiguration(BuildConfiguration original) {
            this.modulePathBuild = original.modulePathBuild;
            this.imageBuilderModeEnforcer = original.imageBuilderModeEnforcer;
            this.workDir = original.workDir;
            this.rootDir = original.rootDir;
            this.libJvmciDir = original.libJvmciDir;
            this.args = original.args;
        }

        protected BuildConfiguration(List<String> args) {
            this(null, null, args);
        }

        BuildConfiguration(Path rootDir, Path workDir, List<String> args) {
            try {
                this.modulePathBuild = (Boolean)isModulePathBuild.invoke(null, new Object[0]);
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                VMError.shouldNotReachHere((Throwable)e);
            }
            this.imageBuilderModeEnforcer = null;
            this.args = Collections.unmodifiableList(args);
            Path path = this.workDir = workDir != null ? workDir : Paths.get(".", new String[0]).toAbsolutePath().normalize();
            if (rootDir != null) {
                this.rootDir = rootDir;
            } else if (IS_AOT) {
                Path executablePath = Paths.get(ProcessProperties.getExecutableName(), new String[0]);
                assert (executablePath != null);
                Path binDir = executablePath.getParent();
                Path rootDirCandidate = binDir.getParent();
                if (rootDirCandidate.endsWith(platform)) {
                    rootDirCandidate = rootDirCandidate.getParent();
                }
                if (rootDirCandidate.endsWith(Paths.get("lib", "svm"))) {
                    rootDirCandidate = rootDirCandidate.getParent().getParent();
                }
                this.rootDir = rootDirCandidate;
            } else {
                String rootDirProperty = "native-image.root";
                String rootDirString = System.getProperty(rootDirProperty);
                if (rootDirString == null) {
                    rootDirString = System.getProperty("java.home");
                }
                this.rootDir = Paths.get(rootDirString, new String[0]);
            }
            Path ljDir = this.rootDir.resolve(Paths.get("lib", "jvmci"));
            this.libJvmciDir = Files.exists(ljDir, new LinkOption[0]) ? ljDir : null;
        }

        public List<String> getGeneratorMainClass() {
            if (this.modulePathBuild) {
                return Arrays.asList("--module", DEFAULT_GENERATOR_MODULE_NAME + "/" + DEFAULT_GENERATOR_CLASS_NAME);
            }
            return List.of(DEFAULT_GENERATOR_CLASS_NAME + NativeImage.DEFAULT_GENERATOR_9PLUS_SUFFIX);
        }

        public Path getWorkingDirectory() {
            return this.workDir;
        }

        public Path getJavaHome() {
            return this.rootDir;
        }

        public Path getJavaExecutable() {
            Path binJava = Paths.get("bin", OS.getCurrent() == OS.WINDOWS ? "java.exe" : "java");
            if (Files.isExecutable(this.rootDir.resolve(binJava))) {
                return this.rootDir.resolve(binJava);
            }
            String javaHome = System.getenv("JAVA_HOME");
            if (javaHome == null) {
                throw NativeImage.showError("Environment variable JAVA_HOME is not set");
            }
            Path javaHomeDir = Paths.get(javaHome, new String[0]);
            if (!Files.isDirectory(javaHomeDir, new LinkOption[0])) {
                throw NativeImage.showError("Environment variable JAVA_HOME does not refer to a directory");
            }
            if (!Files.isExecutable(javaHomeDir.resolve(binJava))) {
                throw NativeImage.showError("Environment variable JAVA_HOME does not refer to a directory with a " + String.valueOf(binJava) + " executable");
            }
            return javaHomeDir.resolve(binJava);
        }

        public List<Path> getBuilderClasspath() {
            if (this.modulePathBuild) {
                return Collections.emptyList();
            }
            ArrayList<Path> result = new ArrayList<Path>();
            if (this.libJvmciDir != null) {
                result.addAll(NativeImage.getJars(this.libJvmciDir, "graal-sdk", "graal", "enterprise-graal"));
            }
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm", "builder")), new String[0]));
            return result;
        }

        public List<Path> getBuilderCLibrariesPaths() {
            return Collections.singletonList(this.rootDir.resolve(Paths.get("lib", "svm", "clibraries")));
        }

        public Path getBuilderInspectServerPath() {
            Path inspectPath = this.rootDir.resolve(Paths.get("lib", "svm", "inspect"));
            if (Files.isDirectory(inspectPath, new LinkOption[0])) {
                return inspectPath;
            }
            return null;
        }

        public List<Path> getImageProvidedClasspath() {
            return this.getImageProvidedJars();
        }

        public List<Path> getImageProvidedModulePath() {
            return this.getImageProvidedJars();
        }

        protected List<Path> getImageProvidedJars() {
            return NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm")), new String[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getBuilderJavaArgs() {
            String javaVersion;
            String[] flagsForVersion;
            ArrayList<String> builderJavaArgs = new ArrayList<String>();
            if (useJVMCINativeLibrary == null) {
                useJVMCINativeLibrary = false;
                ProcessBuilder pb = new ProcessBuilder(new String[0]);
                NativeImage.sanitizeJVMEnvironment(pb.environment(), Map.of());
                List<String> command = pb.command();
                command.add(this.getJavaExecutable().toString());
                command.add("-XX:+PrintFlagsFinal");
                command.add("-version");
                Process process = null;
                try {
                    process = pb.start();
                    try (Scanner inputScanner = new Scanner(process.getInputStream());){
                        while (inputScanner.hasNextLine()) {
                            String value;
                            String line = inputScanner.nextLine();
                            if (!line.contains("bool UseJVMCINativeLibrary") || !(value = SubstrateUtil.split((String)line, (String)"=")[1]).trim().startsWith("true")) continue;
                            useJVMCINativeLibrary = true;
                            break;
                        }
                    }
                    process.waitFor();
                }
                catch (Exception exception) {
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                }
            }
            if ((flagsForVersion = graalCompilerFlags.get(javaVersion = String.valueOf(JavaVersionUtil.JAVA_SPEC))) == null) {
                String suffix = "";
                if (System.getProperty("java.home").contains("-dev")) {
                    suffix = " Update SubstrateCompilerFlagsBuilder.compute_graal_compiler_flags_map() in mx_substratevm.py to add a configuration for a new Java version.";
                }
                NativeImage.showError(String.format("Image building not supported for Java version %s in %s with VM configuration \"%s\".%s", System.getProperty("java.version"), System.getProperty("java.home"), System.getProperty("java.vm.name"), suffix));
            }
            for (String line : flagsForVersion) {
                if (!this.modulePathBuild && line.startsWith("--add-exports=")) {
                    builderJavaArgs.add(line.substring(0, line.lastIndexOf(61) + 1) + "ALL-UNNAMED");
                    continue;
                }
                builderJavaArgs.add(line);
            }
            if (useJVMCINativeLibrary.booleanValue()) {
                builderJavaArgs.add("-XX:+UseJVMCINativeLibrary");
            } else {
                builderJavaArgs.add("-XX:-UseJVMCICompiler");
            }
            return builderJavaArgs;
        }

        public List<Path> getBuilderModulePath() {
            ArrayList<Path> result = new ArrayList<Path>();
            if (this.libJvmciDir != null) {
                result.addAll(NativeImage.getJars(this.libJvmciDir, "graal-sdk", "enterprise-graal"));
            }
            result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "truffle")), "truffle-api"));
            if (this.modulePathBuild) {
                result.addAll(NativeImage.getJars(this.rootDir.resolve(Paths.get("lib", "svm", "builder")), new String[0]));
            }
            return result;
        }

        public List<Path> getBuilderUpgradeModulePath() {
            return this.libJvmciDir != null ? NativeImage.getJars(this.libJvmciDir, "graal", "graal-management") : Collections.emptyList();
        }

        public List<Path> getImageClasspath() {
            return Collections.emptyList();
        }

        public List<String> getBuildArgs() {
            return this.args;
        }

        public boolean buildFallbackImage() {
            return false;
        }

        public Optional<Path> getResourcesJar() {
            return Optional.of(this.rootDir.resolve(Paths.get("lib", "resources.jar")));
        }
    }

    class DriverMetaInfProcessor
    implements NativeImageMetaInfResourceProcessor {
        DriverMetaInfProcessor() {
        }

        @Override
        public void processMetaInfResource(Path classpathEntry, Path resourceRoot, Path resourcePath, MetaInfFileType type) throws IOException {
            NativeImage nativeImage = NativeImage.this;
            Objects.requireNonNull(nativeImage);
            NativeImageArgsProcessor args = nativeImage.new NativeImageArgsProcessor(resourcePath.toUri().toString());
            Path componentDirectory = resourceRoot.relativize(resourcePath).getParent();
            Function<String, String> resolver = str -> {
                int nameCount = componentDirectory.getNameCount();
                String optionArg = null;
                if (nameCount > 2) {
                    String optionArgKey = componentDirectory.subpath(2, nameCount).toString();
                    optionArg = NativeImage.this.propertyFileSubstitutionValues.get(optionArgKey);
                }
                return NativeImage.resolvePropertyValue(str, optionArg, componentDirectory, NativeImage.this.config);
            };
            if (type == MetaInfFileType.Properties) {
                Map<String, String> properties = NativeImage.loadProperties(Files.newInputStream(resourcePath, new OpenOption[0]));
                String imageNameValue = properties.get("ImageName");
                if (imageNameValue != null) {
                    NativeImage.this.addPlainImageBuilderArg(NativeImage.injectHostedOptionOrigin(NativeImage.this.oHName + resolver.apply(imageNameValue), resourcePath.toUri().toString()));
                }
                NativeImage.forEachPropertyValue(properties.get("JavaArgs"), xva$0 -> NativeImage.this.addImageBuilderJavaArgs((String)xva$0), resolver);
                NativeImage.forEachPropertyValue(properties.get("Args"), args, resolver);
            } else {
                args.accept(NativeImage.oH(type.optionKey) + String.valueOf(resourceRoot.relativize(resourcePath)));
            }
            args.apply(true);
        }

        @Override
        public void showWarning(String message) {
            if (NativeImage.this.isVerbose()) {
                NativeImage.showWarning(message);
            }
        }

        @Override
        public void showVerboseMessage(String message) {
            NativeImage.this.showVerboseMessage(NativeImage.this.isVerbose(), message);
        }

        @Override
        public boolean isExcluded(Path resourcePath, Path classpathEntry) {
            return NativeImage.this.excludedConfigs.stream().filter(e -> e.jarPattern.matcher(classpathEntry.toString()).find()).anyMatch(e -> e.resourcePattern.matcher(resourcePath.toString()).find());
        }
    }

    private static final class ExcludeConfig {
        final Pattern jarPattern;
        final Pattern resourcePattern;

        private ExcludeConfig(Pattern jarPattern, Pattern resourcePattern) {
            this.jarPattern = jarPattern;
            this.resourcePattern = resourcePattern;
        }
    }

    private static final class ArgumentEntry {
        private final int index;
        private final String value;

        private ArgumentEntry(int index, String value) {
            this.index = index;
            this.value = value;
        }
    }

    static class ArgumentQueue {
        private final ArrayDeque<String> queue = new ArrayDeque();
        public final String argumentOrigin;

        ArgumentQueue(String argumentOrigin) {
            this.argumentOrigin = argumentOrigin;
        }

        public void add(String arg) {
            this.queue.add(arg);
        }

        public String poll() {
            return this.queue.poll();
        }

        public void push(String arg) {
            this.queue.push(arg);
        }

        public String peek() {
            return this.queue.peek();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public int size() {
            return this.queue.size();
        }

        public List<String> snapshot() {
            return new ArrayList<String>(this.queue);
        }
    }

    private static final class FallbackBuildConfiguration
    extends BuildConfiguration {
        private final List<String> fallbackBuildArgs;

        private FallbackBuildConfiguration(NativeImage original) {
            super(original.config);
            this.fallbackBuildArgs = original.createFallbackBuildArgs();
        }

        @Override
        public List<Path> getImageClasspath() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getBuildArgs() {
            return this.fallbackBuildArgs;
        }

        @Override
        public boolean buildFallbackImage() {
            return true;
        }
    }

    class NativeImageArgsProcessor
    implements Consumer<String> {
        private final ArgumentQueue args;

        NativeImageArgsProcessor(String argumentOrigin) {
            this.args = new ArgumentQueue(argumentOrigin);
        }

        @Override
        public void accept(String arg) {
            this.args.add(arg);
        }

        List<String> apply(boolean strict) {
            ArgumentQueue queue = new ArgumentQueue(this.args.argumentOrigin);
            while (!this.args.isEmpty()) {
                int numArgs = this.args.size();
                if (NativeImage.this.cmdLineOptionHandler.consume(this.args)) {
                    assert (this.args.size() < numArgs) : "OptionHandler pretends to consume argument(s) but isn't: " + NativeImage.this.cmdLineOptionHandler.getClass().getName();
                    continue;
                }
                queue.add(this.args.poll());
            }
            ArrayList<String> leftoverArgs = new ArrayList<String>();
            while (!queue.isEmpty()) {
                boolean consumed = false;
                for (int index = NativeImage.this.optionHandlers.size() - 1; index >= 0; --index) {
                    OptionHandler<? extends NativeImage> handler = NativeImage.this.optionHandlers.get(index);
                    int numArgs = queue.size();
                    if (!handler.consume(queue)) continue;
                    assert (queue.size() < numArgs) : "OptionHandler pretends to consume argument(s) but isn't: " + handler.getClass().getName();
                    consumed = true;
                    break;
                }
                if (consumed) continue;
                if (strict) {
                    NativeImage.showError("Property 'Args' contains invalid entry '" + queue.peek() + "'");
                    continue;
                }
                leftoverArgs.add(queue.poll());
            }
            return leftoverArgs;
        }
    }
}

