/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.driver.NativeImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

class WindowsBuildEnvironmentUtil {
    private static final String VSINSTALLDIR_ENV = "VSINSTALLDIR";
    private static final Path[] KNOWN_VS_LOCATIONS = new Path[]{Paths.get("C:", "Program Files", "Microsoft Visual Studio"), Paths.get("C:", "Program Files (x86)", "Microsoft Visual Studio")};
    private static final String[] KNOWN_VS_EDITIONS = new String[]{"Enterprise", "Professional", "Community", "BuildTools"};
    private static final String VCVARSALL = "vcvarsall.bat";
    private static final Path VCVARSALL_SUBPATH = Paths.get("VC", "Auxiliary", "Build", "vcvarsall.bat");
    private static final String OUTPUT_SEPARATOR = "!NEXTCOMMAND!";
    private static final String VISUAL_STUDIO_MINIMUM_REQUIRED_VERSION = "Visual Studio 2022 version 17.1.0";

    WindowsBuildEnvironmentUtil() {
    }

    static void propagateEnv(Map<String, String> environment) {
        if (WindowsBuildEnvironmentUtil.isCCompilerOnPath()) {
            return;
        }
        Path vcVarsAllLocation = null;
        for (Path visualStudioLocation : KNOWN_VS_LOCATIONS) {
            List<Path> installationCandidates;
            if (!Files.isDirectory(visualStudioLocation, new LinkOption[0])) continue;
            try (Stream<Path> pathStream = Files.list(visualStudioLocation);){
                installationCandidates = pathStream.filter(p -> p.toFile().getName().matches("20\\d\\d")).sorted(Comparator.comparing(p -> p.toFile().getName())).sorted(Comparator.reverseOrder()).toList();
            }
            catch (IOException e) {
                throw WindowsBuildEnvironmentUtil.fail("Failed to traverse known Visual Studio locations.", e);
            }
            block15: for (Path installation : installationCandidates) {
                for (String edition : KNOWN_VS_EDITIONS) {
                    Path possibleLocation = installation.resolve(edition).resolve(VCVARSALL_SUBPATH);
                    if (!Files.isRegularFile(possibleLocation, new LinkOption[0]) || !Files.isReadable(possibleLocation)) continue;
                    vcVarsAllLocation = possibleLocation;
                    continue block15;
                }
            }
        }
        if (vcVarsAllLocation == null) {
            throw WindowsBuildEnvironmentUtil.fail(String.format("Failed to find '%s' in a Visual Studio installation.", VCVARSALL));
        }
        HashMap originalEnv = new HashMap();
        int numSeenOutputSeparators = 0;
        try {
            String commandSequence = String.format("cmd.exe /c set && echo %s && \"%s\" x64 && echo %s && set", OUTPUT_SEPARATOR, vcVarsAllLocation, OUTPUT_SEPARATOR);
            Process p2 = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", commandSequence});
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p2.getInputStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(OUTPUT_SEPARATOR)) {
                        ++numSeenOutputSeparators;
                        continue;
                    }
                    if (numSeenOutputSeparators == 0) {
                        WindowsBuildEnvironmentUtil.processLineWithKeyValue(line, (key, value) -> originalEnv.put(key, value));
                        continue;
                    }
                    if (numSeenOutputSeparators != 2) continue;
                    WindowsBuildEnvironmentUtil.processLineWithKeyValue(line, (key, value) -> {
                        boolean isNewOrModifiedEnvVar;
                        boolean bl = isNewOrModifiedEnvVar = !originalEnv.getOrDefault(key, "").equals(value);
                        if (isNewOrModifiedEnvVar) {
                            environment.put((String)key, (String)value);
                        }
                    });
                }
            }
            p2.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw WindowsBuildEnvironmentUtil.fail("Failed to detect variables of Windows build environment.", e);
        }
        if (!environment.containsKey(VSINSTALLDIR_ENV)) {
            throw WindowsBuildEnvironmentUtil.fail("Failed to automatically set up Windows build environment.");
        }
    }

    private static boolean isCCompilerOnPath() {
        try {
            return Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "where", "cl.exe"}).waitFor() == 0;
        }
        catch (IOException | InterruptedException e) {
            throw NativeImage.showError("Failed to check for 'cl.exe'.", e);
        }
    }

    private static void processLineWithKeyValue(String line, BiConsumer<String, String> consumeKeyValue) {
        String[] parts = line.split("=");
        if (parts.length == 2) {
            consumeKeyValue.accept(parts[0], parts[1]);
        }
    }

    private static Error fail(String reason) {
        return WindowsBuildEnvironmentUtil.fail(reason, null);
    }

    private static Error fail(String reason, Throwable e) {
        throw NativeImage.showError(String.format("%s%nPlease make sure that %s or later is installed on your system. You can download it at https://visualstudio.microsoft.com/downloads/. If this error persists, please try and run GraalVM Native Image in an x64 Native Tools Command Prompt or file a ticket.", reason, VISUAL_STUDIO_MINIMUM_REQUIRED_VERSION), e);
    }
}

