/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionType;

public class SubstrateOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AOTInline": {
                return OptionDescriptor.create((String)"AOTInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Deprecated", SubstrateOptions.class, (String)"AOTInline", SubstrateOptions.AOTInline, (boolean)true, (String)"");
            }
            case "AOTTrivialInline": {
                return OptionDescriptor.create((String)"AOTTrivialInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Perform trivial method inlining in the AOT compiled native image", SubstrateOptions.class, (String)"AOTTrivialInline", SubstrateOptions.AOTTrivialInline, (boolean)false, (String)"");
            }
            case "APIFunctionPrefix": {
                return OptionDescriptor.create((String)"APIFunctionPrefix", (OptionType)OptionType.Debug, String.class, (String)"Prefix that is added to the names of API functions.", SubstrateOptions.class, (String)"APIFunctionPrefix", SubstrateOptions.APIFunctionPrefix, (boolean)false, (String)"");
            }
            case "ActiveProcessorCount": {
                return OptionDescriptor.create((String)"ActiveProcessorCount", (OptionType)OptionType.Debug, Integer.class, (String)"Overwrites the available number of processors provided by the OS. Any value <= 0 means using the processor count from the OS.", SubstrateOptions.class, (String)"ActiveProcessorCount", SubstrateOptions.ActiveProcessorCount, (boolean)false, (String)"");
            }
            case "AdditionalHeaderBytes": {
                return OptionDescriptor.create((String)"AdditionalHeaderBytes", (OptionType)OptionType.Debug, Integer.class, (String)"Add additional header bytes to each object, for diagnostic purposes.", SubstrateOptions.class, (String)"AdditionalHeaderBytes", SubstrateOptions.AdditionalHeaderBytes, (boolean)false, (String)"");
            }
            case "AllocateInstancePrefetchLines": {
                return OptionDescriptor.create((String)"AllocateInstancePrefetchLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of cache lines to load after the object address using prefetch instructions.", SubstrateOptions.class, (String)"AllocateInstancePrefetchLines", SubstrateOptions.AllocateInstancePrefetchLines, (boolean)false, (String)"");
            }
            case "AllocatePrefetchDistance": {
                return OptionDescriptor.create((String)"AllocatePrefetchDistance", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point.", SubstrateOptions.class, (String)"AllocatePrefetchDistance", SubstrateOptions.AllocatePrefetchDistance, (boolean)false, (String)"");
            }
            case "AllocatePrefetchInstr": {
                return OptionDescriptor.create((String)"AllocatePrefetchInstr", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform.", SubstrateOptions.class, (String)"AllocatePrefetchInstr", SubstrateOptions.AllocatePrefetchInstr, (boolean)false, (String)"");
            }
            case "AllocatePrefetchLines": {
                return OptionDescriptor.create((String)"AllocatePrefetchLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of cache lines to load after the array allocation using prefetch instructions.", SubstrateOptions.class, (String)"AllocatePrefetchLines", SubstrateOptions.AllocatePrefetchLines, (boolean)false, (String)"");
            }
            case "AllocatePrefetchStepSize": {
                return OptionDescriptor.create((String)"AllocatePrefetchStepSize", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the step size (in bytes) for sequential prefetch instructions.", SubstrateOptions.class, (String)"AllocatePrefetchStepSize", SubstrateOptions.AllocatePrefetchStepSize, (boolean)false, (String)"");
            }
            case "AllocatePrefetchStyle": {
                return OptionDescriptor.create((String)"AllocatePrefetchStyle", (OptionType)OptionType.Debug, Integer.class, (String)"Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation.", SubstrateOptions.class, (String)"AllocatePrefetchStyle", SubstrateOptions.AllocatePrefetchStyle, (boolean)false, (String)"");
            }
            case "AllowDeprecatedBuilderClassesOnImageClasspath": {
                return OptionDescriptor.create((String)"AllowDeprecatedBuilderClassesOnImageClasspath", (OptionType)OptionType.Debug, Boolean.class, (String)"Instead of abort, only warn if image builder classes are found on the image class-path.", SubstrateOptions.class, (String)"AllowDeprecatedBuilderClassesOnImageClasspath", SubstrateOptions.AllowDeprecatedBuilderClassesOnImageClasspath, (boolean)false, (String)"");
            }
            case "AllowVMInternalThreads": {
                return OptionDescriptor.create((String)"AllowVMInternalThreads", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if VM internal threads (e.g., a dedicated VM operation or reference handling thread) are allowed in this image.", SubstrateOptions.class, (String)"AllowVMInternalThreads", SubstrateOptions.AllowVMInternalThreads, (boolean)false, (String)"");
            }
            case "AutomaticReferenceHandling": {
                return OptionDescriptor.create((String)"AutomaticReferenceHandling", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if the reference handling is executed automatically or manually.", SubstrateOptions.ConcealedOptions.class, (String)"AutomaticReferenceHandling", SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling, (boolean)false, (String)"");
            }
            case "BuildOutputBreakdowns": {
                return OptionDescriptor.create((String)"BuildOutputBreakdowns", (OptionType)OptionType.User, Boolean.class, (String)"Show code and heap breakdowns as part of the build output", SubstrateOptions.class, (String)"BuildOutputBreakdowns", SubstrateOptions.BuildOutputBreakdowns, (boolean)false, (String)"");
            }
            case "BuildOutputColorful": {
                return OptionDescriptor.create((String)"BuildOutputColorful", (OptionType)OptionType.User, Boolean.class, (String)"Colorize build output (enabled by default if colors are supported by terminal)", SubstrateOptions.class, (String)"BuildOutputColorful", SubstrateOptions.BuildOutputColorful, (boolean)false, (String)"");
            }
            case "BuildOutputGCWarnings": {
                return OptionDescriptor.create((String)"BuildOutputGCWarnings", (OptionType)OptionType.User, Boolean.class, (String)"Print GC warnings as part of build output", SubstrateOptions.class, (String)"BuildOutputGCWarnings", SubstrateOptions.BuildOutputGCWarnings, (boolean)false, (String)"");
            }
            case "BuildOutputJSONFile": {
                return OptionDescriptor.create((String)"BuildOutputJSONFile", (OptionType)OptionType.User, LocatableMultiOptionValue.Paths.class, (String)"Print build output statistics as JSON to the specified file. The output conforms to the JSON schema located at: docs/reference-manual/native-image/assets/build-output-schema-v0.9.1.json", SubstrateOptions.class, (String)"BuildOutputJSONFile", SubstrateOptions.BuildOutputJSONFile, (boolean)false, (String)"");
            }
            case "BuildOutputLinks": {
                return OptionDescriptor.create((String)"BuildOutputLinks", (OptionType)OptionType.User, Boolean.class, (String)"Show links in build output (defaults to the value of BuildOutputColorful)", SubstrateOptions.class, (String)"BuildOutputLinks", SubstrateOptions.BuildOutputLinks, (boolean)false, (String)"");
            }
            case "BuildOutputPrefix": {
                return OptionDescriptor.create((String)"BuildOutputPrefix", (OptionType)OptionType.User, Boolean.class, (String)"Prefix build output with '<pid>:<image name>'", SubstrateOptions.class, (String)"BuildOutputPrefix", SubstrateOptions.BuildOutputPrefix, (boolean)false, (String)"");
            }
            case "BuildOutputProgress": {
                return OptionDescriptor.create((String)"BuildOutputProgress", (OptionType)OptionType.User, Boolean.class, (String)"Report progress in build output (default is adaptive)", SubstrateOptions.class, (String)"BuildOutputProgress", SubstrateOptions.BuildOutputProgress, (boolean)false, (String)"");
            }
            case "BuildOutputRecommendations": {
                return OptionDescriptor.create((String)"BuildOutputRecommendations", (OptionType)OptionType.User, Boolean.class, (String)"Show recommendations as part of the build output", SubstrateOptions.class, (String)"BuildOutputRecommendations", SubstrateOptions.BuildOutputRecommendations, (boolean)false, (String)"");
            }
            case "BuildOutputSilent": {
                return OptionDescriptor.create((String)"BuildOutputSilent", (OptionType)OptionType.User, Boolean.class, (String)"Silence build output", SubstrateOptions.class, (String)"BuildOutputSilent", SubstrateOptions.BuildOutputSilent, (boolean)false, (String)"");
            }
            case "CCompilerOption": {
                return OptionDescriptor.create((String)"CCompilerOption", (OptionType)OptionType.User, LocatableMultiOptionValue.Strings.class, (String)"Provide custom C compiler option used for query code compilation.", SubstrateOptions.class, (String)"CCompilerOption", SubstrateOptions.CCompilerOption, (boolean)false, (String)"");
            }
            case "CCompilerPath": {
                return OptionDescriptor.create((String)"CCompilerPath", (OptionType)OptionType.User, String.class, (String)"Provide custom path to C compiler used for query code compilation and linking.", SubstrateOptions.class, (String)"CCompilerPath", SubstrateOptions.CCompilerPath, (boolean)false, (String)"");
            }
            case "CLibraryPath": {
                return OptionDescriptor.create((String)"CLibraryPath", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Paths.class, (String)"Search path for C libraries passed to the linker (list of comma-separated directories)", SubstrateOptions.class, (String)"CLibraryPath", SubstrateOptions.CLibraryPath, (boolean)false, (String)"");
            }
            case "CheckIsolateThreadAtEntry": {
                return OptionDescriptor.create((String)"CheckIsolateThreadAtEntry", (OptionType)OptionType.Debug, Boolean.class, (String)"At CEntryPoints check that the passed IsolateThread is valid.", SubstrateOptions.class, (String)"CheckIsolateThreadAtEntry", SubstrateOptions.CheckIsolateThreadAtEntry, (boolean)false, (String)"");
            }
            case "CheckToolchain": {
                return OptionDescriptor.create((String)"CheckToolchain", (OptionType)OptionType.Expert, Boolean.class, (String)"Check if native-toolchain is known to work with native-image", SubstrateOptions.class, (String)"CheckToolchain", SubstrateOptions.CheckToolchain, (boolean)false, (String)"");
            }
            case "Class": {
                return OptionDescriptor.create((String)"Class", (OptionType)OptionType.User, String.class, (String)"Class containing the default entry point method. Optional if --shared is used.", SubstrateOptions.class, (String)"Class", SubstrateOptions.Class, (boolean)false, (String)"");
            }
            case "CodeAlignment": {
                return OptionDescriptor.create((String)"CodeAlignment", (OptionType)OptionType.Debug, Integer.class, (String)"Alignment of AOT and JIT compiled code in bytes.", SubstrateOptions.class, (String)"CodeAlignment", SubstrateOptions.CodeAlignment, (boolean)false, (String)"");
            }
            case "CompilationIsolateAddressSpaceSize": {
                return OptionDescriptor.create((String)"CompilationIsolateAddressSpaceSize", (OptionType)OptionType.Debug, Long.class, (String)"Size of the reserved address space of each compilation isolate (0: default for new isolates).", SubstrateOptions.class, (String)"CompilationIsolateAddressSpaceSize", SubstrateOptions.CompilationIsolateAddressSpaceSize, (boolean)false, (String)"");
            }
            case "CompileInIsolates": {
                return OptionDescriptor.create((String)"CompileInIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Activate runtime compilation in separate isolates (enable support during image build with option SupportCompileInIsolates).", SubstrateOptions.ConcealedOptions.class, (String)"CompileInIsolates", SubstrateOptions.ConcealedOptions.CompileInIsolates, (boolean)false, (String)"");
            }
            case "CompilerBackend": {
                return OptionDescriptor.create((String)"CompilerBackend", (OptionType)OptionType.User, String.class, (String)"Backend used by the compiler", SubstrateOptions.class, (String)"CompilerBackend", SubstrateOptions.CompilerBackend, (boolean)false, (String)"");
            }
            case "ConfigureReflectionMetadata": {
                return OptionDescriptor.create((String)"ConfigureReflectionMetadata", (OptionType)OptionType.Expert, Boolean.class, (String)"Enable runtime instantiation of reflection objects for non-invoked methods.", SubstrateOptions.class, (String)"ConfigureReflectionMetadata", SubstrateOptions.ConfigureReflectionMetadata, (boolean)true, (String)"");
            }
            case "ContendedPaddingWidth": {
                return OptionDescriptor.create((String)"ContendedPaddingWidth", (OptionType)OptionType.Debug, Integer.class, (String)"How many bytes to pad fields and classes marked @Contended with.", SubstrateOptions.class, (String)"ContendedPaddingWidth", SubstrateOptions.ContendedPaddingWidth, (boolean)false, (String)"");
            }
            case "DeadlockWatchdogExitOnTimeout": {
                return OptionDescriptor.create((String)"DeadlockWatchdogExitOnTimeout", (OptionType)OptionType.Expert, Boolean.class, (String)"Exit the image builder VM after printing call stacks", SubstrateOptions.class, (String)"DeadlockWatchdogExitOnTimeout", SubstrateOptions.DeadlockWatchdogExitOnTimeout, (boolean)false, (String)"");
            }
            case "DeadlockWatchdogInterval": {
                return OptionDescriptor.create((String)"DeadlockWatchdogInterval", (OptionType)OptionType.Expert, Integer.class, (String)"The interval in minutes between watchdog checks (0 disables the watchdog)", SubstrateOptions.class, (String)"DeadlockWatchdogInterval", SubstrateOptions.DeadlockWatchdogInterval, (boolean)false, (String)"");
            }
            case "Debug": {
                return OptionDescriptor.create((String)"Debug", (OptionType)OptionType.Debug, Integer.class, (String)"Control debug information output: 0 - no debuginfo, 1 - AOT code debuginfo, 2 - AOT and runtime code debuginfo (runtime code support only with -H:+UseOldDebugInfo).", SubstrateOptions.class, (String)"Debug", SubstrateOptions.Debug, (boolean)true, (String)"Please use the -g option.");
            }
            case "DebugCodeInfoMaxDepth": {
                return OptionDescriptor.create((String)"DebugCodeInfoMaxDepth", (OptionType)OptionType.Debug, Integer.class, (String)"Specify maximum inlining depth to consider when building DebugCodeInfo", SubstrateOptions.class, (String)"DebugCodeInfoMaxDepth", SubstrateOptions.DebugCodeInfoMaxDepth, (boolean)false, (String)"");
            }
            case "DebugCodeInfoUseSourceMappings": {
                return OptionDescriptor.create((String)"DebugCodeInfoUseSourceMappings", (OptionType)OptionType.Debug, Boolean.class, (String)"Do not use SourceMappings for generating DebugCodeInfo (i.e. only use Infopoints)", SubstrateOptions.class, (String)"DebugCodeInfoUseSourceMappings", SubstrateOptions.DebugCodeInfoUseSourceMappings, (boolean)false, (String)"");
            }
            case "DebugInfoSourceCacheRoot": {
                return OptionDescriptor.create((String)"DebugInfoSourceCacheRoot", (OptionType)OptionType.Debug, String.class, (String)"Directory under which to create source file cache for Application or GraalVM classes", SubstrateOptions.class, (String)"DebugInfoSourceCacheRoot", SubstrateOptions.DebugInfoSourceCacheRoot, (boolean)false, (String)"");
            }
            case "DebugInfoSourceSearchPath": {
                return OptionDescriptor.create((String)"DebugInfoSourceSearchPath", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Paths.class, (String)"Search path for source files for Application or GraalVM classes (list of comma-separated directories or jar files)", SubstrateOptions.class, (String)"DebugInfoSourceSearchPath", SubstrateOptions.DebugInfoSourceSearchPath, (boolean)false, (String)"");
            }
            case "DeleteLocalSymbols": {
                return OptionDescriptor.create((String)"DeleteLocalSymbols", (OptionType)OptionType.Debug, Boolean.class, (String)"Use linker option to remove all local symbols from image.", SubstrateOptions.class, (String)"DeleteLocalSymbols", SubstrateOptions.DeleteLocalSymbols, (boolean)false, (String)"");
            }
            case "DetectUserDirectoriesInImageHeap": {
                return OptionDescriptor.create((String)"DetectUserDirectoriesInImageHeap", (OptionType)OptionType.User, Boolean.class, (String)"When set to true, the image generator verifies that the image heap does not contain a home directory as a substring", SubstrateOptions.class, (String)"DetectUserDirectoriesInImageHeap", SubstrateOptions.DetectUserDirectoriesInImageHeap, (boolean)false, (String)"");
            }
            case "DiagnosticBufferSize": {
                return OptionDescriptor.create((String)"DiagnosticBufferSize", (OptionType)OptionType.Debug, Integer.class, (String)"Specifies the number of entries that diagnostic buffers have.", SubstrateOptions.class, (String)"DiagnosticBufferSize", SubstrateOptions.DiagnosticBufferSize, (boolean)false, (String)"");
            }
            case "DiagnosticDetails": {
                return OptionDescriptor.create((String)"DiagnosticDetails", (OptionType)OptionType.Expert, String.class, (String)"Specifies how many details are printed for certain diagnostic thunks, e.g.: 'DumpThreads:1,DumpRegisters:2'. A value of 1 will result in the maximum amount of information, higher values will print less information. By default, the most detailed output is enabled for all diagnostic thunks. Wildcards (*) are supported in the name of the diagnostic thunk.", SubstrateOptions.class, (String)"DiagnosticDetails", SubstrateOptions.DiagnosticDetails, (boolean)false, (String)"");
            }
            case "DisableTypeIdResultVerification": {
                return OptionDescriptor.create((String)"DisableTypeIdResultVerification", (OptionType)OptionType.Debug, Boolean.class, (String)"For internal purposes only. Disables type id result verification even when running with assertions enabled.", SubstrateOptions.class, (String)"DisableTypeIdResultVerification", SubstrateOptions.DisableTypeIdResultVerification, (boolean)false, (String)"");
            }
            case "DisableURLProtocols": {
                return OptionDescriptor.create((String)"DisableURLProtocols", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"List of comma separated URL protocols that must never be included.", SubstrateOptions.class, (String)"DisableURLProtocols", SubstrateOptions.DisableURLProtocols, (boolean)false, (String)"");
            }
            case "DumpHeapAndExit": {
                return OptionDescriptor.create((String)"DumpHeapAndExit", (OptionType)OptionType.Debug, Boolean.class, (String)"Create a heap dump and exit.", SubstrateOptions.class, (String)"DumpHeapAndExit", SubstrateOptions.DumpHeapAndExit, (boolean)false, (String)"");
            }
            case "DumpTargetInfo": {
                return OptionDescriptor.create((String)"DumpTargetInfo", (OptionType)OptionType.User, Boolean.class, (String)"Show native-toolchain information and image-build settings", SubstrateOptions.class, (String)"DumpTargetInfo", SubstrateOptions.DumpTargetInfo, (boolean)false, (String)"");
            }
            case "EnableAllSecurityServices": {
                return OptionDescriptor.create((String)"EnableAllSecurityServices", (OptionType)OptionType.Debug, Boolean.class, (String)"Add all security service classes to the generated image.", SubstrateOptions.class, (String)"EnableAllSecurityServices", SubstrateOptions.EnableAllSecurityServices, (boolean)true, (String)"");
            }
            case "EnableSignalAPI": {
                return OptionDescriptor.create((String)"EnableSignalAPI", (OptionType)OptionType.Expert, Boolean.class, (String)"Enables the signal API (sun.misc.Signal or jdk.internal.misc.Signal). Defaults to false for shared library and true for executables", SubstrateOptions.class, (String)"EnableSignalAPI", SubstrateOptions.EnableSignalAPI, (boolean)false, (String)"");
            }
            case "EnableSignalHandling": {
                return OptionDescriptor.create((String)"EnableSignalHandling", (OptionType)OptionType.Expert, Boolean.class, (String)"Enables signal handling", SubstrateOptions.class, (String)"EnableSignalHandling", SubstrateOptions.EnableSignalHandling, (boolean)false, (String)"");
            }
            case "EnableURLProtocols": {
                return OptionDescriptor.create((String)"EnableURLProtocols", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"List of comma separated URL protocols to enable.", SubstrateOptions.class, (String)"EnableURLProtocols", SubstrateOptions.EnableURLProtocols, (boolean)false, (String)"");
            }
            case "EnableWildcardExpansion": {
                return OptionDescriptor.create((String)"EnableWildcardExpansion", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable wildcard expansion in command line arguments on Windows.", SubstrateOptions.class, (String)"EnableWildcardExpansion", SubstrateOptions.EnableWildcardExpansion, (boolean)false, (String)"");
            }
            case "EntryPointNamePrefix": {
                return OptionDescriptor.create((String)"EntryPointNamePrefix", (OptionType)OptionType.Debug, String.class, (String)"Prefix that is added to the names of entry point methods.", SubstrateOptions.class, (String)"EntryPointNamePrefix", SubstrateOptions.EntryPointNamePrefix, (boolean)false, (String)"");
            }
            case "FallbackThreshold": {
                return OptionDescriptor.create((String)"FallbackThreshold", (OptionType)OptionType.Debug, Integer.class, (String)"Define when fallback-image generation should be used.", SubstrateOptions.class, (String)"FallbackThreshold", SubstrateOptions.FallbackThreshold, (boolean)false, (String)"");
            }
            case "FlightRecorder": {
                return OptionDescriptor.create((String)"FlightRecorder", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable Java Flight Recorder.", SubstrateOptions.class, (String)"FlightRecorder", SubstrateOptions.FlightRecorder, (boolean)false, (String)"");
            }
            case "FlightRecorderLogging": {
                return OptionDescriptor.create((String)"FlightRecorderLogging", (OptionType)OptionType.Debug, String.class, (String)"Usage: -XX:FlightRecorderLogging=[tag1[+tag2...][*][=level][,...]]", (String[])new String[]{"", "When this option is not set, logging is enabled at a level of WARNING.", "When this option is set to the empty string, logging is enabled at a level of INFO.", "When this option is set to \"disable\", logging is disabled entirely.", "", "Otherwise, this option expects a comma separated list of tag combinations, each with an optional wildcard (*) and level.", "A tag combination without a level is given a default level of INFO.", "Messages with tags that match a given tag combination are set to log at that tag combination's level.", "If a tag combination does not have a wildcard, then only messages with exactly the same tags are matched.", "Otherwise, messages whose tags are a subset of the tag combination are matched.", "Specifying \"all\" instead of a tag combination matches all tag combinations.", "If more than one tag combination matches a message's tags, the rightmost one will apply.", "Messages with tags that do not have any matching tag combinations are set to log at a default level of WARNING.", "This option is case insensitive.", "", "Available log levels:", "[trace, debug, info, warning, error, off]", "", "Available log tags:", "[jfr, system, event, setting, bytecode, parser, metadata, dcmd]"}, SubstrateOptions.class, (String)"FlightRecorderLogging", SubstrateOptions.FlightRecorderLogging, (boolean)false, (String)"");
            }
            case "FoldSecurityManagerGetter": {
                return OptionDescriptor.create((String)"FoldSecurityManagerGetter", (OptionType)OptionType.Expert, Boolean.class, (String)"Fold SecurityManager getter.", SubstrateOptions.class, (String)"FoldSecurityManagerGetter", SubstrateOptions.FoldSecurityManagerGetter, (boolean)false, (String)"");
            }
            case "ForceNoROSectionRelocations": {
                return OptionDescriptor.create((String)"ForceNoROSectionRelocations", (OptionType)OptionType.Debug, Boolean.class, (String)"Use only a writable native image heap (requires ld.gold linker)", SubstrateOptions.class, (String)"ForceNoROSectionRelocations", SubstrateOptions.ForceNoROSectionRelocations, (boolean)false, (String)"");
            }
            case "GenerateBuildArtifactsFile": {
                return OptionDescriptor.create((String)"GenerateBuildArtifactsFile", (OptionType)OptionType.User, Boolean.class, (String)"Create a build-artifacts.json file in the build directory. The output conforms to the JSON schema located at: docs/reference-manual/native-image/assets/build-artifacts-schema-v0.9.0.json", SubstrateOptions.class, (String)"GenerateBuildArtifactsFile", SubstrateOptions.GenerateBuildArtifactsFile, (boolean)false, (String)"");
            }
            case "GenerateDebugInfo": {
                return OptionDescriptor.create((String)"GenerateDebugInfo", (OptionType)OptionType.Debug, Integer.class, (String)"Insert debug info into the generated native image or library", SubstrateOptions.class, (String)"GenerateDebugInfo", SubstrateOptions.GenerateDebugInfo, (boolean)false, (String)"");
            }
            case "HeapDumpPath": {
                return OptionDescriptor.create((String)"HeapDumpPath", (OptionType)OptionType.Debug, String.class, (String)"The path (filename or directory) where heap dumps are created (defaults to the working directory).", SubstrateOptions.class, (String)"HeapDumpPath", SubstrateOptions.HeapDumpPath, (boolean)false, (String)"");
            }
            case "ImageSymbolsPrefix": {
                return OptionDescriptor.create((String)"ImageSymbolsPrefix", (OptionType)OptionType.Debug, String.class, (String)"Common prefix used by method symbols in image.", SubstrateOptions.class, (String)"ImageSymbolsPrefix", SubstrateOptions.ImageSymbolsPrefix, (boolean)false, (String)"");
            }
            case "ImplicitExceptionWithoutStacktraceIsFatal": {
                return OptionDescriptor.create((String)"ImplicitExceptionWithoutStacktraceIsFatal", (OptionType)OptionType.Debug, Boolean.class, (String)"Determines if implicit exceptions are fatal if they don't have a stack trace.", SubstrateOptions.class, (String)"ImplicitExceptionWithoutStacktraceIsFatal", SubstrateOptions.ImplicitExceptionWithoutStacktraceIsFatal, (boolean)false, (String)"");
            }
            case "IncludeDebugHelperMethods": {
                return OptionDescriptor.create((String)"IncludeDebugHelperMethods", (OptionType)OptionType.Debug, Boolean.class, (String)"Determines if debugging-specific helper methods are embedded into the image. Those methods can be called directly from the debugger to obtain or print additional information.", SubstrateOptions.class, (String)"IncludeDebugHelperMethods", SubstrateOptions.IncludeDebugHelperMethods, (boolean)false, (String)"");
            }
            case "IncludeMethodData": {
                return OptionDescriptor.create((String)"IncludeMethodData", (OptionType)OptionType.Expert, Boolean.class, (String)"Include a list of methods included in the image for runtime inspection.", SubstrateOptions.class, (String)"IncludeMethodData", SubstrateOptions.IncludeMethodData, (boolean)false, (String)"");
            }
            case "IncludeNodeSourcePositions": {
                return OptionDescriptor.create((String)"IncludeNodeSourcePositions", (OptionType)OptionType.Debug, Boolean.class, (String)"Track NodeSourcePositions during runtime-compilation", SubstrateOptions.class, (String)"IncludeNodeSourcePositions", SubstrateOptions.IncludeNodeSourcePositions, (boolean)false, (String)"");
            }
            case "InstallExitHandlers": {
                return OptionDescriptor.create((String)"InstallExitHandlers", (OptionType)OptionType.User, Boolean.class, (String)"Provide java.lang.Terminator exit handlers", SubstrateOptions.class, (String)"InstallExitHandlers", SubstrateOptions.InstallExitHandlers, (boolean)false, (String)"");
            }
            case "InternalSymbolsAreGlobal": {
                return OptionDescriptor.create((String)"InternalSymbolsAreGlobal", (OptionType)OptionType.Debug, Boolean.class, (String)"Compatibility option to make symbols used for the image heap global. Using global symbols is problematic for shared libraries because the loader implicitly changes the value when the symbol is already defined in the executable loading the library. Setting this option to true preserves the broken behavior of old Native Image versions.", SubstrateOptions.class, (String)"InternalSymbolsAreGlobal", SubstrateOptions.InternalSymbolsAreGlobal, (boolean)false, (String)"");
            }
            case "InternalThreadStackSize": {
                return OptionDescriptor.create((String)"InternalThreadStackSize", (OptionType)OptionType.Expert, Long.class, (String)"The size of each internal thread stack, in bytes.", SubstrateOptions.class, (String)"InternalThreadStackSize", SubstrateOptions.InternalThreadStackSize, (boolean)false, (String)"");
            }
            case "JNI": {
                return OptionDescriptor.create((String)"JNI", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable Java Native Interface (JNI) support.", SubstrateOptions.class, (String)"JNI", SubstrateOptions.JNI, (boolean)false, (String)"");
            }
            case "JNIExportSymbols": {
                return OptionDescriptor.create((String)"JNIExportSymbols", (OptionType)OptionType.User, Boolean.class, (String)"Export Invocation API symbols.", SubstrateOptions.class, (String)"JNIExportSymbols", SubstrateOptions.JNIExportSymbols, (boolean)false, (String)"");
            }
            case "JNIVerboseLookupErrors": {
                return OptionDescriptor.create((String)"JNIVerboseLookupErrors", (OptionType)OptionType.User, Boolean.class, (String)"Report information about known JNI elements when lookup fails", SubstrateOptions.class, (String)"JNIVerboseLookupErrors", SubstrateOptions.JNIVerboseLookupErrors, (boolean)false, (String)"");
            }
            case "LinkerRPath": {
                return OptionDescriptor.create((String)"LinkerRPath", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Path passed to the linker as the -rpath (list of comma-separated directories)", SubstrateOptions.class, (String)"LinkerRPath", SubstrateOptions.LinkerRPath, (boolean)false, (String)"");
            }
            case "MaxDirectMemorySize": {
                return OptionDescriptor.create((String)"MaxDirectMemorySize", (OptionType)OptionType.Debug, Long.class, (String)"Maximum total size of NIO direct-buffer allocations", SubstrateOptions.class, (String)"MaxDirectMemorySize", SubstrateOptions.MaxDirectMemorySize, (boolean)false, (String)"");
            }
            case "MaxInvokesInTrivialMethod": {
                return OptionDescriptor.create((String)"MaxInvokesInTrivialMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of invokes in a method so that it is considered trivial (for testing only).", SubstrateOptions.class, (String)"MaxInvokesInTrivialMethod", SubstrateOptions.MaxInvokesInTrivialMethod, (boolean)false, (String)"");
            }
            case "MaxJavaStackTraceDepth": {
                return OptionDescriptor.create((String)"MaxJavaStackTraceDepth", (OptionType)OptionType.User, Integer.class, (String)"The maximum number of lines in the stack trace for Java exceptions (0 means all)", SubstrateOptions.class, (String)"MaxJavaStackTraceDepth", SubstrateOptions.MaxJavaStackTraceDepth, (boolean)false, (String)"");
            }
            case "MaxNodesAfterTrivialInlining": {
                return OptionDescriptor.create((String)"MaxNodesAfterTrivialInlining", (OptionType)OptionType.Debug, Integer.class, (String)"The maximum number of nodes in a graph allowed after trivial inlining.", SubstrateOptions.class, (String)"MaxNodesAfterTrivialInlining", SubstrateOptions.MaxNodesAfterTrivialInlining, (boolean)false, (String)"");
            }
            case "MaxNodesInTrivialLeafMethod": {
                return OptionDescriptor.create((String)"MaxNodesInTrivialLeafMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes.", SubstrateOptions.class, (String)"MaxNodesInTrivialLeafMethod", SubstrateOptions.MaxNodesInTrivialLeafMethod, (boolean)false, (String)"");
            }
            case "MaxNodesInTrivialMethod": {
                return OptionDescriptor.create((String)"MaxNodesInTrivialMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of nodes in a method so that it is considered trivial.", SubstrateOptions.class, (String)"MaxNodesInTrivialMethod", SubstrateOptions.MaxNodesInTrivialMethod, (boolean)false, (String)"");
            }
            case "MaxRAM": {
                return OptionDescriptor.create((String)"MaxRAM", (OptionType)OptionType.Expert, Long.class, (String)"Physical memory size (in bytes). By default, the value is queried from the OS/container during VM startup.", SubstrateOptions.class, (String)"MaxRAM", SubstrateOptions.MaxRAM, (boolean)false, (String)"");
            }
            case "MaxUnrolledObjectZeroingStores": {
                return OptionDescriptor.create((String)"MaxUnrolledObjectZeroingStores", (OptionType)OptionType.Debug, Integer.class, (String)"Define the maximum number of stores for which the loop that zeroes out objects is unrolled.", SubstrateOptions.class, (String)"MaxUnrolledObjectZeroingStores", SubstrateOptions.MaxUnrolledObjectZeroingStores, (boolean)false, (String)"");
            }
            case "Method": {
                return OptionDescriptor.create((String)"Method", (OptionType)OptionType.Debug, String.class, (String)"Name of the main entry point method. Optional if --shared is used.", SubstrateOptions.class, (String)"Method", SubstrateOptions.Method, (boolean)false, (String)"");
            }
            case "Module": {
                return OptionDescriptor.create((String)"Module", (OptionType)OptionType.User, String.class, (String)"Module containing the class that contains the main entry point. Optional if --shared is used.", SubstrateOptions.class, (String)"Module", SubstrateOptions.Module, (boolean)false, (String)"");
            }
            case "MultiThreaded": {
                return OptionDescriptor.create((String)"MultiThreaded", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable support for threads and and thread-local variables (disable for single-threaded implementation)", SubstrateOptions.class, (String)"MultiThreaded", SubstrateOptions.MultiThreaded, (boolean)false, (String)"");
            }
            case "Name": {
                return OptionDescriptor.create((String)"Name", (OptionType)OptionType.User, String.class, (String)"Name of the output file to be generated", SubstrateOptions.class, (String)"Name", SubstrateOptions.Name, (boolean)false, (String)"");
            }
            case "NeverInline": {
                return OptionDescriptor.create((String)"NeverInline", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Pattern for disabling inlining of methods during image generation.", (String[])new String[]{"The syntax for a pattern is:", "", "  SourcePatterns = SourcePattern [\",\" SourcePatterns] .", "  SourcePattern = [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .", "  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .", "  Class = { package \".\" } class .", "", "Glob pattern matching (*, ?) is allowed in all parts of the source pattern.", "", "Examples of method filters:", "---------", "  visit(Argument;BlockScope)", "", "  Matches all methods named \"visit\", with the first parameter of", "  type \"Argument\", and the second parameter of type \"BlockScope\".", "  The packages of the parameter types are irrelevant.", "---------", "  arraycopy(Object;;;;)", "", "  Matches all methods named \"arraycopy\", with the first parameter", "  of type \"Object\", and four more parameters of any type. The", "  packages of the parameter types are irrelevant.", "---------", "  org.graalvm.compiler.core.graph.PostOrderNodeIterator.*", "", "  Matches all methods in the class \"org.graalvm.compiler.core.graph.PostOrderNodeIterator\".", "---------", "  *", "", "  Matches all methods in all classes", "---------", "  org.graalvm.compiler.core.graph.*.visit", "", "  Matches all methods named \"visit\" in classes in the package", "  \"org.graalvm.compiler.core.graph\".", "---------", "  arraycopy,toString", "", "  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts as an or operator."}, SubstrateOptions.class, (String)"NeverInline", SubstrateOptions.NeverInline, (boolean)false, (String)"");
            }
            case "OmitInlinedMethodDebugLineInfo": {
                return OptionDescriptor.create((String)"OmitInlinedMethodDebugLineInfo", (OptionType)OptionType.Debug, Boolean.class, (String)"Omit generation of DebugLineInfo originating from inlined methods", SubstrateOptions.class, (String)"OmitInlinedMethodDebugLineInfo", SubstrateOptions.OmitInlinedMethodDebugLineInfo, (boolean)false, (String)"");
            }
            case "Optimize": {
                return OptionDescriptor.create((String)"Optimize", (OptionType)OptionType.User, String.class, (String)"Control code optimizations: b - quick build mode for development, 0 - no optimizations, 1 - basic optimizations, 2 - aggressive optimizations (default).", SubstrateOptions.class, (String)"Optimize", SubstrateOptions.Optimize, (boolean)false, (String)"");
            }
            case "PageSize": {
                return OptionDescriptor.create((String)"PageSize", (OptionType)OptionType.Debug, Integer.class, (String)"Define PageSize of a machine that runs the image. The default = 0 (== same as host machine page size)", SubstrateOptions.class, (String)"PageSize", SubstrateOptions.PageSize, (boolean)false, (String)"");
            }
            case "ParallelGCThreads": {
                return OptionDescriptor.create((String)"ParallelGCThreads", (OptionType)OptionType.User, Integer.class, (String)"Number of GC worker threads. Parallel and G1 GC only.", SubstrateOptions.class, (String)"ParallelGCThreads", SubstrateOptions.ParallelGCThreads, (boolean)false, (String)"");
            }
            case "ParseOnce": {
                return OptionDescriptor.create((String)"ParseOnce", (OptionType)OptionType.Debug, Boolean.class, (String)"When true, compiler graphs are parsed only once before static analysis. When false, compiler graphs are parsed for static analysis and again for AOT compilation.", SubstrateOptions.class, (String)"ParseOnce", SubstrateOptions.ParseOnce, (boolean)false, (String)"");
            }
            case "ParseOnceJIT": {
                return OptionDescriptor.create((String)"ParseOnceJIT", (OptionType)OptionType.Debug, Boolean.class, (String)"When true, each compiler graph version (DeoptTarget, AOT, JIT) needed for runtime compilation will be separately analyzed during static analysis.When false, only one version of the compiler graph (AOT) will be used in static analysis, and then three new versions will be parsed for compilation.", SubstrateOptions.class, (String)"ParseOnceJIT", SubstrateOptions.ParseOnceJIT, (boolean)false, (String)"");
            }
            case "ParseRuntimeOptions": {
                return OptionDescriptor.create((String)"ParseRuntimeOptions", (OptionType)OptionType.Debug, Boolean.class, (String)"Parse and consume standard options and system properties from the command line arguments when the VM is created.", SubstrateOptions.class, (String)"ParseRuntimeOptions", SubstrateOptions.ParseRuntimeOptions, (boolean)false, (String)"");
            }
            case "Path": {
                return OptionDescriptor.create((String)"Path", (OptionType)OptionType.User, String.class, (String)"Directory of the image file to be generated", SubstrateOptions.class, (String)"Path", SubstrateOptions.Path, (boolean)false, (String)"");
            }
            case "PreserveFramePointer": {
                return OptionDescriptor.create((String)"PreserveFramePointer", (OptionType)OptionType.Debug, Boolean.class, (String)"Saves stack base pointer on the stack on method entry.", SubstrateOptions.class, (String)"PreserveFramePointer", SubstrateOptions.PreserveFramePointer, (boolean)false, (String)"");
            }
            case "RemoveUnusedSymbols": {
                return OptionDescriptor.create((String)"RemoveUnusedSymbols", (OptionType)OptionType.Debug, Boolean.class, (String)"Use linker option to prevent unreferenced symbols in image.", SubstrateOptions.class, (String)"RemoveUnusedSymbols", SubstrateOptions.RemoveUnusedSymbols, (boolean)false, (String)"");
            }
            case "ReportAnalysisForbiddenType": {
                return OptionDescriptor.create((String)"ReportAnalysisForbiddenType", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: InHeap, Allocated, Reachable).", SubstrateOptions.class, (String)"ReportAnalysisForbiddenType", SubstrateOptions.ReportAnalysisForbiddenType, (boolean)false, (String)"");
            }
            case "RunMainInNewThread": {
                return OptionDescriptor.create((String)"RunMainInNewThread", (OptionType)OptionType.Expert, Boolean.class, (String)"Initializes and runs main entry point in a new native thread.", SubstrateOptions.class, (String)"RunMainInNewThread", SubstrateOptions.RunMainInNewThread, (boolean)false, (String)"");
            }
            case "RunReachabilityHandlersConcurrently": {
                return OptionDescriptor.create((String)"RunReachabilityHandlersConcurrently", (OptionType)OptionType.Expert, Boolean.class, (String)"Run reachability handlers concurrently during analysis.", SubstrateOptions.class, (String)"RunReachabilityHandlersConcurrently", SubstrateOptions.RunReachabilityHandlersConcurrently, (boolean)false, (String)"");
            }
            case "SharedLibrary": {
                return OptionDescriptor.create((String)"SharedLibrary", (OptionType)OptionType.Debug, Boolean.class, (String)"Build shared library", SubstrateOptions.class, (String)"SharedLibrary", SubstrateOptions.SharedLibrary, (boolean)false, (String)"");
            }
            case "SourceLevelDebug": {
                return OptionDescriptor.create((String)"SourceLevelDebug", (OptionType)OptionType.Debug, Boolean.class, (String)"Preserve the local variable information for every Java source line to allow line-by-line stepping in the debugger. Allow the lookup of Java-level method information, e.g., in stack traces.", SubstrateOptions.class, (String)"SourceLevelDebug", SubstrateOptions.SourceLevelDebug, (boolean)false, (String)"");
            }
            case "SourceLevelDebugFilter": {
                return OptionDescriptor.create((String)"SourceLevelDebugFilter", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Constrain debug info generation to the comma-separated list of package prefixes given to this option.", SubstrateOptions.class, (String)"SourceLevelDebugFilter", SubstrateOptions.SourceLevelDebugFilter, (boolean)false, (String)"");
            }
            case "SpawnIsolates": {
                return OptionDescriptor.create((String)"SpawnIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Support multiple isolates.", SubstrateOptions.class, (String)"SpawnIsolates", SubstrateOptions.SpawnIsolates, (boolean)false, (String)"");
            }
            case "StackSize": {
                return OptionDescriptor.create((String)"StackSize", (OptionType)OptionType.User, Long.class, (String)"The size of each thread stack at run-time, in bytes.", SubstrateOptions.class, (String)"StackSize", SubstrateOptions.StackSize, (boolean)false, (String)"");
            }
            case "StackTrace": {
                return OptionDescriptor.create((String)"StackTrace", (OptionType)OptionType.Debug, Boolean.class, (String)"Provide method names for stack traces.", SubstrateOptions.class, (String)"StackTrace", SubstrateOptions.StackTrace, (boolean)false, (String)"");
            }
            case "StartFlightRecording": {
                return OptionDescriptor.create((String)"StartFlightRecording", (OptionType)OptionType.Debug, String.class, (String)"Start flight recording with options.", SubstrateOptions.class, (String)"StartFlightRecording", SubstrateOptions.StartFlightRecording, (boolean)false, (String)"");
            }
            case "StaticExecutable": {
                return OptionDescriptor.create((String)"StaticExecutable", (OptionType)OptionType.Debug, Boolean.class, (String)"Build statically linked executable (requires static libc and zlib)", SubstrateOptions.class, (String)"StaticExecutable", SubstrateOptions.StaticExecutable, (boolean)false, (String)"");
            }
            case "StaticExecutableWithDynamicLibC": {
                return OptionDescriptor.create((String)"StaticExecutableWithDynamicLibC", (OptionType)OptionType.Expert, Boolean.class, (String)"Builds a statically linked executable with libc dynamically linked", SubstrateOptions.class, (String)"StaticExecutableWithDynamicLibC", SubstrateOptions.StaticExecutableWithDynamicLibC, (boolean)false, (String)"");
            }
            case "StrictQueryCodeCompilation": {
                return OptionDescriptor.create((String)"StrictQueryCodeCompilation", (OptionType)OptionType.User, Boolean.class, (String)"Use strict checks when performing query code compilation.", SubstrateOptions.class, (String)"StrictQueryCodeCompilation", SubstrateOptions.StrictQueryCodeCompilation, (boolean)false, (String)"");
            }
            case "StripDebugInfo": {
                return OptionDescriptor.create((String)"StripDebugInfo", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a separate file for debug info.", SubstrateOptions.class, (String)"StripDebugInfo", SubstrateOptions.StripDebugInfo, (boolean)false, (String)"");
            }
            case "SupportCompileInIsolates": {
                return OptionDescriptor.create((String)"SupportCompileInIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Support runtime compilation in separate isolates (enable at runtime with option CompileInIsolates).", SubstrateOptions.ConcealedOptions.class, (String)"SupportCompileInIsolates", SubstrateOptions.ConcealedOptions.SupportCompileInIsolates, (boolean)false, (String)"");
            }
            case "SupportContinuations": {
                return OptionDescriptor.create((String)"SupportContinuations", (OptionType)OptionType.Debug, Boolean.class, (String)"Support continuations (without requiring a Project Loom JDK)", SubstrateOptions.class, (String)"SupportContinuations", SubstrateOptions.SupportContinuations, (boolean)false, (String)"");
            }
            case "TargetPlatform": {
                return OptionDescriptor.create((String)"TargetPlatform", (OptionType)OptionType.Debug, String.class, (String)"Selects native-image compilation target (in <OS>-<architecture> format). Defaults to host's OS-architecture pair.", SubstrateOptions.class, (String)"TargetPlatform", SubstrateOptions.TargetPlatform, (boolean)false, (String)"");
            }
            case "TearDownFailureNanos": {
                return OptionDescriptor.create((String)"TearDownFailureNanos", (OptionType)OptionType.Debug, Long.class, (String)"The number of nanoseconds before tearing down an isolate gives a failure message.  0 implies no message.", SubstrateOptions.class, (String)"TearDownFailureNanos", SubstrateOptions.TearDownFailureNanos, (boolean)false, (String)"");
            }
            case "TearDownWarningNanos": {
                return OptionDescriptor.create((String)"TearDownWarningNanos", (OptionType)OptionType.Debug, Long.class, (String)"The number of nanoseconds before and between which tearing down an isolate gives a warning message.  0 implies no warning.", SubstrateOptions.class, (String)"TearDownWarningNanos", SubstrateOptions.TearDownWarningNanos, (boolean)false, (String)"");
            }
            case "ThrowMissingRegistrationErrors": {
                return OptionDescriptor.create((String)"ThrowMissingRegistrationErrors", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Throw Native Image-specific errors when trying to access an element that has not been registered.", (String[])new String[]{"This can happen on reflection and serialization queries, and resource access.", "If used without args, the errors will be thrown when calling the corresponding query from any class in scope of the option.", "", "Using -H:ThrowMissingRegistrationErrors without arguments is only allowed on command line or when embedded in a", "native-image.properties file of some zip/jar file on the module-path (but not on class-path).", "", "In the module path case, the option will cause all classes of the module to trigger missing registration errors.", "If used without arguments on command line all classes will trigger missing registration errors.", "", "Using -H:ThrowMissingRegistrationErrors with arguments is allowed in every scope:", "", "  1. On command line", "  2. Embedded in a native-image.properties file of some zip/jar file on module-path", "  3. Embedded in a native-image.properties file of some zip/jar file on class-path", "", "If the option is embedded in native-image.properties file in some zip/jar file all class-names", "and package-names passed to the option have to be found in the zip/jar files the option is embedded", "in. Using -H:ThrowMissingRegistrationErrors with arguments on command line does not have that restriction."}, SubstrateOptions.class, (String)"ThrowMissingRegistrationErrors", SubstrateOptions.ThrowMissingRegistrationErrors, (boolean)false, (String)"");
            }
            case "ThrowMissingRegistrationErrorsPaths": {
                return OptionDescriptor.create((String)"ThrowMissingRegistrationErrorsPaths", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Trigger missing registration errors from all types in the given class or module-path entries.", (String[])new String[]{"", "This option requires arguments that are of the same type as the", "arguments passed via -p (--module-path) or -cp (--class-path):", "", "  -H:ThrowMissingRegistrationErrorsPaths <class search path of directories and zip/jar files>", "", "The given entries are searched and all classes inside are registered as -H:ThrowMissingRegistrationErrorsPaths classes.", "", "This option is only allowed to be used on command line. I.e. the option will be rejected if it is provided", "by Args of a native-image.properties file embedded in a zip/jar file."}, SubstrateOptions.class, (String)"ThrowMissingRegistrationErrorsPaths", SubstrateOptions.ThrowMissingRegistrationErrorsPaths, (boolean)false, (String)"");
            }
            case "TraceClassInitialization": {
                return OptionDescriptor.create((String)"TraceClassInitialization", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Comma-separated list of fully-qualified class names that class initialization is traced for.", SubstrateOptions.class, (String)"TraceClassInitialization", SubstrateOptions.TraceClassInitialization, (boolean)false, (String)"");
            }
            case "TraceNativeToolUsage": {
                return OptionDescriptor.create((String)"TraceNativeToolUsage", (OptionType)OptionType.User, Boolean.class, (String)"Trace all native tool invocations as part of image building", SubstrateOptions.class, (String)"TraceNativeToolUsage", SubstrateOptions.TraceNativeToolUsage, (boolean)false, (String)"");
            }
            case "TraceObjectInstantiation": {
                return OptionDescriptor.create((String)"TraceObjectInstantiation", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Comma-separated list of fully-qualified class names that object instantiation is traced for.", SubstrateOptions.class, (String)"TraceObjectInstantiation", SubstrateOptions.TraceObjectInstantiation, (boolean)false, (String)"");
            }
            case "TraceVMOperations": {
                return OptionDescriptor.create((String)"TraceVMOperations", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace VMOperation execution.", SubstrateOptions.class, (String)"TraceVMOperations", SubstrateOptions.TraceVMOperations, (boolean)false, (String)"");
            }
            case "UnlockExperimentalVMOptions": {
                return OptionDescriptor.create((String)"UnlockExperimentalVMOptions", (OptionType)OptionType.Expert, Boolean.class, (String)"Has no effect in this version of GraalVM. It is present for forward-compatibility with future versions of GraalVM.", SubstrateOptions.class, (String)"UnlockExperimentalVMOptions", SubstrateOptions.UnlockExperimentalVMOptions, (boolean)false, (String)"");
            }
            case "UseCalleeSavedRegisters": {
                return OptionDescriptor.create((String)"UseCalleeSavedRegisters", (OptionType)OptionType.Debug, Boolean.class, (String)"Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)", SubstrateOptions.class, (String)"UseCalleeSavedRegisters", SubstrateOptions.UseCalleeSavedRegisters, (boolean)false, (String)"");
            }
            case "UseCompressedFrameEncodings": {
                return OptionDescriptor.create((String)"UseCompressedFrameEncodings", (OptionType)OptionType.Expert, Boolean.class, (String)"Use compressed frame encoding for frames without local values.", SubstrateOptions.class, (String)"UseCompressedFrameEncodings", SubstrateOptions.UseCompressedFrameEncodings, (boolean)false, (String)"");
            }
            case "UseDedicatedVMOperationThread": {
                return OptionDescriptor.create((String)"UseDedicatedVMOperationThread", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if VM operations should be executed in a dedicated thread.", SubstrateOptions.ConcealedOptions.class, (String)"UseDedicatedVMOperationThread", SubstrateOptions.ConcealedOptions.UseDedicatedVMOperationThread, (boolean)false, (String)"");
            }
            case "UseDirectCallTrampolinesALot": {
                return OptionDescriptor.create((String)"UseDirectCallTrampolinesALot", (OptionType)OptionType.Debug, Boolean.class, (String)"Force many trampolines to be needed for inter-method calls. Normally trampolines are only used when a method destination is outside the range of a pc-relative branch instruction.", SubstrateOptions.class, (String)"UseDirectCallTrampolinesALot", SubstrateOptions.UseDirectCallTrampolinesALot, (boolean)false, (String)"");
            }
            case "UseEpsilonGC": {
                return OptionDescriptor.create((String)"UseEpsilonGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a no-op GC", SubstrateOptions.class, (String)"UseEpsilonGC", SubstrateOptions.UseEpsilonGC, (boolean)false, (String)"");
            }
            case "UseImagebuildDebugSections": {
                return OptionDescriptor.create((String)"UseImagebuildDebugSections", (OptionType)OptionType.Debug, Boolean.class, (String)"Emit debuginfo debug.svm.imagebuild.* sections with detailed image-build options.", SubstrateOptions.class, (String)"UseImagebuildDebugSections", SubstrateOptions.UseImagebuildDebugSections, (boolean)false, (String)"");
            }
            case "UseNullRegion": {
                return OptionDescriptor.create((String)"UseNullRegion", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if a null region is present between the heap base and the image heap.", SubstrateOptions.class, (String)"UseNullRegion", SubstrateOptions.UseNullRegion, (boolean)false, (String)"");
            }
            case "UseOldDebugInfo": {
                return OptionDescriptor.create((String)"UseOldDebugInfo", (OptionType)OptionType.Debug, Boolean.class, (String)"Use old debuginfo", SubstrateOptions.class, (String)"UseOldDebugInfo", SubstrateOptions.UseOldDebugInfo, (boolean)true, (String)"Please use the -g option.");
            }
            case "UseParallelGC": {
                return OptionDescriptor.create((String)"UseParallelGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a parallel GC", SubstrateOptions.class, (String)"UseParallelGC", SubstrateOptions.UseParallelGC, (boolean)false, (String)"");
            }
            case "UsePerfData": {
                return OptionDescriptor.create((String)"UsePerfData", (OptionType)OptionType.Debug, Boolean.class, (String)"Flag to disable jvmstat instrumentation for performance testing.", SubstrateOptions.ConcealedOptions.class, (String)"UsePerfData", SubstrateOptions.ConcealedOptions.UsePerfData, (boolean)false, (String)"");
            }
            case "UseRememberedSet": {
                return OptionDescriptor.create((String)"UseRememberedSet", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if a remembered sets is used, which is necessary for collecting the young and old generation independently.", SubstrateOptions.ConcealedOptions.class, (String)"UseRememberedSet", SubstrateOptions.ConcealedOptions.UseRememberedSet, (boolean)false, (String)"");
            }
            case "UseSerialGC": {
                return OptionDescriptor.create((String)"UseSerialGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a serial GC", SubstrateOptions.class, (String)"UseSerialGC", SubstrateOptions.UseSerialGC, (boolean)false, (String)"");
            }
            case "VerifyNamingConventions": {
                return OptionDescriptor.create((String)"VerifyNamingConventions", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify naming conventions during image construction.", SubstrateOptions.class, (String)"VerifyNamingConventions", SubstrateOptions.VerifyNamingConventions, (boolean)false, (String)"");
            }
            case "VerifyTypes": {
                return OptionDescriptor.create((String)"VerifyTypes", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify type states computed by the static analysis at run time. This is useful when diagnosing problems in the static analysis, but reduces peak performance significantly.", SubstrateOptions.class, (String)"VerifyTypes", SubstrateOptions.VerifyTypes, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 139;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return SubstrateOptions_OptionDescriptors.this.get("AOTInline");
                    }
                    case 1: {
                        return SubstrateOptions_OptionDescriptors.this.get("AOTTrivialInline");
                    }
                    case 2: {
                        return SubstrateOptions_OptionDescriptors.this.get("APIFunctionPrefix");
                    }
                    case 3: {
                        return SubstrateOptions_OptionDescriptors.this.get("ActiveProcessorCount");
                    }
                    case 4: {
                        return SubstrateOptions_OptionDescriptors.this.get("AdditionalHeaderBytes");
                    }
                    case 5: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocateInstancePrefetchLines");
                    }
                    case 6: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchDistance");
                    }
                    case 7: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchInstr");
                    }
                    case 8: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchLines");
                    }
                    case 9: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchStepSize");
                    }
                    case 10: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchStyle");
                    }
                    case 11: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllowDeprecatedBuilderClassesOnImageClasspath");
                    }
                    case 12: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllowVMInternalThreads");
                    }
                    case 13: {
                        return SubstrateOptions_OptionDescriptors.this.get("AutomaticReferenceHandling");
                    }
                    case 14: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputBreakdowns");
                    }
                    case 15: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputColorful");
                    }
                    case 16: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputGCWarnings");
                    }
                    case 17: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputJSONFile");
                    }
                    case 18: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputLinks");
                    }
                    case 19: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputPrefix");
                    }
                    case 20: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputProgress");
                    }
                    case 21: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputRecommendations");
                    }
                    case 22: {
                        return SubstrateOptions_OptionDescriptors.this.get("BuildOutputSilent");
                    }
                    case 23: {
                        return SubstrateOptions_OptionDescriptors.this.get("CCompilerOption");
                    }
                    case 24: {
                        return SubstrateOptions_OptionDescriptors.this.get("CCompilerPath");
                    }
                    case 25: {
                        return SubstrateOptions_OptionDescriptors.this.get("CLibraryPath");
                    }
                    case 26: {
                        return SubstrateOptions_OptionDescriptors.this.get("CheckIsolateThreadAtEntry");
                    }
                    case 27: {
                        return SubstrateOptions_OptionDescriptors.this.get("CheckToolchain");
                    }
                    case 28: {
                        return SubstrateOptions_OptionDescriptors.this.get("Class");
                    }
                    case 29: {
                        return SubstrateOptions_OptionDescriptors.this.get("CodeAlignment");
                    }
                    case 30: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilationIsolateAddressSpaceSize");
                    }
                    case 31: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompileInIsolates");
                    }
                    case 32: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilerBackend");
                    }
                    case 33: {
                        return SubstrateOptions_OptionDescriptors.this.get("ConfigureReflectionMetadata");
                    }
                    case 34: {
                        return SubstrateOptions_OptionDescriptors.this.get("ContendedPaddingWidth");
                    }
                    case 35: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeadlockWatchdogExitOnTimeout");
                    }
                    case 36: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeadlockWatchdogInterval");
                    }
                    case 37: {
                        return SubstrateOptions_OptionDescriptors.this.get("Debug");
                    }
                    case 38: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugCodeInfoMaxDepth");
                    }
                    case 39: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugCodeInfoUseSourceMappings");
                    }
                    case 40: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugInfoSourceCacheRoot");
                    }
                    case 41: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugInfoSourceSearchPath");
                    }
                    case 42: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeleteLocalSymbols");
                    }
                    case 43: {
                        return SubstrateOptions_OptionDescriptors.this.get("DetectUserDirectoriesInImageHeap");
                    }
                    case 44: {
                        return SubstrateOptions_OptionDescriptors.this.get("DiagnosticBufferSize");
                    }
                    case 45: {
                        return SubstrateOptions_OptionDescriptors.this.get("DiagnosticDetails");
                    }
                    case 46: {
                        return SubstrateOptions_OptionDescriptors.this.get("DisableTypeIdResultVerification");
                    }
                    case 47: {
                        return SubstrateOptions_OptionDescriptors.this.get("DisableURLProtocols");
                    }
                    case 48: {
                        return SubstrateOptions_OptionDescriptors.this.get("DumpHeapAndExit");
                    }
                    case 49: {
                        return SubstrateOptions_OptionDescriptors.this.get("DumpTargetInfo");
                    }
                    case 50: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableAllSecurityServices");
                    }
                    case 51: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableSignalAPI");
                    }
                    case 52: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableSignalHandling");
                    }
                    case 53: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableURLProtocols");
                    }
                    case 54: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableWildcardExpansion");
                    }
                    case 55: {
                        return SubstrateOptions_OptionDescriptors.this.get("EntryPointNamePrefix");
                    }
                    case 56: {
                        return SubstrateOptions_OptionDescriptors.this.get("FallbackThreshold");
                    }
                    case 57: {
                        return SubstrateOptions_OptionDescriptors.this.get("FlightRecorder");
                    }
                    case 58: {
                        return SubstrateOptions_OptionDescriptors.this.get("FlightRecorderLogging");
                    }
                    case 59: {
                        return SubstrateOptions_OptionDescriptors.this.get("FoldSecurityManagerGetter");
                    }
                    case 60: {
                        return SubstrateOptions_OptionDescriptors.this.get("ForceNoROSectionRelocations");
                    }
                    case 61: {
                        return SubstrateOptions_OptionDescriptors.this.get("GenerateBuildArtifactsFile");
                    }
                    case 62: {
                        return SubstrateOptions_OptionDescriptors.this.get("GenerateDebugInfo");
                    }
                    case 63: {
                        return SubstrateOptions_OptionDescriptors.this.get("HeapDumpPath");
                    }
                    case 64: {
                        return SubstrateOptions_OptionDescriptors.this.get("ImageSymbolsPrefix");
                    }
                    case 65: {
                        return SubstrateOptions_OptionDescriptors.this.get("ImplicitExceptionWithoutStacktraceIsFatal");
                    }
                    case 66: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeDebugHelperMethods");
                    }
                    case 67: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeMethodData");
                    }
                    case 68: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeNodeSourcePositions");
                    }
                    case 69: {
                        return SubstrateOptions_OptionDescriptors.this.get("InstallExitHandlers");
                    }
                    case 70: {
                        return SubstrateOptions_OptionDescriptors.this.get("InternalSymbolsAreGlobal");
                    }
                    case 71: {
                        return SubstrateOptions_OptionDescriptors.this.get("InternalThreadStackSize");
                    }
                    case 72: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNI");
                    }
                    case 73: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIExportSymbols");
                    }
                    case 74: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIVerboseLookupErrors");
                    }
                    case 75: {
                        return SubstrateOptions_OptionDescriptors.this.get("LinkerRPath");
                    }
                    case 76: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxDirectMemorySize");
                    }
                    case 77: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxInvokesInTrivialMethod");
                    }
                    case 78: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxJavaStackTraceDepth");
                    }
                    case 79: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesAfterTrivialInlining");
                    }
                    case 80: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesInTrivialLeafMethod");
                    }
                    case 81: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesInTrivialMethod");
                    }
                    case 82: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxRAM");
                    }
                    case 83: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxUnrolledObjectZeroingStores");
                    }
                    case 84: {
                        return SubstrateOptions_OptionDescriptors.this.get("Method");
                    }
                    case 85: {
                        return SubstrateOptions_OptionDescriptors.this.get("Module");
                    }
                    case 86: {
                        return SubstrateOptions_OptionDescriptors.this.get("MultiThreaded");
                    }
                    case 87: {
                        return SubstrateOptions_OptionDescriptors.this.get("Name");
                    }
                    case 88: {
                        return SubstrateOptions_OptionDescriptors.this.get("NeverInline");
                    }
                    case 89: {
                        return SubstrateOptions_OptionDescriptors.this.get("OmitInlinedMethodDebugLineInfo");
                    }
                    case 90: {
                        return SubstrateOptions_OptionDescriptors.this.get("Optimize");
                    }
                    case 91: {
                        return SubstrateOptions_OptionDescriptors.this.get("PageSize");
                    }
                    case 92: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParallelGCThreads");
                    }
                    case 93: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseOnce");
                    }
                    case 94: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseOnceJIT");
                    }
                    case 95: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseRuntimeOptions");
                    }
                    case 96: {
                        return SubstrateOptions_OptionDescriptors.this.get("Path");
                    }
                    case 97: {
                        return SubstrateOptions_OptionDescriptors.this.get("PreserveFramePointer");
                    }
                    case 98: {
                        return SubstrateOptions_OptionDescriptors.this.get("RemoveUnusedSymbols");
                    }
                    case 99: {
                        return SubstrateOptions_OptionDescriptors.this.get("ReportAnalysisForbiddenType");
                    }
                    case 100: {
                        return SubstrateOptions_OptionDescriptors.this.get("RunMainInNewThread");
                    }
                    case 101: {
                        return SubstrateOptions_OptionDescriptors.this.get("RunReachabilityHandlersConcurrently");
                    }
                    case 102: {
                        return SubstrateOptions_OptionDescriptors.this.get("SharedLibrary");
                    }
                    case 103: {
                        return SubstrateOptions_OptionDescriptors.this.get("SourceLevelDebug");
                    }
                    case 104: {
                        return SubstrateOptions_OptionDescriptors.this.get("SourceLevelDebugFilter");
                    }
                    case 105: {
                        return SubstrateOptions_OptionDescriptors.this.get("SpawnIsolates");
                    }
                    case 106: {
                        return SubstrateOptions_OptionDescriptors.this.get("StackSize");
                    }
                    case 107: {
                        return SubstrateOptions_OptionDescriptors.this.get("StackTrace");
                    }
                    case 108: {
                        return SubstrateOptions_OptionDescriptors.this.get("StartFlightRecording");
                    }
                    case 109: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticExecutable");
                    }
                    case 110: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticExecutableWithDynamicLibC");
                    }
                    case 111: {
                        return SubstrateOptions_OptionDescriptors.this.get("StrictQueryCodeCompilation");
                    }
                    case 112: {
                        return SubstrateOptions_OptionDescriptors.this.get("StripDebugInfo");
                    }
                    case 113: {
                        return SubstrateOptions_OptionDescriptors.this.get("SupportCompileInIsolates");
                    }
                    case 114: {
                        return SubstrateOptions_OptionDescriptors.this.get("SupportContinuations");
                    }
                    case 115: {
                        return SubstrateOptions_OptionDescriptors.this.get("TargetPlatform");
                    }
                    case 116: {
                        return SubstrateOptions_OptionDescriptors.this.get("TearDownFailureNanos");
                    }
                    case 117: {
                        return SubstrateOptions_OptionDescriptors.this.get("TearDownWarningNanos");
                    }
                    case 118: {
                        return SubstrateOptions_OptionDescriptors.this.get("ThrowMissingRegistrationErrors");
                    }
                    case 119: {
                        return SubstrateOptions_OptionDescriptors.this.get("ThrowMissingRegistrationErrorsPaths");
                    }
                    case 120: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceClassInitialization");
                    }
                    case 121: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceNativeToolUsage");
                    }
                    case 122: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceObjectInstantiation");
                    }
                    case 123: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceVMOperations");
                    }
                    case 124: {
                        return SubstrateOptions_OptionDescriptors.this.get("UnlockExperimentalVMOptions");
                    }
                    case 125: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseCalleeSavedRegisters");
                    }
                    case 126: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseCompressedFrameEncodings");
                    }
                    case 127: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseDedicatedVMOperationThread");
                    }
                    case 128: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseDirectCallTrampolinesALot");
                    }
                    case 129: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseEpsilonGC");
                    }
                    case 130: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseImagebuildDebugSections");
                    }
                    case 131: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseNullRegion");
                    }
                    case 132: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseOldDebugInfo");
                    }
                    case 133: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseParallelGC");
                    }
                    case 134: {
                        return SubstrateOptions_OptionDescriptors.this.get("UsePerfData");
                    }
                    case 135: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseRememberedSet");
                    }
                    case 136: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseSerialGC");
                    }
                    case 137: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyNamingConventions");
                    }
                    case 138: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyTypes");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

