/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.word.Pointer;

class CollectingObjectReferenceVisitor
implements ObjectReferenceVisitor {
    protected final SubstrateReferenceMap result = new SubstrateReferenceMap();

    CollectingObjectReferenceVisitor() {
    }

    @Override
    public boolean visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
        return this.visitObjectReferenceInline(objRef, 0, compressed, holderObject);
    }

    @Override
    public boolean visitObjectReferenceInline(Pointer objRef, int innerOffset, boolean compressed, Object holderObject) {
        int derivedOffset = NumUtil.safeToInt((long)objRef.rawValue());
        this.result.markReferenceAtOffset(derivedOffset, derivedOffset - innerOffset, compressed);
        return true;
    }
}

