/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.deopt.DeoptimizationCounters;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.log.StringBuilderLog;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.RingBuffer;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.util.ArrayList;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class Deoptimizer {
    private static final int MAX_DEOPTIMIZATION_EVENT_PRINT_LENGTH = 1000;
    private static final RingBuffer<char[]> recentDeoptimizationEvents = new RingBuffer(SubstrateOptions.DiagnosticBufferSize.getValue());
    private static final int actionShift = 0;
    private static final int actionBits = 32 - Integer.numberOfLeadingZeros(DeoptimizationAction.values().length);
    private static final int reasonShift = 0 + actionBits;
    private static final int reasonBits = 32 - Integer.numberOfLeadingZeros(DeoptimizationReason.values().length);
    private static final int idShift = reasonShift + reasonBits;
    private static final int idBits = 32;
    public static boolean testGCinDeoptimizer;
    int endOfParams;
    private final CodeInfoQueryResult sourceChunk;
    private final Pointer sourceSp;
    private Object[] materializedObjects;
    private ArrayList<DeoptimizedFrame.RelockObjectData> relockedObjects;
    protected int targetContentSize;
    protected static long deoptStubFrameSize;
    private final IsolateThread targetThread;
    private static final RingBuffer.Consumer<char[]> deoptEventsConsumer;

    public static long encodeDeoptActionAndReasonToLong(DeoptimizationAction action, DeoptimizationReason reason, int speculationId) {
        return (long)action.ordinal() << 0 | (long)reason.ordinal() << reasonShift | (long)speculationId << idShift;
    }

    public static JavaConstant encodeDeoptActionAndReason(DeoptimizationAction action, DeoptimizationReason reason, int speculationId) {
        PrimitiveConstant result = JavaConstant.forLong((long)Deoptimizer.encodeDeoptActionAndReasonToLong(action, reason, speculationId));
        assert (Deoptimizer.decodeDeoptAction((JavaConstant)result) == action);
        assert (Deoptimizer.decodeDeoptReason((JavaConstant)result) == reason);
        assert (Deoptimizer.decodeDebugId((JavaConstant)result) == speculationId);
        return result;
    }

    public static DeoptimizationAction decodeDeoptAction(long actionAndReason) {
        return DeoptimizationAction.values()[(int)(actionAndReason >> 0 & (1L << actionBits) - 1L)];
    }

    public static DeoptimizationReason decodeDeoptReason(long actionAndReason) {
        return DeoptimizationReason.values()[(int)(actionAndReason >> reasonShift & (1L << reasonBits) - 1L)];
    }

    public static int decodeDebugId(long actionAndReason) {
        return (int)(actionAndReason >> idShift & 0xFFFFFFFFL);
    }

    public static DeoptimizationAction decodeDeoptAction(JavaConstant actionAndReason) {
        return Deoptimizer.decodeDeoptAction(actionAndReason.asLong());
    }

    public static DeoptimizationReason decodeDeoptReason(JavaConstant actionAndReason) {
        return Deoptimizer.decodeDeoptReason(actionAndReason.asLong());
    }

    public static int decodeDebugId(JavaConstant actionAndReason) {
        return Deoptimizer.decodeDebugId(actionAndReason.asLong());
    }

    private static boolean checkEncoding() {
        for (DeoptimizationAction action : DeoptimizationAction.values()) {
            for (DeoptimizationReason reason : DeoptimizationReason.values()) {
                for (int speculationId : new int[]{0, 1, -1, Integer.MIN_VALUE, Integer.MAX_VALUE}) {
                    Deoptimizer.encodeDeoptActionAndReason(action, reason, speculationId);
                }
            }
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static DeoptimizedFrame checkDeoptimized(Pointer sourceSp) {
        CodePointer returnAddress;
        if (DeoptimizationSupport.enabled() && (returnAddress = FrameAccess.singleton().readReturnAddress(sourceSp)).equal((ComparableWord)DeoptimizationSupport.getDeoptStubPointer())) {
            DeoptimizedFrame result = (DeoptimizedFrame)sourceSp.readObject(0);
            if (result == null) {
                throw Deoptimizer.checkDeoptimizedError(sourceSp);
            }
            return result;
        }
        return null;
    }

    @Uninterruptible(reason="Switch to interruptible code and report a fatal error.", calleeMustBe=false)
    private static RuntimeException checkDeoptimizedError(Pointer sourceSp) {
        throw Deoptimizer.checkDeoptimizedError0(sourceSp);
    }

    @NeverInline(value="Throws error and exits")
    private static RuntimeException checkDeoptimizedError0(Pointer sourceSp) {
        Log.log().string("Unable to retrieve Deoptimized frame. sp: ").hex(sourceSp.rawValue()).newline();
        throw VMError.shouldNotReachHere("Unable to retrieve Deoptimized frame");
    }

    private static void installDeoptimizedFrame(Pointer sourceSp, DeoptimizedFrame deoptimizedFrame) {
        FrameAccess.singleton().writeReturnAddress(sourceSp, (CodePointer)DeoptimizationSupport.getDeoptStubPointer());
        sourceSp.writeWord(0, (WordBase)deoptimizedFrame.getPin().addressOfObject());
    }

    @NeverInline(value="deoptimize must have a separate stack frame")
    public static void deoptimizeAll() {
        DeoptimizeAllOperation vmOp = new DeoptimizeAllOperation();
        vmOp.enqueue();
    }

    @NeverInline(value="deoptimize must have a separate stack frame")
    public static void deoptimizeInRange(CodePointer fromIp, CodePointer toIp, boolean deoptAll) {
        VMOperation.guaranteeInProgressAtSafepoint("Deoptimization requires a safepoint.");
        Deoptimizer.deoptimizeInRangeOperation(fromIp, toIp, deoptAll);
    }

    @NeverInline(value="Starting a stack walk in the caller frame. Note that we could start the stack frame also further down the stack, because VM operation frames never need deoptimization. But we don't store stack frame information for the first frame we would need to process.")
    private static void deoptimizeInRangeOperation(CodePointer fromIp, CodePointer toIp, boolean deoptAll) {
        VMOperation.guaranteeInProgress("Deoptimizer.deoptimizeInRangeOperation, but not in VMOperation.");
        Pointer sp = KnownIntrinsics.readCallerStackPointer();
        StackFrameVisitor currentThreadDeoptVisitor = Deoptimizer.getStackFrameVisitor((Pointer)fromIp, (Pointer)toIp, deoptAll, CurrentIsolate.getCurrentThread());
        JavaStackWalker.walkCurrentThread(sp, currentThreadDeoptVisitor);
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (vmThread != CurrentIsolate.getCurrentThread()) {
                    StackFrameVisitor deoptVisitor = Deoptimizer.getStackFrameVisitor((Pointer)fromIp, (Pointer)toIp, deoptAll, vmThread);
                    JavaStackWalker.walkThread(vmThread, deoptVisitor);
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
        }
        if (testGCinDeoptimizer) {
            Heap.getHeap().getGC().collect(GCCause.TestGCInDeoptimizer);
        }
    }

    private static StackFrameVisitor getStackFrameVisitor(final Pointer fromIp, final Pointer toIp, final boolean deoptAll, final IsolateThread targetThread) {
        return new StackFrameVisitor(){

            @Override
            public boolean visitFrame(Pointer frameSp, CodePointer frameIp, CodeInfo codeInfo, DeoptimizedFrame deoptFrame) {
                Pointer ip = (Pointer)frameIp;
                if (deoptFrame == null && (ip.aboveOrEqual((UnsignedWord)fromIp) && ip.belowThan((UnsignedWord)toIp) || deoptAll)) {
                    CodeInfoQueryResult queryResult = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, frameIp);
                    Deoptimizer deoptimizer = new Deoptimizer(frameSp, queryResult, targetThread);
                    deoptimizer.deoptSourceFrame(frameIp, deoptAll);
                }
                return true;
            }
        };
    }

    @NeverInline(value="Inlining of this method would require that we have deopt targets for callees of this method (SVM internals).")
    public static void deoptimizeFrame(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation) {
        DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sourceSp);
        if (deoptFrame != null) {
            Deoptimizer.registerSpeculationFailure(deoptFrame.getSourceInstalledCode(), speculation);
            return;
        }
        IsolateThread targetThread = CurrentIsolate.getCurrentThread();
        DeoptimizeFrameOperation vmOp = new DeoptimizeFrameOperation(sourceSp, ignoreNonDeoptimizable, speculation, targetThread);
        vmOp.enqueue();
    }

    private static void deoptimizeFrameOperation(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, IsolateThread targetThread) {
        VMOperation.guaranteeInProgress("doDeoptimizeFrame");
        CodePointer returnAddress = FrameAccess.singleton().readReturnAddress(sourceSp);
        Deoptimizer.deoptimizeFrame(sourceSp, ignoreNonDeoptimizable, speculation, returnAddress, targetThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo object.")
    private static void deoptimizeFrame(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, CodePointer returnAddress, IsolateThread targetThread) {
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(returnAddress);
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
            Deoptimizer.deoptimize(sourceSp, ignoreNonDeoptimizable, speculation, returnAddress, info, targetThread);
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    @Uninterruptible(reason="Pass the now protected CodeInfo object to interruptible code.", calleeMustBe=false)
    private static void deoptimize(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, CodePointer returnAddress, CodeInfo info, IsolateThread targetThread) {
        Deoptimizer.deoptimize0(sourceSp, ignoreNonDeoptimizable, speculation, returnAddress, info, targetThread);
    }

    private static void deoptimize0(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, CodePointer returnAddress, CodeInfo info, IsolateThread targetThread) {
        CodeInfoQueryResult queryResult = CodeInfoTable.lookupCodeInfoQueryResult(info, returnAddress);
        Deoptimizer deoptimizer = new Deoptimizer(sourceSp, queryResult, targetThread);
        DeoptimizedFrame sourceFrame = deoptimizer.deoptSourceFrame(returnAddress, ignoreNonDeoptimizable);
        if (sourceFrame != null) {
            Deoptimizer.registerSpeculationFailure(sourceFrame.getSourceInstalledCode(), speculation);
        }
    }

    public static void invalidateMethodOfFrame(Pointer sourceSp, SpeculationLog.SpeculationReason speculation) {
        CodePointer returnAddress = FrameAccess.singleton().readReturnAddress(sourceSp);
        SubstrateInstalledCode installedCode = CodeInfoTable.lookupInstalledCode(returnAddress);
        DeoptimizedFrame deoptimizedFrame = Deoptimizer.checkDeoptimized(sourceSp);
        if (deoptimizedFrame != null) {
            installedCode = deoptimizedFrame.getSourceInstalledCode();
            if (installedCode == null) {
                return;
            }
        } else if (installedCode == null) {
            throw VMError.shouldNotReachHere("Only runtime compiled methods can be invalidated. sp = " + Long.toHexString(sourceSp.rawValue()) + ", returnAddress = " + Long.toHexString(returnAddress.rawValue()));
        }
        Deoptimizer.registerSpeculationFailure(installedCode, speculation);
        VMOperation.guaranteeNotInProgress("invalidateMethodOfFrame: running user code that can block");
        installedCode.invalidate();
    }

    private static void registerSpeculationFailure(SubstrateInstalledCode installedCode, SpeculationLog.SpeculationReason speculation) {
        SubstrateSpeculationLog speculationLog;
        if (installedCode != null && speculation != null && (speculationLog = installedCode.getSpeculationLog()) != null) {
            speculationLog.addFailedSpeculation(speculation);
        }
    }

    public Deoptimizer(Pointer sourceSp, CodeInfoQueryResult sourceChunk, IsolateThread targetThread) {
        VMError.guarantee(sourceChunk != null, "Must not be null.");
        this.sourceSp = sourceSp;
        this.sourceChunk = sourceChunk;
        this.targetThread = targetThread;
        if (deoptStubFrameSize == 0L) {
            CodeInfo info = CodeInfoTable.getImageCodeInfo();
            deoptStubFrameSize = CodeInfoAccess.lookupTotalFrameSize(info, CodeInfoAccess.relativeIP(info, (CodePointer)DeoptimizationSupport.getDeoptStubPointer()));
        }
    }

    @DeoptStub(stubType=StubType.EntryStub)
    @Uninterruptible(reason="Frame holds Objects in unmanaged storage.")
    public static void deoptStub(DeoptimizedFrame frame) {
        DeoptimizationCounters.counters().deoptCount.inc();
        if (DeoptimizationCounters.Options.ProfileDeoptimization.getValue().booleanValue()) {
            DeoptimizationCounters.startTime.set(System.nanoTime());
        }
        Pointer newSp = KnownIntrinsics.readStackPointer().add(WordFactory.unsigned((long)deoptStubFrameSize)).subtract(FrameAccess.singleton().stackPointerAdjustmentOnCall()).add(WordFactory.unsigned((long)frame.getSourceTotalFrameSize())).subtract(frame.getTargetContent().getSize());
        frame.buildContent(newSp);
        frame.getPin().close();
        recentDeoptimizationEvents.append(frame.getCompletedMessage());
        Deoptimizer.rewriteStackStub(newSp, frame);
    }

    @DeoptStub(stubType=StubType.ExitStub)
    @NeverInline(value="Custom prologue modifies stack pointer register")
    @Uninterruptible(reason="Frame holds Objects in unmanaged storage.")
    private static DeoptimizedFrame rewriteStackStub(Pointer newSp, DeoptimizedFrame frame) {
        Pointer bottomSp = newSp.subtract(FrameAccess.returnAddressSize() + FrameAccess.singleton().savedBasePointerSize());
        frame.getTargetContent().copyToPointer(bottomSp);
        if (DeoptimizationCounters.Options.ProfileDeoptimization.getValue().booleanValue()) {
            DeoptimizationCounters.counters().timeSpentInDeopt.add(System.nanoTime() - DeoptimizationCounters.startTime.get());
        }
        return frame;
    }

    public JavaConstant readLocalVariable(int idx, FrameInfoQueryResult sourceFrame) {
        if (idx < 0 || idx >= sourceFrame.getNumLocals()) {
            throw Deoptimizer.fatalDeoptimizationError(String.format("Invalid idx: %s", idx), sourceFrame);
        }
        if (idx < sourceFrame.getValueInfos().length) {
            return this.readValue(sourceFrame.getValueInfos()[idx], sourceFrame);
        }
        return JavaConstant.forIllegal();
    }

    public DeoptimizedFrame deoptSourceFrame(CodePointer pc, boolean ignoreNonDeoptimizable) {
        DeoptSourceFrameOperation operation = new DeoptSourceFrameOperation(this, pc, ignoreNonDeoptimizable);
        operation.enqueue();
        return operation.getResult();
    }

    private DeoptimizedFrame deoptSourceFrameOperation(CodePointer pc, boolean ignoreNonDeoptimizable) {
        VMOperation.guaranteeInProgress("deoptSourceFrame");
        DeoptimizedFrame existing = Deoptimizer.checkDeoptimized(this.sourceSp);
        if (existing != null) {
            return existing;
        }
        FrameInfoQueryResult frameInfo = this.sourceChunk.getFrameInfo();
        if (frameInfo == null) {
            if (ignoreNonDeoptimizable) {
                return null;
            }
            throw VMError.shouldNotReachHere("Deoptimization: cannot deoptimize a method that was not marked as deoptimizable from address " + Long.toHexString(pc.rawValue()));
        }
        assert (this.endOfParams == 0);
        DeoptimizedFrame.VirtualFrame previousVirtualFrame = null;
        DeoptimizedFrame.VirtualFrame topFrame = null;
        for (FrameInfoQueryResult deoptInfo = frameInfo; deoptInfo != null; deoptInfo = deoptInfo.getCaller()) {
            DeoptimizationCounters.counters().virtualFrameCount.inc();
            if (deoptInfo.getDeoptMethodOffset() == 0) {
                if (ignoreNonDeoptimizable) {
                    return null;
                }
                throw Deoptimizer.fatalDeoptimizationError("Deoptimization: cannot deoptimize a method that has no deoptimization entry point", deoptInfo);
            }
            CodeInfoQueryResult targetInfo = CodeInfoTable.lookupDeoptimizationEntrypoint(deoptInfo.getDeoptMethodOffset(), deoptInfo.getEncodedBci());
            if (targetInfo == null || targetInfo.getFrameInfo() == null) {
                throw Deoptimizer.fatalDeoptimizationError("Deoptimization: no matching target bytecode frame found for deopt target method", deoptInfo);
            }
            if (!targetInfo.getFrameInfo().isDeoptEntry()) {
                throw Deoptimizer.fatalDeoptimizationError("Deoptimization: target frame information not marked as deoptimization entry point", deoptInfo);
            }
            if (targetInfo.getFrameInfo().getDeoptMethod() != null && targetInfo.getFrameInfo().getDeoptMethod().hasCalleeSavedRegisters()) {
                throw Deoptimizer.fatalDeoptimizationError("Deoptimization: target method has callee saved registers, which are not properly restored by the deoptimization runtime", deoptInfo);
            }
            DeoptimizedFrame.VirtualFrame virtualFrame = this.constructTargetFrame(targetInfo, deoptInfo);
            if (previousVirtualFrame != null) {
                previousVirtualFrame.caller = virtualFrame;
            } else {
                topFrame = virtualFrame;
            }
            previousVirtualFrame = virtualFrame;
        }
        if (this.sourceChunk.getTotalFrameSize() < (long)FrameAccess.wordSize()) {
            throw Deoptimizer.fatalDeoptimizationError(String.format("Insufficient space in frame for pointer to DeoptimizedFrame sourceChunkSize: %s, word size: %s", this.sourceChunk.getTotalFrameSize(), FrameAccess.wordSize()), frameInfo);
        }
        DeoptimizedFrame.RelockObjectData[] relockObjectData = this.relockedObjects == null ? null : this.relockedObjects.toArray(new DeoptimizedFrame.RelockObjectData[this.relockedObjects.size()]);
        DeoptimizedFrame deoptimizedFrame = DeoptimizedFrame.factory(this.targetContentSize, this.sourceChunk.getEncodedFrameSize(), CodeInfoTable.lookupInstalledCode(pc), topFrame, relockObjectData, pc);
        Deoptimizer.installDeoptimizedFrame(this.sourceSp, deoptimizedFrame);
        if (Options.TraceDeoptimization.getValue().booleanValue()) {
            Deoptimizer.printDeoptimizedFrame(Log.log(), this.sourceSp, deoptimizedFrame, frameInfo, false);
        }
        Deoptimizer.logDeoptSourceFrameOperation(this.sourceSp, deoptimizedFrame, frameInfo);
        return deoptimizedFrame;
    }

    private static void logDeoptSourceFrameOperation(Pointer sp, DeoptimizedFrame deoptimizedFrame, FrameInfoQueryResult frameInfo) {
        StringBuilderLog log = new StringBuilderLog();
        PointerBase deoptimizedFrameAddress = deoptimizedFrame.getPin().addressOfObject();
        log.string("deoptSourceFrameOperation: DeoptimizedFrame at ").zhex((WordBase)deoptimizedFrameAddress).string(": ");
        Deoptimizer.printDeoptimizedFrame(log, sp, deoptimizedFrame, frameInfo, true);
        recentDeoptimizationEvents.append(log.getResult().toCharArray());
    }

    public static void logRecentDeoptimizationEvents(Log log) {
        log.string("Recent deoptimization events (oldest first):").indent(true);
        recentDeoptimizationEvents.foreach(log, deoptEventsConsumer);
        log.indent(false);
    }

    private DeoptimizedFrame.VirtualFrame constructTargetFrame(CodeInfoQueryResult targetInfo, FrameInfoQueryResult sourceFrame) {
        boolean compatibleState;
        FrameInfoQueryResult targetFrame = targetInfo.getFrameInfo();
        int savedBasePointerSize = FrameAccess.singleton().savedBasePointerSize();
        int targetFrameSize = NumUtil.safeToInt((long)targetInfo.getTotalFrameSize()) - FrameAccess.returnAddressSize() - savedBasePointerSize;
        DeoptimizedFrame.VirtualFrame result = new DeoptimizedFrame.VirtualFrame(targetFrame);
        if (savedBasePointerSize != 0) {
            result.savedBasePointer = new DeoptimizedFrame.SavedBasePointer(this.targetContentSize, this.targetContentSize + targetFrameSize);
            this.targetContentSize += savedBasePointerSize;
        }
        result.returnAddress = new DeoptimizedFrame.ReturnAddress(this.targetContentSize, targetInfo.getIP().rawValue());
        this.targetContentSize += FrameAccess.returnAddressSize();
        boolean bl = compatibleState = sourceFrame.getNumLocals() == targetFrame.getNumLocals() && sourceFrame.getNumStack() == targetFrame.getNumStack() && sourceFrame.getNumLocks() == targetFrame.getNumLocks() && targetFrame.getVirtualObjects().length == 0 && sourceFrame.getValueInfos().length >= targetFrame.getValueInfos().length;
        if (!compatibleState) {
            String message = String.format("Deoptimization is not possible. Please report this error.%nTarget Frame: numLocals-%s, numStack-%s, numLocks-%s, getValueInfos length-%s, virtual objects length-%s%nSource Frame: numLocals-%s, numStack-%s, numLocks-%s, getValueInfos length-%s%n", targetFrame.getNumLocals(), targetFrame.getNumStack(), targetFrame.getNumLocks(), targetFrame.getValueInfos().length, targetFrame.getVirtualObjects().length, sourceFrame.getNumLocals(), sourceFrame.getNumStack(), sourceFrame.getNumLocks(), sourceFrame.getValueInfos().length);
            throw Deoptimizer.fatalDeoptimizationError(message, targetFrame);
        }
        int numValues = targetFrame.getValueInfos().length;
        int newEndOfParams = this.endOfParams;
        block4: for (int idx = 0; idx < numValues; ++idx) {
            FrameInfoQueryResult.ValueInfo targetValue = targetFrame.getValueInfos()[idx];
            if (targetValue.getKind() == JavaKind.Illegal || targetValue.getType() == FrameInfoQueryResult.ValueType.ReservedRegister) continue;
            FrameInfoQueryResult.ValueInfo sourceValue = sourceFrame.getValueInfos()[idx];
            JavaConstant con = this.readValue(sourceValue, sourceFrame);
            if (con.getJavaKind() == JavaKind.Illegal) {
                throw Deoptimizer.fatalDeoptimizationError("Found illegal kind in source frame", sourceFrame);
            }
            if (con.getJavaKind().isObject() && SubstrateObjectConstant.isCompressed(con) != targetValue.isCompressedReference()) {
                Object obj = SubstrateObjectConstant.asObject((Constant)con);
                con = SubstrateObjectConstant.forObject(obj, targetValue.isCompressedReference());
            }
            if (sourceValue.isEliminatedMonitor()) {
                this.relockObject(con);
            }
            switch (targetValue.getType()) {
                case StackSlot: {
                    DeoptimizationCounters.counters().stackValueCount.inc();
                    int targetOffset = TypeConversion.asS4((long)targetValue.getData());
                    int totalOffset = this.targetContentSize + targetOffset;
                    if (totalOffset < this.endOfParams || targetOffset < 0 || targetOffset == targetFrameSize || targetOffset == targetFrameSize + savedBasePointerSize) {
                        throw Deoptimizer.fatalDeoptimizationError(String.format("Bad offset values. targetOffset %s, totalOffset %s, endOfParams %s, targetFrameSize %s, savedBasePointerSize %s", targetOffset, totalOffset, this.endOfParams, targetFrameSize, savedBasePointerSize), targetFrame);
                    }
                    if (targetOffset < targetFrameSize) {
                        result.values[idx] = DeoptimizedFrame.ConstantEntry.factory(totalOffset, con, sourceFrame);
                        continue block4;
                    }
                    if (sourceFrame.getCaller() == null) continue block4;
                    result.values[idx] = DeoptimizedFrame.ConstantEntry.factory(totalOffset, con, sourceFrame);
                    int size = targetValue.getKind().isObject() && !targetValue.isCompressedReference() ? FrameAccess.uncompressedReferenceSize() : ConfigurationValues.getObjectLayout().sizeInBytes(con.getJavaKind());
                    int endOffset = totalOffset + size;
                    if (endOffset <= newEndOfParams) continue block4;
                    newEndOfParams = endOffset;
                    continue block4;
                }
                case DefaultConstant: 
                case Constant: {
                    this.verifyConstant(targetFrame, targetValue, con);
                    DeoptimizationCounters.counters().constantValueCount.inc();
                    continue block4;
                }
                default: {
                    throw Deoptimizer.fatalDeoptimizationError("Unknown deopt target value type: " + String.valueOf(targetValue), targetFrame);
                }
            }
        }
        this.targetContentSize += targetFrameSize;
        this.endOfParams = newEndOfParams;
        return result;
    }

    private void relockObject(JavaConstant valueConstant) {
        Object lockedObject = SubstrateObjectConstant.asObject((Constant)valueConstant);
        Object lockData = MonitorSupport.singleton().prepareRelockObject(lockedObject);
        if (this.relockedObjects == null) {
            this.relockedObjects = new ArrayList();
        }
        this.relockedObjects.add(new DeoptimizedFrame.RelockObjectData(lockedObject, lockData));
    }

    private void verifyConstant(FrameInfoQueryResult targetFrame, FrameInfoQueryResult.ValueInfo targetValue, JavaConstant source) {
        JavaConstant target = this.readValue(targetValue, targetFrame);
        boolean equal = source.getJavaKind() == JavaKind.Object && target.getJavaKind() == JavaKind.Object ? SubstrateObjectConstant.asObject((Constant)target) == SubstrateObjectConstant.asObject((Constant)source) : source.equals(target);
        if (!equal) {
            throw Deoptimizer.fatalDeoptimizationError(String.format("Constants do not match.%nSource: %s%nTarget: %s", source, target), targetFrame);
        }
    }

    private JavaConstant readValue(FrameInfoQueryResult.ValueInfo valueInfo, FrameInfoQueryResult sourceFrame) {
        switch (valueInfo.getType()) {
            case DefaultConstant: 
            case Constant: {
                return valueInfo.getValue();
            }
            case StackSlot: 
            case Register: {
                return Deoptimizer.readConstant(this.sourceSp, WordFactory.signed((long)valueInfo.getData()), valueInfo.getKind(), valueInfo.isCompressedReference(), sourceFrame);
            }
            case ReservedRegister: {
                if (ReservedRegisters.singleton().getThreadRegister() != null && (long)ReservedRegisters.singleton().getThreadRegister().number == valueInfo.getData()) {
                    return JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)this.targetThread.rawValue());
                }
                if (ReservedRegisters.singleton().getHeapBaseRegister() != null && (long)ReservedRegisters.singleton().getHeapBaseRegister().number == valueInfo.getData()) {
                    return JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)CurrentIsolate.getIsolate().rawValue());
                }
                throw Deoptimizer.fatalDeoptimizationError("Unexpected reserved register: " + valueInfo.getData(), sourceFrame);
            }
            case VirtualObject: {
                Object obj = this.materializeObject(TypeConversion.asS4((long)valueInfo.getData()), sourceFrame);
                return SubstrateObjectConstant.forObject(obj, valueInfo.isCompressedReference());
            }
            case Illegal: {
                return JavaConstant.forIllegal();
            }
        }
        throw Deoptimizer.fatalDeoptimizationError("Unexpected type: " + String.valueOf((Object)valueInfo.getType()), sourceFrame);
    }

    private Object materializeObject(int virtualObjectId, FrameInfoQueryResult sourceFrame) {
        int curIdx;
        UnsignedWord curOffset;
        if (this.materializedObjects == null) {
            this.materializedObjects = new Object[sourceFrame.getVirtualObjects().length];
        }
        if (this.materializedObjects.length != sourceFrame.getVirtualObjects().length) {
            throw Deoptimizer.fatalDeoptimizationError(String.format("MaterializedObjects length (%s) does not match sourceFrame", this.materializedObjects.length), sourceFrame);
        }
        Object obj = this.materializedObjects[virtualObjectId];
        if (obj != null) {
            return obj;
        }
        DeoptimizationCounters.counters().virtualObjectsCount.inc();
        FrameInfoQueryResult.ValueInfo[] encodings = sourceFrame.getVirtualObjects()[virtualObjectId];
        DynamicHub hub = (DynamicHub)SubstrateObjectConstant.asObject((Constant)this.readValue(encodings[0], sourceFrame));
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        int layoutEncoding = hub.getLayoutEncoding();
        if (LayoutEncoding.isArray(layoutEncoding)) {
            int length = this.readValue(encodings[1], sourceFrame).asInt();
            obj = Array.newInstance(DynamicHub.toClass(hub.getComponentHub()), length);
            curOffset = LayoutEncoding.getArrayBaseOffset(hub.getLayoutEncoding());
            curIdx = 2;
        } else {
            if (!LayoutEncoding.isPureInstance(layoutEncoding)) {
                throw Deoptimizer.fatalDeoptimizationError("Non-pure instance layout encoding: " + layoutEncoding, sourceFrame);
            }
            try {
                obj = Unsafe.getUnsafe().allocateInstance(DynamicHub.toClass(hub));
            }
            catch (InstantiationException ex) {
                throw Deoptimizer.fatalDeoptimizationError("Instantiation exception: " + String.valueOf(ex), sourceFrame);
            }
            curOffset = WordFactory.unsigned((int)objectLayout.getFirstFieldOffset());
            curIdx = 1;
        }
        this.materializedObjects[virtualObjectId] = obj;
        if (testGCinDeoptimizer) {
            Heap.getHeap().getGC().collect(GCCause.TestGCInDeoptimizer);
        }
        while (curIdx < encodings.length) {
            FrameInfoQueryResult.ValueInfo value = encodings[curIdx];
            JavaKind kind = value.getKind();
            JavaConstant con = this.readValue(value, sourceFrame);
            Deoptimizer.writeValueInMaterializedObj(obj, curOffset, con, sourceFrame);
            curOffset = curOffset.add(objectLayout.sizeInBytes(kind));
            ++curIdx;
        }
        return obj;
    }

    private static void writeValueInMaterializedObj(Object materializedObj, UnsignedWord offsetInObj, JavaConstant constant, FrameInfoQueryResult frameInfo) {
        if (offsetInObj.equal(0)) {
            throw Deoptimizer.fatalDeoptimizationError("offsetInObj is 0. Materialized value would overwrite hub.", frameInfo);
        }
        switch (constant.getJavaKind()) {
            case Boolean: {
                BarrieredAccess.writeByte((Object)materializedObj, (WordBase)offsetInObj, (byte)(constant.asBoolean() ? (byte)1 : 0));
                break;
            }
            case Byte: {
                BarrieredAccess.writeByte((Object)materializedObj, (WordBase)offsetInObj, (byte)((byte)constant.asInt()));
                break;
            }
            case Char: {
                BarrieredAccess.writeChar((Object)materializedObj, (WordBase)offsetInObj, (char)((char)constant.asInt()));
                break;
            }
            case Short: {
                BarrieredAccess.writeShort((Object)materializedObj, (WordBase)offsetInObj, (short)((short)constant.asInt()));
                break;
            }
            case Int: {
                BarrieredAccess.writeInt((Object)materializedObj, (WordBase)offsetInObj, (int)constant.asInt());
                break;
            }
            case Long: {
                BarrieredAccess.writeLong((Object)materializedObj, (WordBase)offsetInObj, (long)constant.asLong());
                break;
            }
            case Float: {
                BarrieredAccess.writeFloat((Object)materializedObj, (WordBase)offsetInObj, (float)constant.asFloat());
                break;
            }
            case Double: {
                BarrieredAccess.writeDouble((Object)materializedObj, (WordBase)offsetInObj, (double)constant.asDouble());
                break;
            }
            case Object: {
                BarrieredAccess.writeObject((Object)materializedObj, (WordBase)offsetInObj, (Object)SubstrateObjectConstant.asObject((Constant)constant));
                break;
            }
            default: {
                throw Deoptimizer.fatalDeoptimizationError("Unexpected JavaKind " + String.valueOf(constant.getJavaKind()), frameInfo);
            }
        }
    }

    private static JavaConstant readConstant(Pointer addr, SignedWord offset, JavaKind kind, boolean compressed, FrameInfoQueryResult frameInfo) {
        switch (kind) {
            case Boolean: {
                return JavaConstant.forBoolean((addr.readByte((WordBase)offset) != 0 ? 1 : 0) != 0);
            }
            case Byte: {
                return JavaConstant.forByte((byte)addr.readByte((WordBase)offset));
            }
            case Char: {
                return JavaConstant.forChar((char)addr.readChar((WordBase)offset));
            }
            case Short: {
                return JavaConstant.forShort((short)addr.readShort((WordBase)offset));
            }
            case Int: {
                return JavaConstant.forInt((int)addr.readInt((WordBase)offset));
            }
            case Long: {
                return JavaConstant.forLong((long)addr.readLong((WordBase)offset));
            }
            case Float: {
                return JavaConstant.forFloat((float)addr.readFloat((WordBase)offset));
            }
            case Double: {
                return JavaConstant.forDouble((double)addr.readDouble((WordBase)offset));
            }
            case Object: {
                Word p = ((Word)addr).add(offset);
                Object obj = ReferenceAccess.singleton().readObjectAt((Pointer)p, compressed);
                return SubstrateObjectConstant.forObject(obj, compressed);
            }
        }
        throw Deoptimizer.fatalDeoptimizationError("Unexpected constant kind: " + String.valueOf(kind), frameInfo);
    }

    private static void printDeoptimizedFrame(Log log, Pointer sp, DeoptimizedFrame deoptimizedFrame, FrameInfoQueryResult sourceFrameInfo, boolean printOnlyTopFrames) {
        log.string("[Deoptimization of frame (").rational(Isolates.getCurrentUptimeMillis(), 1000L, 3L).string("s)").newline();
        SubstrateInstalledCode installedCode = deoptimizedFrame.getSourceInstalledCode();
        if (installedCode != null) {
            log.string("    name: ").string(installedCode.getName()).newline();
        }
        log.string("    sp: ").zhex((WordBase)sp).string("  ip: ").zhex((WordBase)deoptimizedFrame.getSourcePC()).newline();
        if (sourceFrameInfo != null) {
            log.string("    stack trace where execution continues:").newline();
            FrameInfoQueryResult sourceFrame = sourceFrameInfo;
            DeoptimizedFrame.VirtualFrame targetFrame = deoptimizedFrame.getTopFrame();
            int count = 0;
            while (sourceFrame != null) {
                SharedMethod deoptMethod = sourceFrame.getDeoptMethod();
                log.string("        at ");
                if (deoptMethod != null) {
                    StackTraceElement element = deoptMethod.asStackTraceElement(sourceFrame.getBci());
                    if (element.getFileName() != null && element.getLineNumber() >= 0) {
                        log.string(element.toString());
                    } else {
                        log.string(deoptMethod.format("%H.%n(%p)"));
                    }
                } else {
                    log.string("method at ").zhex((WordBase)sourceFrame.getDeoptMethodAddress());
                }
                log.string(" bci ");
                FrameInfoDecoder.logReadableBci(log, sourceFrame.getEncodedBci());
                log.string("  return address ").zhex(targetFrame.returnAddress.returnAddress).newline();
                if (printOnlyTopFrames || Options.TraceDeoptimizationDetails.getValue().booleanValue()) {
                    Deoptimizer.printVirtualFrame(log, targetFrame);
                }
                if (printOnlyTopFrames && ++count >= 4) break;
                sourceFrame = sourceFrame.getCaller();
                targetFrame = targetFrame.getCaller();
            }
        }
        log.string("]").newline();
    }

    private static void printVirtualFrame(Log log, DeoptimizedFrame.VirtualFrame virtualFrame) {
        FrameInfoQueryResult frameInfo = virtualFrame.getFrameInfo();
        String sourceReference = frameInfo.getSourceReference().toString();
        if (sourceReference != null) {
            log.string("            ").string(sourceReference).newline();
        }
        log.string("            bci: ");
        FrameInfoDecoder.logReadableBci(log, frameInfo.getEncodedBci());
        log.string("  deoptMethodOffset: ").signed(frameInfo.getDeoptMethodOffset());
        log.string("  deoptMethod: ").zhex((WordBase)frameInfo.getDeoptMethodAddress());
        log.string("  return address: ").zhex(virtualFrame.returnAddress.returnAddress).string("  offset: ").signed(virtualFrame.returnAddress.offset);
        for (int i = 0; i < frameInfo.getValueInfos().length; ++i) {
            JavaConstant con = virtualFrame.getConstant(i);
            if (con.getJavaKind() == JavaKind.Illegal) continue;
            log.newline().string("            slot ").signed(i);
            log.string("  kind: ").string(con.getJavaKind().toString());
            if (con.getJavaKind() == JavaKind.Object) {
                Object val = SubstrateObjectConstant.asObject((Constant)con);
                if (val == null) {
                    log.string("  null");
                } else {
                    log.string("  value: ").object(val);
                }
            } else {
                log.string("  value: ").string(con.toValueString());
            }
            log.string("  offset: ").signed(virtualFrame.values[i].offset);
        }
        log.newline();
    }

    static RuntimeException fatalDeoptimizationError(String originalMessage, FrameInfoQueryResult frameInfo) {
        long encodedBci = frameInfo.getEncodedBci();
        String message = String.format("%s%nencodedBci: %s (bci %s)%nMethod info: %s", originalMessage, encodedBci, FrameInfoDecoder.readableBci(encodedBci), frameInfo.getSourceReference());
        throw VMError.shouldNotReachHere(message);
    }

    static {
        assert (Deoptimizer.checkEncoding());
        testGCinDeoptimizer = false;
        deoptStubFrameSize = 0L;
        deoptEventsConsumer = (context, entry) -> {
            Log log = (Log)context;
            int length = Math.min(((char[])entry).length, 1000);
            for (int i = 0; i < length; ++i) {
                char c = entry[i];
                if (c == '\n') {
                    log.newline();
                    continue;
                }
                log.character(c);
            }
            if (length < ((char[])entry).length) {
                log.string("...").newline();
            }
        };
    }

    private static class DeoptimizeAllOperation
    extends JavaVMOperation {
        DeoptimizeAllOperation() {
            super(VMOperationInfos.get(DeoptimizeAllOperation.class, "Deoptimize all", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            Deoptimizer.deoptimizeInRange((CodePointer)WordFactory.zero(), (CodePointer)WordFactory.zero(), true);
        }
    }

    private static class DeoptimizeFrameOperation
    extends JavaVMOperation {
        private final Pointer sourceSp;
        private final boolean ignoreNonDeoptimizable;
        private final SpeculationLog.SpeculationReason speculation;
        private final IsolateThread targetThread;

        DeoptimizeFrameOperation(Pointer sourceSp, boolean ignoreNonDeoptimizable, SpeculationLog.SpeculationReason speculation, IsolateThread targetThread) {
            super(VMOperationInfos.get(DeoptimizeFrameOperation.class, "Deoptimize frame", VMOperation.SystemEffect.SAFEPOINT));
            this.sourceSp = sourceSp;
            this.ignoreNonDeoptimizable = ignoreNonDeoptimizable;
            this.speculation = speculation;
            this.targetThread = targetThread;
        }

        @Override
        protected void operate() {
            Deoptimizer.deoptimizeFrameOperation(this.sourceSp, this.ignoreNonDeoptimizable, this.speculation, this.targetThread);
        }
    }

    static class TargetContent {
        private final byte[] frameBuffer;
        private static final int sizeofInt = JavaKind.Int.getByteCount();
        private static final int sizeofLong = JavaKind.Long.getByteCount();
        private final int sizeofCompressedReference = ConfigurationValues.getObjectLayout().getReferenceSize();
        private final int sizeofUncompressedReference = FrameAccess.uncompressedReferenceSize();
        private static final int arrayBaseOffset = ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte);
        private static final ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException("TargetContent.offsetCheck");

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private void offsetCheck(int offset, int size) {
            if (0 > offset || offset > this.frameBuffer.length - size) {
                throw arrayIndexOutOfBoundsException;
            }
        }

        protected TargetContent(int targetContentSize, ByteOrder byteOrder) {
            if (byteOrder != ByteOrder.nativeOrder()) {
                VMError.unsupportedFeature("TargetContent with non-native byte order.");
            }
            if (FrameAccess.returnAddressSize() != sizeofLong) {
                VMError.unsupportedFeature("TargetContent with returnAddressSize() != sizeof(long).");
            }
            this.frameBuffer = new byte[targetContentSize];
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected int getSize() {
            return this.frameBuffer.length;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void copyToPointer(Pointer p) {
            for (int idx = 0; idx < this.frameBuffer.length; ++idx) {
                p.writeByte(idx, this.frameBuffer[idx]);
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void writeInt(int offset, int value) {
            this.offsetCheck(offset, sizeofInt);
            this.addressOfFrameArray0().writeInt(offset, value);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void writeLong(int offset, long value) {
            this.offsetCheck(offset, sizeofLong);
            this.addressOfFrameArray0().writeLong(offset, value);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void writeWord(int offset, WordBase value) {
            if (FrameAccess.wordSize() == 8) {
                this.writeLong(offset, value.rawValue());
            } else if (FrameAccess.wordSize() == 4) {
                this.writeInt(offset, (int)value.rawValue());
            } else {
                throw VMError.shouldNotReachHere("Unexpected word size: " + FrameAccess.wordSize());
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void writeObject(int offset, Object value, boolean compressed) {
            this.offsetCheck(offset, compressed ? this.sizeofCompressedReference : this.sizeofUncompressedReference);
            Word address = (Word)this.addressOfFrameArray0();
            address = address.add(offset);
            ReferenceAccess.singleton().writeObjectAt((Pointer)address, value, compressed);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private Pointer addressOfFrameArray0() {
            return Word.objectToUntrackedPointer((Object)this.frameBuffer).add(arrayBaseOffset);
        }
    }

    private static final class DeoptSourceFrameOperation
    extends JavaVMOperation {
        private final Deoptimizer receiver;
        private final CodePointer pc;
        private final boolean ignoreNonDeoptimizable;
        private DeoptimizedFrame result;

        DeoptSourceFrameOperation(Deoptimizer receiver, CodePointer pc, boolean ignoreNonDeoptimizable) {
            super(VMOperationInfos.get(DeoptSourceFrameOperation.class, "Deoptimize source frame", VMOperation.SystemEffect.SAFEPOINT));
            this.receiver = receiver;
            this.pc = pc;
            this.ignoreNonDeoptimizable = ignoreNonDeoptimizable;
            this.result = null;
        }

        @Override
        public void operate() {
            this.result = this.receiver.deoptSourceFrameOperation(this.pc, this.ignoreNonDeoptimizable);
        }

        public DeoptimizedFrame getResult() {
            return this.result;
        }
    }

    public static class Options {
        public static final RuntimeOptionKey<Boolean> TraceDeoptimization = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Boolean> TraceDeoptimizationDetails = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface DeoptStub {
        public StubType stubType();
    }

    public static enum StubType {
        NoDeoptStub,
        EntryStub,
        ExitStub;

    }
}

