/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.log.Log;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class ChunksAccounting {
    private final ChunksAccounting parent;
    private long alignedCount;
    private long unalignedCount;
    private UnsignedWord unalignedChunkBytes;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ChunksAccounting() {
        this(null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ChunksAccounting(ChunksAccounting parent) {
        this.parent = parent;
        this.reset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void reset() {
        this.alignedCount = 0L;
        this.unalignedCount = 0L;
        this.unalignedChunkBytes = (UnsignedWord)WordFactory.zero();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getChunkBytes() {
        return this.getAlignedChunkBytes().add(this.getUnalignedChunkBytes());
    }

    public long getAlignedChunkCount() {
        return this.alignedCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getAlignedChunkBytes() {
        return WordFactory.unsigned((long)this.alignedCount).multiply(HeapParameters.getAlignedHeapChunkSize());
    }

    public long getUnalignedChunkCount() {
        return this.unalignedCount;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getUnalignedChunkBytes() {
        return this.unalignedChunkBytes;
    }

    void report(Log reportLog) {
        reportLog.string("aligned: ").unsigned((WordBase)this.getAlignedChunkBytes()).string("/").unsigned(this.alignedCount);
        reportLog.string(" ");
        reportLog.string("unaligned: ").unsigned((WordBase)this.unalignedChunkBytes).string("/").unsigned(this.unalignedCount);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void noteAlignedHeapChunk() {
        ++this.alignedCount;
        if (this.parent != null) {
            this.parent.noteAlignedHeapChunk();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void unnoteAlignedHeapChunk() {
        --this.alignedCount;
        if (this.parent != null) {
            this.parent.unnoteAlignedHeapChunk();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void noteUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        this.noteUnaligned(UnalignedHeapChunk.getCommittedObjectMemory(chunk));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void noteUnaligned(UnsignedWord size) {
        ++this.unalignedCount;
        this.unalignedChunkBytes = this.unalignedChunkBytes.add(size);
        if (this.parent != null) {
            this.parent.noteUnaligned(size);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void unnoteUnalignedHeapChunk(UnalignedHeapChunk.UnalignedHeader chunk) {
        this.unnoteUnaligned(UnalignedHeapChunk.getCommittedObjectMemory(chunk));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void unnoteUnaligned(UnsignedWord size) {
        --this.unalignedCount;
        this.unalignedChunkBytes = this.unalignedChunkBytes.subtract(size);
        if (this.parent != null) {
            this.parent.unnoteUnaligned(size);
        }
    }
}

