/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class GreyObjectsWalker {
    private Space space;
    private AlignedHeapChunk.AlignedHeader alignedHeapChunk;
    private Pointer alignedTop;
    private UnalignedHeapChunk.UnalignedHeader unalignedHeapChunk;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GreyObjectsWalker() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void setScanStart(Space s) {
        AlignedHeapChunk.AlignedHeader aChunk;
        this.space = s;
        this.alignedHeapChunk = aChunk = s.getLastAlignedHeapChunk();
        this.alignedTop = aChunk.isNonNull() ? HeapChunk.getTopPointer(aChunk) : (Pointer)WordFactory.nullPointer();
        this.unalignedHeapChunk = s.getLastUnalignedHeapChunk();
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean haveGreyObjects() {
        return this.alignedHeapChunk.notEqual((ComparableWord)this.space.getLastAlignedHeapChunk()) || this.alignedHeapChunk.isNonNull() && this.alignedTop.notEqual((UnsignedWord)HeapChunk.getTopPointer(this.alignedHeapChunk)) || this.unalignedHeapChunk.notEqual((ComparableWord)this.space.getLastUnalignedHeapChunk());
    }

    @NeverInline(value="Split the GC into reasonable compilation units")
    @Uninterruptible(reason="Called from uninterruptible code.")
    void walkGreyObjects() {
        while (this.haveGreyObjects()) {
            this.walkAlignedGreyObjects();
            this.walkUnalignedGreyObjects();
        }
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void walkAlignedGreyObjects() {
        AlignedHeapChunk.AlignedHeader aChunk = this.alignedHeapChunk.isNull() && this.alignedTop.isNull() ? this.space.getFirstAlignedHeapChunk() : this.alignedHeapChunk;
        GreyToBlackObjectVisitor visitor = GCImpl.getGCImpl().getGreyToBlackObjectVisitor();
        if (aChunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader lastChunk;
            do {
                lastChunk = aChunk;
                if (AlignedHeapChunk.walkObjectsInline(aChunk, visitor)) continue;
                throw VMError.shouldNotReachHere();
            } while ((aChunk = HeapChunk.getNext(aChunk)).isNonNull());
            this.alignedHeapChunk = lastChunk;
            this.alignedTop = HeapChunk.getTopPointer(lastChunk);
        }
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void walkUnalignedGreyObjects() {
        UnalignedHeapChunk.UnalignedHeader uChunk = this.unalignedHeapChunk.isNull() ? this.space.getFirstUnalignedHeapChunk() : HeapChunk.getNext(this.unalignedHeapChunk);
        GreyToBlackObjectVisitor visitor = GCImpl.getGCImpl().getGreyToBlackObjectVisitor();
        if (uChunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader lastChunk;
            do {
                lastChunk = uChunk;
                if (UnalignedHeapChunk.walkObjectsInline(uChunk, visitor)) continue;
                throw VMError.shouldNotReachHere();
            } while ((uChunk = HeapChunk.getNext(uChunk)).isNonNull());
            this.unalignedHeapChunk = lastChunk;
        }
    }
}

