/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.util.TimeUtils;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.management.Util;

public final class IncrementalGarbageCollectorMXBean
implements GarbageCollectorMXBean,
NotificationEmitter {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public IncrementalGarbageCollectorMXBean() {
    }

    @Override
    public long getCollectionCount() {
        return HeapImpl.getGCImpl().getAccounting().getIncrementalCollectionCount();
    }

    @Override
    public long getCollectionTime() {
        long nanos = HeapImpl.getGCImpl().getAccounting().getIncrementalCollectionTotalNanos();
        return TimeUtils.roundNanosToMillis(nanos);
    }

    @Override
    public String[] getMemoryPoolNames() {
        return new String[]{"young generation space"};
    }

    @Override
    public String getName() {
        return "young generation scavenger";
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=GarbageCollector", this.getName());
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) {
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    public GcInfo getLastGcInfo() {
        return null;
    }
}

